/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.odt.docbook2odt;

import com.arcway.cockpit.docgen.writer.docbook.model.EOAnchor;
import com.arcway.cockpit.docgen.writer.docbook.model.EOLink;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSubtitle;
import com.arcway.cockpit.docgen.writer.docbook.model.EOUlink;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.AnchorWriter;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.DocBook2ODTGenerationContext;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.LinkWriter;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.UlinkWriter;
import com.arcway.cockpit.docgen.writer.odt.dom.ParagraphWrapper;
import java.util.List;

public class SubTitleWriter {
    private static SubTitleWriter writer;

    public static SubTitleWriter getInstance() {
        if (writer == null) {
            writer = new SubTitleWriter();
        }
        return writer;
    }

    private SubTitleWriter() {
    }

    public void write(EOSubtitle subtitle, ParagraphWrapper paragraph, DocBook2ODTGenerationContext context) {
        List contentList = subtitle.getContent(context.getReportJob());
        for (Object obj : contentList) {
            if (obj instanceof String) {
                paragraph.addText((String)obj);
                continue;
            }
            if (obj instanceof EOAnchor) {
                AnchorWriter.getInstance().write((EOAnchor)obj, paragraph, context);
                continue;
            }
            if (obj instanceof EOLink) {
                LinkWriter.getInstance().write((EOLink)obj, paragraph, context);
                continue;
            }
            if (!(obj instanceof EOUlink)) continue;
            UlinkWriter.getInstance().write((EOUlink)obj, paragraph, context);
        }
    }
}

