/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.designer;

import com.arcway.cockpit.designer.localisation.Messages;
import com.arcway.cockpit.docgen.writer.reporttypesandtemplates.extensiontemplates.IBuiltInReportOutputTemplate;
import com.arcway.cockpit.docgen.writer.reporttypesandtemplates.extensiontemplates.IBuiltInReportTemplate;
import com.arcway.cockpit.docgen.writer.reporttypesandtemplates.extensiontemplates.IReportTemplateProvider;
import com.arcway.lib.eclipse.file.tmp.SessionTempDirectoryManager;
import com.arcway.lib.eclipse.resources.ResourceLoader;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class ReportTemplateProvider
implements IReportTemplateProvider {
    private static final ILogger LOGGER = Logger.getLogger(ReportTemplateProvider.class);
    private static final String FOLDERNAME_REPORTTEMPLATES = "reporttemplates";
    public static final String FOLDERNAME_REPORTOUTPUTTEMPLATES = "outputtemplates";
    public static final String FOLDERNAME_GERMAN = "de";
    public static final String FOLDERNAME_ENGLISH = "en";
    private static final String FILENAME_WORDMLTEMPLATE = "WordMLTemplate.xml";
    private static final String FILENAME_HTMLTEMPLATE = "HTMLTemplate.css";
    private static final String FILENAME_ODTTEMPLATE = "ODTTemplate.ott";
    private static final String FILENAME_REPORTTEMPLATE = "PersonalArchitect.rpttpl";
    private static final List<String> FILTERING_MODULES = new ArrayList<String>(2);

    static {
        FILTERING_MODULES.add("com.arcway.cockpit.frame.sections_and_plans");
        FILTERING_MODULES.add("com.arcway.cockpit.genericmodule.issuemodule2");
    }

    public List<IBuiltInReportTemplate> getReportTemplates() {
        return Arrays.asList(new IBuiltInReportTemplate(){

            public String getUID() {
                return "Velocity.BuiltIn.PersonalArchitect.German";
            }

            public String getName() {
                return Messages.getString("ReportTemplate.German.Name");
            }

            public String getDescription() {
                return Messages.getString("ReportTemplate.German.Description");
            }

            public Locale getLanguage() {
                return Locale.GERMAN;
            }

            public List<String> getIDsOfFilteringModules() {
                return FILTERING_MODULES;
            }

            public File getReportFile() {
                return ReportTemplateProvider.getTemporaryCopyOfPluginRelativeFile("reporttemplates/de", ReportTemplateProvider.FILENAME_REPORTTEMPLATE);
            }
        }, new IBuiltInReportTemplate(){

            public String getUID() {
                return "Velocity.BuiltIn.PersonalArchitect.English";
            }

            public String getName() {
                return Messages.getString("ReportTemplate.English.Name");
            }

            public String getDescription() {
                return Messages.getString("ReportTemplate.English.Description");
            }

            public Locale getLanguage() {
                return Locale.ENGLISH;
            }

            public List<String> getIDsOfFilteringModules() {
                return FILTERING_MODULES;
            }

            public File getReportFile() {
                return ReportTemplateProvider.getTemporaryCopyOfPluginRelativeFile("reporttemplates/en", ReportTemplateProvider.FILENAME_REPORTTEMPLATE);
            }
        });
    }

    public List<IBuiltInReportOutputTemplate> getOutputTemplates() {
        return Arrays.asList(new IBuiltInReportOutputTemplate(){

            public String getUID() {
                return "Velocity.BuiltIn.PersonalArchitect.WordML.German";
            }

            public String getName() {
                return Messages.getString("OutputTemplate.WordML.German.Name");
            }

            public String getDescription() {
                return Messages.getString("OutputTemplate.WordML.German.Description");
            }

            public Integer getImageWidthMM() {
                return 0;
            }

            public Integer getImageHeightMM() {
                return 0;
            }

            public Locale getLanguage() {
                return Locale.GERMAN;
            }

            public String getReportOutputTemplateTypeID() {
                return "WORDML_DOCUMENT";
            }

            public File getFile() {
                return ReportTemplateProvider.getTemporaryCopyOfPluginRelativeFile("outputtemplates/de", ReportTemplateProvider.FILENAME_WORDMLTEMPLATE);
            }

            public String getFormatPalettes() {
                return "arcway_v1";
            }
        }, new IBuiltInReportOutputTemplate(){

            public String getUID() {
                return "Velocity.BuiltIn.PersonalArchitect.WordML.English";
            }

            public String getName() {
                return Messages.getString("OutputTemplate.WordML.English.Name");
            }

            public String getDescription() {
                return Messages.getString("OutputTemplate.WordML.English.Description");
            }

            public Integer getImageWidthMM() {
                return 0;
            }

            public Integer getImageHeightMM() {
                return 0;
            }

            public Locale getLanguage() {
                return Locale.ENGLISH;
            }

            public String getReportOutputTemplateTypeID() {
                return "WORDML_DOCUMENT";
            }

            public File getFile() {
                return ReportTemplateProvider.getTemporaryCopyOfPluginRelativeFile("outputtemplates/en", ReportTemplateProvider.FILENAME_WORDMLTEMPLATE);
            }

            public String getFormatPalettes() {
                return "arcway_v1";
            }
        }, new IBuiltInReportOutputTemplate(){

            public String getUID() {
                return "Velocity.BuiltIn.PersonalArchitect.HTML.German";
            }

            public String getName() {
                return Messages.getString("OutputTemplate.HTML.German.Name");
            }

            public String getDescription() {
                return Messages.getString("OutputTemplate.HTML.German.Description");
            }

            public Integer getImageWidthMM() {
                return 0;
            }

            public Integer getImageHeightMM() {
                return 0;
            }

            public Locale getLanguage() {
                return Locale.GERMAN;
            }

            public String getReportOutputTemplateTypeID() {
                return "HTML_DOCUMENT";
            }

            public File getFile() {
                return ReportTemplateProvider.getTemporaryCopyOfPluginRelativeFile("outputtemplates/de", ReportTemplateProvider.FILENAME_HTMLTEMPLATE);
            }

            public String getFormatPalettes() {
                return "arcway_v1";
            }
        }, new IBuiltInReportOutputTemplate(){

            public String getUID() {
                return "Velocity.BuiltIn.PersonalArchitect.HTML.English";
            }

            public String getName() {
                return Messages.getString("OutputTemplate.HTML.English.Name");
            }

            public String getDescription() {
                return Messages.getString("OutputTemplate.HTML.English.Description");
            }

            public Integer getImageWidthMM() {
                return 0;
            }

            public Integer getImageHeightMM() {
                return 0;
            }

            public Locale getLanguage() {
                return Locale.ENGLISH;
            }

            public String getReportOutputTemplateTypeID() {
                return "HTML_DOCUMENT";
            }

            public File getFile() {
                return ReportTemplateProvider.getTemporaryCopyOfPluginRelativeFile("outputtemplates/en", ReportTemplateProvider.FILENAME_HTMLTEMPLATE);
            }

            public String getFormatPalettes() {
                return "arcway_v1";
            }
        }, new IBuiltInReportOutputTemplate(){

            public String getUID() {
                return "Velocity.BuiltIn.PersonalArchitect.ODT.German";
            }

            public String getName() {
                return Messages.getString("OutputTemplate.ODT.German.Name");
            }

            public String getDescription() {
                return Messages.getString("OutputTemplate.ODT.German.Description");
            }

            public Integer getImageWidthMM() {
                return 0;
            }

            public Integer getImageHeightMM() {
                return 0;
            }

            public Locale getLanguage() {
                return Locale.GERMAN;
            }

            public String getReportOutputTemplateTypeID() {
                return "ODT_DOCUMENT";
            }

            public File getFile() {
                return ReportTemplateProvider.getTemporaryCopyOfPluginRelativeFile("outputtemplates/de", ReportTemplateProvider.FILENAME_ODTTEMPLATE);
            }

            public String getFormatPalettes() {
                return "arcway_v1";
            }
        }, new IBuiltInReportOutputTemplate(){

            public String getUID() {
                return "Velocity.BuiltIn.PersonalArchitect.ODT.English";
            }

            public String getName() {
                return Messages.getString("OutputTemplate.ODT.English.Name");
            }

            public String getDescription() {
                return Messages.getString("OutputTemplate.ODT.English.Description");
            }

            public Integer getImageWidthMM() {
                return 0;
            }

            public Integer getImageHeightMM() {
                return 0;
            }

            public Locale getLanguage() {
                return Locale.ENGLISH;
            }

            public String getReportOutputTemplateTypeID() {
                return "ODT_DOCUMENT";
            }

            public File getFile() {
                return ReportTemplateProvider.getTemporaryCopyOfPluginRelativeFile("outputtemplates/en", ReportTemplateProvider.FILENAME_ODTTEMPLATE);
            }

            public String getFormatPalettes() {
                return "arcway_v1";
            }
        });
    }

    private static File getTemporaryCopyOfPluginRelativeFile(String pluginRelativePath, String fileName) {
        return ReportTemplateProvider.getTemporaryCopyOfPluginRelativeFile("com.arcway.cockpit.designerextensions", pluginRelativePath, fileName);
    }

    public static File getTemporaryCopyOfPluginRelativeFile(String pluginID, String pluginRelativePath, String fileName) {
        File masterFile = ResourceLoader.getFile((String)pluginID, (String)(String.valueOf(pluginRelativePath) + "/" + fileName));
        File fileCopy = null;
        try {
            fileCopy = SessionTempDirectoryManager.createSessionTempFile((File)masterFile);
        }
        catch (JvmExternalResourceInteractionException e) {
            LOGGER.error("Unable to create temporary copy of file: " + masterFile, (Throwable)e);
        }
        return fileCopy;
    }
}

