/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.cockpitlib.client.filter;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.lib.stringtools.StringUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.Viewer;

public abstract class AbstractTextValuesFilter
extends AbstractFilter {
    protected HashSet<String> passValues = new HashSet(16, 0.5f);
    private static final char SEMICOLON = ';';
    private static final String EMPTY = "EMPTY";
    private static final String TRUE = "TRUE";
    private static final String FALSE = "FALSE";
    private boolean invert = false;
    private final boolean acceptItemsOnEmptyPassValuesList;

    public AbstractTextValuesFilter(boolean acceptItemsOnEmptyPassValuesList) {
        this.acceptItemsOnEmptyPassValuesList = acceptItemsOnEmptyPassValuesList;
    }

    @Override
    public boolean doesItemPassFilter(Viewer viewer, Object parentElement, Object element) {
        return this.doesItemPassFilter(element);
    }

    public boolean doesItemPassFilter(Object element) {
        if (!this.isActive()) {
            return true;
        }
        if (this.isValidObjectType(element)) {
            if (this.passValues == null || this.passValues.isEmpty()) {
                return this.acceptItemsOnEmptyPassValuesList;
            }
            String value = this.getStringAttribute(element);
            if (value != null ? this.passValues.contains(value) : this.passValues.contains("")) {
                return !this.invert;
            }
            return this.invert;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public void initWithSemicolonSeparatedString(String valueString) {
        block9: {
            block7: {
                if (valueString == null) break block7;
                values = StringUtil.split((String)valueString, (char)';');
                this.passValues.clear();
                i = 0;
                while (i < values.size()) {
                    block8: {
                        value_i = (String)values.get(i);
                        if (value_i.length() <= 0) break block8;
                        if (i != 0) ** GOTO lbl-1000
                        if (value_i.equals("TRUE")) {
                            this.invert = true;
                        } else if (value_i.equals("FALSE")) {
                            this.invert = false;
                        } else if (value_i.equals("EMPTY")) {
                            this.passValues.add("");
                        } else {
                            this.passValues.add(value_i);
                        }
                    }
                    ++i;
                }
                break block9;
            }
            this.passValues.clear();
        }
    }

    public String getValuesAsSemicolonSeparatedString() {
        StringBuilder valueString = new StringBuilder();
        if (this.invert) {
            valueString.append(TRUE);
        } else {
            valueString.append(FALSE);
        }
        valueString.append(';');
        Iterator<String> valuesIterator = this.passValues.iterator();
        while (valuesIterator.hasNext()) {
            String value = valuesIterator.next();
            if (value.length() == 0) {
                value = EMPTY;
            }
            valueString.append(value);
            if (!valuesIterator.hasNext()) continue;
            valueString.append(';');
        }
        return valueString.toString();
    }

    public void setPassValues(List<String> values) {
        this.passValues.clear();
        if (values != null) {
            this.passValues.addAll(values);
        }
    }

    public List<String> getPassValues() {
        return new ArrayList<String>(this.passValues);
    }

    protected abstract String getStringAttribute(Object var1);

    @Override
    public String getFilterValue() {
        return this.getValuesAsSemicolonSeparatedString();
    }

    @Override
    public void setFilterValue(String value) {
        this.initWithSemicolonSeparatedString(value);
        super.setFilterValue(value);
    }

    @Override
    public void resetValue() {
        this.passValues = new HashSet(16, 0.5f);
        this.setFilterValue("");
    }

    public boolean isInvert() {
        return this.invert;
    }

    public void setInvert(boolean invert) {
        this.invert = invert;
    }
}

