/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.cockpitlib.client.files;

import com.arcway.cockpit.cockpitlib.client.files.AtomicFileWriter;
import com.arcway.cockpit.cockpitlib.client.files.IContentReader;
import com.arcway.cockpit.cockpitlib.client.files.IContentWriter;
import com.arcway.cockpit.cockpitlib.client.files.IFileAccessor;
import com.arcway.cockpit.cockpitlib.client.files.IFileContentProviderForXMLFiles;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLDecoderPool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;

public final class XMLFileAccessor<EO extends EOEncodableObject>
implements IFileAccessor {
    private static final ILogger logger = Logger.getLogger(XMLFileAccessor.class);
    private final File xmlFile;
    private final IEncodableObjectFactory encodableObjectFactory;
    private IFileContentProviderForXMLFiles<EO> currentFileContentInCaseThatItsNotYetWrittenToDisc = null;
    private int dontWriteThrough = 0;

    public XMLFileAccessor(File xmlFile, IEncodableObjectFactory encodableObjectFactory) {
        assert (xmlFile != null);
        this.xmlFile = xmlFile;
        this.encodableObjectFactory = encodableObjectFactory;
    }

    @Override
    public void doWithDelayedWriteThrough(Runnable runnable) throws InvocationTargetException {
        this.enterCopyBackMode();
        try {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            this.enterWriteThroughMode();
        }
    }

    private void enterCopyBackMode() {
        ++this.dontWriteThrough;
    }

    private void enterWriteThroughMode() {
        --this.dontWriteThrough;
        assert (this.dontWriteThrough >= 0);
        if (this.dontWriteThrough == 0 && this.currentFileContentInCaseThatItsNotYetWrittenToDisc != null) {
            try {
                this.writeFile(this.currentFileContentInCaseThatItsNotYetWrittenToDisc.getFileContent());
            }
            finally {
                this.currentFileContentInCaseThatItsNotYetWrittenToDisc = null;
            }
        }
    }

    public EO read() throws IOException, EXDecoderException {
        EO currentFileContent;
        if (this.currentFileContentInCaseThatItsNotYetWrittenToDisc != null) {
            assert (this.dontWriteThrough > 0);
            EO fileContentAfterUpdate = this.currentFileContentInCaseThatItsNotYetWrittenToDisc.getFileContent();
            if (fileContentAfterUpdate != null) {
                logger.debug("XML file is re-read before it was written to disc (this should be avoided)", (Throwable)new Exception());
                File tempFile = File.createTempFile("XML", ".xml");
                try {
                    FileOutputStream fileContentAsOutputStream = new FileOutputStream(tempFile);
                    try {
                        try {
                            this.writeStream(fileContentAfterUpdate, fileContentAsOutputStream);
                        }
                        catch (EXEncoderException e) {
                            throw e.toNewIOException("Unable to return (copy of) file content.");
                        }
                    }
                    finally {
                        try {
                            fileContentAsOutputStream.close();
                        }
                        catch (Exception e) {
                            logger.debug("Unable to close file stream after write failure", (Throwable)e);
                        }
                    }
                    currentFileContent = this.readFile(tempFile);
                }
                finally {
                    try {
                        FileHelper.deleteExistingFileOrDirectory((File)tempFile);
                    }
                    catch (JvmExternalResourceInteractionException jeri) {
                        logger.debug("Unable to delete obsolete temp file:", (Throwable)jeri);
                    }
                }
            }
            currentFileContent = null;
        } else {
            assert (this.dontWriteThrough == 0);
            currentFileContent = this.readFile();
        }
        return currentFileContent;
    }

    public void write(IFileContentProviderForXMLFiles<EO> fileContentProvider) {
        if (this.dontWriteThrough == 0) {
            this.writeFile(fileContentProvider.getFileContent());
        } else {
            this.currentFileContentInCaseThatItsNotYetWrittenToDisc = fileContentProvider;
        }
    }

    public boolean checkIfSourceEOIsNotNull() {
        return this.xmlFile.exists() || this.currentFileContentInCaseThatItsNotYetWrittenToDisc != null;
    }

    private EO readFile() throws EXDecoderException, IOException {
        final ArrayList eos = new ArrayList(1);
        AtomicFileWriter.readFromFile(this.xmlFile, new IContentReader(){

            @Override
            public void readFile(File inputFile) throws EXDecoderException, IOException {
                eos.add(XMLFileAccessor.this.readFile(inputFile));
            }
        });
        Iterator i = eos.iterator();
        EOEncodableObject eo = i.hasNext() ? (EOEncodableObject)i.next() : null;
        return (EO)eo;
    }

    private EO readFile(File inputFile) throws EXDecoderException, IOException {
        EOEncodableObject list = (EOEncodableObject)XMLDecoderPool.decodeXMLFile((File)inputFile, (IEncodableObjectFactory)this.encodableObjectFactory, (boolean)true);
        return (EO)list;
    }

    private void writeFile(EO eo) {
        try {
            if (eo != null) {
                FileHelper.ensureDirectoryExistance((File)this.xmlFile.getParentFile());
                AtomicFileWriter.writeIntoFileAtomically(this.xmlFile, new IContentWriter((EOEncodableObject)eo){
                    private final /* synthetic */ EOEncodableObject val$eo;
                    {
                        this.val$eo = eOEncodableObject;
                    }

                    @Override
                    public void write(OutputStream outputStream) throws IOException {
                        try {
                            XMLFileAccessor.this.writeStream(this.val$eo, outputStream);
                        }
                        catch (EXEncoderException e) {
                            e.toNewIOException(null);
                        }
                    }
                });
            } else if (this.xmlFile.exists()) {
                FileHelper.deleteExistingFileOrDirectory((File)this.xmlFile);
            }
        }
        catch (IOException e) {
            logger.fatal("write() - writing the XML file failed", (Throwable)e);
            assert (false);
        }
        catch (JvmExternalResourceInteractionException e) {
            logger.fatal("write() - writing the XML file failed", (Throwable)e);
            assert (false);
        }
        catch (RuntimeException e) {
            logger.fatal("write() - writing the XML file failed", (Throwable)e);
            assert (false);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStream(EO eo, OutputStream targetStream) throws EXEncoderException {
        assert (eo != null);
        XMLFileAccessor xMLFileAccessor = this;
        synchronized (xMLFileAccessor) {
            eo.writeToXMLStream(targetStream, true);
        }
    }
}

