/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.cockpitlib.client.data.jpa;

import com.arcway.cockpit.cockpitlib.client.data.jpa.JPAPersistenceUnit;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.io.File;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;

public class ProjectClientDBManager {
    private static final ILogger LOGGER = Logger.getLogger(ProjectClientDBManager.class);
    private final JPAPersistenceUnit jpaPersistenceUnit;
    private EntityManager entityManager = null;
    private long transactionSerial = 0L;

    public String getTransactionSerial() {
        return this.entityManager == null ? "not in transaction(" + this.transactionSerial + ")" : "" + this.transactionSerial;
    }

    public ProjectClientDBManager(File dbFolder) {
        this.jpaPersistenceUnit = new JPAPersistenceUnit("pu-projectmodifications", new File(dbFolder, "modDB"), this.getClass().getClassLoader());
    }

    public void createNewEntityManagerAndStartTransaction() {
        assert (this.entityManager == null);
        ++this.transactionSerial;
        LOGGER.debug("=== Start Transaction " + this.getTransactionSerial() + " ===");
        this.entityManager = this.jpaPersistenceUnit.getEmf().createEntityManager();
        this.entityManager.getTransaction().begin();
    }

    public EntityManager getEntityManager() {
        if (this.entityManager == null) {
            assert (false);
            LOGGER.error("Missing Transaction Boundary");
            this.createNewEntityManagerAndStartTransaction();
        }
        return this.entityManager;
    }

    public void commitTransactionAndCloseEntityManager() {
        assert (this.entityManager != null);
        try {
            this.entityManager.getTransaction().commit();
            LOGGER.debug("=== Commit Transaction " + this.getTransactionSerial() + " completed ===");
        }
        finally {
            this.abortPendingTransactionAndEnsureEntityManagerIsClosed();
        }
    }

    public void abortPendingTransactionAndEnsureEntityManagerIsClosed() {
        assert (this.entityManager != null);
        EntityManager em_ = this.entityManager;
        this.entityManager = null;
        try {
            EntityTransaction transaction = em_.getTransaction();
            if (transaction.isActive()) {
                LOGGER.debug("=== Abort Transaction " + this.getTransactionSerial() + " ===");
                transaction.rollback();
            }
        }
        catch (Throwable th) {
            LOGGER.error("unhandled catch block", th);
        }
        try {
            if (em_ != null && em_.isOpen()) {
                em_.close();
            }
        }
        catch (Throwable th) {
            LOGGER.error("unhandled catch block", th);
        }
    }

    public void destruct() {
        if (this.entityManager != null) {
            this.abortPendingTransactionAndEnsureEntityManagerIsClosed();
        }
        this.jpaPersistenceUnit.destruct();
    }
}

