/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.client.base.datamanager;

import com.arcway.cockpit.client.base.datamanager.AbstractDifferentialModificationManager;
import com.arcway.cockpit.client.base.datamanager.AtomicModificationDataAccessor;
import com.arcway.cockpit.client.base.datamanager.DataManagerModificationAccess;
import com.arcway.cockpit.client.base.datamanager.DataModificationLogMgr;
import com.arcway.cockpit.client.base.datamanager.IDataHandler;
import com.arcway.cockpit.client.base.datamanager.IModificationEntityProvider;
import com.arcway.cockpit.cockpitlib.client.data.jpa.JPAEOCoDec;
import com.arcway.cockpit.cockpitlib.client.data.jpa.ModificationDataElement;
import com.arcway.cockpit.frame.shared.message.EOGenericCockpitDatabaseData;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.java.ObjectWrapper;
import com.arcway.lib.java.tuples.KeyTuple;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

public class AccessAgentModificationAccess<T, T_UID, T_EO extends EOGenericCockpitDatabaseData>
extends AbstractDifferentialModificationManager<ModificationDataElement, String> {
    private final DataManagerModificationAccess dataManagerModificationAccess;
    private final String dataTypeIDAsString;
    private DataModificationLogMgr<T, T_UID, T_EO> dataModificationLogMgr;
    private final HashMap<String, ModificationDataElement> existingElementsToDelete;
    private final HashMap<String, ModificationEntityProvider<T>> newElementsToAdd;

    public AccessAgentModificationAccess(DataManagerModificationAccess dataManagerModificationAccess, String dataTypeIDAsString) {
        super(ModificationDataElement.class, new KeyTuple(AccessAgentModificationAccess.class, (Object)dataTypeIDAsString));
        this.dataManagerModificationAccess = dataManagerModificationAccess;
        this.dataTypeIDAsString = dataTypeIDAsString;
        this.existingElementsToDelete = new HashMap();
        this.newElementsToAdd = new HashMap();
    }

    public String getDataTypeIDAsString() {
        return this.dataTypeIDAsString;
    }

    public void setDataModificationLogMgr(DataModificationLogMgr<T, T_UID, T_EO> dataModificationLogMgr) {
        assert (dataModificationLogMgr != null);
        assert (this.dataModificationLogMgr == null);
        this.dataModificationLogMgr = dataModificationLogMgr;
    }

    public List<T> getAllItemsOfModType(char modType, final IDataHandler<T, T_UID, ?, T_EO> dataHandler) throws AtomicModificationDataAccessor.ModificationBootstrapFailure {
        final Character modTypeCharacter = Character.valueOf(modType);
        final ObjectWrapper result = new ObjectWrapper(null);
        this.dataManagerModificationAccess.bootstrapModificationData(new AtomicModificationDataAccessor.IBootstrapModificationAccessor(){

            @Override
            public void run(EntityManager em) throws Exception {
                if (!($assertionsDisabled || AccessAgentModificationAccess.this.existingElementsToDelete.isEmpty() && AccessAgentModificationAccess.this.newElementsToAdd.isEmpty())) {
                    throw new AssertionError();
                }
                Query dataQuery = em.createNamedQuery("ModificationDataElement_readModificationDataByDataTypeIDAndModType");
                dataQuery.setFlushMode(FlushModeType.COMMIT);
                dataQuery.setParameter("dataTypeID", (Object)AccessAgentModificationAccess.this.dataTypeIDAsString);
                dataQuery.setParameter("modType", (Object)modTypeCharacter);
                final XMLDecoder xmlDecoder = new XMLDecoder();
                final ArrayList resultlist = new ArrayList();
                JPAEOCoDec.executeQueryAndProcessResultUsingCursoredStream((Query)dataQuery, (int)20, (JPAEOCoDec.ResultConsumer)new JPAEOCoDec.ResultConsumer(){

                    public void consume(Object row) throws EXDecoderException {
                        String xmlData = (String)row;
                        EncodableObjectBase eo = JPAEOCoDec.convertXmlStringToNewEO((String)xmlData, (XMLDecoder)xmlDecoder, (IEncodableObjectFactory)AccessAgentModificationAccess.this.dataManagerModificationAccess.getEoFactory());
                        Object item = dataHandler.getItemForEO((EOGenericCockpitDatabaseData)eo);
                        resultlist.add(item);
                    }
                });
                result.setWrappedObject(resultlist);
            }
        });
        return (List)result.getWrappedObject();
    }

    public void discardAllModificationsOfModType(final char modType) {
        final Character modTypeCharacter = Character.valueOf(modType);
        this.dataManagerModificationAccess.updateModificationData(new AtomicModificationDataAccessor.IModificationUpdatePreparer(){

            @Override
            public void run(EntityManager em) throws Exception {
                Iterator iterator = AccessAgentModificationAccess.this.newElementsToAdd.entrySet().iterator();
                while (iterator.hasNext()) {
                    ModificationEntityProvider modificationDataElementProvider = (ModificationEntityProvider)iterator.next().getValue();
                    if (modificationDataElementProvider.getModType() != modType) continue;
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    iterator.remove();
                }
                iterator = AccessAgentModificationAccess.this.existingElementsToDelete.entrySet().iterator();
                while (iterator.hasNext()) {
                    ModificationDataElement modificationDataElement = (ModificationDataElement)iterator.next().getValue();
                    if (modificationDataElement.getModType() != modType) continue;
                    iterator.remove();
                }
                TypedQuery query = em.createNamedQuery("ModificationDataElement_deleteAllOfDataTypeIDAndModType", ModificationDataElement.class);
                query.setParameter("dataTypeID", (Object)AccessAgentModificationAccess.this.dataTypeIDAsString);
                query.setParameter("modType", (Object)modTypeCharacter);
                query.executeUpdate();
                em.flush();
            }
        });
    }

    public void addItemOfModType(final T item, final char modType, final IDataHandler<T, ?, ?, ?> dataHandler, final boolean replaceExistingItemOfSameModTypeAndID) {
        this.dataManagerModificationAccess.updateModificationData(new AtomicModificationDataAccessor.IModificationUpdatePreparer(){

            @Override
            public void run(EntityManager em) throws Exception {
                String uidStringForItem = dataHandler.getUIDStringForItem(item);
                if (replaceExistingItemOfSameModTypeAndID) {
                    AccessAgentModificationAccess.this.removeItemOfModType(em, uidStringForItem, modType);
                }
                if (!$assertionsDisabled && !AccessAgentModificationAccess.this.existingElementsToDelete.containsKey(uidStringForItem) && em.find(ModificationDataElement.class, (Object)uidStringForItem) != null) {
                    throw new AssertionError();
                }
                ModificationEntityProvider<Object> modificationDataElementProvider = new ModificationEntityProvider<Object>(uidStringForItem, AccessAgentModificationAccess.this.dataTypeIDAsString, modType, item, dataHandler);
                AccessAgentModificationAccess.this.newElementsToAdd.put(uidStringForItem, modificationDataElementProvider);
            }
        });
    }

    public void removeItemOfModType(final T_UID itemUID, final char modType, final IDataHandler<T, T_UID, ?, ?> dataHandler) {
        this.dataManagerModificationAccess.updateModificationData(new AtomicModificationDataAccessor.IModificationUpdatePreparer(){

            @Override
            public void run(EntityManager em) throws Exception {
                String itemUid = dataHandler.getUIDStringForUID(itemUID);
                AccessAgentModificationAccess.this.removeItemOfModType(em, itemUid, modType);
            }
        });
    }

    private void removeItemOfModType(EntityManager em, String itemUid, char modType) {
        ModificationEntityProvider<T> canceledAddition = this.newElementsToAdd.remove(itemUid);
        if (canceledAddition == null) {
            ModificationDataElement elementToRemove = (ModificationDataElement)em.find(ModificationDataElement.class, (Object)itemUid);
            assert (elementToRemove != null);
            assert (elementToRemove.getModType() == modType);
            ModificationDataElement previousValue = this.existingElementsToDelete.put(itemUid, elementToRemove);
            assert (previousValue == null);
        } else {
            assert (canceledAddition != null);
            assert (canceledAddition.getModType() == modType);
        }
    }

    @Override
    public void handOverModificationUpdates(AtomicModificationDataAccessor.ModificationUpdatesForEntityClass<ModificationDataElement, String> modificationUpdates) {
        modificationUpdates.addUpdates(this.existingElementsToDelete, this.newElementsToAdd);
        this.existingElementsToDelete.clear();
        this.newElementsToAdd.clear();
    }

    @Override
    public void reconstructModificationElements() {
        this.dataModificationLogMgr.reconstructDiskStateFromInMemoryState();
    }

    @Override
    public void checkModificationIntegrity() throws Exception {
        this.dataModificationLogMgr.checkModificationIntegrity();
    }

    public static class ModificationEntityProvider<T>
    implements IModificationEntityProvider<ModificationDataElement> {
        private final String elementUid;
        private final String dataTypeID;
        private final char modType;
        private final T item;
        private final IDataHandler<T, ?, ?, ?> dataHandler;

        public ModificationEntityProvider(String elementUid, String dataTypeID, char modType, T item, IDataHandler<T, ?, ?, ?> dataHandler) {
            this.elementUid = elementUid;
            this.dataTypeID = dataTypeID;
            this.modType = modType;
            this.item = item;
            this.dataHandler = dataHandler;
        }

        @Override
        public ModificationDataElement createModificationEntity() throws EXEncoderException {
            return new ModificationDataElement(this.elementUid, this.dataTypeID, this.modType, this.dataHandler.getEOForItem(this.item));
        }

        public char getModType() {
            return this.modType;
        }
    }
}

