/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.messages;

import com.arcway.cockpit.modulelib2.client.AbstractModulePlugin;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDuration;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeInteger;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeNonEmptyString;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeString;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.cockpit.modulelib2.client.messages.resources.ModuleIconResource;
import com.arcway.cockpit.modulelib2.shared.messages.EOModuleData;
import com.arcway.cockpit.projectplanningmodule2.client.Messages;
import com.arcway.cockpit.projectplanningmodule2.client.ProjectPlanningModule2Plugin;
import com.arcway.cockpit.projectplanningmodule2.client.messages.AbstractModuleDataAdapter;
import com.arcway.cockpit.projectplanningmodule2.client.messages.IWorkItem;
import com.arcway.cockpit.projectplanningmodule2.client.messages.description.WorkItemDescription;
import de.plans.lib.resources.IIconResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class WorkItem
extends AbstractModuleDataAdapter
implements IWorkItem {
    public static final String DATA_TYPE_UID = "ppm2.workitem";
    public static final String IMAGE_NAME = "WorkItem.gif";
    public static final String MODULE_DATA_NAME_KEY = "WorkItem.DisplayName";
    public static final String MODULE_DATA_NAME = Messages.getString("WorkItem.DisplayName");
    public static final String ROLE_NAME = "workItem_name";
    public static final String ROLE_DESCRIPTION = "workItem_description";
    public static final String ROLE_WORK_ESTIMATED = "workItem_workEstimated";
    public static final String ROLE_WORK_DONE = "workItem_workDone";
    public static final String ROLE_WORK_REMAINING = "workItem_workRemaining";
    public static final String ROLE_RESOURCES = "workItem_resources";
    public static final String NAME_NAME_KEY = "WorkItem.Name";
    public static final String NAME_DESCRIPTION_KEY = "WorkItem.Description";
    public static final String NAME_WORK_ESTIMATED_KEY = "WorkItem.WorkEstimated";
    public static final String NAME_WORK_DONE_KEY = "WorkItem.WorkDone";
    public static final String NAME_WORK_REMAINING_KEY = "WorkItem.WorkRemaining";
    public static final String NAME_CATEGORY_KEY = "WorkItem.Category";
    public static final String NAME_RESOURCES_KEY = "WorkItem.Resources";
    public static final String NAME_NAME = Messages.getString("WorkItem.Name");
    public static final String NAME_DESCRIPTION = Messages.getString("WorkItem.Description");
    public static final String NAME_WORK_ESTIMATED = Messages.getString("WorkItem.WorkEstimated");
    public static final String NAME_WORK_DONE = Messages.getString("WorkItem.WorkDone");
    public static final String NAME_WORK_REMAINING = Messages.getString("WorkItem.WorkRemaining");
    public static final String NAME_CATEGORY = Messages.getString("WorkItem.Category");
    public static final String NAME_RESOURCES = Messages.getString("WorkItem.Resources");
    public static final String NAME_PERSON_IN_CHARGE_KEY = "WorkItem.PersonInCharge";
    public static final String NAME_PERSON_IN_CHARGE = Messages.getString("WorkItem.PersonInCharge");
    public static final String ROLE_CATEGORY = "workItem_category";
    public static final HashMap ATTRIBUTE_MAP = new HashMap();
    public static final List ATTRIBUTE_KEYS_FOR_PERMISSIONS;
    public static IModuleDataTypeDescription DATA_TYPE_DESCRIPTION;
    private static IIconResource completedWorkItemIcon;
    private static IIconResource underestimatedWorkItemIcon;

    static {
        ATTRIBUTE_MAP.put(ROLE_NAME, NAME_NAME);
        ATTRIBUTE_MAP.put(ROLE_DESCRIPTION, NAME_DESCRIPTION);
        ATTRIBUTE_MAP.put(ROLE_WORK_ESTIMATED, NAME_WORK_ESTIMATED);
        ATTRIBUTE_MAP.put(ROLE_WORK_DONE, NAME_WORK_DONE);
        ATTRIBUTE_MAP.put(ROLE_WORK_REMAINING, NAME_WORK_REMAINING);
        ATTRIBUTE_MAP.put(ROLE_CATEGORY, NAME_CATEGORY);
        ATTRIBUTE_MAP.put(ROLE_RESOURCES, NAME_RESOURCES);
        ATTRIBUTE_KEYS_FOR_PERMISSIONS = new ArrayList();
        ATTRIBUTE_KEYS_FOR_PERMISSIONS.add(ROLE_NAME);
        ATTRIBUTE_KEYS_FOR_PERMISSIONS.add(ROLE_CATEGORY);
        ATTRIBUTE_KEYS_FOR_PERMISSIONS.add(ROLE_DESCRIPTION);
        ATTRIBUTE_KEYS_FOR_PERMISSIONS.add(ROLE_WORK_ESTIMATED);
        ATTRIBUTE_KEYS_FOR_PERMISSIONS.add(ROLE_WORK_DONE);
        ATTRIBUTE_KEYS_FOR_PERMISSIONS.add(ROLE_WORK_REMAINING);
        ATTRIBUTE_KEYS_FOR_PERMISSIONS.add(ROLE_RESOURCES);
        DATA_TYPE_DESCRIPTION = new WorkItemDescription();
        completedWorkItemIcon = new ModuleIconResource((AbstractModulePlugin)ProjectPlanningModule2Plugin.getDefault(), "WorkItemComplete.gif");
        underestimatedWorkItemIcon = new ModuleIconResource((AbstractModulePlugin)ProjectPlanningModule2Plugin.getDefault(), "WorkItemUnderestimated.gif");
    }

    public WorkItem() {
        this.moduleAttributes.put(ROLE_NAME, new ModuleDataAttributeNonEmptyString(1));
        this.moduleAttributes.put(ROLE_DESCRIPTION, new ModuleDataAttributeString(2));
        this.moduleAttributes.put(ROLE_WORK_ESTIMATED, new ModuleDataAttributeDuration());
        this.moduleAttributes.put(ROLE_WORK_DONE, new ModuleDataAttributeDuration());
        this.moduleAttributes.put(ROLE_WORK_REMAINING, new ModuleDataAttributeDuration());
        this.moduleAttributes.put(ROLE_RESOURCES, new ModuleDataAttributeString(1));
    }

    public WorkItem(EOModuleData eo) {
        this();
        assert (eo != null) : "eo must not be null";
        assert (this.getTypeID().equals(eo.getTypeID()));
        this.fillWithEncodableObject(eo);
    }

    public static List getAttributeKeysForPermissions() {
        return ATTRIBUTE_KEYS_FOR_PERMISSIONS;
    }

    public static String getAttributeDisplayName(String attributeKey) {
        String name = (String)ATTRIBUTE_MAP.get(attributeKey);
        if (name == null) {
            name = "-";
        }
        return name;
    }

    public String getDisplayRepresentation() {
        return this.getName().getDisplayStringRepresentation();
    }

    public void setDisplayRepresentation(String displayRepresentation) {
        this.getName().setValueViaDisplayStringRepresentation(displayRepresentation);
    }

    public String getTypeID() {
        return DATA_TYPE_UID;
    }

    public ModuleDataAttributeNonEmptyString getName() {
        return (ModuleDataAttributeNonEmptyString)this.moduleAttributes.get(ROLE_NAME);
    }

    public ModuleDataAttributeString getDescription() {
        return (ModuleDataAttributeString)this.moduleAttributes.get(ROLE_DESCRIPTION);
    }

    public ModuleDataAttributeDuration getWorkEstimated() {
        return (ModuleDataAttributeDuration)this.moduleAttributes.get(ROLE_WORK_ESTIMATED);
    }

    public ModuleDataAttributeDuration getWorkDone() {
        return (ModuleDataAttributeDuration)this.moduleAttributes.get(ROLE_WORK_DONE);
    }

    public ModuleDataAttributeDuration getWorkRemaining() {
        return (ModuleDataAttributeDuration)this.moduleAttributes.get(ROLE_WORK_REMAINING);
    }

    public ModuleDataAttributeString getResources() {
        return (ModuleDataAttributeString)this.moduleAttributes.get(ROLE_RESOURCES);
    }

    public boolean isComplete() {
        return this.getWorkRemaining().getValue() == 0L && this.getWorkDone().getValue() > 0L;
    }

    public void setUnit(short unit) {
        this.getWorkDone().setUnit((int)unit);
        this.getWorkEstimated().setUnit((int)unit);
        this.getWorkRemaining().setUnit((int)unit);
    }

    public void setHoursPerDay(int hoursPerDay) {
        this.getWorkDone().setHoursPerDay(hoursPerDay);
        this.getWorkEstimated().setHoursPerDay(hoursPerDay);
        this.getWorkRemaining().setHoursPerDay(hoursPerDay);
    }

    public ModuleDataAttributeDuration calculateForecast() {
        return this.getWorkDone().addDuration(this.getWorkRemaining());
    }

    public ModuleDataAttributeInteger calculatePercentWorkComplete() {
        long calculatedForecast = this.calculateForecast().getValue();
        if (calculatedForecast > 0L) {
            return new ModuleDataAttributeInteger((int)(1000L * this.getWorkDone().getValue() / calculatedForecast + 5L) / 10);
        }
        return new ModuleDataAttributeInteger(0);
    }

    public String getStatus() {
        if (this.isComplete()) {
            return "complete";
        }
        if (this.calculateForecast().getValue() > this.getWorkEstimated().getValue()) {
            return "underestimated";
        }
        return "intime";
    }

    public IIconResource getStatusDependentIcon() {
        String status = this.getStatus();
        if (status.equals("complete")) {
            return completedWorkItemIcon;
        }
        if (status.equals("underestimated")) {
            return underestimatedWorkItemIcon;
        }
        return this.getTypeDescription().getTypeIcon();
    }

    @Override
    public WorkItem getWorkItem() {
        return this;
    }

    protected final IModuleDataTypeDescription getTypeDescription_internal() {
        return DATA_TYPE_DESCRIPTION;
    }
}

