/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.messages;

import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.modulelib2.client.AbstractModulePlugin;
import com.arcway.cockpit.modulelib2.client.ModuleLabelProvider;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeBoolean;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDiscrete;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDuration;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeInteger;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeNonEmptyString;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeString;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeTimestamp;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.cockpit.modulelib2.client.messages.resources.ModuleIconResource;
import com.arcway.cockpit.modulelib2.shared.messages.EOModuleData;
import com.arcway.cockpit.projectplanningmodule2.client.Messages;
import com.arcway.cockpit.projectplanningmodule2.client.ProjectPlanningModule2Plugin;
import com.arcway.cockpit.projectplanningmodule2.client.messages.AbstractModuleDataAdapter;
import com.arcway.cockpit.projectplanningmodule2.client.messages.description.TaskDescription;
import de.plans.lib.localisation.ILabelProvider;
import de.plans.lib.resources.IIconResource;
import de.plans.lib.util.DateUtil;
import de.plans.lib.util.valueranges.DiscreteValue;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class Task
extends AbstractModuleDataAdapter
implements IPermissionOperand {
    public static final String DATA_TYPE_UID = "ppm2.task";
    public static final String IMAGE_NAME = "Task.gif";
    public static final String MODULE_DATA_NAME_KEY = "Task.DisplayName";
    public static final String MODULE_DATA_NAME = Messages.getString("Task.DisplayName");
    public static final String ROLE_START = "ppm.task.start";
    public static final String ROLE_FINISH = "ppm.task.finish";
    public static final String ROLE_NAME = "ppm.task.name";
    public static final String ROLE_RESOURCE_NAMES = "ppm.task.resourceNames";
    public static final String ROLE_IS_CRITICAL = "ppm.task.isCritical";
    public static final String ROLE_PRIORITY = "ppm.task.priority";
    public static final String ROLE_IMPORTED_STATE = "ppm.task.importedState";
    public static final String ROLE_IS_MILESTONE = "ppm.task.isMilestone";
    public static final String ROLE_IMPORTED_PERCENT_WORK_COMPLETE = "ppm.task.importedPercentWorkComplete";
    public static final String ROLE_IMPORTED_WORK = "ppm.task.importedWork";
    public static final String ROLE_ID = "ppm.task.ID";
    public static final String ROLE_EXTERNAL_UID = "ppm.task.externalUID";
    public static final String NAME_START_KEY = "Task.Start";
    public static final String NAME_FINISH_KEY = "Task.Finish";
    public static final String NAME_DURATION_KEY = "Task.Duration";
    public static final String NAME_NAME_KEY = "Task.Name";
    public static final String NAME_RESOURCE_NAMES_KEY = "Task.ResourceNames";
    public static final String NAME_IS_CRITICAL_KEY = "Task.IsCritical";
    public static final String NAME_PRIORITY_KEY = "Task.Priority";
    public static final String NAME_STATUS_KEY = "Task.Status";
    public static final String NAME_IS_MILESTONE_KEY = "Task.IsMilestone";
    public static final String NAME_IMPORTED_PERCENT_WORK_COMPLETE_KEY = "Task.OriginalPercentWorkComplete";
    public static final String NAME_IMPORTED_WORK_KEY = "Task.OriginalWork";
    public static final String NAME_ID_KEY = "Task.ID";
    public static final String NAME_EXTERNAL_UID_KEY = "Task.ExternalUID";
    public static final String NAME_START = Messages.getString("Task.Start");
    public static final String NAME_FINISH = Messages.getString("Task.Finish");
    public static final String NAME_DURATION = Messages.getString("Task.Duration");
    public static final String NAME_NAME = Messages.getString("Task.Name");
    public static final String NAME_RESOURCE_NAMES = Messages.getString("Task.ResourceNames");
    public static final String NAME_IS_CRITICAL = Messages.getString("Task.IsCritical");
    public static final String NAME_PRIORITY = Messages.getString("Task.Priority");
    public static final String NAME_STATUS = Messages.getString("Task.Status");
    public static final String NAME_IS_MILESTONE = Messages.getString("Task.IsMilestone");
    public static final String NAME_IMPORTED_PERCENT_WORK_COMPLETE = Messages.getString("Task.OriginalPercentWorkComplete");
    public static final String NAME_IMPORTED_WORK = Messages.getString("Task.OriginalWork");
    public static final String NAME_ID = Messages.getString("Task.ID");
    public static final String NAME_EXTERNAL_UID = Messages.getString("Task.ExternalUID");
    public static final String PERM_KEY_START_FINISH = "ppm.task.startppm.task.finish";
    public static final HashMap ATTRIBUTE_MAP = new HashMap();
    public static final List ATTRIBUTE_KEYS_FOR_PERMISSIONS;
    private static final DiscreteValue[] STATE_VALUES;
    public static final int STATE_COMPLETE = 0;
    public static final int STATE_ON_SCHEDULE = 1;
    public static final int STATE_LATE = 2;
    public static final int STATE_FUTURE = 3;
    public static final int STATE_NONE = 4;
    public static IModuleDataTypeDescription DATA_TYPE_DESCRIPTION;
    private static IIconResource lateTaskIcon;
    private static IIconResource lateUnderestimatedTaskIcon;
    private static IIconResource underestimatedTaskIcon;
    private static IIconResource milestoneIcon;
    private final ModuleDataAttributeDiscrete state;
    private final ModuleDataAttributeDuration workDone;
    private final ModuleDataAttributeDuration workRemaining;
    private final ModuleDataAttributeDuration workEstimated;
    private final ModuleDataAttributeString bottomUpResources;
    private int hoursPerDay = 8;

    static {
        ATTRIBUTE_MAP.put(ROLE_START, NAME_START);
        ATTRIBUTE_MAP.put(ROLE_FINISH, NAME_FINISH);
        ATTRIBUTE_MAP.put(PERM_KEY_START_FINISH, String.valueOf(NAME_START) + "/" + NAME_FINISH);
        ATTRIBUTE_MAP.put(ROLE_NAME, NAME_NAME);
        ATTRIBUTE_MAP.put(ROLE_RESOURCE_NAMES, NAME_RESOURCE_NAMES);
        ATTRIBUTE_MAP.put(ROLE_IS_CRITICAL, NAME_IS_CRITICAL);
        ATTRIBUTE_MAP.put(ROLE_PRIORITY, NAME_PRIORITY);
        ATTRIBUTE_MAP.put(ROLE_IMPORTED_WORK, NAME_IMPORTED_WORK);
        ATTRIBUTE_MAP.put(ROLE_IS_MILESTONE, NAME_IS_MILESTONE);
        ATTRIBUTE_MAP.put(ROLE_ID, NAME_ID);
        ATTRIBUTE_KEYS_FOR_PERMISSIONS = new ArrayList();
        ATTRIBUTE_KEYS_FOR_PERMISSIONS.add(ROLE_NAME);
        ATTRIBUTE_KEYS_FOR_PERMISSIONS.add(PERM_KEY_START_FINISH);
        ATTRIBUTE_KEYS_FOR_PERMISSIONS.add(ROLE_IS_MILESTONE);
        ATTRIBUTE_KEYS_FOR_PERMISSIONS.add(ROLE_IMPORTED_WORK);
        STATE_VALUES = new DiscreteValue[]{new DiscreteValue((ILabelProvider)new ModuleLabelProvider("Task.Status.Complete", Messages.class)), new DiscreteValue((ILabelProvider)new ModuleLabelProvider("Task.Status.OnSchedule", Messages.class)), new DiscreteValue((ILabelProvider)new ModuleLabelProvider("Task.Status.Late", Messages.class), (IIconResource)new ModuleIconResource((AbstractModulePlugin)ProjectPlanningModule2Plugin.getDefault(), "red_dot.gif")), new DiscreteValue((ILabelProvider)new ModuleLabelProvider("Task.Status.FutureTask", Messages.class)), new DiscreteValue((ILabelProvider)new ModuleLabelProvider("Task.Status.None", Messages.class))};
        DATA_TYPE_DESCRIPTION = new TaskDescription();
        lateUnderestimatedTaskIcon = new ModuleIconResource((AbstractModulePlugin)ProjectPlanningModule2Plugin.getDefault(), "TaskUnderestimatedLate.gif");
        underestimatedTaskIcon = new ModuleIconResource((AbstractModulePlugin)ProjectPlanningModule2Plugin.getDefault(), "TaskUnderestimated.gif");
        lateTaskIcon = new ModuleIconResource((AbstractModulePlugin)ProjectPlanningModule2Plugin.getDefault(), "TaskLate.gif");
        milestoneIcon = new ModuleIconResource((AbstractModulePlugin)ProjectPlanningModule2Plugin.getDefault(), "Milestone.gif");
    }

    public static DiscreteValue[] getStateKeys() {
        return STATE_VALUES;
    }

    public Task() {
        this.moduleAttributes.put(ROLE_START, new ModuleDataAttributeTimestamp(new Long(System.currentTimeMillis()), false));
        this.moduleAttributes.put(ROLE_FINISH, new ModuleDataAttributeTimestamp(new Long(System.currentTimeMillis()), false));
        this.moduleAttributes.put(ROLE_NAME, new ModuleDataAttributeNonEmptyString(1));
        this.moduleAttributes.put(ROLE_RESOURCE_NAMES, new ModuleDataAttributeString(1));
        this.moduleAttributes.put(ROLE_IS_CRITICAL, new ModuleDataAttributeBoolean());
        this.moduleAttributes.put(ROLE_PRIORITY, new ModuleDataAttributeInteger());
        this.moduleAttributes.put(ROLE_IMPORTED_STATE, new ModuleDataAttributeDiscrete(Task.getStateKeys(), 4));
        this.moduleAttributes.put(ROLE_IS_MILESTONE, new ModuleDataAttributeBoolean());
        this.moduleAttributes.put(ROLE_IMPORTED_WORK, new ModuleDataAttributeDuration());
        this.moduleAttributes.put(ROLE_IMPORTED_PERCENT_WORK_COMPLETE, new ModuleDataAttributeInteger());
        this.moduleAttributes.put(ROLE_ID, new ModuleDataAttributeInteger());
        this.moduleAttributes.put(ROLE_EXTERNAL_UID, new ModuleDataAttributeString(1));
        this.state = new ModuleDataAttributeDiscrete(Task.getStateKeys(), 4);
        this.workDone = new ModuleDataAttributeDuration(0L);
        this.workRemaining = new ModuleDataAttributeDuration(0L);
        this.workEstimated = new ModuleDataAttributeDuration(0L);
        this.bottomUpResources = new ModuleDataAttributeString("", 1);
    }

    public Task(EOModuleData eo) {
        this();
        assert (eo != null);
        assert (this.getTypeID().equals(eo.getTypeID()));
        this.fillWithEncodableObject(eo);
    }

    public static List getAttributeKeysForPermissions() {
        return ATTRIBUTE_KEYS_FOR_PERMISSIONS;
    }

    public static String getAttributeDisplayName(String attributeKey) {
        String name = (String)ATTRIBUTE_MAP.get(attributeKey);
        if (name == null) {
            name = "unknown";
        }
        return name;
    }

    public String getDisplayRepresentation() {
        return this.getName().getDisplayStringRepresentation();
    }

    public void setDisplayRepresentation(String displayRepresentation) {
    }

    public String getTypeID() {
        return DATA_TYPE_UID;
    }

    public ModuleDataAttributeTimestamp getStart() {
        return (ModuleDataAttributeTimestamp)this.moduleAttributes.get(ROLE_START);
    }

    public ModuleDataAttributeTimestamp getFinish() {
        return (ModuleDataAttributeTimestamp)this.moduleAttributes.get(ROLE_FINISH);
    }

    public ModuleDataAttributeDuration calculateDuration() {
        if (this.isMilestone().getValue()) {
            ModuleDataAttributeDuration duration = new ModuleDataAttributeDuration(0L);
            duration.setUnit(3);
            return duration;
        }
        int days = this.getStart().getValue() != null && this.getFinish().getValue() != null ? DateUtil.getWorkingDays((Date)new Date(this.getStart().getValue()), (Date)new Date(this.getFinish().getValue())) + 1 : 0;
        ModuleDataAttributeDuration duration = new ModuleDataAttributeDuration();
        duration.setUnit(3);
        duration.setHoursPerDay(this.getOriginalWork().getHoursPerDay());
        duration.setValueViaDisplayStringRepresentation("" + days);
        return duration;
    }

    public String getResourceNameDisplayRepresentation() {
        if (this.bottomUpResources.isEmpty()) {
            return this.getResourceNames().getDisplayStringRepresentation();
        }
        return this.bottomUpResources.getDisplayStringRepresentation();
    }

    public ModuleDataAttributeString getName() {
        return (ModuleDataAttributeString)this.moduleAttributes.get(ROLE_NAME);
    }

    public ModuleDataAttributeString getResourceNames() {
        return (ModuleDataAttributeString)this.moduleAttributes.get(ROLE_RESOURCE_NAMES);
    }

    public ModuleDataAttributeString getBottomUpResourceNames() {
        return (ModuleDataAttributeString)this.moduleAttributes.get(ROLE_RESOURCE_NAMES);
    }

    public ModuleDataAttributeBoolean isCritical() {
        return (ModuleDataAttributeBoolean)this.moduleAttributes.get(ROLE_IS_CRITICAL);
    }

    public ModuleDataAttributeInteger getPriority() {
        return (ModuleDataAttributeInteger)this.moduleAttributes.get(ROLE_PRIORITY);
    }

    public ModuleDataAttributeDiscrete getImportedState() {
        return (ModuleDataAttributeDiscrete)this.moduleAttributes.get(ROLE_IMPORTED_STATE);
    }

    public ModuleDataAttributeBoolean isMilestone() {
        return (ModuleDataAttributeBoolean)this.moduleAttributes.get(ROLE_IS_MILESTONE);
    }

    public ModuleDataAttributeDuration getOriginalWork() {
        return (ModuleDataAttributeDuration)this.moduleAttributes.get(ROLE_IMPORTED_WORK);
    }

    public ModuleDataAttributeInteger getOriginalPercentWorkComplete() {
        return (ModuleDataAttributeInteger)this.moduleAttributes.get(ROLE_IMPORTED_PERCENT_WORK_COMPLETE);
    }

    public ModuleDataAttributeInteger getID() {
        return (ModuleDataAttributeInteger)this.moduleAttributes.get(ROLE_ID);
    }

    public ModuleDataAttributeString getExternalUID() {
        return (ModuleDataAttributeString)this.moduleAttributes.get(ROLE_EXTERNAL_UID);
    }

    public String getPermissionOperandType() {
        return "ppm2.prmOperand.task";
    }

    public String getPermissionOperandUID() {
        return this.getUID();
    }

    public String getPermissionOperandDisplayName() {
        return this.getDisplayRepresentation();
    }

    public ModuleDataAttributeDiscrete getState() {
        return this.state;
    }

    public boolean isComplete() {
        return this.getState().getValue() == 0;
    }

    public boolean isOnSchedule() {
        return this.getState().getValue() == 1;
    }

    public boolean isLate() {
        return this.getState().getValue() == 2;
    }

    public boolean isFuture() {
        return this.getState().getValue() == 3;
    }

    public ModuleDataAttributeDuration getWorkDone() {
        return this.workDone;
    }

    public ModuleDataAttributeDuration getWorkRemaining() {
        return this.workRemaining;
    }

    public ModuleDataAttributeDuration getWorkEstimated() {
        return this.workEstimated;
    }

    public ModuleDataAttributeDuration calculateAbsoluteTolerance() {
        return this.getOriginalWork().subtractDuration(this.calculateWorkForecast());
    }

    public int calculateRelativeTolerance() {
        long workForecast = this.calculateWorkForecast().getValue();
        long originalWork = this.getOriginalWork().getValue();
        if (originalWork > workForecast) {
            return (int)(100L * (originalWork - workForecast) / originalWork);
        }
        return 0;
    }

    public ModuleDataAttributeDuration calculateWorkForecast() {
        return this.getWorkDone().addDuration(this.getWorkRemaining());
    }

    public int calculatePercentWorkComplete() {
        long forecast = this.calculateWorkForecast().getValue();
        if (forecast > 0L) {
            return (int)(100L * this.getWorkDone().getValue() / forecast);
        }
        return 0;
    }

    public boolean hasExternalRepresentation() {
        return this.getExternalUID().getValue() != null;
    }

    public void setHoursPerDay(int hoursPerDay) {
        this.workDone.setHoursPerDay(hoursPerDay);
        this.workEstimated.setHoursPerDay(hoursPerDay);
        this.workRemaining.setHoursPerDay(hoursPerDay);
        this.getOriginalWork().setHoursPerDay(hoursPerDay);
        this.hoursPerDay = hoursPerDay;
    }

    public int getHoursPerDay() {
        return this.hoursPerDay;
    }

    public String getStatus() {
        if (this.isMilestone().getValue()) {
            return "milestone";
        }
        if (this.isLate()) {
            if (this.calculateWorkForecast().getValue() > this.getOriginalWork().getValue()) {
                return "late-underestimated";
            }
            return "late";
        }
        if (this.calculateWorkForecast().getValue() > this.getOriginalWork().getValue()) {
            return "intime-underestimated";
        }
        return "intime";
    }

    public IIconResource getStatusDependentIcon() {
        String status = this.getStatus();
        if (status.equals("milestone")) {
            return milestoneIcon;
        }
        if (status.equals("late")) {
            return lateTaskIcon;
        }
        if (status.equals("late-underestimated")) {
            return lateUnderestimatedTaskIcon;
        }
        if (status.equals("intime-underestimated")) {
            return underestimatedTaskIcon;
        }
        return this.getTypeDescription().getTypeIcon();
    }

    protected final IModuleDataTypeDescription getTypeDescription_internal() {
        return DATA_TYPE_DESCRIPTION;
    }
}

