/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.messages;

import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDuration;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeInteger;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeNonEmptyString;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeString;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeTimestamp;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.cockpit.modulelib2.shared.messages.EOModuleData;
import com.arcway.cockpit.projectplanningmodule2.client.Messages;
import com.arcway.cockpit.projectplanningmodule2.client.gui.actions.ProjectPlanActionFilter;
import com.arcway.cockpit.projectplanningmodule2.client.messages.AbstractModuleDataAdapter;
import com.arcway.cockpit.projectplanningmodule2.client.messages.description.ProjectPlanDescription;
import de.plans.lib.util.DateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eclipse.ui.IActionFilter;

public class ProjectPlan
extends AbstractModuleDataAdapter
implements IPermissionOperand,
IActionFilter {
    public static final String DATA_TYPE_UID = "ppm2.projectplan";
    public static final String MODULE_DATA_NAME_KEY = "ProjectPlan.ProjectPlan";
    public static final String MODULE_DATA_NAME = Messages.getString("ProjectPlan.ProjectPlan");
    public static final String IMAGE_NAME = "Project.gif";
    public static final String ROLE_NAME = "ppm.projectplan.name";
    public static final String ROLE_ORIGINAL_WORK = "ppm.projectplan.originalWork";
    public static final String ROLE_DESCRIPTION = "ppm.projectplan.description";
    public static final String ROLE_HOURS_PER_DAY = "ppm.projectplan.hoursPerDay";
    public static final String ROLE_EXTERNAL_UID = "ppm.projectplan.externalUID";
    public static final String NAME_NAME_KEY = "ProjectPlan.Name";
    public static final String NAME_START_KEY = "ProjectPlan.Start";
    public static final String NAME_FINISH_KEY = "ProjectPlan.Finish";
    public static final String NAME_DURATION_KEY = "ProjectPlan.Duration";
    public static final String NAME_WORK_KEY = "ProjectPlan.Work";
    public static final String NAME_WORK_DONE_KEY = "ProjectPlan.WorkDone";
    public static final String NAME_ORIGINAL_WORK_KEY = "ProjectPlan.OriginalWork";
    public static final String NAME_DESCRIPTION_KEY = "ProjectPlan.Description";
    public static final String NAME_HOURS_PER_DAY_KEY = "ProjectPlan.HoursPerDay";
    public static final String NAME_EXTERNAL_UID_KEY = "ProjectPlan.ExternalUID";
    public static final String NAME_NAME = Messages.getString("ProjectPlan.Name");
    public static final String NAME_START = Messages.getString("ProjectPlan.Start");
    public static final String NAME_FINISH = Messages.getString("ProjectPlan.Finish");
    public static final String NAME_DURATION = Messages.getString("ProjectPlan.Duration");
    public static final String NAME_WORK = Messages.getString("ProjectPlan.Work");
    public static final String NAME_WORK_DONE = Messages.getString("ProjectPlan.WorkDone");
    public static final String NAME_ORIGINAL_WORK = Messages.getString("ProjectPlan.OriginalWork");
    public static final String NAME_DESCRIPTION = Messages.getString("ProjectPlan.Description");
    public static final String NAME_HOURS_PER_DAY = Messages.getString("ProjectPlan.HoursPerDay");
    public static final String NAME_EXTERNAL_UID = Messages.getString("ProjectPlan.ExternalUID");
    private final ModuleDataAttributeTimestamp start = new ModuleDataAttributeTimestamp(null, false);
    private final ModuleDataAttributeTimestamp finish = new ModuleDataAttributeTimestamp(null, false);
    private final ModuleDataAttributeDuration workDone = new ModuleDataAttributeDuration();
    private final ModuleDataAttributeDuration workRemaining = new ModuleDataAttributeDuration();
    private final ModuleDataAttributeDuration workEstimated = new ModuleDataAttributeDuration();
    public static final HashMap ATTRIBUTE_MAP = new HashMap();
    public static final List ATTRIBUTE_KEYS_FOR_PERMISSIONS;
    public static IModuleDataTypeDescription DATA_TYPE_DESCRIPTION;

    static {
        ATTRIBUTE_MAP.put(ROLE_NAME, NAME_NAME);
        ATTRIBUTE_MAP.put(ROLE_ORIGINAL_WORK, NAME_ORIGINAL_WORK);
        ATTRIBUTE_MAP.put(ROLE_DESCRIPTION, NAME_DESCRIPTION);
        ATTRIBUTE_MAP.put(ROLE_HOURS_PER_DAY, NAME_HOURS_PER_DAY);
        ATTRIBUTE_KEYS_FOR_PERMISSIONS = new ArrayList();
        ATTRIBUTE_KEYS_FOR_PERMISSIONS.add(ROLE_NAME);
        ATTRIBUTE_KEYS_FOR_PERMISSIONS.add(ROLE_DESCRIPTION);
        DATA_TYPE_DESCRIPTION = new ProjectPlanDescription();
    }

    public ProjectPlan() {
        this.moduleAttributes.put(ROLE_NAME, new ModuleDataAttributeNonEmptyString(1));
        this.moduleAttributes.put(ROLE_ORIGINAL_WORK, new ModuleDataAttributeDuration());
        this.moduleAttributes.put(ROLE_DESCRIPTION, new ModuleDataAttributeString(2));
        this.moduleAttributes.put(ROLE_HOURS_PER_DAY, new ModuleDataAttributeInteger(8));
        this.moduleAttributes.put(ROLE_EXTERNAL_UID, new ModuleDataAttributeString(1));
    }

    public ProjectPlan(EOModuleData eo) {
        this();
        assert (eo != null);
        assert (this.getTypeID().equals(eo.getTypeID()));
        this.fillWithEncodableObject(eo);
    }

    public static List getAttributeKeysForPermissions() {
        return ATTRIBUTE_KEYS_FOR_PERMISSIONS;
    }

    public static String getAttributeDisplayName(String attributeKey) {
        String name = (String)ATTRIBUTE_MAP.get(attributeKey);
        if (name == null) {
            name = "unknown";
        }
        return name;
    }

    public String getDisplayRepresentation() {
        return this.getName().getDisplayStringRepresentation();
    }

    public void setDisplayRepresentation(String displayRepresentation) {
        this.getName().setValueViaDisplayStringRepresentation(displayRepresentation);
    }

    public String getTypeID() {
        return DATA_TYPE_UID;
    }

    public ModuleDataAttributeString getName() {
        return (ModuleDataAttributeString)this.moduleAttributes.get(ROLE_NAME);
    }

    public ModuleDataAttributeTimestamp getStart() {
        return this.start;
    }

    public ModuleDataAttributeTimestamp getFinish() {
        return this.finish;
    }

    public ModuleDataAttributeDuration calculateDuration() {
        int days = this.start.getValue() != null && this.finish.getValue() != null ? DateUtil.getWorkingDays((Date)new Date(this.start.getValue()), (Date)new Date(this.finish.getValue())) + 1 : 0;
        ModuleDataAttributeDuration duration = new ModuleDataAttributeDuration();
        duration.setUnit(3);
        duration.setHoursPerDay(this.getHoursPerDay().getValue());
        duration.setValueViaDisplayStringRepresentation("" + days);
        return duration;
    }

    public ModuleDataAttributeDuration calculateWorkForecast() {
        return this.getWorkDone().addDuration(this.getWorkRemaining());
    }

    public ModuleDataAttributeDuration calculateAbsoluteTolerance() {
        return this.getOriginalWork().subtractDuration(this.calculateWorkForecast());
    }

    public int calculateRelativeTolerance() {
        long workForcast = this.calculateWorkForecast().getValue();
        long originalWork = this.getOriginalWork().getValue();
        if (originalWork > workForcast) {
            return (int)(100L * (originalWork - workForcast) / originalWork);
        }
        return 0;
    }

    public int calculateWorkComplete() {
        long forecast = this.calculateWorkForecast().getValue();
        if (forecast > 0L) {
            return (int)(100L * this.getWorkDone().getValue() / forecast);
        }
        return 0;
    }

    public ModuleDataAttributeDuration getWorkRemaining() {
        return this.workRemaining;
    }

    public ModuleDataAttributeDuration getWorkDone() {
        return this.workDone;
    }

    public ModuleDataAttributeDuration getWorkEstimated() {
        return this.workEstimated;
    }

    public ModuleDataAttributeDuration getOriginalWork() {
        return (ModuleDataAttributeDuration)this.moduleAttributes.get(ROLE_ORIGINAL_WORK);
    }

    public ModuleDataAttributeString getDescription() {
        return (ModuleDataAttributeString)this.moduleAttributes.get(ROLE_DESCRIPTION);
    }

    public ModuleDataAttributeInteger getHoursPerDay() {
        return (ModuleDataAttributeInteger)this.moduleAttributes.get(ROLE_HOURS_PER_DAY);
    }

    public ModuleDataAttributeString getExternalUID() {
        return (ModuleDataAttributeString)this.moduleAttributes.get(ROLE_EXTERNAL_UID);
    }

    public String getPermissionOperandType() {
        return "ppm2.prmOperand.projectPlan";
    }

    public String getPermissionOperandUID() {
        return this.getUID();
    }

    public String getPermissionOperandDisplayName() {
        return this.getDisplayRepresentation();
    }

    public boolean testAttribute(Object target, String name, String value) {
        return ProjectPlanActionFilter.testAttribute(target, name, value);
    }

    protected final IModuleDataTypeDescription getTypeDescription_internal() {
        return DATA_TYPE_DESCRIPTION;
    }
}

