/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.messages;

import com.arcway.cockpit.modulelib2.shared.messages.AbstractLinkTypeHelper_Shared;
import com.arcway.cockpit.modulelib2.shared.messages.ILinkTypeHelper_Shared;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class PPMLinkTypeHelper_Shared
extends AbstractLinkTypeHelper_Shared {
    public static final String LTID_TASK_PROJECTPLAN = "TaskProjectPlan";
    public static final String LTID_TASK_TASK = "TaskTask";
    public static final String LTID_WORKITEM_TASK = "WorkItemTask";
    public static final String LTID_WORKITEM_CATEGORY = "WorkItemCategory";
    public static final String LTID_WORKITEM_RESPONSIBLE = "WorkItemStakeholder";
    public static final String LTID_WORKITEM_UE = "WorkItemUniqueElement";
    public static final String LTID_PROJECT_SOURCEFILE = "ProjectSourceFile";
    public static final String LTID_PROJECTPLAN_SECTION = PPMLinkTypeHelper_Shared.getDefault().getSectionLinkTypeID("ppm2.projectplan");
    private static ILinkTypeHelper_Shared singleton;

    private PPMLinkTypeHelper_Shared() {
    }

    public static ILinkTypeHelper_Shared getDefault() {
        if (singleton == null) {
            singleton = new PPMLinkTypeHelper_Shared();
        }
        return singleton;
    }

    protected String getModuleDataDataTypeIDForLinkType_(String linkTypeID) {
        assert (linkTypeID != null) : "linkTypeID must not be null";
        if (linkTypeID.equals(LTID_TASK_PROJECTPLAN)) {
            return "ppm2.task";
        }
        if (linkTypeID.equals(LTID_TASK_TASK)) {
            return "ppm2.task";
        }
        if (linkTypeID.equals(LTID_WORKITEM_TASK)) {
            return "ppm2.workitem";
        }
        if (linkTypeID.equals(LTID_WORKITEM_CATEGORY)) {
            return "ppm2.workitem";
        }
        if (linkTypeID.equals(LTID_WORKITEM_RESPONSIBLE)) {
            return "ppm2.workitem";
        }
        if (linkTypeID.equals(LTID_WORKITEM_UE)) {
            return "ppm2.workitem";
        }
        if (linkTypeID.equals(LTID_PROJECT_SOURCEFILE)) {
            return "ppm2.projectplan";
        }
        return null;
    }

    protected String getLinkableObjectDataTypeIDForLinkType_(String linkTypeID) {
        if (linkTypeID.equals(LTID_TASK_PROJECTPLAN)) {
            return "ppm2.projectplan";
        }
        if (linkTypeID.equals(LTID_TASK_TASK)) {
            return "ppm2.task";
        }
        if (linkTypeID.equals(LTID_WORKITEM_TASK)) {
            return "ppm2.task";
        }
        if (linkTypeID.equals(LTID_WORKITEM_CATEGORY)) {
            return "ppm2.workitemcategory";
        }
        if (linkTypeID.equals(LTID_WORKITEM_RESPONSIBLE)) {
            return "com.arcway.cockpit.stakeholder";
        }
        if (linkTypeID.equals(LTID_WORKITEM_UE)) {
            return "com.arcway.cockpit.uniqueelement";
        }
        if (linkTypeID.equals(LTID_PROJECT_SOURCEFILE)) {
            return "ppm2.sourceFile";
        }
        return null;
    }

    public Collection getLinkTypeIDsForModuleDataDataType(String dataTypeUID) {
        assert (dataTypeUID != null) : "dataTypeUID must not be null";
        List<String> linkTypeIDs_ = dataTypeUID.equals("ppm2.task") ? Arrays.asList(LTID_TASK_PROJECTPLAN, LTID_TASK_TASK) : (dataTypeUID.equals("ppm2.workitem") ? Arrays.asList(LTID_WORKITEM_TASK, LTID_WORKITEM_CATEGORY, LTID_WORKITEM_RESPONSIBLE, LTID_WORKITEM_UE) : (dataTypeUID.equals("ppm2.projectplan") ? Arrays.asList(LTID_PROJECT_SOURCEFILE) : new ArrayList<String>()));
        return new ArrayList<String>(linkTypeIDs_);
    }

    public Collection getLinkTypeIDsForLinkableObjectDataType(String dataTypeUID) {
        assert (dataTypeUID != null) : "dataTypeUID must not be null";
        List<String> linkTypeIDs_ = dataTypeUID.equals("ppm2.task") ? Arrays.asList(LTID_TASK_PROJECTPLAN) : (dataTypeUID.equals("ppm2.task") ? Arrays.asList(LTID_WORKITEM_TASK, LTID_TASK_TASK) : (dataTypeUID.equals("ppm2.workitemcategory") ? Arrays.asList(LTID_WORKITEM_CATEGORY) : (dataTypeUID.equals("ppm2.sourceFile") ? Arrays.asList(LTID_PROJECT_SOURCEFILE) : new ArrayList<String>())));
        return new ArrayList<String>(linkTypeIDs_);
    }

    public String getHierarchyLinkTypeID(String parentTypeID, String childTypeID) {
        if (parentTypeID.equals("ppm2.projectplan") && childTypeID.equals("ppm2.task")) {
            return LTID_TASK_PROJECTPLAN;
        }
        if (parentTypeID.equals("ppm2.projectplan") && childTypeID.equals("ppm2.sourceFile")) {
            return LTID_PROJECT_SOURCEFILE;
        }
        if (parentTypeID.equals("ppm2.task") && childTypeID.equals("ppm2.workitem")) {
            return LTID_WORKITEM_TASK;
        }
        return null;
    }

    public boolean isUELinkType(String linkTypeID) {
        assert (linkTypeID != null) : "linkTypeID must not be null";
        return linkTypeID.equals(LTID_WORKITEM_UE);
    }

    public boolean isLELinkType(String linkTypeID) {
        return false;
    }

    public String getModelElementLinkTypeIDForModuleDataDataType(String dataTypeUID) {
        if (dataTypeUID.equals("ppm2.workitem")) {
            return LTID_WORKITEM_UE;
        }
        return null;
    }

    public boolean hasLinkableObjectContributionFromFrame_(String linkTypeID) {
        return LTID_WORKITEM_UE.equals(linkTypeID) || LTID_WORKITEM_RESPONSIBLE.equals(linkTypeID);
    }
}

