/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.messages;

import com.arcway.cockpit.modulelib2.client.messages.DataTypesHelper;
import com.arcway.cockpit.modulelib2.client.messages.IDataTypesHelper;
import com.arcway.cockpit.modulelib2.client.messages.IDataTypesHelper_Core;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.cockpit.projectplanningmodule2.client.messages.description.ProjectPlanDescription;
import com.arcway.cockpit.projectplanningmodule2.client.messages.description.SourceFileDescription;
import com.arcway.cockpit.projectplanningmodule2.client.messages.description.TaskDescription;
import com.arcway.cockpit.projectplanningmodule2.client.messages.description.WorkItemCategoryDescription;
import com.arcway.cockpit.projectplanningmodule2.client.messages.description.WorkItemDescription;
import com.arcway.lib.java.collectionmaps.SetMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PPMDataTypesHelper
implements IDataTypesHelper_Core {
    private static IDataTypesHelper singleton;
    private static final Collection<String> administrativeDataTypes;
    private static final Collection<String> documentationDataTypes;
    private static final Collection<String> virtualDataTypes;
    private static final SetMap<String, String> map_childTypeID_parentTypeIDs;
    private static final Map<String, IModuleDataTypeDescription> map_typeID_typeDescription;

    static {
        administrativeDataTypes = Arrays.asList("ppm2.workitemcategory");
        documentationDataTypes = Arrays.asList("ppm2.projectplan", "ppm2.task", "ppm2.workitem", "ppm2.sourceFile");
        virtualDataTypes = Collections.emptyList();
        map_childTypeID_parentTypeIDs = new SetMap();
        map_childTypeID_parentTypeIDs.add((Object)"ppm2.projectplan", (Object)"hierarchyroot");
        map_childTypeID_parentTypeIDs.add((Object)"ppm2.task", (Object)"ppm2.projectplan");
        map_childTypeID_parentTypeIDs.add((Object)"ppm2.task", (Object)"ppm2.task");
        map_childTypeID_parentTypeIDs.add((Object)"ppm2.workitem", (Object)"hierarchyroot");
        map_childTypeID_parentTypeIDs.add((Object)"ppm2.workitem", (Object)"ppm2.task");
        map_childTypeID_parentTypeIDs.add((Object)"ppm2.sourceFile", (Object)"ppm2.projectplan");
        map_typeID_typeDescription = new HashMap<String, IModuleDataTypeDescription>();
        map_typeID_typeDescription.put("ppm2.projectplan", (IModuleDataTypeDescription)new ProjectPlanDescription());
        map_typeID_typeDescription.put("ppm2.task", (IModuleDataTypeDescription)new TaskDescription());
        map_typeID_typeDescription.put("ppm2.workitem", (IModuleDataTypeDescription)new WorkItemDescription());
        map_typeID_typeDescription.put("ppm2.sourceFile", (IModuleDataTypeDescription)new SourceFileDescription());
        map_typeID_typeDescription.put("ppm2.workitemcategory", (IModuleDataTypeDescription)new WorkItemCategoryDescription());
    }

    public static IDataTypesHelper getDefault() {
        if (singleton == null) {
            singleton = new DataTypesHelper((IDataTypesHelper_Core)new PPMDataTypesHelper());
        }
        return singleton;
    }

    private PPMDataTypesHelper() {
    }

    public Collection<String> getAdministrativeDataTypes() {
        return administrativeDataTypes;
    }

    public Collection<String> getDocumentationDataTypes() {
        return documentationDataTypes;
    }

    public Collection<String> getVirtualDataTypes() {
        return virtualDataTypes;
    }

    public Collection<String> getParentTypeIDs(String childTypeID) {
        return map_childTypeID_parentTypeIDs.get((Object)childTypeID);
    }

    public IModuleDataTypeDescription getTypeDescription(String typeID) {
        return map_typeID_typeDescription.get(typeID);
    }
}

