/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.gui.projection;

import com.arcway.cockpit.projectplanningmodule2.client.ProjectPlanningModule2Plugin;
import com.arcway.cockpit.projectplanningmodule2.client.gui.projection.DimensionedWorkProgressProjectionFactory;
import com.arcway.planagent.controllinginterface.lib.projections.BubbleContainerProjection;
import com.arcway.planagent.controllinginterface.lib.projections.ProgressBarProjection;
import com.arcway.planagent.controllinginterface.lib.projections.TextLabelProjection;
import com.arcway.planagent.controllinginterface.planviewer.IProjection;
import de.plans.lib.util.LocalisationUtils;
import org.eclipse.jface.preference.IPreferenceStore;

public class WorkProgressProjectionFactory {
    private WorkProgressProjectionFactory() {
    }

    public static IProjection createProjection(float work, float workComplete, float workEstimated, float percentWorkComplete) {
        BubbleContainerProjection bubbleFctry = null;
        if (percentWorkComplete >= 0.0f && work >= 0.0f && workComplete >= 0.0f && workEstimated >= 0.0f) {
            IPreferenceStore store = ProjectPlanningModule2Plugin.getDefault().getPreferenceStore();
            String selectedProjection = store.getString("ppm2.projections.workprogress");
            if (selectedProjection == null || selectedProjection.length() == 0) {
                selectedProjection = "ppm2.projections.progress_with_estimation_h";
            }
            if ("ppm2.projections.progress_with_estimation_h".equals(selectedProjection)) {
                IProjection fctry = DimensionedWorkProgressProjectionFactory.createProjection(workEstimated, workComplete, work - workComplete);
                bubbleFctry = new BubbleContainerProjection(fctry);
            } else if ("ppm2.projections.progress_with_estimation_p".equals(selectedProjection)) {
                IProjection fctry = DimensionedWorkProgressProjectionFactory.createProjection(workEstimated, workComplete, work - workComplete, (int)percentWorkComplete);
                bubbleFctry = new BubbleContainerProjection(fctry);
            } else if ("ppm2.projections.progress_without_estimation".equals(selectedProjection)) {
                ProgressBarProjection progressFctry = new ProgressBarProjection((int)percentWorkComplete);
                String requestText = String.valueOf(LocalisationUtils.roundLocalized((double)workComplete, (int)2, (boolean)true)) + "h / " + LocalisationUtils.roundLocalized((double)work, (int)2, (boolean)true) + "h";
                TextLabelProjection textFctry = new TextLabelProjection(requestText);
                IProjection[] factories = new IProjection[]{progressFctry, textFctry};
                bubbleFctry = new BubbleContainerProjection(factories);
            }
        }
        assert (bubbleFctry != null) : "invalid datas for creating this projection";
        return bubbleFctry;
    }
}

