/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.gui.projection;

import com.arcway.cockpit.frame.client.global.selection.CockpitSelectionManager;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.frame.client.project.planeditors.projections.IProjectionPreferencePage;
import com.arcway.cockpit.projectplanningmodule2.client.Messages;
import com.arcway.cockpit.projectplanningmodule2.client.ProjectPlanningModule2Plugin;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ProjectionManager;
import com.arcway.cockpit.projectplanningmodule2.client.gui.projection.ProjectPlanningProjectionsLicenseHandler;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class ProjectionPreferencePage
extends PreferencePage
implements IProjectionPreferencePage {
    private static final String WORK_PROGRESS_SETTINGS_GROUP_LABEL = Messages.getString("ProjectionPreferencePage.WorkProgressSettingsGroup");
    private static final String WORK_PROGRESS_SETTINGS_LABEL = Messages.getString("ProjectionPreferencePage.WorkProgressSettings");
    private static final String APPLY_DATA_VIEW_FILTER_GROUP_LABEL = Messages.getString("ProjectionPreferencePage.ApplyFilterGroup");
    private static final String APPLY_DATA_VIEW_FILTER_LABEL = Messages.getString("ProjectionPreferencePage.ApplyFilter");
    private static final String WORK_PROGRESS_WITH_ESTIMATION_H = Messages.getString("ProjectionPreferencePage.WithEstimationH");
    private static final String WORK_PROGRESS_WITH_ESTIMATION_P = Messages.getString("ProjectionPreferencePage.WithEstimationP");
    private static final String WORK_PROGRESS_NO_ESTIMATION = Messages.getString("ProjectionPreferencePage.WithoutEstimation");
    private Button applyDataViewFilterButton;
    private ProjectPlanningProjectionsLicenseHandler licenseHandler;
    private Button btn_estimateHours;
    private Button btn_estimatePercent;
    private Button btn_estimateNone;
    private Composite parent;

    protected Control createContents(Composite parentComposite) {
        this.parent = parentComposite;
        if (this.licenseHandler == null) {
            this.licenseHandler = new ProjectPlanningProjectionsLicenseHandler();
        }
        if (this.licenseHandler.anyProjectHasLicense()) {
            Composite composite = new Composite(parentComposite, 0);
            GridLayout layout = new GridLayout();
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(768));
            Group grp_progress = new Group(composite, 0);
            grp_progress.setText(WORK_PROGRESS_SETTINGS_GROUP_LABEL);
            layout = new GridLayout(2, false);
            layout.marginTop = 10;
            layout.horizontalSpacing = 10;
            grp_progress.setLayout((Layout)layout);
            grp_progress.setLayoutData((Object)new GridData(768));
            Label lbl_progress = new Label((Composite)grp_progress, 0);
            lbl_progress.setText(WORK_PROGRESS_SETTINGS_LABEL);
            GridData gd = new GridData(1, 1, false, false);
            gd.verticalSpan = 3;
            lbl_progress.setLayoutData((Object)gd);
            this.btn_estimateHours = new Button((Composite)grp_progress, 16);
            this.btn_estimateHours.setText(WORK_PROGRESS_WITH_ESTIMATION_H);
            gd = new GridData(768);
            this.btn_estimateHours.setLayoutData((Object)gd);
            this.btn_estimatePercent = new Button((Composite)grp_progress, 16);
            this.btn_estimatePercent.setText(WORK_PROGRESS_WITH_ESTIMATION_P);
            gd = new GridData(768);
            this.btn_estimatePercent.setLayoutData((Object)gd);
            this.btn_estimateNone = new Button((Composite)grp_progress, 16);
            this.btn_estimateNone.setText(WORK_PROGRESS_NO_ESTIMATION);
            gd = new GridData(768);
            this.btn_estimateNone.setLayoutData((Object)gd);
            Group grp_filter = new Group(composite, 0);
            grp_filter.setText(APPLY_DATA_VIEW_FILTER_GROUP_LABEL);
            layout = new GridLayout(2, false);
            layout.marginTop = 10;
            grp_filter.setLayout((Layout)layout);
            grp_filter.setLayoutData((Object)new GridData(768));
            this.applyDataViewFilterButton = new Button((Composite)grp_filter, 16416);
            this.applyDataViewFilterButton.setText(APPLY_DATA_VIEW_FILTER_LABEL);
            this.init();
            return composite;
        }
        this.noDefaultAndApplyButton();
        return this.licenseHandler.createNoLicensePage(parentComposite);
    }

    public void init() {
        IPreferenceStore store = this.doGetPreferenceStore();
        this.applyDataViewFilterButton.setSelection(store.getBoolean("ppm2.projections.preference.applydataviewfilter"));
        String workProgressPreference = store.getString("ppm2.projections.workprogress");
        if (workProgressPreference.equals("ppm2.projections.progress_with_estimation_h")) {
            this.btn_estimateHours.setSelection(true);
        } else if (workProgressPreference.equals("ppm2.projections.progress_with_estimation_p")) {
            this.btn_estimatePercent.setSelection(true);
        } else if (workProgressPreference.equals("ppm2.projections.progress_without_estimation")) {
            this.btn_estimateNone.setSelection(true);
        }
    }

    public void performApply() {
        IPreferenceStore store = this.doGetPreferenceStore();
        store.setValue("ppm2.projections.preference.applydataviewfilter", this.applyDataViewFilterButton.getSelection());
        String selectionToStore = null;
        if (this.btn_estimateHours.getSelection()) {
            selectionToStore = "ppm2.projections.progress_with_estimation_h";
        } else if (this.btn_estimatePercent.getSelection()) {
            selectionToStore = "ppm2.projections.progress_with_estimation_p";
        } else if (this.btn_estimateNone.getSelection()) {
            selectionToStore = "ppm2.projections.progress_without_estimation";
        }
        if (selectionToStore != null) {
            store.setValue("ppm2.projections.workprogress", selectionToStore);
        }
    }

    public boolean performOk() {
        this.performApply();
        if (this.parent.isVisible()) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IModuleProjectAgent projectAgent = CockpitSelectionManager.getSelectionService((ISelectionService)page.getActivePart().getSite().getWorkbenchWindow().getSelectionService()).getModuleProjectAgent();
            String currentProjectUid = projectAgent.getProjectUID();
            ProjectionManager currentProjectionManager = (ProjectionManager)ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(currentProjectUid).getProjectionManager();
            currentProjectionManager.updateProjections(page);
        }
        return true;
    }

    protected void performDefaults() {
        IPreferenceStore store = this.doGetPreferenceStore();
        this.applyDataViewFilterButton.setSelection(store.getDefaultBoolean("ppm2.projections.preference.applydataviewfilter"));
        String defaultString = store.getDefaultString("ppm2.projections.workprogress");
        if (defaultString.equals("ppm2.projections.progress_with_estimation_h")) {
            this.btn_estimateHours.setSelection(true);
            this.btn_estimatePercent.setSelection(false);
            this.btn_estimateNone.setSelection(false);
        } else if (defaultString.equals("ppm2.projections.progress_with_estimation_p")) {
            this.btn_estimatePercent.setSelection(true);
            this.btn_estimateHours.setSelection(false);
            this.btn_estimateNone.setSelection(false);
        } else if (defaultString.equals("ppm2.projections.progress_without_estimation")) {
            this.btn_estimateNone.setSelection(true);
            this.btn_estimateHours.setSelection(false);
            this.btn_estimatePercent.setSelection(false);
        }
        super.performDefaults();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return ProjectPlanningModule2Plugin.getDefault().getPreferenceStore();
    }

    public boolean isImmediateProjectionPossible(String projectUID) {
        return this.licenseHandler.checkLicense(projectUID);
    }
}

