/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.gui.projection;

import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.text.TextStyle;
import com.arcway.planagent.controllinginterface.lib.projections.DimensionedProgressBarProjection;
import com.arcway.planagent.controllinginterface.planviewer.IProjection;
import de.plans.lib.util.LocalisationUtils;

public class DimensionedWorkProgressProjectionFactory {
    private static final TextStyle textStyle = new TextStyle("Arial");
    private static final TextStyle textStyleBold = new TextStyle("Arial", true, false);

    public static IProjection createProjection(double workEstimated, double workDone, double workRemaining) {
        String barPartLeftLabel = String.valueOf(DimensionedWorkProgressProjectionFactory.workToString(workDone)) + "h";
        String barPartRightLabel = String.valueOf(DimensionedWorkProgressProjectionFactory.workToString(workRemaining)) + "h";
        return DimensionedWorkProgressProjectionFactory.createProjection(workEstimated, workDone, workRemaining, barPartLeftLabel, barPartRightLabel);
    }

    public static IProjection createProjection(double workEstimated, double workDone, double workRemaining, int percentComplete) {
        String barPartLeftLabel = String.valueOf(Integer.toString(percentComplete)) + "%";
        String barPartRightLabel = String.valueOf(Integer.toString(100 - percentComplete)) + "%";
        return DimensionedWorkProgressProjectionFactory.createProjection(workEstimated, workDone, workRemaining, barPartLeftLabel, barPartRightLabel);
    }

    private static String workToString(double work) {
        return LocalisationUtils.roundLocalized((double)work, (int)0, (boolean)true);
    }

    private DimensionedWorkProgressProjectionFactory() {
    }

    private static IProjection createProjection(double workEstimated, double workDone, double workRemaining, String barPartLeftLabel, String barPartRightLabel) {
        Color barLabelColor = workDone + workRemaining > workEstimated ? new Color(255, 107, 107) : new Color(77, 236, 137);
        return new DimensionedProgressBarProjection(64.0, 20.0, 8.0, 8.0, Color.GRAY, workEstimated, Color.BLACK, Color.BLACK, textStyleBold, DimensionedWorkProgressProjectionFactory.workToString(workEstimated), new FillColor(Color.BLACK), Color.WHITE, textStyle, barPartLeftLabel, workDone, new FillColor(barLabelColor), Color.BLACK, textStyle, barPartRightLabel, workRemaining, Color.BLACK, Color.BLACK, textStyleBold, DimensionedWorkProgressProjectionFactory.workToString(workDone + workRemaining));
    }
}

