/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.gui.menu.actions;

import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IModuleDataEditDialogProvider;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataCreationWizard;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.projectplanningmodule2.client.Messages;
import com.arcway.cockpit.projectplanningmodule2.client.ProjectPlanningModule2Plugin;
import com.arcway.cockpit.projectplanningmodule2.client.gui.dialogs.EditWorkItemAdapter;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItem;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

public class ActionNewWorkItemViaModelElement
extends Action {
    private IModelController modelCtrl;
    private final List<IUniqueElement> uniqueElements;
    private final Shell activeShell;

    public ActionNewWorkItemViaModelElement(Shell activeShell, List<IUniqueElement> uniqueElements) {
        this.activeShell = activeShell;
        this.uniqueElements = uniqueElements;
        if (uniqueElements.size() > 0) {
            String projectUID = uniqueElements.get(0).getProjectUID();
            this.modelCtrl = ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(projectUID);
        }
    }

    public void run() {
        assert (this.modelCtrl != null);
        EditWorkItemAdapter dialogProvider = new EditWorkItemAdapter(null, null, -1L);
        ModuleDataCreationWizard wizard = new ModuleDataCreationWizard((IModuleDataEditDialogProvider)dialogProvider, "ppm2.workitem", this.modelCtrl, Messages.getString("EditWorkItemDialog.EnterWorkItemAttributes"));
        WorkItem newItem = new WorkItem();
        newItem.setProjectUID(this.modelCtrl.getProjectUID());
        boolean creationPossible = wizard.initialiseWizard(new IModuleData[]{newItem}, new IModuleData[0]);
        if (!creationPossible) {
            return;
        }
        WizardDialog dialog = new WizardDialog(this.activeShell, (IWizard)wizard);
        if (dialog.open() == 0) {
            final WorkItem workItem = dialogProvider.getWorkItem();
            for (final IUniqueElement uniqueElement : this.uniqueElements) {
                this.modelCtrl.executeTransaction(new Runnable(){

                    @Override
                    public void run() {
                        ActionNewWorkItemViaModelElement.this.modelCtrl.createLink(uniqueElement.getUID(), (IModuleData)workItem, "WorkItemUniqueElement");
                    }
                });
            }
        }
    }
}

