/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.gui.menu.actions;

import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleLockManager;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IModuleDataEditDialogProvider;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataCreationWizard;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDuration;
import com.arcway.cockpit.projectplanningmodule2.client.Messages;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.gui.dialogs.EditWorkItemAdapter;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItem;
import java.util.Collection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

public class ActionNewWorkItem
extends Action {
    private final Shell activeShell;
    private final ModelController modelCtrl;
    private final Task parent;

    public ActionNewWorkItem(Shell activeShell, IModelController modelCtrl, Task parent) {
        this.activeShell = activeShell;
        this.modelCtrl = (ModelController)modelCtrl;
        this.parent = parent;
    }

    public void run() {
        assert (this.modelCtrl != null);
        ModuleLockManager lockMgr = (ModuleLockManager)this.modelCtrl.getLockMgr();
        LockAccess lock = lockMgr.acquireInsertLock((ICockpitProjectData)this.parent);
        if (!lock.hasLock()) {
            lock.releaseLocks();
            return;
        }
        Collection<WorkItem> alreadyExistingWorkItems = this.modelCtrl.getWorkItemChildren(this.parent);
        String proposedName = null;
        if (alreadyExistingWorkItems.size() == 0) {
            proposedName = this.parent.getName().getDisplayStringRepresentation();
        }
        ModuleDataAttributeDuration proposedEstimatedWork = this.parent.getOriginalWork();
        for (WorkItem workItem : alreadyExistingWorkItems) {
            proposedEstimatedWork = proposedEstimatedWork.subtractDuration(workItem.getWorkEstimated());
        }
        EditWorkItemAdapter dialogProvider = new EditWorkItemAdapter(this.parent, proposedName, proposedEstimatedWork.getValue());
        ModuleDataCreationWizard wizard = new ModuleDataCreationWizard((IModuleDataEditDialogProvider)dialogProvider, "ppm2.workitem", (IModelController)this.modelCtrl, Messages.getString("EditWorkItemDialog.EnterWorkItemAttributes"));
        WorkItem newItem = new WorkItem();
        newItem.setProjectUID(this.modelCtrl.getProjectUID());
        boolean creationPossible = wizard.initialiseWizard(new IModuleData[]{newItem}, new IModuleData[]{this.parent});
        if (!creationPossible) {
            lock.releaseLocks();
            return;
        }
        WizardDialog dialog = new WizardDialog(this.activeShell, (IWizard)wizard);
        if (dialog.open() != 0) {
            lock.releaseLocks();
        }
    }
}

