/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.gui.menu.actions;

import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.projectplanningmodule2.client.Messages;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.messages.ProjectPlan;
import com.arcway.cockpit.projectplanningmodule2.client.messages.SourceFile;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ActionDisconnectProjectPlan
extends Action {
    private static final ILogger LOGGER = Logger.getLogger(ActionDisconnectProjectPlan.class);
    private final IModelController modelCtrl;
    private final ProjectPlan plan;
    private final Shell activeShell;
    private final Runnable disconnect = new Runnable(){

        @Override
        public void run() {
            ActionDisconnectProjectPlan.this.disconnect();
        }
    };

    public ActionDisconnectProjectPlan(Shell activeShell, IModelController modelCtrl, ProjectPlan plan) {
        this.modelCtrl = modelCtrl;
        this.plan = plan;
        this.activeShell = activeShell;
    }

    public void run() {
        assert (this.modelCtrl != null);
        this.modelCtrl.executeTransaction(this.disconnect);
    }

    private void disconnect() {
        assert (this.plan != null) : "currentSelection must not be null";
        String fileName = "";
        Iterator sourceFiles = this.modelCtrl.getLinkableObjects((IModuleData)this.plan, "ProjectSourceFile").iterator();
        assert (sourceFiles.hasNext());
        if (!sourceFiles.hasNext()) {
            LOGGER.warn("Disconnect action: No source file found");
            return;
        }
        fileName = ((SourceFile)((Object)sourceFiles.next())).getPath().getDisplayStringRepresentation();
        AbstractLockManager lockManager = this.modelCtrl.getLockMgr();
        LockAccess lock = lockManager.acquireEditLock((ICockpitProjectData)this.plan, true);
        if (!lock.hasLock()) {
            lock.releaseLocks();
            return;
        }
        HashSet<LockAccess> locks = new HashSet<LockAccess>();
        if (this.requestLocks(locks)) {
            if (MessageDialog.openConfirm((Shell)this.activeShell, (String)Messages.getString("ActionDelegateDisconnect.Title"), (String)(String.valueOf(Messages.getString("ActionDelegateDisconnect.Text1")) + fileName + Messages.getString("ActionDelegateDisconnect.Text2")))) {
                ((ModelController)this.modelCtrl).disconnectProjectPlan(this.plan);
            } else {
                this.releaseLocks(locks);
            }
        }
    }

    private boolean requestLocks(Collection<LockAccess> locks) {
        AbstractLockManager lockMgr = this.modelCtrl.getLockMgr();
        for (Task task : this.modelCtrl.getModuleData((IModuleData)this.plan, "TaskProjectPlan")) {
            LockAccess lockAccess = lockMgr.acquireEditLock((ICockpitProjectData)task);
            if (!lockAccess.hasLock()) {
                this.releaseLocks(locks);
                return false;
            }
            locks.add(lockAccess);
            lockAccess = lockMgr.acquireRemoveLock((ICockpitProjectData)task);
            if (lockAccess.hasLock()) {
                locks.add(lockAccess);
                continue;
            }
            this.releaseLocks(locks);
            return false;
        }
        return true;
    }

    private void releaseLocks(Collection<LockAccess> locks) {
        for (LockAccess lockAccess : locks) {
            lockAccess.releaseLocks();
        }
    }
}

