/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.gui.menu.actions;

import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.projectplanningmodule2.client.ModuleIdentification;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.action.Action;

public class ActionDetachWorkItemFromTask
extends Action {
    private final IModelController modelCtrl;
    private final Collection<WorkItem> workItems;
    private final Collection<LockAccess> acquiredLocks = new ArrayList<LockAccess>();
    private final Runnable deAssignWorkItems = new Runnable(){

        @Override
        public void run() {
            ActionDetachWorkItemFromTask.this.deassignWorkItems();
        }
    };

    public ActionDetachWorkItemFromTask(IModelController modelCtrl, Collection<WorkItem> workItems) {
        this.modelCtrl = modelCtrl;
        this.workItems = workItems;
    }

    public void run() {
        this.modelCtrl.executeTransaction(this.deAssignWorkItems);
    }

    private void deassignWorkItems() {
        AbstractLockManager lockManager = this.modelCtrl.getLockMgr();
        this.acquiredLocks.clear();
        for (WorkItem workItem : this.workItems) {
            LockAccess lockAccess = lockManager.acquireMoveLockBeforeMoving((ICockpitProjectData)workItem, ModuleIdentification.getModuleID());
            if (lockAccess.hasLock()) {
                this.acquiredLocks.add(lockAccess);
                continue;
            }
            lockAccess.releaseLocks();
            Iterator<LockAccess> locks = this.acquiredLocks.iterator();
            while (locks.hasNext()) {
                locks.next().releaseLocks();
            }
            return;
        }
        for (WorkItem workItem : this.workItems) {
            Task parent = (Task)this.modelCtrl.getParent((IModuleData)workItem);
            this.modelCtrl.deleteLink(parent.getUID(), workItem.getUID(), "WorkItemTask");
            ((ModelController)this.modelCtrl).propagateAttributes_workItem(parent);
        }
    }
}

