/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.gui.menu.actions;

import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleLockManager;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.projectplanningmodule2.client.Messages;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.PermissionMgr;
import com.arcway.cockpit.projectplanningmodule2.client.messages.ProjectPlan;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ActionDelete
extends Action {
    private final Shell activeShell;
    private final IModelController modelCtrl;
    private final ArrayList<IModuleData> selection;
    private final Runnable delete = new Runnable(){

        @Override
        public void run() {
            ActionDelete.this.deleteItems(ActionDelete.this.selection);
        }
    };
    private static final int BUTTON_INDEX_DELETE = 0;
    private static final int BUTTON_INDEX_DETACH = 1;
    private static final int BUTTON_INDEX_CANCEL_WITHOUT_WORKITEMS = 1;
    private static final int BUTTON_INDEX_CANCEL_WITH_WORKITEMS = 2;
    private static final String[] BUTTON_LABELS_WITH_WORKITEMS = new String[]{Messages.getString("ActionDelegateDelete.ButtonLabelDeleteWorkItems"), Messages.getString("ActionDelegateDelete.ButtonLabelDetachWorkItems"), Messages.getString("ActionDelegateDelete.ButtonLabelCancel")};
    private static final String[] BUTTON_LABELS_WITHOUT_WORKITEMS = new String[]{Messages.getString("ActionDelegateDelete.ButtonLabelDelete"), Messages.getString("ActionDelegateDelete.ButtonLabelCancel")};

    public ActionDelete(Shell activeShell, IModelController modelCtrl, ArrayList<IModuleData> selection) {
        this.activeShell = activeShell;
        this.modelCtrl = modelCtrl;
        this.selection = selection;
    }

    public void run() {
        assert (this.selection != null);
        assert (this.modelCtrl != null) : "modelCtrl must not be null";
        this.modelCtrl.executeTransaction(this.delete);
    }

    public void deleteItems(List<IModuleData> items) {
        Task parent;
        assert (this.modelCtrl != null);
        PermissionMgr permissionMgr = (PermissionMgr)this.modelCtrl.getPermissionMgr();
        boolean hasPermission = permissionMgr.mayDeleteItems(items);
        if (!hasPermission) {
            permissionMgr.showNoPermissionMsg(this.activeShell);
            return;
        }
        ModuleLockManager lockMgr = (ModuleLockManager)this.modelCtrl.getLockMgr();
        ArrayList<LockAccess> aquiredLocks = new ArrayList<LockAccess>();
        for (IModuleData element : items) {
            LockAccess lock;
            if (element instanceof ProjectPlan) {
                ProjectPlan projectPlan = (ProjectPlan)element;
                lock = lockMgr.acquireRemoveLock((ICockpitProjectData)projectPlan);
                if (!lock.hasLock()) {
                    this.releaseLocks(aquiredLocks);
                    return;
                }
                aquiredLocks.add(lock);
                continue;
            }
            if (element instanceof Task) {
                Task task = (Task)element;
                lock = lockMgr.acquireRemoveLock((ICockpitProjectData)task);
                if (!lock.hasLock()) {
                    this.releaseLocks(aquiredLocks);
                    return;
                }
                aquiredLocks.add(lock);
                continue;
            }
            if (!(element instanceof WorkItem)) continue;
            WorkItem workItem = (WorkItem)element;
            lock = lockMgr.acquireRemoveLock((ICockpitProjectData)workItem);
            if (!lock.hasLock()) {
                this.releaseLocks(aquiredLocks);
                return;
            }
            aquiredLocks.add(lock);
        }
        ArrayList<IModuleData> parentsOfWorkItems = new ArrayList<IModuleData>();
        ArrayList<IModuleData> parentsOfTasks = new ArrayList<IModuleData>();
        int c = 0;
        while (c < items.size()) {
            IModuleData toDelete = items.get(c);
            IModuleData parent2 = this.modelCtrl.getParent(toDelete);
            if (toDelete instanceof WorkItem) {
                parentsOfWorkItems.add(parent2);
            } else if (toDelete instanceof Task) {
                parentsOfTasks.add(parent2);
            }
            ++c;
        }
        ArrayList subItemsToBeDeleted = new ArrayList();
        int c2 = 0;
        while (c2 < items.size()) {
            IModuleData toDelete = items.get(c2);
            if (toDelete instanceof ProjectPlan || toDelete instanceof Task) {
                subItemsToBeDeleted.addAll(this.modelCtrl.getAllDescendants(toDelete));
            }
            ++c2;
        }
        boolean subItemsContainWorkItems = false;
        Iterator i = subItemsToBeDeleted.iterator();
        while (i.hasNext()) {
            if (!(i.next() instanceof WorkItem)) continue;
            subItemsContainWorkItems = true;
            break;
        }
        MessageDialog dialog = subItemsContainWorkItems ? new MessageDialog(this.activeShell, Messages.getString("ActionDelegateDelete.ConfirmDeletionTitleWithWorkItems"), Display.getCurrent().getSystemImage(4), String.valueOf(Messages.getString("ActionDelegateDelete.ConfirmDeletionTextWithWorkItemsPart1")) + "\n\n" + Messages.getString("ActionDelegateDelete.ConfirmDeletionTextWithWorkItemsPart2"), 3, BUTTON_LABELS_WITH_WORKITEMS, 2) : new MessageDialog(this.activeShell, Messages.getString("ActionDelegateDelete.ConfirmDeletionTitleWithoutWorkItems"), Display.getCurrent().getSystemImage(4), Messages.getString("ActionDelegateDelete.ConfirmDeletionTextWithoutWorkItems"), 3, BUTTON_LABELS_WITHOUT_WORKITEMS, 1);
        int result = dialog.open();
        if (result == 0) {
            items.addAll(subItemsToBeDeleted);
        } else if (result == 1 && subItemsContainWorkItems) {
            i = subItemsToBeDeleted.iterator();
            while (i.hasNext()) {
                IModuleData subItem = (IModuleData)i.next();
                if (!(subItem instanceof WorkItem)) continue;
                i.remove();
            }
            items.addAll(subItemsToBeDeleted);
        } else {
            this.releaseLocks(aquiredLocks);
            return;
        }
        this.modelCtrl.deleteItems(items);
        int c3 = 0;
        while (c3 < parentsOfWorkItems.size()) {
            parent = (Task)((Object)parentsOfWorkItems.get(c3));
            if (parent != null && this.modelCtrl.itemExists("ppm2.task", parent.getUID())) {
                ((ModelController)this.modelCtrl).propagateAttributes_workItem(parent);
            }
            ++c3;
        }
        c3 = 0;
        while (c3 < parentsOfTasks.size()) {
            parent = (IModuleData)parentsOfTasks.get(c3);
            if (parent != null && this.modelCtrl.itemExists(parent.getTypeID(), parent.getUID())) {
                ((ModelController)this.modelCtrl).propagateAttributes_task((IModuleData)parent);
            }
            ++c3;
        }
    }

    private void releaseLocks(Collection<LockAccess> aquiredLocks) {
        for (LockAccess currentLock : aquiredLocks) {
            currentLock.releaseLocks();
        }
    }
}

