/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.gui.linkviewcontribution;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChangesListener;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChangesProviderManager;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.PropertyChanges;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.IndirectLinksContainer;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.AbstractLinkContentProvider;
import com.arcway.cockpit.modulelib2.client.gui.IUserInterface;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.projectplanningmodule2.client.Messages;
import com.arcway.cockpit.projectplanningmodule2.client.ProjectPlanningModule2Plugin;
import com.arcway.cockpit.projectplanningmodule2.client.core.licensetypes.ClientFunctionLicenseTypePPMLinkItems;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.gui.linkviewcontribution.WorkItemLinks;
import com.arcway.cockpit.projectplanningmodule2.client.messages.IWorkItem;
import com.arcway.cockpit.projectplanningmodule2.client.messages.PPMLinkTypeHelper_Shared;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItem;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;

public class LinkContentProvider
extends AbstractLinkContentProvider
implements IPropertyChangesListener {
    private static final ILogger logger = Logger.getLogger(LinkContentProvider.class);
    private String currentProjectId = null;
    private IPropertyChangesProviderManager currentPropertyChangesProviderManager = null;
    private WorkItemLinks currentLinkViewContent = null;

    public LinkContentProvider(IUserInterface UI) {
        super(UI);
    }

    public boolean isLinkedModuleDataLinkType(String linkTypeID) {
        return PPMLinkTypeHelper_Shared.getDefault().isUELinkType(linkTypeID);
    }

    public List doGetLinkedModuleData(IUniqueElement element, Collection containedElements, Collection containerElements) {
        String newProjectId = element.getProjectUID();
        if (this.currentProjectId == null || !this.currentProjectId.equals(newProjectId)) {
            IModuleProjectAgent projectAgent = ProjectPlanningModule2Plugin.getDefault().getProjectManager().getProjectAgent(newProjectId);
            this.currentPropertyChangesProviderManager = projectAgent.getPropertyChangesProviderManager();
            this.currentProjectId = newProjectId;
        }
        IModelController modelController = ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(this.currentProjectId);
        IndirectLinksContainer indirectLinksContainerComponents = new IndirectLinksContainer(true);
        IndirectLinksContainer indirectLinksContainerStructure = new IndirectLinksContainer(false);
        WorkItemLinks workItemLinks = new WorkItemLinks(modelController.getLinksForLinkableObject(element.getUID(), "WorkItemUniqueElement"), this.currentProjectId);
        HashSet containedLinks = new HashSet();
        for (IUniqueElement ue : containedElements) {
            Collection links = modelController.getModuleData(ue.getUID(), "WorkItemUniqueElement");
            containedLinks.addAll(links);
        }
        if (!containedLinks.isEmpty()) {
            indirectLinksContainerComponents.setLinkedModuleData(new ArrayList(containedLinks));
            workItemLinks.add(indirectLinksContainerComponents);
        }
        HashSet containerLinks = new HashSet();
        for (IUniqueElement ue : containerElements) {
            Collection links = modelController.getModuleData(ue.getUID(), "WorkItemUniqueElement");
            containerLinks.addAll(links);
        }
        if (!containerLinks.isEmpty()) {
            indirectLinksContainerStructure.setLinkedModuleData(new ArrayList(containerLinks));
            workItemLinks.add(indirectLinksContainerStructure);
        }
        ArrayList<WorkItemLinks> linkList = new ArrayList<WorkItemLinks>();
        if (!workItemLinks.isEmpty()) {
            linkList.add(workItemLinks);
        }
        this.currentLinkViewContent = workItemLinks;
        return linkList;
    }

    public boolean hasLinks(IUniqueElement element, Collection<IUniqueElement> containedElements, Collection<IUniqueElement> containerElements) {
        return LinkContentProvider.hasLinkedInformation((IUniqueElement)element, containedElements, containerElements, (IModelController)ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(element.getProjectUID()), Arrays.asList("WorkItemUniqueElement"));
    }

    public boolean hasChildren(Object element) {
        return element instanceof WorkItemLinks;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof WorkItemLinks) {
            return ((Collection)parentElement).toArray();
        }
        return null;
    }

    public void modelRefreshed(IPropertyChanges<?> changes, Class<?> clazz, String projectUID) {
        this.triggerLinkViewRefresh();
    }

    private void triggerLinkViewRefresh() {
        if (this.currentLinkViewContent != null) {
            ArrayList<WorkItemLinks> modifiedElements = new ArrayList<WorkItemLinks>();
            modifiedElements.add(this.currentLinkViewContent);
            PropertyChanges changes = new PropertyChanges(null, modifiedElements, null);
            this.currentPropertyChangesProviderManager.modelRefreshed((IPropertyChanges)changes, WorkItemLinks.class);
        }
    }

    public String getTypeName() {
        return Messages.getString("LinkViewContribution.RootLabel");
    }

    public ImageDescriptor getIcon() {
        return ProjectPlanningModule2Plugin.getImageDescriptor("Project.gif");
    }

    public boolean mayHaveLinksToConstructionElements(ICockpitProjectData data) {
        return data instanceof IWorkItem;
    }

    public boolean canDeleteInfoLink(ICockpitProjectData uniqueElement, ICockpitProjectData moduleDataItem) {
        String projectUID = uniqueElement.getProjectUID();
        IModelController modelController = ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(projectUID);
        if (moduleDataItem instanceof WorkItem) {
            return modelController.getModuleData(uniqueElement.getUID(), "WorkItemUniqueElement").contains(moduleDataItem);
        }
        return false;
    }

    public void deleteInfoLink(final ICockpitProjectData uniqueElement, final ICockpitProjectData moduleDataItem) {
        String projectUID = uniqueElement.getProjectUID();
        final IModelController modelController = ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(projectUID);
        if (!(moduleDataItem instanceof WorkItem)) {
            return;
        }
        final String linkTypeID = "WorkItemUniqueElement";
        modelController.executeTransaction(new Runnable(){

            @Override
            public void run() {
                modelController.deleteLink(uniqueElement.getUID(), moduleDataItem.getUID(), linkTypeID);
            }
        });
    }

    public Collection getUIDsOfLinkedUniqueElement(ICockpitProjectData data) {
        if (data instanceof Task) {
            Task task = (Task)data;
            ModelController modelController = (ModelController)ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(task.getProjectUID());
            ArrayList uids = new ArrayList();
            this.addUniqueElementUIDSForTask(task, modelController, uids);
            return uids;
        }
        return new ArrayList();
    }

    private void addUniqueElementUIDSForTask(Task task, ModelController modelController, ArrayList uids) {
        if (modelController.containsSubTasks(task)) {
            for (Task subtask : modelController.getTaskChildren(task)) {
                this.addUniqueElementUIDSForTask(subtask, modelController, uids);
            }
        } else {
            this.addUniqueElementUIDSForWorkItemChildren(task, modelController, uids);
        }
    }

    private void addUniqueElementUIDSForWorkItemChildren(Task task, ModelController modelController, ArrayList uids) {
        for (WorkItem workItem : modelController.getWorkItemChildren(task)) {
            for (IUniqueElement ue : modelController.getLinkableObjects((IModuleData)workItem, "WorkItemUniqueElement")) {
                if (uids.contains(ue.getUID())) continue;
                uids.add(ue.getUID());
            }
        }
    }

    public IClientFunctionLicenseType2 getRequiredLicenseTypeForUnlinking() {
        return ClientFunctionLicenseTypePPMLinkItems.getInstance();
    }
}

