/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.gui.dnd;

import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleLockManager;
import com.arcway.cockpit.modulelib2.client.gui.dnd.AbstractEditorDropListener;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IModuleDataEditDialogProvider;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataCreationWizard;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDuration;
import com.arcway.cockpit.projectplanningmodule2.client.Messages;
import com.arcway.cockpit.projectplanningmodule2.client.ProjectPlanningModule2Plugin;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.gui.dialogs.EditWorkItemAdapter;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItem;
import java.util.Collection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class EditorDropListener
extends AbstractEditorDropListener {
    public boolean dropOnUniqueElement(final IUniqueElement uniqueElement, int modesAllowed, int mode, Object payLoad) {
        if (payLoad instanceof Collection) {
            for (Object droppedObject : (Collection)payLoad) {
                if (droppedObject instanceof WorkItem) {
                    final WorkItem element = (WorkItem)droppedObject;
                    final IModelController modelController = ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(element.getProjectUID());
                    modelController.executeTransaction(new Runnable(){

                        @Override
                        public void run() {
                            modelController.createLink(uniqueElement.getUID(), (IModuleData)element, "WorkItemUniqueElement");
                        }
                    });
                    continue;
                }
                if (!(droppedObject instanceof Task)) continue;
                Task task = (Task)((Object)droppedObject);
                ModelController modelCtrl = (ModelController)ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(task.getProjectUID());
                ModuleLockManager lockMgr = (ModuleLockManager)modelCtrl.getLockMgr();
                LockAccess lock = lockMgr.acquireInsertLock((ICockpitProjectData)task);
                if (!lock.hasLock()) {
                    lock.releaseLocks();
                    return false;
                }
                Collection<WorkItem> alreadyExistingWorkItems = modelCtrl.getWorkItemChildren(task);
                String proposedName = null;
                if (alreadyExistingWorkItems.size() == 0) {
                    proposedName = task.getName().getDisplayStringRepresentation();
                }
                ModuleDataAttributeDuration proposedEstimatedWork = task.getOriginalWork();
                for (WorkItem workItem : alreadyExistingWorkItems) {
                    proposedEstimatedWork = proposedEstimatedWork.subtractDuration(workItem.getWorkEstimated());
                }
                EditWorkItemAdapter dialogProvider = new EditWorkItemAdapter(task, proposedName, proposedEstimatedWork.getValue(), uniqueElement);
                ModuleDataCreationWizard wizard = new ModuleDataCreationWizard((IModuleDataEditDialogProvider)dialogProvider, "ppm2.workitem", (IModelController)modelCtrl, Messages.getString("EditWorkItemDialog.EnterWorkItemAttributes"));
                WorkItem newItem = new WorkItem();
                newItem.setProjectUID(modelCtrl.getProjectUID());
                boolean creationPossible = wizard.initialiseWizard(new IModuleData[]{newItem}, new IModuleData[]{task});
                if (!creationPossible) {
                    lock.releaseLocks();
                    return false;
                }
                WizardDialog dialog = new WizardDialog(this.getIssuingShell(), (IWizard)wizard);
                dialog.open();
            }
            return true;
        }
        return false;
    }

    protected Shell getIssuingShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    protected void createLink(IUniqueElement uniqueElement, Object moduleDataItem) {
    }

    protected Collection<? extends EOLink> getExistingLinksForModuleDataItem(Object moduleDataItem) {
        if (moduleDataItem instanceof WorkItem) {
            WorkItem item = (WorkItem)moduleDataItem;
            IModelController modelController = ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(item.getProjectUID());
            return modelController.getLinksForModuleDataItem((IModuleData)item, "WorkItemUniqueElement");
        }
        if (moduleDataItem instanceof Task) {
            return null;
        }
        return null;
    }
}

