/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.gui.dialogs;

import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDuration;
import com.arcway.cockpit.projectplanningmodule2.client.Messages;
import com.arcway.cockpit.projectplanningmodule2.client.ModuleIdentification;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.gui.dialogs.EditDialogManager;
import com.arcway.cockpit.projectplanningmodule2.client.gui.preferences.PreferenceManager;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItem;
import com.arcway.lib.java.collectionmaps.SetMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class ReassignWorkItemsDialog
extends TitleAreaDialog
implements ISelectionChangedListener,
SelectionListener {
    private final ModelController modelController;
    private final Task currentTask;
    private Object currentWorkItemSource;
    private final SetMap currentlyAssignedWorkItems;
    private final Map newlyAssignedWorkItems;
    private final Map noLongerAssignedWorkItems;
    private Map workItemSourceLabelMap;
    private Composite editArea;
    private TableViewer leftWorkItemsTableViewer;
    private TableViewer rightItemsOfTaskTableViewer;
    private Button btnMoveRight;
    private Button btnMoveLeft;
    private Text fldLeftTotalWork;
    private Text fldRightTotalWork;
    private Combo rightWorkItemsSource;
    private Button okButton;
    private final AbstractLockManager lockManager;
    private final Map locks;
    private boolean selectionOfTableEntriesDisabled = false;

    public ReassignWorkItemsDialog(Shell parentShell, IModelController modelController, Task task, SetMap workItemsForTasks) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.modelController = (ModelController)modelController;
        this.currentTask = task;
        this.currentlyAssignedWorkItems = workItemsForTasks;
        this.newlyAssignedWorkItems = new HashMap();
        this.noLongerAssignedWorkItems = new HashMap();
        this.lockManager = modelController.getLockMgr();
        this.locks = new HashMap();
    }

    protected Control createDialogArea(Composite parent) {
        parent.getShell().setText(Messages.getString("ReassignWorkItemsDialog.Title"));
        this.setTitle(Messages.getString("ReassignWorkItemsDialog.Title"));
        this.setMessageText();
        this.editArea = new Composite(parent, 0);
        this.editArea.setLayout((Layout)new GridLayout());
        this.editArea.setLayoutData((Object)new GridData(1808));
        this.createReassignWorkitemsWidgets();
        this.setWidgetState();
        return this.editArea;
    }

    private void setMessageText() {
        String msg = Messages.getString("ReassignWorkItemsDialog.Message");
        this.setMessage(msg);
    }

    private void createReassignWorkitemsWidgets() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        this.editArea.setLayout((Layout)gridLayout);
        GridData gd = null;
        Label lblLeftWorkItems = new Label(this.editArea, 0);
        lblLeftWorkItems.setText(String.valueOf(Messages.getString("EditTaskDialog.LabelAssignedWorkItemsField")) + ":");
        gd = new GridData();
        gd.horizontalSpan = 3;
        lblLeftWorkItems.setLayoutData((Object)gd);
        this.rightWorkItemsSource = new Combo(this.editArea, 8);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        this.rightWorkItemsSource.setLayoutData((Object)gd);
        this.workItemSourceLabelMap = new HashMap();
        ArrayList tasks = new ArrayList(this.currentlyAssignedWorkItems.keySet());
        Collections.sort(tasks, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 == null && o2 != null) {
                    return -1;
                }
                if (o1 != null && o2 == null) {
                    return 1;
                }
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 instanceof Task && o2 instanceof Task) {
                    int id2;
                    int id1 = ((Task)((Object)o1)).getID().getValue();
                    if (id1 < (id2 = ((Task)((Object)o2)).getID().getValue())) {
                        return -1;
                    }
                    if (id1 == id2) {
                        return 0;
                    }
                    return 1;
                }
                return 0;
            }
        });
        for (Object nextSource : tasks) {
            if (nextSource == null) {
                this.rightWorkItemsSource.add(Messages.getString("EditTaskDialog.LabelUnassignedWorkItemsField"), 0);
                this.workItemSourceLabelMap.put(Messages.getString("EditTaskDialog.LabelUnassignedWorkItemsField"), null);
                continue;
            }
            if (nextSource == this.currentTask) continue;
            String text = ((Task)((Object)nextSource)).getDisplayRepresentation();
            this.rightWorkItemsSource.add(text);
            this.workItemSourceLabelMap.put(text, nextSource);
        }
        this.rightWorkItemsSource.setVisibleItemCount(15);
        this.rightWorkItemsSource.select(0);
        this.rightWorkItemsSource.addSelectionListener((SelectionListener)this);
        this.leftWorkItemsTableViewer = this.createWorkItemTable(this.editArea, 2, this.currentlyAssignedWorkItems.get((Object)this.currentTask));
        this.createAssignButtons(this.editArea);
        this.rightItemsOfTaskTableViewer = this.createWorkItemTable(this.editArea, 2, new ArrayList());
        Label lblLeftWorkItemsSummary = new Label(this.editArea, 0);
        lblLeftWorkItemsSummary.setText(String.valueOf(Messages.getString("EditTaskDialog.accumulatedUnassignedWork")) + ":");
        this.fldLeftTotalWork = new Text(this.editArea, 0);
        this.fldLeftTotalWork.setEditable(false);
        this.fldLeftTotalWork.setLayoutData((Object)new GridData(768));
        new Label(this.editArea, 0);
        Label lblRightWorkItemsSummary = new Label(this.editArea, 0);
        lblRightWorkItemsSummary.setText(String.valueOf(Messages.getString("EditTaskDialog.accumulatedAssignedWork")) + ":");
        this.fldRightTotalWork = new Text(this.editArea, 0);
        this.fldRightTotalWork.setEditable(false);
        this.fldRightTotalWork.setLayoutData((Object)new GridData(768));
        this.switchWorkItemSource();
        this.calculateTotalWork();
        this.selectionChanged(null);
    }

    private TableViewer createWorkItemTable(Composite composite, int span, Collection workItems) {
        TableViewer tv = new TableViewer(composite);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = span;
        gd.heightHint = 200;
        tv.getTable().setLayoutData((Object)gd);
        tv.setLabelProvider((IBaseLabelProvider)new WorkItemsLabelProvider());
        tv.setContentProvider((IContentProvider)new WorkItemsTableDataProvider());
        tv.getTable().setHeaderVisible(true);
        tv.getTable().setLinesVisible(false);
        TableColumn nameColumn = new TableColumn(tv.getTable(), 0);
        nameColumn.setText(Messages.getString("EditTaskDialog.NameColumn"));
        nameColumn.setWidth(120);
        TableColumn workColumn = new TableColumn(tv.getTable(), 0);
        workColumn.setText(Messages.getString("EditTaskDialog.WorkColumn"));
        workColumn.pack();
        TableColumn ueColumn = new TableColumn(tv.getTable(), 0);
        ueColumn.setText(Messages.getString("EditTaskDialog.UniqueElementColumn"));
        ueColumn.pack();
        tv.setInput((Object)workItems);
        return tv;
    }

    private void createAssignButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayoutData((Object)new GridData(4));
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        this.btnMoveRight = new Button(buttonComposite, 8);
        this.btnMoveRight.setText(">");
        this.btnMoveRight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReassignWorkItemsDialog.this.deassignWorkItem();
            }
        });
        this.btnMoveLeft = new Button(buttonComposite, 8);
        this.btnMoveLeft.setText("<");
        this.btnMoveLeft.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReassignWorkItemsDialog.this.assignWorkItem();
            }
        });
    }

    private void setWidgetState() {
        this.leftWorkItemsTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.rightItemsOfTaskTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.okButton = this.getButton(0);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!this.selectionOfTableEntriesDisabled) {
            IStructuredSelection selection = (IStructuredSelection)this.rightItemsOfTaskTableViewer.getSelection();
            if (selection.isEmpty()) {
                this.btnMoveLeft.setEnabled(false);
            } else {
                this.btnMoveLeft.setEnabled(true);
            }
            selection = (IStructuredSelection)this.leftWorkItemsTableViewer.getSelection();
            if (selection.isEmpty()) {
                this.btnMoveRight.setEnabled(false);
            } else {
                this.btnMoveRight.setEnabled(true);
            }
        }
    }

    private void deassignWorkItem() {
        IStructuredSelection selection = (IStructuredSelection)this.leftWorkItemsTableViewer.getSelection();
        ArrayList<WorkItem> workItemsThatCantBeMoved = new ArrayList<WorkItem>();
        ArrayList<WorkItem> workItemsToBeMoved = new ArrayList<WorkItem>(selection.size());
        HashMap<WorkItem, LockAccess> moveLocks = new HashMap<WorkItem, LockAccess>(selection.size());
        for (WorkItem workItem : selection) {
            if (this.locks.containsKey(workItem)) {
                LockAccess lock = (LockAccess)this.locks.get(workItem);
                lock.releaseLocks();
                this.locks.remove(workItem);
                workItemsToBeMoved.add(workItem);
                continue;
            }
            LockAccess lockAccess = this.lockManager.acquireMoveLockBeforeMoving((ICockpitProjectData)workItem, ModuleIdentification.getModuleID(), false);
            if (lockAccess.hasLock()) {
                moveLocks.put(workItem, lockAccess);
                workItemsToBeMoved.add(workItem);
                continue;
            }
            workItemsThatCantBeMoved.add(workItem);
        }
        if (EditDialogManager.showMoveWorkItemLockErrMsg(workItemsThatCantBeMoved, !workItemsToBeMoved.isEmpty(), this.getShell())) {
            for (WorkItem workItem : workItemsToBeMoved) {
                this.currentlyAssignedWorkItems.remove((Object)this.currentTask, (Object)workItem);
                if (!this.newlyAssignedWorkItems.containsKey(workItem)) {
                    this.currentlyAssignedWorkItems.add(this.currentWorkItemSource, (Object)workItem);
                    this.noLongerAssignedWorkItems.put(workItem, this.currentWorkItemSource);
                    continue;
                }
                Object originalSourceOfWorkItem = this.newlyAssignedWorkItems.get(workItem);
                this.currentlyAssignedWorkItems.add(originalSourceOfWorkItem, (Object)workItem);
                this.newlyAssignedWorkItems.remove(workItem);
            }
            this.locks.putAll(moveLocks);
        }
        this.rightItemsOfTaskTableViewer.setInput((Object)this.currentlyAssignedWorkItems.get(this.currentWorkItemSource));
        this.leftWorkItemsTableViewer.refresh();
        this.calculateTotalWork();
    }

    private void assignWorkItem() {
        IStructuredSelection selection = (IStructuredSelection)this.rightItemsOfTaskTableViewer.getSelection();
        ArrayList<WorkItem> workItemsThatCantBeMoved = new ArrayList<WorkItem>();
        ArrayList<WorkItem> workItemsToBeMoved = new ArrayList<WorkItem>(selection.size());
        HashMap<WorkItem, LockAccess> moveLocks = new HashMap<WorkItem, LockAccess>(selection.size());
        for (WorkItem workItem : selection) {
            if (this.locks.containsKey(workItem)) {
                LockAccess lock = (LockAccess)this.locks.get(workItem);
                lock.releaseLocks();
                this.locks.remove(workItem);
                workItemsToBeMoved.add(workItem);
                continue;
            }
            LockAccess lockAccess = this.lockManager.acquireMoveLockBeforeMoving((ICockpitProjectData)workItem, ModuleIdentification.getModuleID(), false);
            if (lockAccess.hasLock()) {
                moveLocks.put(workItem, lockAccess);
                workItemsToBeMoved.add(workItem);
                continue;
            }
            workItemsThatCantBeMoved.add(workItem);
        }
        if (EditDialogManager.showMoveWorkItemLockErrMsg(workItemsThatCantBeMoved, !workItemsToBeMoved.isEmpty(), this.getShell())) {
            for (WorkItem workItem : workItemsToBeMoved) {
                this.currentlyAssignedWorkItems.add((Object)this.currentTask, (Object)workItem);
                this.currentlyAssignedWorkItems.remove(this.currentWorkItemSource, (Object)workItem);
                if (!this.noLongerAssignedWorkItems.containsKey(workItem)) {
                    this.newlyAssignedWorkItems.put(workItem, this.currentWorkItemSource);
                    continue;
                }
                this.noLongerAssignedWorkItems.remove(workItem);
            }
            this.locks.putAll(moveLocks);
        }
        this.rightItemsOfTaskTableViewer.refresh();
        this.leftWorkItemsTableViewer.setInput((Object)this.currentlyAssignedWorkItems.get((Object)this.currentTask));
        this.calculateTotalWork();
    }

    private void calculateTotalWork() {
        ModuleDataAttributeDuration unassignedWork = new ModuleDataAttributeDuration(0L);
        unassignedWork.setUnit(PreferenceManager.getBottomUpWorkUnit());
        unassignedWork.setHoursPerDay(this.currentTask.getHoursPerDay());
        for (WorkItem workItem : this.currentlyAssignedWorkItems.get((Object)this.currentTask)) {
            unassignedWork = unassignedWork.addDuration(workItem.getWorkEstimated());
        }
        this.fldLeftTotalWork.setText(unassignedWork.getDisplayRepresentationWithUnit());
        ModuleDataAttributeDuration assignedWork = new ModuleDataAttributeDuration(0L);
        assignedWork.setUnit(PreferenceManager.getBottomUpWorkUnit());
        assignedWork.setHoursPerDay(this.currentTask.getHoursPerDay());
        for (WorkItem workItem : this.currentlyAssignedWorkItems.get(this.currentWorkItemSource)) {
            assignedWork = assignedWork.addDuration(workItem.getWorkEstimated());
        }
        this.fldRightTotalWork.setText(assignedWork.getDisplayRepresentationWithUnit());
    }

    private void switchWorkItemSource() {
        int selectionIndex = this.rightWorkItemsSource.getSelectionIndex();
        if (selectionIndex != -1) {
            this.currentWorkItemSource = this.workItemSourceLabelMap.get(this.rightWorkItemsSource.getItem(selectionIndex));
            this.rightItemsOfTaskTableViewer.setInput((Object)this.currentlyAssignedWorkItems.get(this.currentWorkItemSource));
        } else {
            this.rightWorkItemsSource.setEnabled(false);
            this.rightItemsOfTaskTableViewer.setInput(null);
            this.btnMoveLeft.setEnabled(false);
            this.btnMoveRight.setEnabled(false);
            this.selectionOfTableEntriesDisabled = true;
        }
    }

    protected void okPressed() {
        ArrayList<LockAccess> acquiredLocks = new ArrayList<LockAccess>();
        HashSet<Task> allTasks = new HashSet<Task>();
        if (!this.newlyAssignedWorkItems.isEmpty()) {
            allTasks.add(this.currentTask);
        }
        allTasks.addAll(this.newlyAssignedWorkItems.values());
        allTasks.addAll(this.noLongerAssignedWorkItems.values());
        for (Task task : allTasks) {
            if (task == null) continue;
            LockAccess lockAccess = this.lockManager.acquireMoveLock((ICockpitProjectData)task, false);
            if (lockAccess.hasLock()) {
                acquiredLocks.add(lockAccess);
                continue;
            }
            int c = 0;
            while (c < acquiredLocks.size()) {
                ((LockAccess)acquiredLocks.get(c)).releaseLocks();
                ++c;
            }
            this.setMessage(Messages.getString("EditTaskDialogue.WorkItemsAlreadyLocked"), 3);
            return;
        }
        super.okPressed();
    }

    public Map getNewlyAssignedWorkItems() {
        return this.newlyAssignedWorkItems;
    }

    public Map getNoLongerAssignedWorkItems() {
        return this.noLongerAssignedWorkItems;
    }

    public void widgetSelected(SelectionEvent e) {
        this.switchWorkItemSource();
        this.calculateTotalWork();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public boolean close() {
        if (this.getReturnCode() != 0) {
            this.releaseLocks();
        }
        return super.close();
    }

    private void releaseLocks() {
        for (LockAccess lock : this.locks.values()) {
            lock.releaseLocks();
        }
    }

    private class WorkItemsLabelProvider
    implements ITableLabelProvider {
        private WorkItemsLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof WorkItem) {
                WorkItem workItem = (WorkItem)element;
                switch (columnIndex) {
                    case 0: {
                        return workItem.getName().getDisplayStringRepresentation();
                    }
                    case 1: {
                        return workItem.getWorkEstimated().getDisplayRepresentationWithUnit();
                    }
                    case 2: {
                        Iterator ueLink = ReassignWorkItemsDialog.this.modelController.getLinkableObjects((IModuleData)workItem, "WorkItemUniqueElement").iterator();
                        if (ueLink.hasNext()) {
                            return ((IUniqueElement)ueLink.next()).getElementName();
                        }
                        return "";
                    }
                }
                return "";
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class WorkItemsTableDataProvider
    implements IStructuredContentProvider {
        private WorkItemsTableDataProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement != null && inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

