/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.gui.dialogs;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholder;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.modules.IModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.AbstractModulePlugin;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleLockManager;
import com.arcway.cockpit.modulelib2.client.gui.ImageDescriptorRegistry;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataEditPropertyAdapter;
import com.arcway.cockpit.modulelib2.client.messages.AbstractModuleData;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.ModuleDataReference;
import com.arcway.cockpit.modulelib2.client.messages.StakeholderReference;
import com.arcway.cockpit.modulelib2.client.messages.valuerangehelper.ValueRangeHelperModuleData;
import com.arcway.cockpit.modulelib2.client.messages.valuerangehelper.ValueRangeHelperStakeholderLink;
import com.arcway.cockpit.projectplanningmodule2.client.Messages;
import com.arcway.cockpit.projectplanningmodule2.client.ProjectPlanningModule2Plugin;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.PermissionMgr;
import com.arcway.cockpit.projectplanningmodule2.client.gui.preferences.PreferenceManager;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItem;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItemCategory;
import com.arcway.cockpit.projectplanningmodule2.client.messages.description.WorkItemDescription;
import com.arcway.lib.ui.IModificationProblem;
import de.plans.lib.util.gui.elements.UIETextDropDown;
import de.plans.lib.util.gui.elements.UIETextField;
import de.plans.lib.util.valueranges.IValueRangeHelperList;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EditWorkItemAdapter
extends ModuleDataEditPropertyAdapter {
    private NumberFormat decimalFormater;
    private WorkItem workItem = null;
    private Task containingTask;
    private ModuleDataReference workItemCategory;
    private WorkItemCategory oldCategory;
    private ValueRangeHelperModuleData valueRangeHelperCategory;
    private StakeholderReference stakeholder;
    private IStakeholder oldStakeholder;
    private ValueRangeHelperStakeholderLink valueRangeHelperPersonInCharge;
    private String proposedName;
    private long proposedWorkEstimated;
    private String workItemUnit;
    private IModelController model = null;
    private Text fieldPercentCompleted;
    private Button buttonWorkCompleted;
    private Label lblQuestionMark;
    private Image imgQuestionMark;
    private DoneWorkListener doneWorkListener;
    private EstimatedWorkListener estimatedWorkListener;
    private RemainingWorkListener remainingWorkListener;
    private StandardModifyListener standardModifyListener;
    private UIETextField fieldName;
    private UIETextField fieldWorkEstimated;
    private UIETextField fieldWorkPrognose;
    private UIETextField fieldWorkDone;
    private UIETextField fieldWorkRemaining;
    private UIETextField fieldResource;
    private UIETextField fieldDescription;
    private UIETextDropDown fieldCategory;
    private UIETextDropDown fieldPersonInCharge;
    private LockAccess lock;
    private boolean remainingWorkChangedManually = false;
    private IUniqueElement uniqueElement;

    public EditWorkItemAdapter(Task containingTask, String proposedName, long proposedWorkEstimated, IUniqueElement uniqueElement) {
        super(true);
        this.containingTask = containingTask;
        this.proposedName = proposedName;
        this.proposedWorkEstimated = proposedWorkEstimated;
        this.uniqueElement = uniqueElement;
    }

    public EditWorkItemAdapter(Task containingTask, String proposedName, long proposedWorkEstimated) {
        this(containingTask, proposedName, proposedWorkEstimated, null);
    }

    public EditWorkItemAdapter() {
        super(false);
    }

    public String getDataTypeID() {
        return "ppm2.workitem";
    }

    public Class getDataClass() {
        return WorkItem.class;
    }

    public String getPropertyName() {
        return WorkItem.MODULE_DATA_NAME;
    }

    public ImageDescriptor getPropertyImageDescriptor() {
        return ProjectPlanningModule2Plugin.getImageDescriptor("WorkItem.gif");
    }

    protected ImageDescriptorRegistry getImageDescriptorRegistry() {
        return ProjectPlanningModule2Plugin.getDefault().getImageDescriptorRegistry();
    }

    public Composite createEditPage_internal(Composite parent) {
        Composite editArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 7;
        gridLayout.makeColumnsEqualWidth = false;
        editArea.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        editArea.setLayoutData((Object)gridData);
        this.createCategoryWidget(editArea, 7, (IModuleData)this.workItem);
        Label label = new Label(editArea, 0);
        label.setText(String.valueOf(WorkItem.NAME_NAME) + ":");
        Text widget = (Text)this.fieldName.getControl(editArea);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 6;
        widget.setLayoutData((Object)gridData);
        label = new Label(editArea, 0);
        label.setText(String.valueOf(WorkItem.NAME_CATEGORY) + ":");
        Control dropdown = this.fieldCategory.getControl(editArea);
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        dropdown.setLayoutData((Object)gridData);
        label = new Label(editArea, 0);
        label.setText(String.valueOf(WorkItem.NAME_WORK_ESTIMATED) + " (" + this.workItemUnit + "):");
        widget = (Text)this.fieldWorkEstimated.getControl(editArea);
        gridData = new GridData(768);
        gridData.widthHint = 40;
        widget.setLayoutData((Object)gridData);
        label = new Label(editArea, 0);
        label.setText(String.valueOf(Messages.getString("EditWorkItemDialog.WorkPrognose")) + " (" + this.workItemUnit + "):");
        widget = (Text)this.fieldWorkPrognose.getControl(editArea);
        widget.setEditable(false);
        gridData = new GridData(768);
        gridData.widthHint = 40;
        widget.setLayoutData((Object)gridData);
        label = new Label(editArea, 0);
        label = new Label(editArea, 0);
        label.setText(String.valueOf(Messages.getString("EditWorkItemDialog.PercentCompleted")) + ":");
        this.fieldPercentCompleted = new Text(editArea, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 40;
        this.fieldPercentCompleted.setLayoutData((Object)gridData);
        label = new Label(editArea, 0);
        label.setText(String.valueOf(WorkItem.NAME_WORK_DONE) + " (" + this.workItemUnit + "):");
        widget = (Text)this.fieldWorkDone.getControl(editArea);
        gridData = new GridData(768);
        gridData.widthHint = 40;
        widget.setLayoutData((Object)gridData);
        label = new Label(editArea, 0);
        label.setText(String.valueOf(WorkItem.NAME_WORK_REMAINING) + " (" + this.workItemUnit + "):");
        widget = (Text)this.fieldWorkRemaining.getControl(editArea);
        gridData = new GridData(768);
        gridData.widthHint = 40;
        widget.setLayoutData((Object)gridData);
        this.lblQuestionMark = new Label(editArea, 0);
        this.imgQuestionMark = ProjectPlanningModule2Plugin.getDefault().getImageDescriptorRegistry().get(ProjectPlanningModule2Plugin.getImageDescriptor("quest_mark.gif"));
        this.lblQuestionMark.setImage(this.imgQuestionMark);
        this.lblQuestionMark.setVisible(false);
        this.buttonWorkCompleted = new Button(editArea, 0);
        this.buttonWorkCompleted.setText(Messages.getString("EditWorkItemDialog.ButtonDone"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.buttonWorkCompleted.setLayoutData((Object)gridData);
        this.buttonWorkCompleted.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditWorkItemAdapter.this.completeWorkItem();
                EditWorkItemAdapter.this.lblQuestionMark.setVisible(true);
            }
        });
        label = new Label(editArea, 0);
        label.setText(String.valueOf(WorkItem.NAME_PERSON_IN_CHARGE) + ":");
        dropdown = this.fieldPersonInCharge.getControl(editArea);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        dropdown.setLayoutData((Object)gridData);
        label = new Label(editArea, 0);
        label.setText(String.valueOf(WorkItem.NAME_RESOURCES) + ":");
        widget = (Text)this.fieldResource.getControl(editArea);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        widget.setLayoutData((Object)gridData);
        label = new Label(editArea, 0);
        label.setText(String.valueOf(WorkItem.NAME_DESCRIPTION) + ":");
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        gridData.verticalIndent = 5;
        label.setLayoutData((Object)gridData);
        widget = (Text)this.fieldDescription.getControl(editArea);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 6;
        gridData.heightHint = 50;
        widget.setLayoutData((Object)gridData);
        this.setValues();
        this.setWidgetState();
        this.enableModifyListeners();
        this.checkPageForErrors(false);
        this.remainingWorkChangedManually = false;
        return editArea;
    }

    private void enableModifyListeners() {
        this.fieldDescription.addModifyListener((ModifyListener)this.standardModifyListener);
        this.fieldName.addModifyListener((ModifyListener)this.standardModifyListener);
        this.fieldPercentCompleted.addModifyListener((ModifyListener)this.standardModifyListener);
        this.fieldWorkDone.addModifyListener((ModifyListener)this.doneWorkListener);
        this.fieldWorkEstimated.addModifyListener((ModifyListener)this.estimatedWorkListener);
        this.fieldWorkEstimated.addModifyListener((ModifyListener)this.standardModifyListener);
        this.fieldWorkPrognose.addModifyListener((ModifyListener)this.standardModifyListener);
        this.fieldWorkRemaining.addModifyListener((ModifyListener)this.remainingWorkListener);
        this.fieldPersonInCharge.addModifyListener((ModifyListener)this.standardModifyListener);
        this.fieldCategory.addModifyListener((ModifyListener)this.standardModifyListener);
        this.fieldResource.addModifyListener((ModifyListener)this.standardModifyListener);
    }

    private void disableModifyListeners() {
        this.fieldDescription.removeModifyListener((ModifyListener)this.standardModifyListener);
        this.fieldName.removeModifyListener((ModifyListener)this.standardModifyListener);
        this.fieldPercentCompleted.removeModifyListener((ModifyListener)this.standardModifyListener);
        this.fieldWorkDone.removeModifyListener((ModifyListener)this.doneWorkListener);
        this.fieldWorkEstimated.removeModifyListener((ModifyListener)this.estimatedWorkListener);
        this.fieldWorkEstimated.removeModifyListener((ModifyListener)this.standardModifyListener);
        this.fieldWorkPrognose.removeModifyListener((ModifyListener)this.standardModifyListener);
        this.fieldWorkRemaining.removeModifyListener((ModifyListener)this.remainingWorkListener);
        this.fieldPersonInCharge.removeModifyListener((ModifyListener)this.standardModifyListener);
        this.fieldCategory.removeModifyListener((ModifyListener)this.standardModifyListener);
        this.fieldResource.removeModifyListener((ModifyListener)this.standardModifyListener);
    }

    private void completeWorkItem() {
        int oldWorkDone = this.getWorkDone();
        int oldWorkRemaining = this.getWorkRemaining();
        this.fieldWorkDone.forceText(String.valueOf(oldWorkDone + oldWorkRemaining));
        this.forceValueForWorkRemaining("0");
        this.setWidgetState();
    }

    private void forceValueForWorkRemaining(String newContent) {
        String oldContent = this.fieldWorkRemaining.getCurrentValue();
        if (!oldContent.trim().equals(newContent.trim())) {
            this.lblQuestionMark.setVisible(true);
        }
        this.fieldWorkRemaining.forceText(newContent);
    }

    private void computeAndSetPercentCompleted() {
        if (this.getWorkDone() + this.getWorkRemaining() != 0) {
            this.fieldPercentCompleted.setText(Integer.toString(this.getWorkDone() * 100 / (this.getWorkDone() + this.getWorkRemaining())));
        } else {
            this.fieldPercentCompleted.setText(Integer.toString(0));
        }
    }

    private void workDoneChanged() {
        int doneWork;
        this.disableModifyListeners();
        int estimatedWork = this.getWorkEstimated();
        int remainingWork = this.getWorkRemaining();
        if (this.fieldWorkDone.getCurrentValue() != "") {
            try {
                doneWork = Integer.parseInt(this.fieldWorkDone.getCurrentValue());
            }
            catch (NumberFormatException e) {
                doneWork = estimatedWork - remainingWork;
            }
        } else {
            doneWork = 0;
        }
        if (doneWork == 0) {
            remainingWork = estimatedWork;
            this.forceValueForWorkRemaining(Integer.toString(estimatedWork));
        } else if (!this.remainingWorkChangedManually) {
            remainingWork = Math.max(Integer.parseInt(this.fieldWorkEstimated.getCurrentValue()) - doneWork, 0);
            this.forceValueForWorkRemaining(Integer.toString(remainingWork));
        } else {
            remainingWork = this.fieldWorkRemaining.getCurrentValue().length() > 0 ? this.getWorkRemaining() : 0;
        }
        this.computeAndSetPercentCompleted();
        this.fieldWorkPrognose.forceText(Integer.toString(doneWork + remainingWork));
        this.setWidgetState();
        this.enableModifyListeners();
    }

    private void workEstimatedChanged() {
        int estimatedWork;
        this.disableModifyListeners();
        int doneWork = this.getWorkDone();
        int remainingWork = this.getWorkRemaining();
        String value = this.fieldWorkEstimated.getCurrentValue().trim();
        if (value.length() > 0) {
            try {
                estimatedWork = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                estimatedWork = doneWork + remainingWork;
            }
        } else {
            estimatedWork = 0;
        }
        this.forceValueForWorkRemaining(Integer.toString(estimatedWork));
        this.computeAndSetPercentCompleted();
        this.fieldWorkPrognose.forceText(Integer.toString(doneWork + estimatedWork));
        this.setWidgetState();
        this.enableModifyListeners();
    }

    private void workRemainingChanged() {
        this.disableModifyListeners();
        this.computeAndSetPercentCompleted();
        this.fieldWorkPrognose.forceText(Integer.toString(this.getWorkDone() + this.getWorkRemaining()));
        this.setWidgetState();
        this.enableModifyListeners();
    }

    private int getWorkRemaining() {
        if (this.fieldWorkRemaining.getCurrentValue().length() > 0) {
            try {
                Number number = this.decimalFormater.parse(this.fieldWorkRemaining.getCurrentValue());
                if (number != null) {
                    return (int)number.floatValue();
                }
            }
            catch (ParseException e) {
                return 0;
            }
        }
        return 0;
    }

    private int getWorkDone() {
        if (this.fieldWorkDone.getCurrentValue().length() > 0) {
            try {
                Number number = this.decimalFormater.parse(this.fieldWorkDone.getCurrentValue());
                if (number != null) {
                    return (int)number.floatValue();
                }
            }
            catch (ParseException e) {
                return 0;
            }
        }
        return 0;
    }

    private int getWorkEstimated() {
        if (this.fieldWorkEstimated.getCurrentValue().length() > 0) {
            try {
                Number number = this.decimalFormater.parse(this.fieldWorkEstimated.getCurrentValue());
                if (number != null) {
                    return (int)number.floatValue();
                }
            }
            catch (ParseException e) {
                return 0;
            }
        }
        return 0;
    }

    private void setWidgetState() {
        PermissionMgr permissionMgr = (PermissionMgr)this.model.getPermissionMgr();
        boolean isNotYetCommited = this.isCreationDialogue() || ((ModelController)this.model).isNew(this.workItem);
        boolean hasLock = true;
        if (!this.isCreationDialogue() && !this.lock.hasLock()) {
            hasLock = false;
        }
        this.fieldWorkPrognose.setEditable(false);
        this.fieldPercentCompleted.setEditable(false);
        if (hasLock && (isNotYetCommited || this.mayEditAttribute(permissionMgr, "workItem_name"))) {
            this.fieldName.setEditable(true);
        } else {
            this.fieldName.setEditable(false);
        }
        if (hasLock && this.mayEditAttribute(permissionMgr, "workItem_description")) {
            this.fieldDescription.setEditable(true);
        } else {
            this.fieldDescription.setEditable(false);
        }
        if (hasLock && this.mayEditAttribute(permissionMgr, "workItem_category")) {
            this.fieldCategory.setEnabled(true);
        } else {
            this.fieldCategory.setEnabled(false);
        }
        if (hasLock && this.mayEditAttribute(permissionMgr, "workItem_resources")) {
            this.fieldResource.setEditable(true);
            this.fieldPersonInCharge.setEnabled(true);
        } else {
            this.fieldResource.setEditable(false);
            this.fieldPersonInCharge.setEnabled(false);
        }
        if (this.getWorkDone() > 0) {
            this.fieldWorkEstimated.setEditable(false);
        } else if (hasLock && this.mayEditAttribute(permissionMgr, "workItem_workEstimated")) {
            this.fieldWorkEstimated.setEditable(true);
        } else {
            this.fieldWorkEstimated.setEditable(false);
        }
        if (hasLock && this.mayEditAttribute(permissionMgr, "workItem_workRemaining")) {
            this.fieldWorkRemaining.setEditable(true);
        } else {
            this.fieldWorkRemaining.setEditable(false);
        }
        if (this.getWorkRemaining() > 0) {
            if (hasLock && this.mayEditAttribute(permissionMgr, "workItem_workDone")) {
                this.buttonWorkCompleted.setEnabled(true);
            } else {
                this.buttonWorkCompleted.setEnabled(false);
            }
        } else {
            this.buttonWorkCompleted.setEnabled(false);
        }
        if (hasLock && this.mayEditAttribute(permissionMgr, "workItem_workDone")) {
            this.fieldWorkDone.setEditable(true);
        } else {
            this.fieldWorkDone.setEditable(false);
        }
        if (hasLock && permissionMgr.mayEditItemStructurally((IModuleData)this.workItem, (IModuleData)this.containingTask)) {
            this.setCategoryEditable(true);
        } else {
            this.setCategoryEditable(false);
        }
    }

    private boolean mayEditAttribute(PermissionMgr permissionMgr, String roleName) {
        return permissionMgr.mayEditAttribute((IModuleData)this.workItem, (IModuleData)this.containingTask, roleName);
    }

    public IModificationProblem setItems(IModuleData[] items, IModuleData[] parents) {
        if (items.length == 1) {
            this.workItem = (WorkItem)items[0];
            this.model = ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(this.workItem.getProjectUID());
            if (!this.isCreationDialogue()) {
                this.containingTask = (Task)this.model.getParent((IModuleData)this.workItem);
                this.workItemCategory = new ModuleDataReference((AbstractModuleData)((ModelController)this.model).getCategory(this.workItem));
                this.stakeholder = new StakeholderReference(((ModelController)this.model).getStakeholderForWorkItem(this.workItem));
            }
            this.internalConstruct(this.model);
            if (!this.isCreationDialogue()) {
                ModuleLockManager lockMgr = (ModuleLockManager)this.model.getLockMgr();
                this.lock = lockMgr.acquireEditLock((ICockpitProjectData)this.workItem);
                if (!this.lock.hasLock()) {
                    this.lock.releaseLocks();
                } else {
                    this.workItem = (WorkItem)this.model.getItem("ppm2.workitem", this.workItem.getUID());
                    if (this.workItem == null) {
                        return this.getModificationProblemItemDeleted();
                    }
                }
            }
        }
        return null;
    }

    private void internalConstruct(IModelController modelCtrl) {
        if (this.isCreationDialogue()) {
            if (this.proposedName != null) {
                this.workItem.getName().setValue(this.proposedName);
            }
            if (this.proposedWorkEstimated >= 0L) {
                this.workItem.getWorkEstimated().setValue(this.proposedWorkEstimated);
                this.workItem.getWorkRemaining().setValue(this.proposedWorkEstimated);
            }
            this.workItemCategory = new ModuleDataReference();
            this.oldCategory = null;
            this.stakeholder = new StakeholderReference();
            this.oldStakeholder = null;
        } else {
            Collection stakeHolders = modelCtrl.getLinkableObjects((IModuleData)this.workItem, "WorkItemStakeholder");
            this.oldStakeholder = !stakeHolders.isEmpty() ? (IStakeholder)stakeHolders.iterator().next() : null;
            Collection categories = modelCtrl.getLinkableObjects((IModuleData)this.workItem, "WorkItemCategory");
            this.oldCategory = !categories.isEmpty() ? (WorkItemCategory)((Object)categories.iterator().next()) : null;
        }
        this.decimalFormater = PreferenceManager.getBottomUpWorkUnit() == 3 ? new DecimalFormat("0.#") : new DecimalFormat("0");
        int workUnit = 0;
        int prefUnit = PreferenceManager.getBottomUpWorkUnit();
        switch (prefUnit) {
            case 3: {
                workUnit = 3;
                this.workItemUnit = Messages.getString("Unit.Days");
                break;
            }
            case 1: {
                workUnit = 1;
                this.workItemUnit = Messages.getString("Unit.Hours");
                break;
            }
            default: {
                workUnit = 3;
                this.workItemUnit = Messages.getString("Unit.Days");
            }
        }
        this.valueRangeHelperCategory = new ValueRangeHelperModuleData("ppm2.workitemcategory", (IModuleData)new WorkItemCategory(), null, this.model, true, this.workItemCategory, true);
        this.valueRangeHelperPersonInCharge = new ValueRangeHelperStakeholderLink(this.stakeholder, ProjectPlanningModule2Plugin.getDefault().getProjectManager().getProjectAgent(this.model.getProjectUID()), true);
        this.fieldName = new UIETextField(Messages.getString("WorkItem.Name"), this.workItem.getName().getValueRangeHelper());
        this.fieldCategory = new UIETextDropDown(Messages.getString("WorkItem.Category"), (IValueRangeHelperList)this.valueRangeHelperCategory);
        this.workItem.getWorkEstimated().setUnit(workUnit);
        this.fieldWorkEstimated = new UIETextField(Messages.getString("WorkItem.WorkEstimated"), this.workItem.getWorkEstimated().getValueRangeHelper());
        this.workItem.getWorkDone().setUnit(workUnit);
        this.fieldWorkDone = new UIETextField(Messages.getString("WorkItem.WorkDone"), this.workItem.getWorkDone().getValueRangeHelper());
        this.workItem.getWorkRemaining().setUnit(workUnit);
        this.fieldWorkPrognose = new UIETextField(Messages.getString("EditWorkItemDialog.WorkPrognose"), this.workItem.calculateForecast().getValueRangeHelper());
        this.fieldWorkRemaining = new UIETextField(Messages.getString("WorkItem.WorkRemaining"), this.workItem.getWorkRemaining().getValueRangeHelper());
        this.fieldResource = new UIETextField(Messages.getString("WorkItem.Resources"), this.workItem.getResources().getValueRangeHelper());
        this.fieldDescription = new UIETextField(Messages.getString("WorkItem.Description"), this.workItem.getDescription().getValueRangeHelper(), true);
        this.fieldPersonInCharge = new UIETextDropDown(WorkItem.NAME_PERSON_IN_CHARGE, (IValueRangeHelperList)this.valueRangeHelperPersonInCharge);
        this.doneWorkListener = new DoneWorkListener();
        this.estimatedWorkListener = new EstimatedWorkListener();
        this.remainingWorkListener = new RemainingWorkListener();
        this.standardModifyListener = new StandardModifyListener();
    }

    public IModuleDataTypeDescriptionForFrame getCockpitDataType() {
        return WorkItemDescription.MODULEDATATYPEDESCRIPTION_FORFRAME;
    }

    public boolean isMultipleEditPossible() {
        return false;
    }

    private void setValues() {
        this.fieldName.setValue();
        this.fieldCategory.setValue();
        this.fieldWorkEstimated.setValue();
        this.fieldWorkPrognose.setValue();
        this.fieldWorkDone.setValue();
        this.fieldWorkRemaining.setValue();
        this.fieldResource.setValue();
        this.fieldDescription.setValue();
        this.fieldPersonInCharge.setValue();
        this.computeAndSetPercentCompleted();
    }

    private void getValues() {
        this.fieldName.getValue();
        this.fieldCategory.getValue();
        this.fieldWorkEstimated.getValue();
        this.fieldWorkPrognose.getValue();
        this.fieldWorkDone.getValue();
        this.fieldWorkRemaining.getValue();
        this.fieldResource.getValue();
        this.fieldDescription.getValue();
        this.fieldPersonInCharge.getValue();
    }

    public WorkItem getWorkItem() {
        return this.workItem;
    }

    public void checkPageForErrors(boolean notAtInitialisation) {
        String checkResult = null;
        checkResult = this.fieldName.checkCurrentValue();
        if (checkResult == null) {
            checkResult = this.fieldWorkEstimated.checkCurrentValue();
        }
        if (checkResult == null) {
            checkResult = this.fieldWorkDone.checkCurrentValue();
        }
        if (checkResult == null) {
            checkResult = this.fieldWorkRemaining.checkCurrentValue();
        }
        if (checkResult == null) {
            checkResult = this.fieldPersonInCharge.checkCurrentValue();
        }
        if (notAtInitialisation) {
            this.getCallback().setErrMsg(checkResult);
            this.getCallback().setChangedStatus(true);
        } else {
            if (checkResult != null) {
                this.getCallback().setCommitable(false);
            }
            this.getCallback().setChangedStatus(false);
        }
    }

    public void cancelChanges1() {
        if (!this.isCreationDialogue() && this.lock != null) {
            this.lock.releaseLocks();
        }
    }

    public Collection<IModificationProblem> requestCommit() {
        return Collections.EMPTY_LIST;
    }

    public void rollbackCommitRequest() {
    }

    protected void doCommitChanges() {
        this.getValues();
        if (this.isCreationDialogue()) {
            WorkItemCategory newCategory = (WorkItemCategory)this.workItemCategory.getItem();
            IStakeholder newStakeholder = this.stakeholder.getItem();
            ((ModelController)this.model).storeNewWorkItemCreation(this.workItem, newCategory, newStakeholder, this.containingTask, this.uniqueElement);
            if (this.containingTask != null) {
                this.model.itemPropertiesModified((IModuleData)this.containingTask, null);
            }
        } else {
            WorkItemCategory newCategory = (WorkItemCategory)this.workItemCategory.getItem();
            if (!(this.oldCategory == null || newCategory != null && this.oldCategory.getUID().equals(newCategory.getUID()))) {
                this.model.deleteLink(this.oldCategory.getUID(), this.workItem.getUID(), "WorkItemCategory");
            }
            if (!(newCategory == null || this.oldCategory != null && this.oldCategory.getUID().equals(newCategory.getUID()))) {
                this.model.createLink(newCategory.getUID(), (IModuleData)this.workItem, "WorkItemCategory");
            }
            IStakeholder newStakeholder = this.stakeholder.getItem();
            if (!(this.oldStakeholder == null || newStakeholder != null && this.oldStakeholder.getUID().equals(newStakeholder.getUID()))) {
                this.model.deleteLink(this.oldStakeholder.getUID(), this.workItem.getUID(), "WorkItemStakeholder");
            }
            if (!(newStakeholder == null || this.oldStakeholder != null && this.oldStakeholder.getUID().equals(newStakeholder.getUID()))) {
                if (this.oldStakeholder != null) {
                    this.model.deleteLink(this.oldStakeholder.getUID(), this.workItem.getUID(), "WorkItemStakeholder");
                }
                this.model.createLink(newStakeholder.getUID(), (IModuleData)this.workItem, "WorkItemStakeholder");
            }
            if (this.containingTask != null) {
                ((ModelController)this.model).propagateAttributes_workItem(this.containingTask);
            }
            this.model.itemPropertiesModified((IModuleData)this.workItem, null);
        }
    }

    protected IModelController getModel() {
        return this.model;
    }

    protected AbstractModulePlugin getPlugin() {
        return ProjectPlanningModule2Plugin.getDefault();
    }

    private class DoneWorkListener
    implements ModifyListener {
        private DoneWorkListener() {
        }

        public void modifyText(ModifyEvent e) {
            EditWorkItemAdapter.this.workDoneChanged();
            EditWorkItemAdapter.this.checkPageForErrors(true);
        }
    }

    private class EstimatedWorkListener
    implements ModifyListener {
        private EstimatedWorkListener() {
        }

        public void modifyText(ModifyEvent e) {
            EditWorkItemAdapter.this.workEstimatedChanged();
            EditWorkItemAdapter.this.checkPageForErrors(true);
        }
    }

    private class RemainingWorkListener
    implements ModifyListener {
        private RemainingWorkListener() {
        }

        public void modifyText(ModifyEvent e) {
            EditWorkItemAdapter.this.workRemainingChanged();
            EditWorkItemAdapter.this.remainingWorkChangedManually = true;
            EditWorkItemAdapter.this.lblQuestionMark.setVisible(false);
            EditWorkItemAdapter.this.checkPageForErrors(true);
        }
    }

    private class StandardModifyListener
    implements ModifyListener {
        private StandardModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            EditWorkItemAdapter.this.checkPageForErrors(true);
        }
    }
}

