/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.gui.dialogs;

import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.modules.IModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.AbstractModulePlugin;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.AbstractPermissionMgr;
import com.arcway.cockpit.modulelib2.client.gui.ImageDescriptorRegistry;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataEditPropertyAdapter;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDuration;
import com.arcway.cockpit.projectplanningmodule2.client.Messages;
import com.arcway.cockpit.projectplanningmodule2.client.ModuleIdentification;
import com.arcway.cockpit.projectplanningmodule2.client.ProjectPlanningModule2Plugin;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.PermissionMgr;
import com.arcway.cockpit.projectplanningmodule2.client.gui.dialogs.EditDialogManager;
import com.arcway.cockpit.projectplanningmodule2.client.gui.preferences.PreferenceManager;
import com.arcway.cockpit.projectplanningmodule2.client.messages.ProjectPlan;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItem;
import com.arcway.cockpit.projectplanningmodule2.client.messages.description.TaskDescription;
import com.arcway.lib.eclipse.gui.widgets.DatePickerDialog;
import com.arcway.lib.ui.IModificationProblem;
import de.plans.lib.util.DateUtil;
import de.plans.lib.util.gui.elements.UIETextField;
import de.plans.lib.util.valueranges.ILong;
import de.plans.lib.util.valueranges.ValueRangeHelperDuration;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class EditTaskAdapter
extends ModuleDataEditPropertyAdapter
implements ModifyListener,
ISelectionChangedListener {
    private static final DateFormat dateFormat = DateFormat.getDateInstance();
    private Task task = null;
    private ProjectPlan containingPlan;
    private ModelController model = null;
    private Composite editArea;
    private TabFolder tabFolderTask;
    private TabItem tabItemEditTaskDesc;
    private Composite editTaskDescArea;
    private TabItem tabItemReassignWorkItems;
    private Composite reassignWorkItemsArea;
    private TableViewer leftItemsOfTaskTableViewer;
    private TableViewer rightWorkItemsTableViewer;
    private Button btnMoveRight;
    private Button btnMoveLeft;
    private Text fldRightTotalWork;
    private Text fldLeftTotalWork;
    private Button checkIsMilestone;
    private UIETextField textTitle;
    private UIETextField textStart;
    private UIETextField textFinish;
    private Text textDuration;
    private ValueRangeHelperDuration durationChecker;
    private UIETextField textWorkTopDown;
    private Collection<WorkItem> currentlyAssignedWorkItems;
    private Collection<WorkItem> currentlyUnassignedWorkItems;
    private Collection<WorkItem> newlyAssignedWorkItems;
    private Collection<WorkItem> noLongerAssignedWorkItems;
    private LockAccess lock;
    private Map<WorkItem, LockAccess> workItemLocks;
    private final long MAX_DURATION_IN_YEARS = 500L;
    private final List<Button> calendarButtons = new ArrayList<Button>();
    private final int INDEX_OF_START_BUTTON = 0;
    private final int INDEX_OF_FINISH_BUTTON = 1;
    private boolean handlingModifications = false;
    private LockAccess idLock;
    private boolean isExclusiveProjectLockConflicting = false;
    private boolean isAManualModification = false;
    private LockAccess moveLock;

    public EditTaskAdapter(ProjectPlan containingPlan) {
        super(true);
        this.containingPlan = containingPlan;
    }

    public EditTaskAdapter() {
        super(false);
    }

    public String getDataTypeID() {
        return "ppm2.task";
    }

    public Class getDataClass() {
        return Task.class;
    }

    public String getPropertyName() {
        return Task.MODULE_DATA_NAME;
    }

    public ImageDescriptor getPropertyImageDescriptor() {
        return ProjectPlanningModule2Plugin.getImageDescriptor("Task.gif");
    }

    protected ImageDescriptorRegistry getImageDescriptorRegistry() {
        return ProjectPlanningModule2Plugin.getDefault().getImageDescriptorRegistry();
    }

    public Composite createEditPage_internal(Composite parent) {
        this.editArea = new Composite(parent, 0);
        this.editArea.setLayout((Layout)new GridLayout());
        this.editArea.setLayoutData((Object)new GridData(1808));
        this.tabFolderTask = new TabFolder(this.editArea, 0);
        this.tabFolderTask.setLayoutData((Object)new GridData(1808));
        this.tabItemEditTaskDesc = new TabItem(this.tabFolderTask, 2048);
        this.tabItemEditTaskDesc.setText(Messages.getString("EditTaskDialog.TabName.Description"));
        this.editTaskDescArea = new Composite((Composite)this.tabFolderTask, 0);
        this.editTaskDescArea.setLayout((Layout)new GridLayout());
        this.tabItemEditTaskDesc.setControl((Control)this.editTaskDescArea);
        this.createCategoryWidget(this.editTaskDescArea, 1, (IModuleData)this.task);
        this.createEditTaskDescWidgets();
        this.tabItemReassignWorkItems = new TabItem(this.tabFolderTask, 2048);
        this.tabItemReassignWorkItems.setText(Messages.getString("EditTaskDialog.TabName.Attributes"));
        this.reassignWorkItemsArea = new Composite((Composite)this.tabFolderTask, 0);
        this.reassignWorkItemsArea.setLayout((Layout)new GridLayout());
        this.tabItemReassignWorkItems.setControl((Control)this.reassignWorkItemsArea);
        this.createReassignWorkitemsWidgets();
        this.setValues();
        this.setWidgetState();
        this.registerModifyListeners();
        this.handleModifications(null, false);
        return this.editArea;
    }

    private void createEditTaskDescWidgets() {
        this.calendarButtons.clear();
        GridData gridData = new GridData(768);
        this.editTaskDescArea.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.editTaskDescArea.setLayout((Layout)gridLayout);
        this.createLabel(String.valueOf(Task.NAME_NAME) + ":", 1, this.editTaskDescArea);
        Control control = this.textTitle.getControl(this.editTaskDescArea);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 40;
        gridData.horizontalSpan = 3;
        control.setLayoutData((Object)gridData);
        control.setFocus();
        this.createDateField(String.valueOf(Task.NAME_START) + ":", this.textStart, this.editTaskDescArea, this);
        String unitLabel = "(" + Messages.getString("Unit.Days") + ")";
        this.createLabel(String.valueOf(Task.NAME_DURATION) + " " + unitLabel + ":", 1, this.editTaskDescArea);
        this.textDuration = new Text(this.editTaskDescArea, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 40;
        gridData.horizontalSpan = 1;
        this.textDuration.setLayoutData((Object)gridData);
        this.createDateField(String.valueOf(Task.NAME_FINISH) + ":", this.textFinish, this.editTaskDescArea, this);
        unitLabel = PreferenceManager.getTopDownWorkUnit() == 3 ? "(" + Messages.getString("Unit.Days") + ")" : "(" + Messages.getString("Unit.Hours") + ")";
        this.createLabel(String.valueOf(Task.NAME_IMPORTED_WORK) + " " + unitLabel + ":", 1, this.editTaskDescArea);
        control = this.textWorkTopDown.getControl(this.editTaskDescArea);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 40;
        gridData.horizontalSpan = 1;
        control.setLayoutData((Object)gridData);
        this.checkIsMilestone = new Button(this.editTaskDescArea, 32);
        this.checkIsMilestone.setText(Messages.getString("EditTaskDialog.Milestone"));
        this.checkIsMilestone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditTaskAdapter.this.milestoneStatusChanged();
            }
        });
    }

    private void createReassignWorkitemsWidgets() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        this.reassignWorkItemsArea.setLayout((Layout)gridLayout);
        GridData gd = null;
        Label lblLeftWorkItems = new Label(this.reassignWorkItemsArea, 0);
        lblLeftWorkItems.setText(String.valueOf(Messages.getString("EditTaskDialog.LabelAssignedWorkItemsField")) + ":");
        gd = new GridData();
        gd.horizontalSpan = 3;
        lblLeftWorkItems.setLayoutData((Object)gd);
        Label lblRightWorkItems = new Label(this.reassignWorkItemsArea, 0);
        lblRightWorkItems.setText(String.valueOf(Messages.getString("EditTaskDialog.LabelUnassignedWorkItemsField")) + ":");
        gd = new GridData();
        gd.horizontalSpan = 2;
        lblRightWorkItems.setLayoutData((Object)gd);
        this.leftItemsOfTaskTableViewer = this.createWorkItemTable(this.reassignWorkItemsArea, 2, this.currentlyAssignedWorkItems);
        this.createAssignButtons(this.reassignWorkItemsArea);
        this.rightWorkItemsTableViewer = this.createWorkItemTable(this.reassignWorkItemsArea, 2, this.currentlyUnassignedWorkItems);
        Label lblLeftWorkItemsSummary = new Label(this.reassignWorkItemsArea, 0);
        lblLeftWorkItemsSummary.setText(String.valueOf(Messages.getString("EditTaskDialog.accumulatedAssignedWork")) + ":");
        this.fldLeftTotalWork = new Text(this.reassignWorkItemsArea, 2048);
        this.fldLeftTotalWork.setEditable(false);
        this.fldLeftTotalWork.setLayoutData((Object)new GridData(768));
        new Label(this.reassignWorkItemsArea, 0);
        Label lblRightWorkItemsSummary = new Label(this.reassignWorkItemsArea, 0);
        lblRightWorkItemsSummary.setText(String.valueOf(Messages.getString("EditTaskDialog.accumulatedUnassignedWork")) + ":");
        this.fldRightTotalWork = new Text(this.reassignWorkItemsArea, 2048);
        this.fldRightTotalWork.setEditable(false);
        this.fldRightTotalWork.setLayoutData((Object)new GridData(768));
        this.selectionChanged(null);
        this.calculateTotalWork();
    }

    private TableViewer createWorkItemTable(Composite composite, int span, Collection<WorkItem> workItems) {
        TableViewer tv = new TableViewer(composite);
        ViewerSorter workItemSorter = new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((WorkItem)e1).getName().getDisplayStringRepresentation().compareToIgnoreCase(((WorkItem)e2).getName().getDisplayStringRepresentation());
            }
        };
        tv.setSorter(workItemSorter);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = span;
        gd.heightHint = 200;
        tv.getTable().setLayoutData((Object)gd);
        tv.setLabelProvider((IBaseLabelProvider)new WorkItemsLabelProvider());
        tv.setContentProvider((IContentProvider)new WorkItemsTableDataProvider());
        tv.getTable().setHeaderVisible(true);
        tv.getTable().setLinesVisible(false);
        TableColumn nameColumn = new TableColumn(tv.getTable(), 0);
        nameColumn.setText(Messages.getString("EditTaskDialog.NameColumn"));
        nameColumn.setWidth(120);
        TableColumn workColumn = new TableColumn(tv.getTable(), 0);
        workColumn.setText(Messages.getString("EditTaskDialog.WorkColumn"));
        workColumn.pack();
        TableColumn ueColumn = new TableColumn(tv.getTable(), 0);
        ueColumn.setText(Messages.getString("EditTaskDialog.UniqueElementColumn"));
        ueColumn.pack();
        tv.setInput(workItems);
        return tv;
    }

    private void createDateField(String label, UIETextField uiElement, Composite dialogueArea, ModifyListener modifyListener) {
        Label dateLabel = new Label(dialogueArea, 0);
        dateLabel.setText(label);
        Composite dateGrid = new Composite(dialogueArea, 0);
        GridLayout dateGridLayout = new GridLayout();
        dateGridLayout.numColumns = 2;
        dateGridLayout.marginHeight = 0;
        dateGridLayout.marginWidth = 0;
        dateGridLayout.horizontalSpacing = 0;
        dateGridLayout.verticalSpacing = 0;
        dateGrid.setLayout((Layout)dateGridLayout);
        GridData gridData = new GridData(768);
        dateGrid.setLayoutData((Object)gridData);
        Text textField = (Text)uiElement.getControl(dateGrid);
        gridData = new GridData(768);
        textField.setLayoutData((Object)gridData);
        Button btnCalendar = new Button(dateGrid, 8);
        btnCalendar.setImage(ProjectPlanningModule2Plugin.getImageDescriptor("calendar.gif").createImage());
        btnCalendar.addSelectionListener((SelectionListener)new DatePickerSelectionAdapter(textField, modifyListener));
        this.calendarButtons.add(btnCalendar);
    }

    private void createAssignButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayoutData((Object)new GridData(4));
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        this.btnMoveRight = new Button(buttonComposite, 8);
        this.btnMoveRight.setText(">");
        this.btnMoveRight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditTaskAdapter.this.deassignWorkItems();
                EditTaskAdapter.this.getCallback().setChangedStatus(true);
            }
        });
        this.btnMoveLeft = new Button(buttonComposite, 8);
        this.btnMoveLeft.setText("<");
        this.btnMoveLeft.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditTaskAdapter.this.assignWorkItems();
                EditTaskAdapter.this.getCallback().setChangedStatus(true);
            }
        });
    }

    private void registerModifyListeners() {
        this.textTitle.addModifyListener((ModifyListener)this);
        this.textStart.addModifyListener((ModifyListener)this);
        this.textFinish.addModifyListener((ModifyListener)this);
        this.textDuration.addModifyListener((ModifyListener)this);
        this.textWorkTopDown.addModifyListener((ModifyListener)this);
        this.textFinish.getControl(null).addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                EditTaskAdapter.this.handleModifications(e.widget, true);
            }
        });
    }

    private void setMessageText() {
        if (this.isCreationDialogue()) {
            String msg = Messages.getString("EditTaskDialog.Message.New");
            this.getCallback().setMessage(msg, 0);
        }
    }

    private void calculateTotalWork() {
        ModuleDataAttributeDuration unassignedWork = new ModuleDataAttributeDuration(0L);
        unassignedWork.setUnit(PreferenceManager.getBottomUpWorkUnit());
        unassignedWork.setHoursPerDay(this.task.getHoursPerDay());
        for (WorkItem workItem : this.currentlyUnassignedWorkItems) {
            unassignedWork = unassignedWork.addDuration(workItem.getWorkEstimated());
        }
        this.fldRightTotalWork.setText(unassignedWork.getDisplayRepresentationWithUnit());
        ModuleDataAttributeDuration assignedWork = new ModuleDataAttributeDuration(0L);
        assignedWork.setUnit(PreferenceManager.getBottomUpWorkUnit());
        assignedWork.setHoursPerDay(this.task.getHoursPerDay());
        for (WorkItem workItem : this.currentlyAssignedWorkItems) {
            assignedWork = assignedWork.addDuration(workItem.getWorkEstimated());
        }
        this.fldLeftTotalWork.setText(assignedWork.getDisplayRepresentationWithUnit());
    }

    private void milestoneStatusChanged() {
        this.setWidgetState();
        this.handleModifications((Widget)this.checkIsMilestone, true);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.leftItemsOfTaskTableViewer.getSelection();
        if (selection.isEmpty()) {
            this.btnMoveRight.setEnabled(false);
        } else {
            this.btnMoveRight.setEnabled(true);
        }
        selection = (IStructuredSelection)this.rightWorkItemsTableViewer.getSelection();
        if (selection.isEmpty()) {
            this.btnMoveLeft.setEnabled(false);
        } else {
            this.btnMoveLeft.setEnabled(true);
        }
    }

    private void deassignWorkItems() {
        IStructuredSelection selection = (IStructuredSelection)this.leftItemsOfTaskTableViewer.getSelection();
        ArrayList<WorkItem> workItemsThatCantBeMoved = new ArrayList<WorkItem>();
        ArrayList<WorkItem> workItemsToBeMoved = new ArrayList<WorkItem>(selection.size());
        HashMap<WorkItem, LockAccess> moveLocks = new HashMap<WorkItem, LockAccess>(selection.size());
        for (WorkItem workItem : selection) {
            LockAccess lockAccess;
            if (this.workItemLocks.containsKey(workItem)) {
                lockAccess = this.workItemLocks.get(workItem);
                lockAccess.releaseLocks();
                this.workItemLocks.remove(workItem);
                workItemsToBeMoved.add(workItem);
                continue;
            }
            lockAccess = this.model.getLockMgr().acquireMoveLockBeforeMoving((ICockpitProjectData)workItem, ModuleIdentification.getModuleID(), false);
            if (lockAccess.hasLock()) {
                moveLocks.put(workItem, lockAccess);
                workItemsToBeMoved.add(workItem);
                continue;
            }
            workItemsThatCantBeMoved.add(workItem);
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (EditDialogManager.showMoveWorkItemLockErrMsg(workItemsThatCantBeMoved, !workItemsToBeMoved.isEmpty(), shell)) {
            for (WorkItem workItem : workItemsToBeMoved) {
                this.currentlyUnassignedWorkItems.add(workItem);
                this.currentlyAssignedWorkItems.remove(workItem);
                if (this.newlyAssignedWorkItems.remove(workItem)) continue;
                this.noLongerAssignedWorkItems.add(workItem);
            }
            this.workItemLocks.putAll(moveLocks);
        }
        this.leftItemsOfTaskTableViewer.refresh();
        this.rightWorkItemsTableViewer.refresh();
        this.calculateTotalWork();
    }

    private void assignWorkItems() {
        IStructuredSelection selection = (IStructuredSelection)this.rightWorkItemsTableViewer.getSelection();
        ArrayList<WorkItem> workItemsThatCantBeMoved = new ArrayList<WorkItem>();
        ArrayList<WorkItem> workItemsToBeMoved = new ArrayList<WorkItem>();
        HashMap<WorkItem, LockAccess> moveLocks = new HashMap<WorkItem, LockAccess>(selection.size());
        for (WorkItem workItem : selection) {
            LockAccess lockAccess;
            if (this.workItemLocks.containsKey(workItem)) {
                lockAccess = this.workItemLocks.get(workItem);
                lockAccess.releaseLocks();
                this.workItemLocks.remove(workItem);
                workItemsToBeMoved.add(workItem);
                continue;
            }
            lockAccess = this.model.getLockMgr().acquireMoveLockBeforeMoving((ICockpitProjectData)workItem, ModuleIdentification.getModuleID(), false);
            if (lockAccess.hasLock()) {
                moveLocks.put(workItem, lockAccess);
                workItemsToBeMoved.add(workItem);
                continue;
            }
            workItemsThatCantBeMoved.add(workItem);
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (EditDialogManager.showMoveWorkItemLockErrMsg(workItemsThatCantBeMoved, !workItemsToBeMoved.isEmpty(), shell)) {
            for (WorkItem workItem : workItemsToBeMoved) {
                this.currentlyAssignedWorkItems.add(workItem);
                this.currentlyUnassignedWorkItems.remove(workItem);
                if (this.noLongerAssignedWorkItems.remove(workItem)) continue;
                this.newlyAssignedWorkItems.add(workItem);
            }
            this.workItemLocks.putAll(moveLocks);
        }
        this.leftItemsOfTaskTableViewer.refresh();
        this.rightWorkItemsTableViewer.refresh();
        this.calculateTotalWork();
    }

    private void setWidgetState() {
        boolean reassigningWorkItemsAllowed;
        boolean isNotYetCommited;
        AbstractPermissionMgr permissionMgr = this.model.getPermissionMgr();
        boolean isSynchronized = !this.isCreationDialogue() && this.model.isSynchronized(this.task);
        boolean bl = isNotYetCommited = this.isCreationDialogue() || this.model.isNew((ICockpitProjectData)this.task);
        if (isSynchronized) {
            this.textTitle.setEditable(false);
            this.textStart.setEditable(false);
            this.textFinish.setEditable(false);
            this.textDuration.setEditable(false);
            this.textWorkTopDown.setEditable(false);
            this.checkIsMilestone.setEnabled(false);
            this.enableCalendarButtons(false);
            this.setCategoryEditable(false);
        } else {
            boolean mayEdit = true;
            if (!this.isCreationDialogue() && !this.lock.hasLock()) {
                mayEdit = false;
            }
            if (mayEdit && (isNotYetCommited || permissionMgr.mayEditAttribute((IModuleData)this.task, (IModuleData)this.containingPlan, "ppm.task.name"))) {
                this.textTitle.setEditable(true);
            } else {
                this.textTitle.setEditable(false);
            }
            if (mayEdit && permissionMgr.mayEditAttribute((IModuleData)this.task, (IModuleData)this.containingPlan, "ppm.task.startppm.task.finish")) {
                this.textStart.setEditable(true);
                this.enableCalendarButton(true, 0);
            } else {
                this.textStart.setEditable(false);
                this.enableCalendarButton(false, 0);
            }
            if (this.checkIsMilestone.getSelection()) {
                this.textFinish.setEditable(false);
                this.enableCalendarButton(false, 1);
                this.textDuration.setEditable(false);
                this.textWorkTopDown.setEditable(false);
                if (mayEdit && permissionMgr.mayEditAttribute((IModuleData)this.task, (IModuleData)this.containingPlan, "ppm.task.isMilestone")) {
                    this.checkIsMilestone.setEnabled(true);
                } else {
                    this.checkIsMilestone.setEnabled(false);
                }
            } else {
                if (mayEdit && permissionMgr.mayEditAttribute((IModuleData)this.task, (IModuleData)this.containingPlan, "ppm.task.startppm.task.finish")) {
                    this.textFinish.setEditable(true);
                    this.textDuration.setEditable(true);
                    this.enableCalendarButton(true, 1);
                } else {
                    this.textFinish.setEditable(false);
                    this.textDuration.setEditable(false);
                    this.enableCalendarButton(false, 1);
                }
                if (this.model.getTaskChildren(this.task).size() > 0 || this.model.getWorkItemChildren(this.task).size() > 0) {
                    this.checkIsMilestone.setEnabled(false);
                    this.textWorkTopDown.setEditable(false);
                } else {
                    if (mayEdit && permissionMgr.mayEditAttribute((IModuleData)this.task, (IModuleData)this.containingPlan, "ppm.task.isMilestone")) {
                        this.checkIsMilestone.setEnabled(true);
                    } else {
                        this.checkIsMilestone.setEnabled(false);
                    }
                    if (mayEdit && permissionMgr.mayEditAttribute((IModuleData)this.task, (IModuleData)this.containingPlan, "ppm.task.importedWork")) {
                        this.textWorkTopDown.setEditable(true);
                    } else {
                        this.textWorkTopDown.setEditable(false);
                    }
                }
            }
            if (mayEdit && permissionMgr.mayEditItemStructurally((IModuleData)this.task, (IModuleData)this.containingPlan)) {
                this.setCategoryEditable(true);
            } else {
                this.setCategoryEditable(false);
            }
        }
        boolean bl2 = reassigningWorkItemsAllowed = ((PermissionMgr)permissionMgr).mayEditWorkItemsOfTask(this.task) && ((PermissionMgr)permissionMgr).mayEditUnassignedWorkItems();
        if (reassigningWorkItemsAllowed && this.task != null && !this.checkIsMilestone.getSelection()) {
            this.rightWorkItemsTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            this.rightWorkItemsTableViewer.getTable().setEnabled(true);
            this.leftItemsOfTaskTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            this.leftItemsOfTaskTableViewer.getTable().setEnabled(true);
        } else {
            this.btnMoveRight.setEnabled(false);
            this.rightWorkItemsTableViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
            this.rightWorkItemsTableViewer.getTable().setEnabled(false);
            this.btnMoveLeft.setEnabled(false);
            this.leftItemsOfTaskTableViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
            this.leftItemsOfTaskTableViewer.getTable().setEnabled(false);
        }
    }

    private void enableCalendarButtons(boolean enabled) {
        for (Button btn : this.calendarButtons) {
            btn.setEnabled(enabled);
        }
    }

    private void enableCalendarButton(boolean enabled, int index) {
        Button btn = this.calendarButtons.get(index);
        if (btn != null) {
            btn.setEnabled(enabled);
        }
    }

    private void releaseWorkItemLocks() {
        for (LockAccess lockAccess : this.workItemLocks.values()) {
            lockAccess.releaseLocks();
        }
    }

    public IModificationProblem setItems(IModuleData[] items, IModuleData[] parents) {
        if (items.length == 1) {
            boolean isSynchronized;
            this.task = (Task)items[0];
            this.model = (ModelController)ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(this.task.getProjectUID());
            if (!this.isCreationDialogue()) {
                this.containingPlan = this.model.getProjectPlanForTask(this.task);
            }
            this.internalConstruct((IModelController)this.model);
            boolean bl = isSynchronized = !this.isCreationDialogue() && this.model.isSynchronized(this.task);
            if (!isSynchronized && !this.isCreationDialogue()) {
                ModuleLockManager lockMgr = (ModuleLockManager)this.model.getLockMgr();
                this.lock = lockMgr.acquireEditLock((ICockpitProjectData)this.task);
                if (!this.lock.hasLock()) {
                    this.lock.releaseLocks();
                } else {
                    this.task = (Task)this.model.getItem("ppm2.task", this.task.getUID());
                    if (this.task == null) {
                        return this.getModificationProblemItemDeleted();
                    }
                }
            }
        }
        return null;
    }

    private void internalConstruct(IModelController modelCtrl) {
        if (this.isCreationDialogue()) {
            this.task.setHoursPerDay(this.containingPlan.getHoursPerDay().getValue());
            this.task.getWorkDone().setUnit(PreferenceManager.getBottomUpWorkUnit());
            this.task.getWorkRemaining().setUnit(PreferenceManager.getBottomUpWorkUnit());
            this.task.getWorkEstimated().setUnit(PreferenceManager.getBottomUpWorkUnit());
            this.task.getOriginalWork().setUnit(PreferenceManager.getTopDownWorkUnit());
        }
        this.currentlyAssignedWorkItems = this.isCreationDialogue() ? new ArrayList<WorkItem>() : ((ModelController)modelCtrl).getWorkItemChildren(this.task);
        this.currentlyUnassignedWorkItems = ((ModelController)modelCtrl).getUnassignedWorkItems();
        this.newlyAssignedWorkItems = new ArrayList<WorkItem>();
        this.noLongerAssignedWorkItems = new ArrayList<WorkItem>();
        this.workItemLocks = new HashMap<WorkItem, LockAccess>();
        this.textTitle = new UIETextField(Task.NAME_NAME, this.task.getName().getValueRangeHelper());
        this.textStart = new UIETextField(Task.NAME_START, this.task.getStart().getValueRangeHelper());
        this.textFinish = new UIETextField(Task.NAME_FINISH, this.task.getFinish().getValueRangeHelper());
        this.textWorkTopDown = new UIETextField(Task.NAME_IMPORTED_WORK, this.task.getOriginalWork().getValueRangeHelper());
        this.durationChecker = new ValueRangeHelperDuration((ILong)new ModuleDataAttributeDuration());
        this.durationChecker.setUnit(3);
        this.durationChecker.setConversionFactors(0, 0, 8);
    }

    public IModuleDataTypeDescriptionForFrame getCockpitDataType() {
        return TaskDescription.MODULEDATATYPEDESCRIPTION_FORFRAME;
    }

    public boolean isMultipleEditPossible() {
        return false;
    }

    private void setValues() {
        this.textTitle.setValue();
        this.textStart.setValue();
        this.textFinish.setValue();
        this.textDuration.setText(this.task.calculateDuration().getDisplayStringRepresentation());
        this.textWorkTopDown.setValue();
        this.checkIsMilestone.setSelection(this.task.isMilestone().getValue());
    }

    private void getValues() {
        if (this.checkIsMilestone.getSelection()) {
            this.textTitle.getValue();
            this.textStart.getValue();
            this.task.getFinish().setValue(this.task.getStart().getValue());
            this.task.getOriginalWork().setValue(0L);
            this.task.isMilestone().setValue(true);
        } else {
            this.textTitle.getValue();
            this.textStart.getValue();
            this.textFinish.getValue();
            this.textWorkTopDown.getValue();
            this.task.isMilestone().setValue(false);
        }
    }

    public void modifyText(ModifyEvent e) {
        this.handleModifications(e.widget, true);
    }

    private synchronized void handleModifications(Widget w, boolean notAtInitialisation) {
        if (!this.handlingModifications) {
            String checkResult;
            this.handlingModifications = true;
            boolean durationToLong = false;
            if (w != null && !this.isAManualModification) {
                Date startDate2;
                if (w == this.textFinish.getControl(null)) {
                    try {
                        startDate2 = dateFormat.parse(this.textStart.getCurrentValue());
                        Date finishDate = dateFormat.parse(this.textFinish.getCurrentValue());
                        long durationInYears = (finishDate.getTime() - startDate2.getTime()) / 1471228928L;
                        if (durationInYears > 500L) {
                            durationToLong = true;
                        } else {
                            String newText;
                            durationToLong = false;
                            if (!finishDate.before(startDate2)) {
                                int newDuration = DateUtil.getWorkingDays((Date)startDate2, (Date)finishDate) + 1;
                                String newText2 = "" + newDuration;
                                if (!newText2.equals(this.textDuration.getText())) {
                                    this.isAManualModification = true;
                                    this.textDuration.setText(newText2);
                                    this.isAManualModification = false;
                                }
                            } else if (!this.textFinish.getControl(null).isFocusControl() && !(newText = dateFormat.format(finishDate)).equals(this.textStart.getCurrentValue())) {
                                this.isAManualModification = true;
                                this.textDuration.setText("1");
                                this.textStart.forceText(newText);
                                this.isAManualModification = false;
                            }
                        }
                    }
                    catch (ParseException startDate2) {}
                } else if (w == this.textStart.getControl(null) || w == this.textDuration) {
                    try {
                        Date newFinishDate;
                        String newText;
                        startDate2 = dateFormat.parse(this.textStart.getCurrentValue());
                        int duration = Integer.parseInt(this.textDuration.getText());
                        if (duration >= 1 && !(newText = dateFormat.format(newFinishDate = DateUtil.addWorkingDays((Date)startDate2, (int)(duration - 1)))).equals(this.textFinish.getCurrentValue())) {
                            this.isAManualModification = true;
                            this.textFinish.forceText(newText);
                            this.isAManualModification = false;
                        }
                    }
                    catch (ParseException startDate3) {
                    }
                    catch (NumberFormatException startDate3) {
                        // empty catch block
                    }
                }
            }
            if ((checkResult = null) == null && durationToLong) {
                checkResult = Messages.getString("EditTaskAdapter.1");
            }
            if (checkResult == null) {
                checkResult = this.textTitle.checkCurrentValue();
            }
            if (checkResult == null) {
                checkResult = this.textStart.checkCurrentValue();
            }
            if (checkResult == null) {
                checkResult = this.textFinish.checkCurrentValue();
            }
            if (checkResult == null && !this.durationChecker.check(this.textDuration.getText())) {
                checkResult = this.durationChecker.getErrorMessage(Task.NAME_DURATION);
            }
            if (checkResult == null) {
                checkResult = this.textWorkTopDown.checkCurrentValue();
            }
            if (this.isExclusiveProjectLockConflicting) {
                if (notAtInitialisation) {
                    this.getCallback().setErrMsg(com.arcway.cockpit.modulelib2.client.Messages.getString((String)"CreationDialogs.ExclusiveProjectLock"));
                    this.getCallback().setChangedStatus(true);
                } else {
                    this.getCallback().setChangedStatus(false);
                }
                this.getCallback().setCommitable(checkResult == null);
            } else if (notAtInitialisation) {
                this.getCallback().setErrMsg(checkResult);
                this.getCallback().setChangedStatus(true);
            } else {
                if (checkResult != null) {
                    this.getCallback().setCommitable(false);
                }
                this.getCallback().setChangedStatus(false);
            }
            this.handlingModifications = false;
        }
    }

    public Task getTask() {
        return this.task;
    }

    public Collection<WorkItem> getNewlyAssignedWorkItems() {
        return this.newlyAssignedWorkItems;
    }

    public Collection<WorkItem> getNoLongerAssignedWorkItems() {
        return this.noLongerAssignedWorkItems;
    }

    public void cancelChanges1() {
        if (!this.isCreationDialogue() && this.lock != null) {
            this.lock.releaseLocks();
        }
        this.releaseWorkItemLocks();
    }

    public Collection<IModificationProblem> requestCommit() {
        if (this.isCreationDialogue()) {
            int id = this.model.getNewTaskID(this.containingPlan);
            this.idLock = null;
            while (this.idLock == null || !this.idLock.hasLock()) {
                this.idLock = this.model.getLockMgr().acquireUniqueIDLock("" + id, "ppm2.task");
                if (!this.idLock.hasLock()) {
                    if (!this.idLock.isExclusiveProjectLockConflicting()) {
                        ++id;
                        this.isExclusiveProjectLockConflicting = false;
                        continue;
                    }
                    this.isExclusiveProjectLockConflicting = true;
                    return Arrays.asList(new ModificationProblem(com.arcway.cockpit.modulelib2.client.Messages.getString((String)"CreationAction.ExclusiveProjectLock.Message"), com.arcway.cockpit.modulelib2.client.Messages.getString((String)"CreationAction.ExclusiveProjectLock.Title")));
                }
                this.isExclusiveProjectLockConflicting = false;
            }
            this.task.getID().setValue(id);
        }
        if (!this.isCreationDialogue() && !this.newlyAssignedWorkItems.isEmpty()) {
            this.moveLock = this.model.getLockMgr().acquireMoveLock((ICockpitProjectData)this.task, false);
            if (this.moveLock.hasLock()) {
                return Collections.emptyList();
            }
            this.moveLock.releaseLocks();
            return Arrays.asList(new ModificationProblem(Messages.getString("EditTaskDialogue.WorkItemsAlreadyLocked"), Messages.getString("EditTaskDialogue.TaskModificationsCantBeSaved")));
        }
        return Collections.emptyList();
    }

    public void rollbackCommitRequest() {
        if (this.idLock != null) {
            this.idLock.releaseLocks();
        }
        if (this.moveLock != null) {
            this.moveLock.releaseLocks();
        }
    }

    protected void doCommitChanges() {
        this.getValues();
        if (this.isCreationDialogue()) {
            this.model.addItem((IModuleData)this.task);
            for (WorkItem workItem : this.getNewlyAssignedWorkItems()) {
                this.model.createLink(this.task.getUID(), (IModuleData)workItem, "WorkItemTask");
            }
            this.model.createLink(this.containingPlan.getUID(), (IModuleData)this.task, "TaskProjectPlan");
            if (this.getNewlyAssignedWorkItems().isEmpty()) {
                this.model.propagateAttributes_task((IModuleData)this.task);
            } else {
                this.model.propagateAttributes_workItem(this.task);
            }
        } else {
            for (WorkItem workItem : this.getNoLongerAssignedWorkItems()) {
                this.model.deleteLink(this.task.getUID(), workItem.getUID(), "WorkItemTask");
            }
            for (WorkItem workItem : this.getNewlyAssignedWorkItems()) {
                this.model.createLink(this.task.getUID(), (IModuleData)workItem, "WorkItemTask");
            }
            if (this.getNewlyAssignedWorkItems().isEmpty() && this.getNoLongerAssignedWorkItems().isEmpty()) {
                this.model.propagateAttributes_task((IModuleData)this.task);
            } else {
                this.model.propagateAttributes_workItem(this.task);
            }
            this.model.itemPropertiesModified((IModuleData)this.task, null);
        }
    }

    protected IModelController getModel() {
        return this.model;
    }

    protected AbstractModulePlugin getPlugin() {
        return ProjectPlanningModule2Plugin.getDefault();
    }

    private class DatePickerSelectionAdapter
    extends SelectionAdapter {
        private final Text textField;
        private final ModifyListener modifyListener;

        public DatePickerSelectionAdapter(Text textField, ModifyListener modifyListener) {
            this.textField = textField;
            this.modifyListener = modifyListener;
        }

        public void widgetSelected(SelectionEvent e) {
            this.openDueDatePicker();
        }

        private void openDueDatePicker() {
            Date date = null;
            try {
                date = dateFormat.parse(this.textField.getText());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            DatePickerDialog datePickerDialog = new DatePickerDialog(this.textField.getShell(), date, false);
            if (datePickerDialog.open() == 0 && (date = datePickerDialog.getDate()) != null) {
                this.textField.setText(dateFormat.format(date));
                if (this.modifyListener != null) {
                    Event modifyEvent = new Event();
                    modifyEvent.widget = this.textField;
                    this.modifyListener.modifyText(new ModifyEvent(modifyEvent));
                }
            }
        }
    }

    private class WorkItemsLabelProvider
    implements ITableLabelProvider {
        private WorkItemsLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof WorkItem) {
                WorkItem workItem = (WorkItem)element;
                switch (columnIndex) {
                    case 0: {
                        return workItem.getName().getDisplayStringRepresentation();
                    }
                    case 1: {
                        return workItem.getWorkEstimated().getDisplayRepresentationWithUnit();
                    }
                    case 2: {
                        Iterator ueLink = EditTaskAdapter.this.model.getLinkableObjects((IModuleData)workItem, "WorkItemUniqueElement").iterator();
                        if (ueLink.hasNext()) {
                            return ((IUniqueElement)ueLink.next()).getElementName();
                        }
                        return "";
                    }
                }
                return "";
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class WorkItemsTableDataProvider
    implements IStructuredContentProvider {
        private WorkItemsTableDataProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement != null && inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

