/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.gui.dialogs;

import com.arcway.cockpit.frame.client.project.modules.IModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.AbstractModulePlugin;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.AbstractPermissionMgr;
import com.arcway.cockpit.modulelib2.client.gui.ImageDescriptorRegistry;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataEditPropertyAdapter;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.projectplanningmodule2.client.Messages;
import com.arcway.cockpit.projectplanningmodule2.client.ProjectPlanningModule2Plugin;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.gui.preferences.PreferenceManager;
import com.arcway.cockpit.projectplanningmodule2.client.messages.ProjectPlan;
import com.arcway.cockpit.projectplanningmodule2.client.messages.description.ProjectPlanDescription;
import com.arcway.lib.ui.IModificationProblem;
import de.plans.lib.util.gui.elements.UIETextField;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class EditProjectPlanAdapter
extends ModuleDataEditPropertyAdapter
implements ModifyListener {
    private ProjectPlan projectPlan = null;
    private IModelController model = null;
    private UIETextField name;
    private UIETextField description;
    private LockAccess lock;

    public EditProjectPlanAdapter(boolean isNew) {
        super(isNew);
    }

    public String getDataTypeID() {
        return "ppm2.projectplan";
    }

    public Class getDataClass() {
        return ProjectPlan.class;
    }

    public String getPropertyName() {
        return ProjectPlan.MODULE_DATA_NAME;
    }

    public ImageDescriptor getPropertyImageDescriptor() {
        return ProjectPlanningModule2Plugin.getImageDescriptor("Project.gif");
    }

    protected ImageDescriptorRegistry getImageDescriptorRegistry() {
        return ProjectPlanningModule2Plugin.getDefault().getImageDescriptorRegistry();
    }

    public Composite createEditPage_internal(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        gridLayout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)gridLayout);
        this.createCategoryWidget(composite, 6, (IModuleData)this.projectPlan);
        this.createLabel(String.valueOf(ProjectPlan.NAME_NAME) + ":", 1, composite);
        Control control = this.name.getControl(composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 5;
        control.setLayoutData((Object)gridData);
        this.createLabel(String.valueOf(ProjectPlan.NAME_DESCRIPTION) + ":", 1, composite);
        control = this.description.getControl(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 5;
        gridData.heightHint = 150;
        control.setLayoutData((Object)gridData);
        this.setValues();
        this.name.addModifyListener((ModifyListener)this);
        this.description.addModifyListener((ModifyListener)this);
        this.setWidgetState();
        this.handleModifications(null, false);
        return composite;
    }

    private void setMessageText() {
        if (this.isCreationDialogue()) {
            String msg = Messages.getString("EditProjectPlanDialog.Create.Message");
            this.getCallback().setMessage(msg, 0);
        }
    }

    private void setWidgetState() {
        AbstractPermissionMgr permissionMgr = this.model.getPermissionMgr();
        boolean hasLock = true;
        if (!this.isCreationDialogue() && !this.lock.hasLock()) {
            hasLock = false;
        }
        if (hasLock && (this.isCreationDialogue() || permissionMgr.mayEditAttribute((IModuleData)this.projectPlan, null, "ppm.projectplan.name"))) {
            this.name.setEditable(true);
        } else {
            this.name.setEditable(false);
        }
        if (hasLock && (this.isCreationDialogue() || permissionMgr.mayEditAttribute((IModuleData)this.projectPlan, null, "ppm.projectplan.description"))) {
            this.description.setEnabled(true);
        } else {
            this.description.setEnabled(false);
        }
        if (hasLock && permissionMgr.mayEditItemStructurally((IModuleData)this.projectPlan, null)) {
            this.setCategoryEditable(true);
        } else {
            this.setCategoryEditable(false);
        }
    }

    public IModificationProblem setItems(IModuleData[] items, IModuleData[] parents) {
        if (items.length == 1) {
            this.projectPlan = (ProjectPlan)items[0];
            this.model = ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(this.projectPlan.getProjectUID());
            this.internalConstruct(this.model);
            if (!this.isCreationDialogue()) {
                ModuleLockManager lockMgr = (ModuleLockManager)this.model.getLockMgr();
                this.lock = lockMgr.acquireEditLock((ICockpitProjectData)this.projectPlan);
                if (!this.lock.hasLock()) {
                    this.lock.releaseLocks();
                } else {
                    this.projectPlan = (ProjectPlan)this.model.getItem("ppm2.projectplan", this.projectPlan.getUID());
                    if (this.projectPlan == null) {
                        return this.getModificationProblemItemDeleted();
                    }
                }
            }
        }
        return null;
    }

    private void internalConstruct(IModelController modelCtrl) {
        if (this.isCreationDialogue()) {
            this.projectPlan.getWorkDone().setUnit(PreferenceManager.getBottomUpWorkUnit());
            this.projectPlan.getWorkRemaining().setUnit(PreferenceManager.getBottomUpWorkUnit());
            this.projectPlan.getWorkEstimated().setUnit(PreferenceManager.getBottomUpWorkUnit());
            this.projectPlan.getOriginalWork().setUnit(PreferenceManager.getTopDownWorkUnit());
        }
        this.name = new UIETextField(ProjectPlan.NAME_NAME, this.projectPlan.getName().getValueRangeHelper());
        this.description = new UIETextField(ProjectPlan.NAME_DESCRIPTION, this.projectPlan.getDescription().getValueRangeHelper(), true);
    }

    public IModuleDataTypeDescriptionForFrame getCockpitDataType() {
        return ProjectPlanDescription.MODULEDATATYPEDESCRIPTION_FORFRAME;
    }

    public boolean isMultipleEditPossible() {
        return false;
    }

    private void setValues() {
        this.name.setValue();
        this.description.setValue();
    }

    private void getValues() {
        this.name.getValue();
        this.description.getValue();
    }

    public void modifyText(ModifyEvent e) {
        this.handleModifications(e, true);
    }

    private void handleModifications(ModifyEvent e, boolean notAtInitialisation) {
        String checkResult = null;
        checkResult = this.name.checkCurrentValue();
        if (checkResult == null) {
            checkResult = this.description.checkCurrentValue();
        }
        if (notAtInitialisation) {
            this.getCallback().setErrMsg(checkResult);
            this.getCallback().setChangedStatus(true);
        } else {
            if (checkResult != null) {
                this.getCallback().setCommitable(false);
            }
            this.getCallback().setChangedStatus(false);
        }
    }

    public ProjectPlan getProjectPlan() {
        return this.projectPlan;
    }

    public void cancelChanges1() {
        if (!this.isCreationDialogue() && this.lock != null) {
            this.lock.releaseLocks();
        }
    }

    public Collection<IModificationProblem> requestCommit() {
        return Collections.EMPTY_LIST;
    }

    public void rollbackCommitRequest() {
    }

    protected void doCommitChanges() {
        this.getValues();
        if (this.isCreationDialogue()) {
            this.model.addItem((IModuleData)this.projectPlan);
        } else {
            ((ModelController)this.model).propagateAttributes_projectPlan(this.projectPlan);
            this.model.itemPropertiesModified((IModuleData)this.projectPlan, null);
        }
    }

    protected IModelController getModel() {
        return this.model;
    }

    protected AbstractModulePlugin getPlugin() {
        return ProjectPlanningModule2Plugin.getDefault();
    }
}

