/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.gui.detailsviewprovider;

import com.arcway.cockpit.client.base.interfaces.frame.gui.DetailsElement;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementSeparator;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementSingle;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementTable;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementTitle;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueList;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueSeparator;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueSingle;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueTable;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueTitle;
import com.arcway.cockpit.frame.client.lib.dataviews.dnd.DataViewDragSourceListener;
import com.arcway.cockpit.frame.client.lib.dataviews.dnd.DragSource;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.detailsviewprovider.ModuleDetailsProvider;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDuration;
import com.arcway.cockpit.projectplanningmodule2.client.Messages;
import com.arcway.cockpit.projectplanningmodule2.client.ProjectPlanningModule2Plugin;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.RessourceWorkCumulator;
import com.arcway.cockpit.projectplanningmodule2.client.gui.dnd.ProjectPlanningEditorDragSupport;
import com.arcway.cockpit.projectplanningmodule2.client.gui.preferences.PreferenceManager;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItem;
import com.arcway.lib.eclipse.transfer.dnd.IDragSourceListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class DetailsProviderTask
extends ModuleDetailsProvider {
    private Task task;

    public DetailsProviderTask() {
        ProjectPlanningModule2Plugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if ("ppm.prefs.PrefTopDownWorkUnit".equals(e.getProperty()) && DetailsProviderTask.this.task != null) {
                    DetailsProviderTask.this.showElement(DetailsProviderTask.this.getCurrentElementToShow());
                }
            }
        });
    }

    protected List<DetailsElement> getTitleDetailsElements_internal(ICockpitProjectData itemToShow) {
        Task task_;
        assert (itemToShow instanceof Task) : "element to be shown must be of type Task";
        this.task = task_ = (Task)itemToShow;
        ProjectPlanningEditorDragSupport dragSupport = new ProjectPlanningEditorDragSupport(this.getModelController(this.task.getProjectUID()));
        DataViewDragSourceListener dragListener = new DataViewDragSourceListener(DetailsProviderTask.createSelectionProvider((Object)itemToShow), new DragSource[]{dragSupport.getDragSource()});
        return Collections.singletonList(new DetailsElementTitle(null, new DetailsValueTitle(task_.getDisplayRepresentation(), this.getTitleImage((ICockpitProjectData)task_), (IDragSourceListener)dragListener)));
    }

    protected List<DetailsElement> getFixAttributeDetailsElements(ICockpitProjectData itemToShow) {
        assert (itemToShow instanceof Task) : "element to be shown must be of type Task";
        Task task_ = (Task)itemToShow;
        int statusColour = 0;
        int status = task_.getState().getValue();
        if (status == 2) {
            statusColour = 3;
        } else if (status == 3) {
            statusColour = 0;
        } else if (status == 0) {
            statusColour = 1;
        } else if (status == 1) {
            statusColour = 1;
        }
        int criticalColour = 0;
        boolean isCritical = task_.isCritical().getValue();
        criticalColour = isCritical ? 3 : 0;
        ArrayList<DetailsElement> detailsElements = new ArrayList<DetailsElement>();
        if (!task_.isMilestone().getValue()) {
            detailsElements.add((DetailsElement)new DetailsElementSingle(null, Task.NAME_START, new DetailsValueSingle(task_.getStart().getDisplayStringRepresentation(), 0)));
        }
        detailsElements.add((DetailsElement)new DetailsElementSingle(null, Task.NAME_FINISH, new DetailsValueSingle(task_.getFinish().getDisplayStringRepresentation(), 0)));
        if (!task_.isMilestone().getValue()) {
            detailsElements.add((DetailsElement)new DetailsElementSingle(null, Task.NAME_DURATION, new DetailsValueSingle(task_.calculateDuration().getDisplayRepresentationWithUnit(), 0)));
            detailsElements.add((DetailsElement)new DetailsElementSeparator(null, 8, new DetailsValueSeparator()));
            detailsElements.add((DetailsElement)new DetailsElementSingle(null, Messages.getString("DetailsProviderTask.3"), new DetailsValueSingle(String.valueOf(task_.calculatePercentWorkComplete()), 0)));
            detailsElements.add((DetailsElement)new DetailsElementSeparator(null, 8, new DetailsValueSeparator()));
            detailsElements.add((DetailsElement)new DetailsElementSingle(null, Messages.getString("DetailsProviderTask.TopDownEstimation"), new DetailsValueSingle(task_.getOriginalWork().getDisplayRepresentationWithUnit(), 0)));
            detailsElements.add((DetailsElement)new DetailsElementSingle(null, Messages.getString("DetailsProviderTask.BottomUpEstimation"), new DetailsValueSingle(task_.getWorkEstimated().getDisplayRepresentationWithUnit(), 0)));
            detailsElements.add((DetailsElement)new DetailsElementSeparator(null, 8, new DetailsValueSeparator()));
            detailsElements.add((DetailsElement)new DetailsElementSingle(null, Messages.getString("DetailsProviderTask.2"), new DetailsValueSingle(task_.calculateWorkForecast().getDisplayRepresentationWithUnit(), 0)));
            detailsElements.add((DetailsElement)new DetailsElementSingle(null, WorkItem.NAME_WORK_DONE, new DetailsValueSingle(task_.getWorkDone().getDisplayRepresentationWithUnit(), 0)));
            detailsElements.add((DetailsElement)new DetailsElementSingle(null, WorkItem.NAME_WORK_REMAINING, new DetailsValueSingle(task_.getWorkRemaining().getDisplayRepresentationWithUnit(), 0)));
            detailsElements.add((DetailsElement)new DetailsElementSeparator(null, 8, new DetailsValueSeparator()));
            detailsElements.add((DetailsElement)new DetailsElementSingle(null, Task.NAME_STATUS, new DetailsValueSingle(task_.getState().getDisplayStringRepresentation(), statusColour)));
            detailsElements.add((DetailsElement)new DetailsElementSingle(null, Task.NAME_IS_CRITICAL, new DetailsValueSingle(task_.isCritical().getDisplayStringRepresentation(), criticalColour)));
            detailsElements.add((DetailsElement)new DetailsElementSingle(null, Task.NAME_PRIORITY, new DetailsValueSingle(task_.getPriority().getDisplayStringRepresentation(), 0)));
        }
        return detailsElements;
    }

    protected List<DetailsElement> getTypeSpecificAdditionalInformationDetailsElements(ICockpitProjectData itemToShow) {
        assert (itemToShow instanceof Task) : "element to be shown must be of type Task";
        Task task_ = (Task)itemToShow;
        ModelController modelController = (ModelController)ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(task_.getProjectUID());
        DetailsValueTable detailsValueResourceTable = null;
        int workUnit = PreferenceManager.getBottomUpWorkUnit();
        RessourceWorkCumulator workComulator = modelController.getRessourceWorkCumulator(task_);
        Iterator<String> ressourceNames = workComulator.getResourceNames().iterator();
        if (ressourceNames.hasNext()) {
            detailsValueResourceTable = new DetailsValueTable();
            detailsValueResourceTable.addColumn(Messages.getString("DetailsProviderTask.5"));
            detailsValueResourceTable.addColumn(Messages.getString("DetailsProviderTask.6"));
            detailsValueResourceTable.addColumn(Messages.getString("DetailsProviderTask.7"));
            detailsValueResourceTable.addColumn(Messages.getString("DetailsProviderTask.8"));
            while (ressourceNames.hasNext()) {
                String ressourceName = ressourceNames.next();
                ModuleDataAttributeDuration workOfResource = workComulator.getWorkForecast(ressourceName);
                workOfResource.setUnit(workUnit);
                ModuleDataAttributeDuration workDoneOfResource = workComulator.getWorkDone(ressourceName);
                workDoneOfResource.setUnit(workUnit);
                String resourceWork = workOfResource.getDisplayRepresentationWithUnit();
                String resourceWorkDone = workDoneOfResource.getDisplayRepresentationWithUnit();
                String percentComplete = "-";
                if (workOfResource.getValue() != 0L) {
                    percentComplete = String.valueOf((int)(100L * workDoneOfResource.getValue() / workOfResource.getValue()));
                }
                DetailsValueList row = new DetailsValueList();
                row.addListElement(ressourceName, null, null);
                row.addListElement(resourceWork, null, null);
                row.addListElement(resourceWorkDone, null, null);
                row.addListElement(percentComplete, null, null);
                detailsValueResourceTable.addTableRow(row);
            }
        }
        if (detailsValueResourceTable != null) {
            return Collections.singletonList(new DetailsElementTable(Messages.getString("DetailsProviderTask.4"), detailsValueResourceTable));
        }
        return Collections.emptyList();
    }

    public IAction[] getToolbarActions() {
        return null;
    }

    public String getID() {
        return "ppm2.task";
    }

    protected IModelController getModelController(String projectUID) {
        return ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(projectUID);
    }

    public boolean canBeDisplayed(ICockpitProjectData item) {
        if (!(item instanceof Task)) {
            return false;
        }
        Task taskToDisplay = (Task)item;
        IModelController modelController = ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(taskToDisplay.getProjectUID());
        return modelController.itemExists(taskToDisplay.getTypeID(), taskToDisplay.getUID());
    }
}

