/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.gui.detailsviewprovider;

import com.arcway.cockpit.client.base.interfaces.frame.gui.DetailsElement;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementList;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementMulti;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementSeparator;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementSingle;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementTable;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementTitle;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.ListEntryParameter;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueList;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueMulti;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueSeparator;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueSingle;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueTable;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueTitle;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.detailsviewprovider.ModuleDetailsProvider;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDuration;
import com.arcway.cockpit.projectplanningmodule2.client.Messages;
import com.arcway.cockpit.projectplanningmodule2.client.ProjectPlanningModule2Plugin;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.RessourceWorkCumulator;
import com.arcway.cockpit.projectplanningmodule2.client.gui.detailsviewprovider.OpenSourceFileRunnable;
import com.arcway.cockpit.projectplanningmodule2.client.gui.preferences.PreferenceManager;
import com.arcway.cockpit.projectplanningmodule2.client.messages.ProjectPlan;
import com.arcway.cockpit.projectplanningmodule2.client.messages.SourceFile;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItem;
import com.arcway.lib.java.collections.CollectionUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class DetailsProviderProjectPlan
extends ModuleDetailsProvider {
    private ProjectPlan projectPlan;

    public DetailsProviderProjectPlan() {
        ProjectPlanningModule2Plugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if ("ppm.prefs.PrefTopDownWorkUnit".equals(e.getProperty()) && DetailsProviderProjectPlan.this.projectPlan != null) {
                    DetailsProviderProjectPlan.this.showElement(DetailsProviderProjectPlan.this.getCurrentElementToShow());
                }
            }
        });
    }

    public IAction[] getToolbarActions() {
        return null;
    }

    protected List<DetailsElement> getTitleDetailsElements_internal(ICockpitProjectData itemToShow) {
        ProjectPlan projectPlan_;
        assert (itemToShow instanceof ProjectPlan) : "element to be shown must be of type ProjectPlan";
        this.projectPlan = projectPlan_ = (ProjectPlan)itemToShow;
        return Collections.singletonList(new DetailsElementTitle(null, new DetailsValueTitle(projectPlan_.getName().getDisplayStringRepresentation(), this.getTitleImage((ICockpitProjectData)projectPlan_))));
    }

    protected List<DetailsElement> getFixAttributeDetailsElements(ICockpitProjectData itemToShow) {
        assert (itemToShow instanceof ProjectPlan) : "element to be shown must be of type ProjectPlan";
        ProjectPlan projectPlan_ = (ProjectPlan)itemToShow;
        ArrayList<DetailsElement> detailsElements = new ArrayList<DetailsElement>();
        detailsElements.add((DetailsElement)new DetailsElementMulti(null, Messages.getString("DetailsProviderProjectPlan.4"), new DetailsValueMulti(projectPlan_.getDescription().getDisplayStringRepresentation()), false));
        detailsElements.add((DetailsElement)new DetailsElementSeparator(null, 8, new DetailsValueSeparator()));
        detailsElements.add((DetailsElement)new DetailsElementSingle(null, Messages.getString("DetailsProviderProjectPlan.5"), new DetailsValueSingle(projectPlan_.getStart().getDisplayStringRepresentation())));
        detailsElements.add((DetailsElement)new DetailsElementSingle(null, Messages.getString("DetailsProviderProjectPlan.6"), new DetailsValueSingle(projectPlan_.getFinish().getDisplayStringRepresentation())));
        detailsElements.add((DetailsElement)new DetailsElementSingle(null, Messages.getString("DetailsProviderProjectPlan.7"), new DetailsValueSingle(projectPlan_.calculateDuration().getDisplayRepresentationWithUnit())));
        detailsElements.add((DetailsElement)new DetailsElementSeparator(null, 8, new DetailsValueSeparator()));
        detailsElements.add((DetailsElement)new DetailsElementSingle(null, Messages.getString("DetailsProviderTask.3"), new DetailsValueSingle(String.valueOf(projectPlan_.calculateWorkComplete()), 0)));
        detailsElements.add((DetailsElement)new DetailsElementSeparator(null, 8, new DetailsValueSeparator()));
        detailsElements.add((DetailsElement)new DetailsElementSingle(null, Messages.getString("DetailsProviderTask.TopDownEstimation"), new DetailsValueSingle(projectPlan_.getOriginalWork().getDisplayRepresentationWithUnit(), 0)));
        detailsElements.add((DetailsElement)new DetailsElementSingle(null, Messages.getString("DetailsProviderTask.BottomUpEstimation"), new DetailsValueSingle(projectPlan_.getWorkEstimated().getDisplayRepresentationWithUnit(), 0)));
        detailsElements.add((DetailsElement)new DetailsElementSeparator(null, 8, new DetailsValueSeparator()));
        detailsElements.add((DetailsElement)new DetailsElementSingle(null, Messages.getString("DetailsProviderProjectPlan.8"), new DetailsValueSingle(projectPlan_.calculateWorkForecast().getDisplayRepresentationWithUnit())));
        detailsElements.add((DetailsElement)new DetailsElementSingle(null, Messages.getString("DetailsProviderProjectPlan.9"), new DetailsValueSingle(projectPlan_.getWorkDone().getDisplayRepresentationWithUnit())));
        detailsElements.add((DetailsElement)new DetailsElementSingle(null, WorkItem.NAME_WORK_REMAINING, new DetailsValueSingle(projectPlan_.getWorkRemaining().getDisplayRepresentationWithUnit())));
        return detailsElements;
    }

    protected List<DetailsElement> getTypeSpecificAdditionalInformationDetailsElements(ICockpitProjectData itemToShow) {
        assert (itemToShow instanceof ProjectPlan) : "element to be shown must be of type ProjectPlan";
        ProjectPlan projectPlan_ = (ProjectPlan)itemToShow;
        ModelController modelController = (ModelController)ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(projectPlan_.getProjectUID());
        DetailsValueTable detailsValueTasksTable = new DetailsValueTable();
        detailsValueTasksTable.addColumn(Messages.getString("DetailsProviderProjectPlan.14"));
        detailsValueTasksTable.addColumn(Messages.getString("DetailsProviderProjectPlan.15"));
        Collection tasks = CollectionUtils.getTypedCollection((Collection)modelController.getChildren((IModuleData)projectPlan_, "ppm2.task"), Task.class);
        String stateString = Task.getStateKeys()[0].getName(Locale.getDefault());
        DetailsValueList tableRow = new DetailsValueList();
        tableRow.addListElement(stateString, null, null);
        tableRow.addListElement(String.valueOf(this.countTaskByState(tasks, 0)), null, null);
        detailsValueTasksTable.addTableRow(tableRow);
        tableRow = new DetailsValueList();
        stateString = Task.getStateKeys()[3].getName(Locale.getDefault());
        tableRow.addListElement(stateString, null, null);
        tableRow.addListElement(String.valueOf(this.countTaskByState(tasks, 3)), null, null);
        detailsValueTasksTable.addTableRow(tableRow);
        tableRow = new DetailsValueList();
        stateString = Task.getStateKeys()[2].getName(Locale.getDefault());
        tableRow.addListElement(stateString, null, null);
        tableRow.addListElement(String.valueOf(this.countTaskByState(tasks, 2)), null, null);
        detailsValueTasksTable.addTableRow(tableRow);
        tableRow = new DetailsValueList();
        stateString = Task.getStateKeys()[1].getName(Locale.getDefault());
        tableRow.addListElement(stateString, null, null);
        tableRow.addListElement(String.valueOf(this.countTaskByState(tasks, 1)), null, null);
        detailsValueTasksTable.addTableRow(tableRow);
        tableRow = new DetailsValueList();
        stateString = Task.getStateKeys()[4].getName(Locale.getDefault());
        tableRow.addListElement(stateString, null, null);
        tableRow.addListElement(String.valueOf(this.countTaskByState(tasks, 4)), null, null);
        detailsValueTasksTable.addTableRow(tableRow);
        DetailsValueTable detailsValueResourcesTable = null;
        int workBottomUpUnit = PreferenceManager.getBottomUpWorkUnit();
        RessourceWorkCumulator workComulator = modelController.getRessourceWorkCumulator(projectPlan_);
        Iterator<String> ressourceNames = workComulator.getResourceNames().iterator();
        if (ressourceNames.hasNext()) {
            detailsValueResourcesTable = new DetailsValueTable();
            detailsValueResourcesTable.addColumn(Messages.getString("DetailsProviderProjectPlan.16"));
            detailsValueResourcesTable.addColumn(Messages.getString("DetailsProviderProjectPlan.17"));
            detailsValueResourcesTable.addColumn(Messages.getString("DetailsProviderProjectPlan.18"));
            detailsValueResourcesTable.addColumn(Messages.getString("DetailsProviderProjectPlan.19"));
            while (ressourceNames.hasNext()) {
                String ressourceName = ressourceNames.next();
                ModuleDataAttributeDuration workOfResource = workComulator.getWorkForecast(ressourceName);
                workOfResource.setUnit(workBottomUpUnit);
                ModuleDataAttributeDuration workDoneOfResource = workComulator.getWorkDone(ressourceName);
                workDoneOfResource.setUnit(workBottomUpUnit);
                String resourceWork = workOfResource.getDisplayRepresentationWithUnit();
                String resourceWorkDone = workDoneOfResource.getDisplayRepresentationWithUnit();
                String percentComplete = "-";
                if (workOfResource.getValue() > 0L) {
                    percentComplete = String.valueOf((int)(100L * workDoneOfResource.getValue() / workOfResource.getValue()));
                }
                DetailsValueList row = new DetailsValueList();
                row.addListElement(ressourceName, null, null);
                row.addListElement(resourceWork, null, null);
                row.addListElement(resourceWorkDone, null, null);
                row.addListElement(percentComplete, null, null);
                detailsValueResourcesTable.addTableRow(row);
            }
        }
        DetailsValueList detailsValueSourceFile = new DetailsValueList();
        OpenSourceFileRunnable openSourceFileRunnable = null;
        SourceFile sourceFile = modelController.getSourceFile(projectPlan_);
        String sourceFileURL = "-";
        if (sourceFile != null && sourceFile.getPath() != null) {
            sourceFileURL = sourceFile.getPath().getDisplayStringRepresentation();
            File file = sourceFile.getPath().getValue().toFile();
            if (file.exists()) {
                openSourceFileRunnable = new OpenSourceFileRunnable(file, this.getContainingDetailsView().getSite().getPage());
            }
        }
        detailsValueSourceFile.addListElement(sourceFileURL, null, new ListEntryParameter(openSourceFileRunnable, null, null));
        ArrayList<DetailsElement> detailsElements = new ArrayList<DetailsElement>();
        detailsElements.add((DetailsElement)new DetailsElementTable(Messages.getString("DetailsProviderProjectPlan.10"), detailsValueTasksTable));
        if (detailsValueResourcesTable != null) {
            detailsElements.add((DetailsElement)new DetailsElementSeparator(null, 8, new DetailsValueSeparator()));
            detailsElements.add((DetailsElement)new DetailsElementTable(Messages.getString("DetailsProviderProjectPlan.11"), detailsValueResourcesTable));
        }
        detailsElements.add((DetailsElement)new DetailsElementSeparator(null, 8, new DetailsValueSeparator()));
        detailsElements.add((DetailsElement)new DetailsElementList(null, Messages.getString("DetailsProviderProjectPlan.0"), detailsValueSourceFile));
        return detailsElements;
    }

    private int countTaskByState(Collection<Task> tasks, int taskStatus) {
        int count = 0;
        for (Task task : tasks) {
            if (task.getState().getValue() != taskStatus) continue;
            ++count;
        }
        return count;
    }

    public String getID() {
        return "ppm2.projectplan";
    }

    protected IModelController getModelController(String projectUID) {
        return ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(projectUID);
    }

    public boolean canBeDisplayed(ICockpitProjectData item) {
        assert (item != null);
        if (!(item instanceof ProjectPlan)) {
            return false;
        }
        ProjectPlan pp = (ProjectPlan)item;
        IModelController modelController = ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(pp.getProjectUID());
        return modelController.itemExists(pp.getTypeID(), pp.getUID());
    }
}

