/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.gui.actions;

import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.wizards.MainSynchronizeWizard;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.global.license.licensetypes.SynchronizeLicenseType;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import java.util.Collections;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

public class SynchronizeMenuAction
extends Action {
    private final Shell shell;
    private final Object selectedElement;

    public SynchronizeMenuAction(Shell shell_, Object selectedElement) {
        this.shell = shell_;
        this.selectedElement = selectedElement;
    }

    public void run() {
        if (this.selectedElement instanceof ICockpitProjectData) {
            ICockpitProjectData projectData = (ICockpitProjectData)this.selectedElement;
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectData.getProjectUID());
            if (projectAgent != null && projectAgent.isOpened()) {
                if (projectAgent.getServerLicenseManager().isLicenseOperationAllowed((IClientFunctionLicenseType)SynchronizeLicenseType.getSingleInstance())) {
                    MainSynchronizeWizard mainSynchronizeWizard = new MainSynchronizeWizard(this.selectedElement);
                    this.activateSynchronizeWizard(mainSynchronizeWizard);
                } else {
                    ModificationProblem problem = new ModificationProblem((IClientFunctionLicenseType)SynchronizeLicenseType.getSingleInstance(), Messages.getString((String)"SynchronizeAction.cannot_synchronize"));
                    ModificationProblemsDialog dialog = new ModificationProblemsDialog(Collections.singleton(problem), Messages.getString((String)"SynchronizeAction.synchronization_not_possible"), this.shell.getShell());
                    dialog.open();
                }
            }
        }
    }

    public void activateSynchronizeWizard(MainSynchronizeWizard wizard) {
        assert (wizard != null) : "wizard is null";
        WizardDialog dialog = new WizardDialog(this.shell.getShell(), (IWizard)wizard);
        dialog.open();
    }
}

