/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.gui.actions;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListener;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.actions.IActionRunNotifier;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IModuleDataEditDialogProvider;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataCreationWizard;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.projectplanningmodule2.client.Messages;
import com.arcway.cockpit.projectplanningmodule2.client.ProjectPlanningModule2Plugin;
import com.arcway.cockpit.projectplanningmodule2.client.core.licensetypes.ClientFunctionLicenseTypePPMModifyItems;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.PermissionMgr;
import com.arcway.cockpit.projectplanningmodule2.client.gui.actions.PPM2ModuleAction;
import com.arcway.cockpit.projectplanningmodule2.client.gui.dialogs.EditWorkItemAdapter;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchPart;

public class ActionNewUnassignedWorkItem
extends PPM2ModuleAction
implements IModuleProjectSwitchListener,
IActionRunNotifier {
    private IModelController modelCtrl;

    public ActionNewUnassignedWorkItem() {
        this.setText(Messages.getString("Action.NewUnassignedWorkItem.Label"));
        this.setToolTipText(Messages.getString("Action.NewUnassignedWorkItem.Tooltip"));
        this.setEnabled(false);
        this.setImageDescriptor(ProjectPlanningModule2Plugin.getImageDescriptor("New_WorkItem.gif"));
    }

    protected void handleProjectChanged(String projectUID) {
        boolean hasPermission = false;
        this.modelCtrl = ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(projectUID);
        if (this.modelCtrl != null) {
            PermissionMgr permissionMgr = (PermissionMgr)this.modelCtrl.getPermissionMgr();
            hasPermission = permissionMgr.mayEditUnassignedWorkItems();
        }
        this.setEnabled(hasPermission);
    }

    public void modelRefreshed(IPropertyChanges changes, Class clazz) {
        if (this.modelCtrl != null) {
            this.projectSwitched(this.modelCtrl.getProjectUID());
        }
    }

    public void run() {
        assert (this.modelCtrl != null);
        EditWorkItemAdapter dialogProvider = new EditWorkItemAdapter(null, null, -1L);
        ModuleDataCreationWizard wizard = new ModuleDataCreationWizard((IModuleDataEditDialogProvider)dialogProvider, "ppm2.workitem", this.modelCtrl, Messages.getString("EditWorkItemDialog.EnterWorkItemAttributes"));
        WorkItem newItem = new WorkItem();
        newItem.setProjectUID(this.modelCtrl.getProjectUID());
        boolean creationPossible = wizard.initialiseWizard(new IModuleData[]{newItem}, new IModuleData[0]);
        if (!creationPossible) {
            return;
        }
        WizardDialog dialog = new WizardDialog(this.getContainingShell(), (IWizard)wizard);
        dialog.open();
        this.notifyRunListeners();
    }

    protected void handleSelectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return ClientFunctionLicenseTypePPMModifyItems.getInstance();
    }
}

