/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.gui.actions;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.projectplanningmodule2.client.ProjectPlanningModule2Plugin;
import com.arcway.cockpit.projectplanningmodule2.client.core.licensetypes.ClientFunctionLicenseTypePPMModifyItems;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.PermissionMgr;
import com.arcway.cockpit.projectplanningmodule2.client.gui.actions.PPM2ModuleActionDelegate;
import com.arcway.cockpit.projectplanningmodule2.client.gui.dialogs.ReassignWorkItemsDialog;
import com.arcway.cockpit.projectplanningmodule2.client.gui.preferences.PreferenceManager;
import com.arcway.cockpit.projectplanningmodule2.client.messages.ProjectPlan;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItem;
import com.arcway.lib.java.collectionmaps.SetMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class ActionDelegateReassignWorkItems
extends PPM2ModuleActionDelegate {
    private final Runnable reassign = new Runnable(){

        @Override
        public void run() {
            ActionDelegateReassignWorkItems.this.reassign();
        }
    };
    private ModelController modelCtrl;
    private boolean enabled;
    private Task currentlySelectedTask;
    private ReassignWorkItemsDialog dialog;
    private ProjectPlan projectPlan;

    protected boolean determineEnabledStatus(String projectUID) {
        return this.enabled;
    }

    protected boolean determineEnabledStatus(IPropertyChanges changes, Class clazz) {
        return this.enabled;
    }

    protected boolean determineEnabledStatus(ISelection selection) {
        boolean enable = false;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection selectionContent = (IStructuredSelection)selection;
            String projectUid = ProjectSelectionAnalyser.extractProjectUID((ISelection)selectionContent);
            if (selectionContent.size() == 1 && selectionContent.getFirstElement() instanceof Task && projectUid != null && ProjectMgr.getProjectMgr().getProjectAgent(projectUid).isOpened()) {
                PermissionMgr permissionMgr;
                this.modelCtrl = (ModelController)ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(projectUid);
                this.currentlySelectedTask = (Task)((Object)selectionContent.getFirstElement());
                enable = this.currentlySelectedTask.isMilestone().getValue() || this.modelCtrl.containsSubTasks(this.currentlySelectedTask) ? false : (permissionMgr = (PermissionMgr)this.modelCtrl.getPermissionMgr()).mayEditWorkItemsOfTask(this.currentlySelectedTask);
            } else {
                this.currentlySelectedTask = null;
                enable = false;
            }
        }
        this.enabled = enable;
        return this.enabled;
    }

    public void run(IAction action) {
        assert (this.modelCtrl != null);
        this.projectPlan = this.modelCtrl.getProjectPlanForTask(this.currentlySelectedTask);
        Collection allTasks = this.modelCtrl.getAllTasksOfProject(this.projectPlan);
        SetMap taskWorkItemMap = new SetMap();
        for (Task task : allTasks) {
            if (!this.modelCtrl.containsWorkItems(task) || !((PermissionMgr)this.modelCtrl.getPermissionMgr()).mayEditWorkItemsOfTask(task)) continue;
            taskWorkItemMap.addAll((Object)task, this.modelCtrl.getWorkItemChildren(task));
        }
        if (((PermissionMgr)this.modelCtrl.getPermissionMgr()).mayEditUnassignedWorkItems()) {
            taskWorkItemMap.addAll(null, this.modelCtrl.getUnassignedWorkItems());
        }
        this.dialog = new ReassignWorkItemsDialog(this.getIssuingShell(), (IModelController)this.modelCtrl, this.currentlySelectedTask, taskWorkItemMap);
        if (this.dialog.open() == 0) {
            this.modelCtrl.executeTransaction(this.reassign);
        }
    }

    private void reassign() {
        Map noLongerAssignedWorkItems = this.dialog.getNoLongerAssignedWorkItems();
        for (WorkItem workItem : noLongerAssignedWorkItems.keySet()) {
            Task newParent = (Task)((Object)noLongerAssignedWorkItems.get(workItem));
            this.modelCtrl.deleteLink(this.currentlySelectedTask.getUID(), workItem.getUID(), "WorkItemTask");
            if (newParent == null) continue;
            this.modelCtrl.createLink(newParent.getUID(), (IModuleData)workItem, "WorkItemTask");
        }
        Map newlyAssignedWorkItems = this.dialog.getNewlyAssignedWorkItems();
        for (WorkItem workItem : newlyAssignedWorkItems.keySet()) {
            Task oldParent = (Task)((Object)newlyAssignedWorkItems.get(workItem));
            if (oldParent != null) {
                this.modelCtrl.deleteLink(oldParent.getUID(), workItem.getUID(), "WorkItemTask");
            }
            this.modelCtrl.createLink(this.currentlySelectedTask.getUID(), (IModuleData)workItem, "WorkItemTask");
        }
        HashSet<Object> modifiedTasks = new HashSet<Object>();
        modifiedTasks.addAll(noLongerAssignedWorkItems.values());
        modifiedTasks.addAll(newlyAssignedWorkItems.values());
        modifiedTasks.add((Object)this.currentlySelectedTask);
        modifiedTasks.remove(null);
        if (modifiedTasks.size() < 10) {
            Iterator<Object> iterator = modifiedTasks.iterator();
            while (iterator.hasNext()) {
                this.modelCtrl.propagateAttributes_workItem((Task)((Object)iterator.next()));
            }
        } else {
            this.modelCtrl.propagateAttributes_completely(this.projectPlan, PreferenceManager.getBottomUpWorkUnit(), PreferenceManager.getTopDownWorkUnit());
        }
        if (this.currentlySelectedTask != null) {
            this.modelCtrl.itemPropertiesModified((IModuleData)this.currentlySelectedTask, null);
        }
    }

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return ClientFunctionLicenseTypePPMModifyItems.getInstance();
    }
}

