/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.gui.actions;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IModuleDataEditDialogProvider;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataCreationWizard;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.projectplanningmodule2.client.Messages;
import com.arcway.cockpit.projectplanningmodule2.client.ProjectPlanningModule2Plugin;
import com.arcway.cockpit.projectplanningmodule2.client.core.licensetypes.ClientFunctionLicenseTypePPMModifyItems;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.PermissionMgr;
import com.arcway.cockpit.projectplanningmodule2.client.gui.actions.PPM2ModuleActionDelegate;
import com.arcway.cockpit.projectplanningmodule2.client.gui.dialogs.EditWorkItemAdapter;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

public class ActionDelegateNewWorkItemViaUniqueElements
extends PPM2ModuleActionDelegate {
    private IModelController modelCtrl;
    private IUniqueElement currentlySelectedUniqueElement;
    private boolean enabled;

    protected boolean determineEnabledStatus(String projectUID) {
        return this.enabled;
    }

    protected boolean determineEnabledStatus(IPropertyChanges changes, Class clazz) {
        return this.enabled;
    }

    protected boolean determineEnabledStatus(ISelection selection) {
        boolean enable = false;
        if (selection != null) {
            IStructuredSelection selectionContent = (IStructuredSelection)selection;
            String projectUid = ProjectSelectionAnalyser.extractProjectUID((ISelection)selectionContent);
            if (selectionContent.size() == 1 && selectionContent.getFirstElement() instanceof IUniqueElement && projectUid != null && ProjectMgr.getProjectMgr().getProjectAgent(projectUid).isOpened()) {
                this.modelCtrl = ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(projectUid);
                this.currentlySelectedUniqueElement = (IUniqueElement)selectionContent.getFirstElement();
                PermissionMgr permissionMgr = (PermissionMgr)this.modelCtrl.getPermissionMgr();
                enable = permissionMgr.mayEditUnassignedWorkItems();
            } else {
                this.currentlySelectedUniqueElement = null;
                enable = false;
            }
        }
        this.enabled = enable;
        return this.enabled;
    }

    public void run(IAction action) {
        assert (this.modelCtrl != null);
        EditWorkItemAdapter dialogProvider = new EditWorkItemAdapter(null, null, -1L);
        ModuleDataCreationWizard wizard = new ModuleDataCreationWizard((IModuleDataEditDialogProvider)dialogProvider, "ppm2.workitem", this.modelCtrl, Messages.getString("EditWorkItemDialog.EnterWorkItemAttributes"));
        WorkItem newItem = new WorkItem();
        newItem.setProjectUID(this.modelCtrl.getProjectUID());
        boolean creationPossible = wizard.initialiseWizard(new IModuleData[]{newItem}, new IModuleData[0]);
        if (!creationPossible) {
            return;
        }
        WizardDialog dialog = new WizardDialog(this.getIssuingShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            final WorkItem workItem = dialogProvider.getWorkItem();
            if (this.currentlySelectedUniqueElement != null) {
                this.modelCtrl.executeTransaction(new Runnable(){

                    @Override
                    public void run() {
                        ActionDelegateNewWorkItemViaUniqueElements.this.modelCtrl.createLink(ActionDelegateNewWorkItemViaUniqueElements.this.currentlySelectedUniqueElement.getUID(), (IModuleData)workItem, "WorkItemUniqueElement");
                    }
                });
            }
        }
    }

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return ClientFunctionLicenseTypePPMModifyItems.getInstance();
    }
}

