/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.gui.actions;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleLockManager;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IModuleDataEditDialogProvider;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataCreationWizard;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDuration;
import com.arcway.cockpit.projectplanningmodule2.client.Messages;
import com.arcway.cockpit.projectplanningmodule2.client.ProjectPlanningModule2Plugin;
import com.arcway.cockpit.projectplanningmodule2.client.core.licensetypes.ClientFunctionLicenseTypePPMModifyItems;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.PermissionMgr;
import com.arcway.cockpit.projectplanningmodule2.client.gui.actions.PPM2ModuleActionDelegate;
import com.arcway.cockpit.projectplanningmodule2.client.gui.dialogs.EditWorkItemAdapter;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItem;
import java.util.Collection;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

public class ActionDelegateNewWorkItem
extends PPM2ModuleActionDelegate {
    private ModelController modelCtrl;
    private Task currentlySelectedTask;
    private boolean enabled;

    protected boolean determineEnabledStatus(String projectUID) {
        return this.enabled;
    }

    protected boolean determineEnabledStatus(IPropertyChanges changes, Class clazz) {
        return this.enabled;
    }

    protected boolean determineEnabledStatus(ISelection selection) {
        boolean enable = false;
        if (selection != null) {
            IStructuredSelection selectionContent = (IStructuredSelection)selection;
            String projectUid = ProjectSelectionAnalyser.extractProjectUID((ISelection)selectionContent);
            if (selectionContent != null && selectionContent.size() == 1 && selectionContent.getFirstElement() instanceof Task && projectUid != null && ProjectMgr.getProjectMgr().getProjectAgent(projectUid).isOpened()) {
                PermissionMgr permissionMgr;
                this.modelCtrl = (ModelController)ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(projectUid);
                this.currentlySelectedTask = (Task)((Object)selectionContent.getFirstElement());
                enable = this.modelCtrl.containsSubTasks(this.currentlySelectedTask) || this.currentlySelectedTask.isMilestone().getValue() ? false : (permissionMgr = (PermissionMgr)this.modelCtrl.getPermissionMgr()).mayEditWorkItemsOfTask(this.currentlySelectedTask);
            } else {
                this.currentlySelectedTask = null;
                enable = false;
            }
        }
        this.enabled = enable;
        return this.enabled;
    }

    public void run(IAction action) {
        assert (this.modelCtrl != null);
        ModuleLockManager lockMgr = (ModuleLockManager)this.modelCtrl.getLockMgr();
        LockAccess lock = lockMgr.acquireInsertLock((ICockpitProjectData)this.currentlySelectedTask);
        if (!lock.hasLock()) {
            lock.releaseLocks();
            return;
        }
        Collection<WorkItem> alreadyExistingWorkItems = this.modelCtrl.getWorkItemChildren(this.currentlySelectedTask);
        String proposedName = null;
        if (alreadyExistingWorkItems.size() == 0) {
            proposedName = this.currentlySelectedTask.getName().getDisplayStringRepresentation();
        }
        ModuleDataAttributeDuration proposedEstimatedWork = this.currentlySelectedTask.getOriginalWork();
        for (WorkItem workItem : alreadyExistingWorkItems) {
            proposedEstimatedWork = proposedEstimatedWork.subtractDuration(workItem.getWorkEstimated());
        }
        EditWorkItemAdapter dialogProvider = new EditWorkItemAdapter(this.currentlySelectedTask, proposedName, proposedEstimatedWork.getValue());
        ModuleDataCreationWizard wizard = new ModuleDataCreationWizard((IModuleDataEditDialogProvider)dialogProvider, "ppm2.workitem", (IModelController)this.modelCtrl, Messages.getString("EditWorkItemDialog.EnterWorkItemAttributes"));
        WorkItem newItem = new WorkItem();
        newItem.setProjectUID(this.modelCtrl.getProjectUID());
        boolean creationPossible = wizard.initialiseWizard(new IModuleData[]{newItem}, new IModuleData[]{this.currentlySelectedTask});
        if (!creationPossible) {
            lock.releaseLocks();
            return;
        }
        WizardDialog dialog = new WizardDialog(this.getIssuingShell(), (IWizard)wizard);
        if (dialog.open() != 0) {
            lock.releaseLocks();
        }
    }

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return ClientFunctionLicenseTypePPMModifyItems.getInstance();
    }
}

