/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.gui.actions;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleLockManager;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IModuleDataEditDialogProvider;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataCreationWizard;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.projectplanningmodule2.client.Messages;
import com.arcway.cockpit.projectplanningmodule2.client.ProjectPlanningModule2Plugin;
import com.arcway.cockpit.projectplanningmodule2.client.core.licensetypes.ClientFunctionLicenseTypePPMModifyItems;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.PermissionMgr;
import com.arcway.cockpit.projectplanningmodule2.client.gui.actions.PPM2ModuleActionDelegate;
import com.arcway.cockpit.projectplanningmodule2.client.gui.dialogs.EditTaskAdapter;
import com.arcway.cockpit.projectplanningmodule2.client.messages.ProjectPlan;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

public class ActionDelegateNewTask
extends PPM2ModuleActionDelegate {
    private IModelController modelCtrl;
    private boolean enabled;
    private ProjectPlan currentlySelectedProjectPlan;

    protected boolean determineEnabledStatus(String projectUID) {
        return this.enabled;
    }

    protected boolean determineEnabledStatus(IPropertyChanges changes, Class clazz) {
        return this.enabled;
    }

    protected boolean determineEnabledStatus(ISelection selection) {
        boolean enable = false;
        if (selection != null) {
            IStructuredSelection selectionContent = (IStructuredSelection)selection;
            String projectUid = ProjectSelectionAnalyser.extractProjectUID((ISelection)selectionContent);
            if (selectionContent != null && selectionContent.size() == 1 && selectionContent.getFirstElement() instanceof ProjectPlan && projectUid != null && ProjectMgr.getProjectMgr().getProjectAgent(projectUid).isOpened()) {
                this.modelCtrl = ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(projectUid);
                this.currentlySelectedProjectPlan = (ProjectPlan)((Object)selectionContent.getFirstElement());
                PermissionMgr permissionMgr = (PermissionMgr)this.modelCtrl.getPermissionMgr();
                enable = permissionMgr.mayEditProjectPlan(this.currentlySelectedProjectPlan);
            } else {
                this.currentlySelectedProjectPlan = null;
                enable = false;
            }
        }
        this.enabled = enable;
        return this.enabled;
    }

    public void run(IAction action) {
        assert (this.modelCtrl != null);
        ModuleLockManager lockMgr = (ModuleLockManager)this.modelCtrl.getLockMgr();
        LockAccess lock = lockMgr.acquireInsertLock((ICockpitProjectData)this.currentlySelectedProjectPlan);
        if (!lock.hasLock()) {
            lock.releaseLocks();
            return;
        }
        EditTaskAdapter dialogProvider = new EditTaskAdapter(this.currentlySelectedProjectPlan);
        ModuleDataCreationWizard wizard = new ModuleDataCreationWizard((IModuleDataEditDialogProvider)dialogProvider, "ppm2.task", this.modelCtrl, Messages.getString("EditTaskDialog.Message.New"));
        Task newItem = new Task();
        newItem.setProjectUID(this.modelCtrl.getProjectUID());
        boolean creationPossible = wizard.initialiseWizard(new IModuleData[]{newItem}, new IModuleData[]{this.currentlySelectedProjectPlan});
        if (!creationPossible) {
            lock.releaseLocks();
            return;
        }
        WizardDialog dialog = new WizardDialog(this.getIssuingShell(), (IWizard)wizard);
        if (dialog.open() != 0) {
            lock.releaseLocks();
        }
    }

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return ClientFunctionLicenseTypePPMModifyItems.getInstance();
    }
}

