/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.gui.actions;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.projectplanningmodule2.client.Messages;
import com.arcway.cockpit.projectplanningmodule2.client.ProjectPlanningModule2Plugin;
import com.arcway.cockpit.projectplanningmodule2.client.core.licensetypes.ClientFunctionLicenseTypePPMModifyItems;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.PermissionMgr;
import com.arcway.cockpit.projectplanningmodule2.client.gui.actions.PPM2ModuleActionDelegate;
import com.arcway.cockpit.projectplanningmodule2.client.messages.ProjectPlan;
import com.arcway.cockpit.projectplanningmodule2.client.messages.SourceFile;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import de.plans.lib.util.Logger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class ActionDelegateDisconnect
extends PPM2ModuleActionDelegate {
    private static final Logger logger = Logger.getLogger(ActionDelegateDisconnect.class);
    private ProjectPlan plan = null;
    private IModelController model = null;
    private boolean enabled;
    private final Runnable disconnect = new Runnable(){

        @Override
        public void run() {
            ActionDelegateDisconnect.this.disconnect();
        }
    };

    public void run(IAction action) {
        if (this.model != null) {
            this.model.executeTransaction(this.disconnect);
        }
    }

    private void disconnect() {
        assert (this.plan != null) : "currentSelection must not be null";
        String fileName = "";
        Iterator sourceFiles = this.model.getLinkableObjects((IModuleData)this.plan, "ProjectSourceFile").iterator();
        assert (sourceFiles.hasNext());
        if (!sourceFiles.hasNext()) {
            logger.warn((Object)"Disconnect action: No source file found");
            return;
        }
        fileName = ((SourceFile)((Object)sourceFiles.next())).getPath().getDisplayStringRepresentation();
        if (!this.checkPermissions()) {
            this.model.getPermissionMgr().showNoPermissionMsg(this.getIssuingShell());
            return;
        }
        AbstractLockManager lockManager = this.model.getLockMgr();
        LockAccess lock = lockManager.acquireEditLock((ICockpitProjectData)this.plan, true);
        if (!lock.hasLock()) {
            lock.releaseLocks();
            return;
        }
        HashSet locks = new HashSet();
        if (this.requestLocks(locks)) {
            if (MessageDialog.openConfirm((Shell)this.getIssuingShell(), (String)Messages.getString("ActionDelegateDisconnect.Title"), (String)(String.valueOf(Messages.getString("ActionDelegateDisconnect.Text1")) + fileName + Messages.getString("ActionDelegateDisconnect.Text2")))) {
                ((ModelController)this.model).disconnectProjectPlan(this.plan);
            } else {
                this.releaseLocks(locks);
            }
        }
    }

    protected boolean determineEnabledStatus(ISelection selection) {
        IStructuredSelection structuredSelection;
        if (selection instanceof IStructuredSelection && !(structuredSelection = (IStructuredSelection)selection).isEmpty()) {
            ICockpitProjectData firstElement = (ICockpitProjectData)structuredSelection.getFirstElement();
            this.model = ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(firstElement.getProjectUID());
            if (firstElement instanceof ProjectPlan) {
                this.plan = (ProjectPlan)firstElement;
                this.enabled = this.checkPermissions();
                return this.enabled;
            }
        }
        this.plan = null;
        this.enabled = this.checkPermissions();
        return this.enabled;
    }

    protected boolean determineEnabledStatus(String projectUID) {
        this.model = ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(projectUID);
        if (this.model == null) {
            this.plan = null;
        }
        this.enabled = this.checkPermissions();
        return this.enabled;
    }

    protected boolean determineEnabledStatus(IPropertyChanges changes, Class clazz) {
        this.enabled = this.checkPermissions();
        return this.enabled;
    }

    private boolean checkPermissions() {
        return this.plan != null && this.model != null && ((PermissionMgr)this.model.getPermissionMgr()).mayEditProjectPlan(this.plan);
    }

    public boolean requestLocks(Collection locks) {
        AbstractLockManager lockMgr = this.model.getLockMgr();
        for (Task task : this.model.getModuleData((IModuleData)this.plan, "TaskProjectPlan")) {
            LockAccess lockAccess = lockMgr.acquireEditLock((ICockpitProjectData)task);
            if (!lockAccess.hasLock()) {
                this.releaseLocks(locks);
                return false;
            }
            locks.add(lockAccess);
            lockAccess = lockMgr.acquireRemoveLock((ICockpitProjectData)task);
            if (lockAccess.hasLock()) {
                locks.add(lockAccess);
                continue;
            }
            this.releaseLocks(locks);
            return false;
        }
        return true;
    }

    public void releaseLocks(Collection locks) {
        for (LockAccess lockAccess : locks) {
            lockAccess.releaseLocks();
        }
    }

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return ClientFunctionLicenseTypePPMModifyItems.getInstance();
    }
}

