/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.gui.actions;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleLockManager;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.projectplanningmodule2.client.Messages;
import com.arcway.cockpit.projectplanningmodule2.client.ProjectPlanningModule2Plugin;
import com.arcway.cockpit.projectplanningmodule2.client.core.licensetypes.ClientFunctionLicenseTypePPMModifyItems;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.PermissionMgr;
import com.arcway.cockpit.projectplanningmodule2.client.gui.actions.PPM2ModuleActionDelegate;
import com.arcway.cockpit.projectplanningmodule2.client.messages.IWorkItem;
import com.arcway.cockpit.projectplanningmodule2.client.messages.ProjectPlan;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;

public class ActionDelegateDelete
extends PPM2ModuleActionDelegate {
    private ArrayList currentSelection = null;
    private IModelController modelCtrl = null;
    private boolean enabled;
    private final Runnable delete = new Runnable(){

        @Override
        public void run() {
            ActionDelegateDelete.this.deleteItems(ActionDelegateDelete.this.currentSelection);
        }
    };
    private static final int BUTTON_INDEX_DELETE = 0;
    private static final int BUTTON_INDEX_DETACH = 1;
    private static final int BUTTON_INDEX_CANCEL_WITHOUT_WORKITEMS = 1;
    private static final int BUTTON_INDEX_CANCEL_WITH_WORKITEMS = 2;
    private static final String[] BUTTON_LABELS_WITH_WORKITEMS = new String[]{Messages.getString("ActionDelegateDelete.ButtonLabelDeleteWorkItems"), Messages.getString("ActionDelegateDelete.ButtonLabelDetachWorkItems"), Messages.getString("ActionDelegateDelete.ButtonLabelCancel")};
    private static final String[] BUTTON_LABELS_WITHOUT_WORKITEMS = new String[]{Messages.getString("ActionDelegateDelete.ButtonLabelDelete"), Messages.getString("ActionDelegateDelete.ButtonLabelCancel")};

    public void run(IAction action) {
        assert (action != null);
        assert (this.currentSelection != null);
        this.modelCtrl.executeTransaction(this.delete);
    }

    public void deleteItems(List items) {
        Task parent;
        assert (this.modelCtrl != null);
        PermissionMgr permissionMgr = (PermissionMgr)this.modelCtrl.getPermissionMgr();
        boolean hasPermission = permissionMgr.mayDeleteItems(items);
        if (!hasPermission) {
            permissionMgr.showNoPermissionMsg(this.getIssuingShell());
            return;
        }
        ModuleLockManager lockMgr = (ModuleLockManager)this.modelCtrl.getLockMgr();
        ArrayList<LockAccess> aquiredLocks = new ArrayList<LockAccess>();
        for (Object element : items) {
            LockAccess lock;
            if (element instanceof ProjectPlan) {
                ProjectPlan projectPlan = (ProjectPlan)((Object)element);
                lock = lockMgr.acquireRemoveLock((ICockpitProjectData)projectPlan);
                if (!lock.hasLock()) {
                    this.releaseLocks(aquiredLocks);
                    return;
                }
                aquiredLocks.add(lock);
                continue;
            }
            if (element instanceof Task) {
                Task task = (Task)((Object)element);
                lock = lockMgr.acquireRemoveLock((ICockpitProjectData)task);
                if (!lock.hasLock()) {
                    this.releaseLocks(aquiredLocks);
                    return;
                }
                aquiredLocks.add(lock);
                continue;
            }
            if (!(element instanceof WorkItem)) continue;
            WorkItem workItem = (WorkItem)element;
            lock = lockMgr.acquireRemoveLock((ICockpitProjectData)workItem);
            if (!lock.hasLock()) {
                this.releaseLocks(aquiredLocks);
                return;
            }
            aquiredLocks.add(lock);
        }
        ArrayList<IModuleData> parentsOfWorkItems = new ArrayList<IModuleData>();
        ArrayList<IModuleData> parentsOfTasks = new ArrayList<IModuleData>();
        int c = 0;
        while (c < items.size()) {
            IModuleData toDelete = (IModuleData)items.get(c);
            IModuleData parent2 = this.modelCtrl.getParent(toDelete);
            if (toDelete instanceof WorkItem) {
                parentsOfWorkItems.add(parent2);
            } else if (toDelete instanceof Task) {
                parentsOfTasks.add(parent2);
            }
            ++c;
        }
        ArrayList subItemsToBeDeleted = new ArrayList();
        int c2 = 0;
        while (c2 < items.size()) {
            IModuleData toDelete = (IModuleData)items.get(c2);
            if (toDelete instanceof ProjectPlan || toDelete instanceof Task) {
                subItemsToBeDeleted.addAll(this.modelCtrl.getAllDescendants(toDelete));
            }
            ++c2;
        }
        boolean subItemsContainWorkItems = false;
        Iterator i = subItemsToBeDeleted.iterator();
        while (i.hasNext()) {
            if (!(i.next() instanceof WorkItem)) continue;
            subItemsContainWorkItems = true;
            break;
        }
        MessageDialog dialog = subItemsContainWorkItems ? new MessageDialog(this.getIssuingShell(), Messages.getString("ActionDelegateDelete.ConfirmDeletionTitleWithWorkItems"), Display.getCurrent().getSystemImage(4), String.valueOf(Messages.getString("ActionDelegateDelete.ConfirmDeletionTextWithWorkItemsPart1")) + "\n\n" + Messages.getString("ActionDelegateDelete.ConfirmDeletionTextWithWorkItemsPart2"), 3, BUTTON_LABELS_WITH_WORKITEMS, 2) : new MessageDialog(this.getIssuingShell(), Messages.getString("ActionDelegateDelete.ConfirmDeletionTitleWithoutWorkItems"), Display.getCurrent().getSystemImage(4), Messages.getString("ActionDelegateDelete.ConfirmDeletionTextWithoutWorkItems"), 3, BUTTON_LABELS_WITHOUT_WORKITEMS, 1);
        int result = dialog.open();
        if (result == 0) {
            items.addAll(subItemsToBeDeleted);
        } else if (result == 1 && subItemsContainWorkItems) {
            i = subItemsToBeDeleted.iterator();
            while (i.hasNext()) {
                IModuleData subItem = (IModuleData)i.next();
                if (!(subItem instanceof WorkItem)) continue;
                i.remove();
            }
            items.addAll(subItemsToBeDeleted);
        } else {
            this.releaseLocks(aquiredLocks);
            return;
        }
        this.modelCtrl.deleteItems((Collection)items);
        int c3 = 0;
        while (c3 < parentsOfWorkItems.size()) {
            parent = (Task)((Object)parentsOfWorkItems.get(c3));
            if (parent != null && this.modelCtrl.itemExists("ppm2.task", parent.getUID())) {
                ((ModelController)this.modelCtrl).propagateAttributes_workItem(parent);
            }
            ++c3;
        }
        c3 = 0;
        while (c3 < parentsOfTasks.size()) {
            parent = (IModuleData)parentsOfTasks.get(c3);
            if (parent != null && this.modelCtrl.itemExists(parent.getTypeID(), parent.getUID())) {
                ((ModelController)this.modelCtrl).propagateAttributes_task((IModuleData)parent);
            }
            ++c3;
        }
    }

    private void releaseLocks(Collection aquiredLocks) {
        for (LockAccess currentLock : aquiredLocks) {
            currentLock.releaseLocks();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected boolean determineEnabledStatus(ISelection selection) {
        block10: {
            enable = false;
            if (selection == null || !(selection instanceof IStructuredSelection)) break block10;
            selectionContent = (IStructuredSelection)selection;
            projectUid = ProjectSelectionAnalyser.extractProjectUID((ISelection)selectionContent);
            if (projectUid == null || !ProjectMgr.getProjectMgr().getProjectAgent(projectUid).isOpened()) ** GOTO lbl43
            this.modelCtrl = ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(projectUid);
            if (this.modelCtrl != null) {
                permissionMgr = (PermissionMgr)this.modelCtrl.getPermissionMgr();
                this.currentSelection = new ArrayList<E>();
                for (E nextSelectionElement : selectionContent) {
                    if (nextSelectionElement instanceof ProjectPlan) {
                        projectPlan = (ProjectPlan)nextSelectionElement;
                        if (permissionMgr.mayDeleteProjectPlan(projectPlan)) {
                            this.currentSelection.add(projectPlan);
                            continue;
                        }
                        this.currentSelection.clear();
                        break;
                    }
                    if (nextSelectionElement instanceof Task) {
                        task = (Task)nextSelectionElement;
                        parent = this.modelCtrl.getParent((IModuleData)task);
                        if (permissionMgr.mayDeleteTask(task) && !((ModelController)this.modelCtrl).isSynchronized(task)) {
                            this.currentSelection.add(task);
                            continue;
                        }
                        this.currentSelection.clear();
                        break;
                    }
                    if (nextSelectionElement instanceof IWorkItem) {
                        workItem = ((IWorkItem)nextSelectionElement).getWorkItem();
                        if (permissionMgr.mayEditWorkItem(workItem, parent = this.modelCtrl.getParent((IModuleData)workItem))) {
                            this.currentSelection.add(workItem);
                            continue;
                        }
                        this.currentSelection.clear();
                        break;
                    }
                    this.currentSelection.clear();
                    break;
                }
                if (this.currentSelection.size() > 0) {
                    enable = true;
                }
            } else {
                this.enabled = enable;
                return this.enabled;
lbl43:
                // 1 sources

                enable = false;
            }
        }
        this.enabled = enable;
        return this.enabled;
    }

    protected boolean determineEnabledStatus(String projectUID) {
        this.modelCtrl = ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(projectUID);
        return this.enabled;
    }

    protected boolean determineEnabledStatus(IPropertyChanges changes, Class clazz) {
        if (this.currentSelection != null) {
            this.currentSelection.removeAll(changes.getDeletedElements());
        }
        return this.enabled;
    }

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return ClientFunctionLicenseTypePPMModifyItems.getInstance();
    }
}

