/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.gui.actions;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.projectplanningmodule2.client.ModuleIdentification;
import com.arcway.cockpit.projectplanningmodule2.client.ProjectPlanningModule2Plugin;
import com.arcway.cockpit.projectplanningmodule2.client.core.licensetypes.ClientFunctionLicenseTypePPMModifyItems;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.PermissionMgr;
import com.arcway.cockpit.projectplanningmodule2.client.gui.actions.PPM2ModuleActionDelegate;
import com.arcway.cockpit.projectplanningmodule2.client.messages.IWorkItem;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class ActionDelegateDeassignWorkItem
extends PPM2ModuleActionDelegate {
    private IModelController modelCtrl;
    private boolean enabled;
    private final Collection currentlySelectedWorkItems = new ArrayList();
    private final Collection acquiredLocks = new ArrayList();
    private final Runnable deAssignWorkItems = new Runnable(){

        @Override
        public void run() {
            ActionDelegateDeassignWorkItem.this.deassignWorkItems();
        }
    };

    protected boolean determineEnabledStatus(String projectUID) {
        return this.enabled;
    }

    protected boolean determineEnabledStatus(IPropertyChanges changes, Class clazz) {
        return this.enabled;
    }

    protected boolean determineEnabledStatus(ISelection selection) {
        boolean enable = true;
        if (selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection selectionContent = (IStructuredSelection)selection;
            String projectUid = ProjectSelectionAnalyser.extractProjectUID((ISelection)selectionContent);
            if (selectionContent != null && !selectionContent.isEmpty() && projectUid != null && ProjectMgr.getProjectMgr().getProjectAgent(projectUid).isOpened()) {
                this.modelCtrl = ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(projectUid);
                PermissionMgr permissionMgr = (PermissionMgr)this.modelCtrl.getPermissionMgr();
                this.currentlySelectedWorkItems.clear();
                for (Object selectedItem : selectionContent) {
                    if (selectedItem instanceof IWorkItem) {
                        WorkItem workItem = ((IWorkItem)selectedItem).getWorkItem();
                        Task parent = (Task)this.modelCtrl.getParent((IModuleData)workItem);
                        if (parent != null && permissionMgr.mayEditWorkItemsOfTask(parent)) {
                            this.currentlySelectedWorkItems.add(workItem);
                            continue;
                        }
                        this.currentlySelectedWorkItems.clear();
                        enable = false;
                    } else {
                        this.currentlySelectedWorkItems.clear();
                        enable = false;
                    }
                    break;
                }
            } else {
                this.currentlySelectedWorkItems.clear();
                enable = false;
            }
        } else {
            this.currentlySelectedWorkItems.clear();
            enable = false;
        }
        this.enabled = enable;
        return this.enabled;
    }

    public void run(IAction action) {
        assert (this.modelCtrl != null);
        this.modelCtrl.executeTransaction(this.deAssignWorkItems);
    }

    private void deassignWorkItems() {
        AbstractLockManager lockManager = this.modelCtrl.getLockMgr();
        this.acquiredLocks.clear();
        for (WorkItem workItem : this.currentlySelectedWorkItems) {
            LockAccess lockAccess = lockManager.acquireMoveLockBeforeMoving((ICockpitProjectData)workItem, ModuleIdentification.getModuleID());
            if (lockAccess.hasLock()) {
                this.acquiredLocks.add(lockAccess);
                continue;
            }
            lockAccess.releaseLocks();
            Iterator locks = this.acquiredLocks.iterator();
            while (locks.hasNext()) {
                ((LockAccess)locks.next()).releaseLocks();
            }
            return;
        }
        for (WorkItem workItem : this.currentlySelectedWorkItems) {
            Task parent = (Task)this.modelCtrl.getParent((IModuleData)workItem);
            this.modelCtrl.deleteLink(parent.getUID(), workItem.getUID(), "WorkItemTask");
            ((ModelController)this.modelCtrl).propagateAttributes_workItem(parent);
        }
    }

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return ClientFunctionLicenseTypePPMModifyItems.getInstance();
    }
}

