/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.gui;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholder;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractBooleanValueFilter;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractDateValuesFilter;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractDiscreteValueFilter;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractTextListFilter;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractTextValuesFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.BooleanFilterItem;
import com.arcway.cockpit.cockpitlib.client.filter.gui.DateFilterItem;
import com.arcway.cockpit.cockpitlib.client.filter.gui.DiscreteValueListFilterItem;
import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.frame.client.global.gui.views.lib.dataview.filters.FilterHelper;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListener;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListenerManager;
import com.arcway.cockpit.modulelib2.client.core.IModelControllerProvider;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.filters.ModuleDataTableListFilterItem;
import com.arcway.cockpit.modulelib2.client.messages.AbstractModuleData;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeTimestamp;
import com.arcway.cockpit.projectplanningmodule2.client.Messages;
import com.arcway.cockpit.projectplanningmodule2.client.ModuleIdentification;
import com.arcway.cockpit.projectplanningmodule2.client.ProjectPlanningModule2Plugin;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.messages.ProjectPlan;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItem;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItemCategory;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.util.valueranges.ValueRangeHelperTimestamp;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ProjectPlanningFilters
implements IModuleProjectSwitchListener {
    private static ILogger logger = Logger.getLogger(ProjectPlanningFilters.class);
    private final boolean useFixModel;
    private ModelController model;
    private IModuleProjectSwitchListenerManager projectSwitchListenerManager;
    private ModuleDataTableListFilterItem projectPlanFilterItem;

    public ProjectPlanningFilters(IModuleProjectSwitchListenerManager projectSwitchListenerManager) {
        assert (projectSwitchListenerManager != null) : "projectSelectionService must not be null";
        projectSwitchListenerManager.registerProjectSwitchListener((IModuleProjectSwitchListener)this);
        this.projectSwitchListenerManager = projectSwitchListenerManager;
        this.useFixModel = false;
    }

    public ProjectPlanningFilters(IModelController model) {
        this.model = (ModelController)model;
        this.useFixModel = true;
    }

    public List<IFilterItem> createFilters() {
        IFilterItem[] filterItems = new IFilterItem[]{this.createProjectPlanFilterItem(), this.createTaskIsCriticalFilterItem(), this.createTaskStartDateFilterItem(), this.createTaskEndDateFilterItem(), this.createTaskStatusFilterItem(), this.createTaskContainsWorkItemsFilterItem(), this.createResourceFilterItem(), this.createWorkItemEffortUnderEstimatedFilterItem(), this.createWorkItemDoneFilterItem(), this.createWorkItemCategoryFilterItem(), this.createWorkItemLastChangeFilterItem(), this.createWorkItemCreationDateFilterItem()};
        return Arrays.asList(filterItems);
    }

    public AbstractTextValuesFilter createProjectPlanFilter() {
        return new AbstractTextListFilter(){

            protected String[] getStringAttributes(Object element) {
                if (element instanceof ProjectPlan) {
                    return new String[]{((ProjectPlan)((Object)element)).getDisplayRepresentation().trim()};
                }
                if (element instanceof Task) {
                    Task task = (Task)((Object)element);
                    ProjectPlan projectPlan = ProjectPlanningFilters.this.model.getProjectPlanForTask(task);
                    return new String[]{projectPlan.getDisplayRepresentation().trim()};
                }
                if (element instanceof WorkItem) {
                    WorkItem workItem = (WorkItem)element;
                    Task task = ProjectPlanningFilters.this.model.getTaskForWorkItem(workItem);
                    if (task != null) {
                        ProjectPlan projectPlan = ProjectPlanningFilters.this.model.getProjectPlanForTask(task);
                        return new String[]{projectPlan.getDisplayRepresentation().trim()};
                    }
                }
                return null;
            }

            public String getFilterID() {
                return String.valueOf(ModuleIdentification.getModuleID()) + "ProjectPlanFilter";
            }

            protected boolean isValidObjectType(Object element) {
                return element instanceof ProjectPlan || element instanceof Task || element instanceof WorkItem && ProjectPlanningFilters.this.model.getTaskForWorkItem((WorkItem)element) != null;
            }

            public boolean isFilterProperty(Object element, String property) {
                return property.equals("ppm2.projectplan");
            }
        };
    }

    public AbstractBooleanValueFilter createTaskIsCriticalFilter() {
        return new AbstractBooleanValueFilter(){

            protected boolean isValidObjectType(Object element) {
                return element instanceof Task || element instanceof WorkItem && ProjectPlanningFilters.this.model.getTaskForWorkItem((WorkItem)element) != null;
            }

            public String getFilterID() {
                return String.valueOf(ModuleIdentification.getModuleID()) + "TaskIsCriticalFilter";
            }

            protected boolean getBooleanAttribute(Object element) {
                if (element instanceof Task) {
                    return ((Task)((Object)element)).isCritical().getValue();
                }
                if (element instanceof WorkItem) {
                    WorkItem workItem = (WorkItem)element;
                    Task task = ProjectPlanningFilters.this.model.getTaskForWorkItem(workItem);
                    if (task != null) {
                        return task.isCritical().getValue();
                    }
                }
                return false;
            }
        };
    }

    public AbstractDateValuesFilter createTaskStartDateFilter() {
        return new AbstractDateValuesFilter(){

            protected Timestamp getDateAttribute(Object element) {
                if (element instanceof Task) {
                    Task task = (Task)((Object)element);
                    ModuleDataAttributeTimestamp startDate = task.getStart();
                    return ((ValueRangeHelperTimestamp)startDate.getValueRangeHelper()).getValue();
                }
                if (element instanceof WorkItem) {
                    WorkItem workItem = (WorkItem)element;
                    Task task = ProjectPlanningFilters.this.model.getTaskForWorkItem(workItem);
                    if (task != null) {
                        ModuleDataAttributeTimestamp startDate = task.getStart();
                        return ((ValueRangeHelperTimestamp)startDate.getValueRangeHelper()).getValue();
                    }
                }
                return null;
            }

            public String getFilterID() {
                return String.valueOf(ModuleIdentification.getModuleID()) + "taskStartDateFilter";
            }

            protected boolean isValidObjectType(Object element) {
                return element instanceof Task || element instanceof WorkItem && ProjectPlanningFilters.this.model.getTaskForWorkItem((WorkItem)element) != null;
            }

            public boolean isFilterProperty(Object element, String property) {
                return property.equals("ppm2.task");
            }
        };
    }

    public AbstractDateValuesFilter createTaskEndDateFilter() {
        return new AbstractDateValuesFilter(){

            protected Timestamp getDateAttribute(Object element) {
                if (element instanceof Task) {
                    Task task = (Task)((Object)element);
                    ModuleDataAttributeTimestamp finishDate = task.getFinish();
                    return ((ValueRangeHelperTimestamp)finishDate.getValueRangeHelper()).getValue();
                }
                if (element instanceof WorkItem) {
                    WorkItem workItem = (WorkItem)element;
                    Task task = ProjectPlanningFilters.this.model.getTaskForWorkItem(workItem);
                    if (task != null) {
                        ModuleDataAttributeTimestamp finishDate = task.getFinish();
                        return ((ValueRangeHelperTimestamp)finishDate.getValueRangeHelper()).getValue();
                    }
                }
                return null;
            }

            public String getFilterID() {
                return String.valueOf(ModuleIdentification.getModuleID()) + "taskFinishDateFilter";
            }

            protected boolean isValidObjectType(Object element) {
                return element instanceof Task || element instanceof WorkItem && ProjectPlanningFilters.this.model.getTaskForWorkItem((WorkItem)element) != null;
            }

            public boolean isFilterProperty(Object element, String property) {
                return property.equals("ppm2.task");
            }
        };
    }

    public AbstractDiscreteValueFilter createTaskStatusFilter() {
        return new AbstractDiscreteValueFilter(){

            protected int getDiscreteIndex(Object element) {
                if (element instanceof Task) {
                    return ((Task)((Object)element)).getState().getValue();
                }
                if (element instanceof WorkItem) {
                    WorkItem workItem = (WorkItem)element;
                    Task task = ProjectPlanningFilters.this.model.getTaskForWorkItem(workItem);
                    if (task != null) {
                        return task.getState().getValue();
                    }
                }
                return -1;
            }

            public String getFilterID() {
                return String.valueOf(ModuleIdentification.getModuleID()) + "TaskStatusFilter";
            }

            protected boolean isValidObjectType(Object element) {
                return element instanceof Task || element instanceof WorkItem && ProjectPlanningFilters.this.model.getTaskForWorkItem((WorkItem)element) != null;
            }

            public boolean isFilterProperty(Object element, String property) {
                return property.equals("ppm.task.importedState");
            }
        };
    }

    public AbstractBooleanValueFilter createTaskContainsWorkItemFilter() {
        return new AbstractBooleanValueFilter(){

            protected boolean getBooleanAttribute(Object element) {
                try {
                    Task task = (Task)((Object)element);
                    return !ProjectPlanningFilters.this.model.getLinksForLinkableObject(task.getUID(), "WorkItemTask").isEmpty();
                }
                catch (ClassCastException e) {
                    return false;
                }
            }

            public String getFilterID() {
                return String.valueOf(ModuleIdentification.getModuleID()) + "TaskContainsWorkItemFilter";
            }

            protected boolean isValidObjectType(Object element) {
                return element instanceof Task;
            }
        };
    }

    public AbstractTextValuesFilter createResourceFilter() {
        return new AbstractTextListFilter(){

            protected String[] getStringAttributes(Object element) {
                if (element instanceof WorkItem) {
                    WorkItem workItem = (WorkItem)element;
                    String[] resourceStrings = ProjectPlanningFilters.this.determineRessourceStringValues(workItem);
                    return resourceStrings;
                }
                return null;
            }

            public String getFilterID() {
                return String.valueOf(ModuleIdentification.getModuleID()) + "ResourceFilter";
            }

            protected boolean isValidObjectType(Object element) {
                return element instanceof WorkItem;
            }

            public boolean isFilterProperty(Object element, String property) {
                return property.equals("ppm2.workitem");
            }
        };
    }

    public AbstractBooleanValueFilter createWorkItemEffortUnderestimatedFilter() {
        return new AbstractBooleanValueFilter(){

            protected boolean isValidObjectType(Object element) {
                return element instanceof WorkItem;
            }

            public String getFilterID() {
                return String.valueOf(ModuleIdentification.getModuleID()) + "WorkItemEffortUnderestimatedFilter";
            }

            protected boolean getBooleanAttribute(Object element) {
                try {
                    WorkItem workItem = (WorkItem)element;
                    return workItem.getWorkEstimated().isShorterThan(workItem.calculateForecast());
                }
                catch (ClassCastException e) {
                    return false;
                }
            }
        };
    }

    public AbstractBooleanValueFilter createWorkItemDoneFilter() {
        return new AbstractBooleanValueFilter(){

            protected boolean isValidObjectType(Object element) {
                return element instanceof WorkItem;
            }

            public String getFilterID() {
                return String.valueOf(ModuleIdentification.getModuleID()) + "WorkItemDoneFilter";
            }

            protected boolean getBooleanAttribute(Object element) {
                try {
                    return ((WorkItem)element).isComplete();
                }
                catch (ClassCastException e) {
                    return false;
                }
            }
        };
    }

    public AbstractDateValuesFilter createWorkItemLastChangeFilter() {
        return new AbstractDateValuesFilter(){

            protected Timestamp getDateAttribute(Object element) {
                if (element instanceof WorkItem) {
                    WorkItem workItem = (WorkItem)element;
                    ModuleDataAttributeTimestamp changeDate = workItem.getModificationTime();
                    return ((ValueRangeHelperTimestamp)changeDate.getValueRangeHelper()).getValue();
                }
                return null;
            }

            public String getFilterID() {
                return String.valueOf(ModuleIdentification.getModuleID()) + "workItemLastChangeFilter";
            }

            protected boolean isValidObjectType(Object element) {
                return element instanceof WorkItem;
            }

            public boolean isFilterProperty(Object element, String property) {
                return property.equals("ppm2.workitem");
            }
        };
    }

    public AbstractDateValuesFilter createWorkItemCreationDateFilter() {
        return new AbstractDateValuesFilter(){

            protected Timestamp getDateAttribute(Object element) {
                if (element instanceof WorkItem) {
                    WorkItem workItem = (WorkItem)element;
                    ModuleDataAttributeTimestamp creationDate = workItem.getCreationTime();
                    return ((ValueRangeHelperTimestamp)creationDate.getValueRangeHelper()).getValue();
                }
                return null;
            }

            public String getFilterID() {
                return String.valueOf(ModuleIdentification.getModuleID()) + "workItemCreationDateFilter";
            }

            protected boolean isValidObjectType(Object element) {
                return element instanceof WorkItem;
            }

            public boolean isFilterProperty(Object element, String property) {
                return property.equals("ppm2.workitem");
            }
        };
    }

    public AbstractTextValuesFilter createWorkItemCategoryFilter() {
        return new AbstractTextValuesFilter(true){

            protected String getStringAttribute(Object element) {
                if (ProjectPlanningFilters.this.model != null && element instanceof WorkItem) {
                    Iterator linkableObjects = ProjectPlanningFilters.this.model.getLinkableObjects((IModuleData)((WorkItem)element), "WorkItemCategory").iterator();
                    if (linkableObjects.hasNext()) {
                        WorkItemCategory cat = (WorkItemCategory)((Object)linkableObjects.next());
                        return cat.getDisplayRepresentation();
                    }
                    return "";
                }
                return null;
            }

            public String getFilterID() {
                return String.valueOf(ModuleIdentification.getModuleID()) + "WorkItemCategoryFilter";
            }

            protected boolean isValidObjectType(Object element) {
                return element instanceof WorkItem;
            }

            public boolean isFilterProperty(Object element, String property) {
                return property.equals("ppm2.workitem");
            }
        };
    }

    public IFilterItem createProjectPlanFilterItem() {
        if (this.useFixModel) {
            this.projectPlanFilterItem = new ProjectPlanFilterItem((IModelController)this.model, this.createProjectPlanFilter());
        } else {
            this.projectPlanFilterItem = new ProjectPlanFilterItem(this.projectSwitchListenerManager, this.createProjectPlanFilter());
            this.projectSwitchListenerManager.registerProjectSwitchListener((IModuleProjectSwitchListener)this.projectPlanFilterItem);
        }
        return this.projectPlanFilterItem;
    }

    public IFilterItem createTaskIsCriticalFilterItem() {
        return new BooleanFilterItem(FilterHelper.getFilterName((String)Task.MODULE_DATA_NAME, (String)Messages.getString("ProjectPlanningFilters.TaskIsCritical")), this.createTaskIsCriticalFilter());
    }

    public IFilterItem createTaskStartDateFilterItem() {
        return new DateFilterItem(FilterHelper.getFilterName((String)Task.MODULE_DATA_NAME, (String)Task.NAME_START), this.createTaskStartDateFilter());
    }

    public IFilterItem createTaskEndDateFilterItem() {
        return new DateFilterItem(FilterHelper.getFilterName((String)Task.MODULE_DATA_NAME, (String)Task.NAME_FINISH), this.createTaskEndDateFilter());
    }

    public IFilterItem createTaskStatusFilterItem() {
        return new DiscreteValueListFilterItem(FilterHelper.getFilterName((String)Task.MODULE_DATA_NAME, (String)Task.NAME_STATUS), Arrays.asList(Task.getStateKeys()), this.createTaskStatusFilter());
    }

    public IFilterItem createTaskContainsWorkItemsFilterItem() {
        return new BooleanFilterItem(FilterHelper.getFilterName((String)Task.MODULE_DATA_NAME, (String)Messages.getString("ProjectPlanningFilters.0")), this.createTaskContainsWorkItemFilter());
    }

    public IFilterItem createResourceFilterItem() {
        if (this.useFixModel) {
            this.projectPlanFilterItem = new ResourceFilterItem((IModelController)this.model, this.createResourceFilter());
        } else {
            this.projectPlanFilterItem = new ResourceFilterItem(this.projectSwitchListenerManager, this.createResourceFilter());
            this.projectSwitchListenerManager.registerProjectSwitchListener((IModuleProjectSwitchListener)this.projectPlanFilterItem);
        }
        return this.projectPlanFilterItem;
    }

    public IFilterItem createWorkItemEffortUnderEstimatedFilterItem() {
        return new BooleanFilterItem(FilterHelper.getFilterName((String)WorkItem.MODULE_DATA_NAME, (String)Messages.getString("ProjectPlanningFilters.1")), this.createWorkItemEffortUnderestimatedFilter());
    }

    public IFilterItem createWorkItemDoneFilterItem() {
        return new BooleanFilterItem(FilterHelper.getFilterName((String)WorkItem.MODULE_DATA_NAME, (String)Messages.getString("ProjectPlanningFilters.2")), this.createWorkItemDoneFilter());
    }

    public IFilterItem createWorkItemLastChangeFilterItem() {
        return new DateFilterItem(FilterHelper.getFilterName((String)WorkItem.MODULE_DATA_NAME, (String)AbstractModuleData.MDATE_NAME), this.createWorkItemLastChangeFilter());
    }

    public IFilterItem createWorkItemCreationDateFilterItem() {
        return new DateFilterItem(FilterHelper.getFilterName((String)WorkItem.MODULE_DATA_NAME, (String)AbstractModuleData.CDATE_NAME), this.createWorkItemCreationDateFilter());
    }

    public IFilterItem createWorkItemCategoryFilterItem() {
        if (this.useFixModel) {
            this.projectPlanFilterItem = new ModuleDataTableListFilterItem(FilterHelper.getFilterName((String)WorkItem.MODULE_DATA_NAME, (String)WorkItem.NAME_CATEGORY), "ppm2.workitemcategory", (IModelController)this.model, this.createWorkItemCategoryFilter());
        } else {
            this.projectPlanFilterItem = new ModuleDataTableListFilterItem(FilterHelper.getFilterName((String)WorkItem.MODULE_DATA_NAME, (String)WorkItem.NAME_CATEGORY), "ppm2.workitemcategory", this.projectSwitchListenerManager, (IModelControllerProvider)ProjectPlanningModule2Plugin.getDefault().getProjectManager(), this.createWorkItemCategoryFilter());
            this.projectSwitchListenerManager.registerProjectSwitchListener((IModuleProjectSwitchListener)this.projectPlanFilterItem);
        }
        this.projectPlanFilterItem.setComparator(new Comparator(){

            public int compare(Object o1, Object o2) {
                WorkItemCategory c1 = (WorkItemCategory)((Object)o1);
                WorkItemCategory c2 = (WorkItemCategory)((Object)o2);
                return c1.getCategory().getDisplayStringRepresentation().compareToIgnoreCase(c2.getCategory().getDisplayStringRepresentation());
            }
        });
        return this.projectPlanFilterItem;
    }

    public void projectSwitched(String projectUID) {
        this.model = (ModelController)ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(projectUID);
        this.initializeDefaultValues();
    }

    public void dispose() {
        if (this.projectSwitchListenerManager != null) {
            this.projectSwitchListenerManager.deregisterProjectSwitchListener((IModuleProjectSwitchListener)this);
        }
        this.model = null;
    }

    private void initializeDefaultValues() {
    }

    private String[] determineRessourceStringValues(WorkItem workItem) {
        String stakeholderName = null;
        IStakeholder stakeholder = this.model.getStakeholderForWorkItem(workItem);
        if (stakeholder != null) {
            stakeholderName = stakeholder.getStakeholderName();
        }
        String ressourceName = null;
        if (workItem.getResources().getValue() != null && workItem.getResources().getValue().length() > 0) {
            ressourceName = workItem.getResources().getDisplayStringRepresentation();
        }
        String[] resourceStrings = null;
        resourceStrings = stakeholderName != null && ressourceName != null ? new String[]{stakeholderName, ressourceName} : (stakeholderName != null ? new String[]{stakeholderName} : (ressourceName != null ? new String[]{ressourceName} : new String[]{workItem.getResources().getDisplayStringRepresentation()}));
        return resourceStrings;
    }

    private class ProjectPlanFilterItem
    extends ModuleDataTableListFilterItem {
        public ProjectPlanFilterItem(IModelController modelController, AbstractTextValuesFilter filter) {
            super(FilterHelper.getFilterName((String)ProjectPlan.MODULE_DATA_NAME, (String)ProjectPlan.NAME_NAME), "ppm2.projectplan", modelController, filter);
        }

        public ProjectPlanFilterItem(IModuleProjectSwitchListenerManager projectSwitchListenerManager, AbstractTextValuesFilter filter) {
            super(FilterHelper.getFilterName((String)ProjectPlan.MODULE_DATA_NAME, (String)ProjectPlan.NAME_NAME), "ppm2.projectplan", projectSwitchListenerManager, (IModelControllerProvider)ProjectPlanningModule2Plugin.getDefault().getProjectManager(), filter);
        }

        protected String[] extractStringAttributes(IModuleData data) {
            return new String[]{((ProjectPlan)data).getDisplayRepresentation()};
        }
    }

    private class ResourceFilterItem
    extends ModuleDataTableListFilterItem {
        public ResourceFilterItem(IModelController modelController, AbstractTextValuesFilter filter) {
            super(FilterHelper.getFilterName((String)WorkItem.MODULE_DATA_NAME, (String)WorkItem.NAME_RESOURCES), "ppm2.workitem", modelController, filter);
        }

        public ResourceFilterItem(IModuleProjectSwitchListenerManager projectSwitchListenerManager, AbstractTextValuesFilter filter) {
            super(FilterHelper.getFilterName((String)WorkItem.MODULE_DATA_NAME, (String)WorkItem.NAME_RESOURCES), "ppm2.workitem", projectSwitchListenerManager, (IModelControllerProvider)ProjectPlanningModule2Plugin.getDefault().getProjectManager(), filter);
        }

        protected String[] extractStringAttributes(IModuleData data) {
            String[] resourceStrings = ProjectPlanningFilters.this.determineRessourceStringValues((WorkItem)data);
            return resourceStrings;
        }
    }
}

