/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.gui;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholder;
import com.arcway.cockpit.modulelib2.client.gui.ImageDescriptorRegistry;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.IModuleFixColumnProvider;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDuration;
import com.arcway.cockpit.projectplanningmodule2.client.ProjectPlanningModule2Plugin;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.gui.preferences.PreferenceManager;
import com.arcway.cockpit.projectplanningmodule2.client.messages.ProjectPlan;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItem;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItemCategory;
import com.arcway.lib.java.collections.CollectionUtils;
import java.util.Collection;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class DataViewLabelProvider
implements IModuleFixColumnProvider {
    private final ImageDescriptorRegistry imageDescriptorRegistry = ProjectPlanningModule2Plugin.getDefault().getImageDescriptorRegistry();
    private final ImageDescriptor unsynchronizedPlanImageDescriptor = ProjectPlanningModule2Plugin.getImageDescriptor("Project.gif");
    private final ImageDescriptor synchronizesPlanImageDescriptor = ProjectPlanningModule2Plugin.getImageDescriptor("Project_synchronized.gif");
    private final ImageDescriptor unlinkedWorkItemImageDescriptor = ProjectPlanningModule2Plugin.getImageDescriptor("BrokenLink.gif");

    public Image getColumnImage(IModuleData element, String columnID) {
        ModelController modelController = (ModelController)ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(element.getProjectUID());
        if (columnID.equals("name")) {
            if (element instanceof ProjectPlan) {
                ProjectPlan plan = (ProjectPlan)element;
                ImageDescriptor descriptor = modelController.isSynchronized(plan) ? this.synchronizesPlanImageDescriptor : this.unsynchronizedPlanImageDescriptor;
                return this.imageDescriptorRegistry.get(descriptor);
            }
            if (element instanceof Task) {
                Task task = (Task)element;
                return task.getStatusDependentIcon().getImage();
            }
            if (element instanceof WorkItem) {
                WorkItem workItem = (WorkItem)element;
                return workItem.getStatusDependentIcon().getImage();
            }
        } else if (columnID.equals("image") && element instanceof WorkItem) {
            WorkItem workItem = (WorkItem)element;
            if (modelController.getLinksForModuleDataItem((IModuleData)workItem, "WorkItemUniqueElement").isEmpty()) {
                return this.imageDescriptorRegistry.get(this.unlinkedWorkItemImageDescriptor);
            }
            return null;
        }
        return null;
    }

    public String getColumnText(IModuleData element, String columnID) {
        if (element instanceof ProjectPlan) {
            return this.getColumnText((ProjectPlan)element, columnID);
        }
        if (element instanceof Task) {
            return this.getColumnText((Task)element, columnID);
        }
        if (element instanceof WorkItem) {
            return this.getColumnText((WorkItem)element, columnID);
        }
        return null;
    }

    private String getColumnText(ProjectPlan project, String columnID) {
        if (columnID.equals("name")) {
            return project.getName().getDisplayStringRepresentation();
        }
        if (columnID.equals("work_topdown")) {
            ModuleDataAttributeDuration originalWork = project.getOriginalWork();
            return originalWork.getDisplayRepresentationWithUnit();
        }
        if (columnID.equals("work_estimated")) {
            ModuleDataAttributeDuration workEstimated = project.getWorkEstimated();
            return workEstimated.getDisplayRepresentationWithUnit();
        }
        if (columnID.equals("work_done")) {
            ModuleDataAttributeDuration workDone = project.getWorkDone();
            return String.valueOf(workDone.getDisplayRepresentationWithUnit()) + " (" + project.calculateWorkComplete() + "%)";
        }
        if (columnID.equals("work_done_absolute")) {
            ModuleDataAttributeDuration workDone = project.getWorkDone();
            return workDone.getDisplayRepresentationWithUnit();
        }
        if (columnID.equals("work_done_relative")) {
            return String.valueOf(project.calculateWorkComplete()) + "%";
        }
        if (columnID.equals("work_remaining")) {
            ModuleDataAttributeDuration workRemaining = project.getWorkRemaining();
            return workRemaining.getDisplayRepresentationWithUnit();
        }
        if (columnID.equals("work forecast")) {
            ModuleDataAttributeDuration workForecast = project.calculateWorkForecast();
            return workForecast.getDisplayRepresentationWithUnit();
        }
        if (columnID.equals("start")) {
            return project.getStart().getDisplayStringRepresentation();
        }
        if (columnID.equals("end")) {
            return project.getFinish().getDisplayStringRepresentation();
        }
        if (columnID.equals("duration")) {
            return project.calculateDuration().getDisplayRepresentationWithUnit();
        }
        return "";
    }

    private String getColumnText(Task task, String columnID) {
        if (columnID.equals("name")) {
            return task.getDisplayRepresentation();
        }
        if (columnID.equals("image")) {
            return "";
        }
        if (columnID.equals("start")) {
            return task.getStart().getDisplayStringRepresentation();
        }
        if (columnID.equals("ressources")) {
            return task.getResourceNameDisplayRepresentation();
        }
        if (!task.isMilestone().getValue()) {
            if (columnID.equals("work_topdown")) {
                ModuleDataAttributeDuration originalWork = task.getOriginalWork();
                return originalWork.getDisplayRepresentationWithUnit();
            }
            if (columnID.equals("work_estimated")) {
                ModuleDataAttributeDuration workEstimated = task.getWorkEstimated();
                return workEstimated.getDisplayRepresentationWithUnit();
            }
            if (columnID.equals("work_done")) {
                ModuleDataAttributeDuration workDone = task.getWorkDone();
                return String.valueOf(workDone.getDisplayRepresentationWithUnit()) + " (" + task.calculatePercentWorkComplete() + "%)";
            }
            if (columnID.equals("work forecast")) {
                ModuleDataAttributeDuration workForecast = task.calculateWorkForecast();
                return workForecast.getDisplayRepresentationWithUnit();
            }
            if (columnID.equals("work_done_absolute")) {
                ModuleDataAttributeDuration workDone = task.getWorkDone();
                return workDone.getDisplayRepresentationWithUnit();
            }
            if (columnID.equals("work_done_relative")) {
                return String.valueOf(task.calculatePercentWorkComplete()) + "%";
            }
            if (columnID.equals("work_remaining")) {
                ModuleDataAttributeDuration workRemaining = task.getWorkRemaining();
                return workRemaining.getDisplayRepresentationWithUnit();
            }
            if (columnID.equals("state")) {
                return task.getState().getDisplayStringRepresentation();
            }
            if (columnID.equals("critical")) {
                return task.isCritical().getDisplayStringRepresentation();
            }
            if (columnID.equals("end")) {
                return task.getFinish().getDisplayStringRepresentation();
            }
            if (columnID.equals("duration")) {
                return task.calculateDuration().getDisplayRepresentationWithUnit();
            }
            if (columnID.equals("priority")) {
                return task.getPriority().getDisplayStringRepresentation();
            }
            return "";
        }
        return "";
    }

    private String getColumnText(WorkItem workItem, String columnID) {
        ModelController modelController = (ModelController)ProjectPlanningModule2Plugin.getDefault().getProjectManager().getModelController(workItem.getProjectUID());
        int workUnit = 0;
        int prefUnit = PreferenceManager.getBottomUpWorkUnit();
        switch (prefUnit) {
            case 3: {
                workUnit = 3;
                break;
            }
            case 1: {
                workUnit = 1;
                break;
            }
            default: {
                workUnit = 3;
            }
        }
        if (columnID.equals("name")) {
            return workItem.getName().getDisplayStringRepresentation();
        }
        if (columnID.equals("image")) {
            return "";
        }
        if (columnID.equals("work_estimated")) {
            ModuleDataAttributeDuration workEstimated = workItem.getWorkEstimated();
            workEstimated.setUnit(workUnit);
            return workEstimated.getDisplayRepresentationWithUnit();
        }
        if (columnID.equals("work_done")) {
            ModuleDataAttributeDuration workDone = workItem.getWorkDone();
            workDone.setUnit(workUnit);
            return String.valueOf(workDone.getDisplayRepresentationWithUnit()) + " (" + workItem.calculatePercentWorkComplete().getValue() + "%)";
        }
        if (columnID.equals("work forecast")) {
            ModuleDataAttributeDuration workForecast = workItem.calculateForecast();
            workForecast.setUnit(workUnit);
            return workForecast.getDisplayRepresentationWithUnit();
        }
        if (columnID.equals("work_done_absolute")) {
            ModuleDataAttributeDuration workDone = workItem.getWorkDone();
            workDone.setUnit(workUnit);
            return workDone.getDisplayRepresentationWithUnit();
        }
        if (columnID.equals("work_done_relative")) {
            return String.valueOf(workItem.calculatePercentWorkComplete().getValue()) + "%";
        }
        if (columnID.equals("work_remaining")) {
            ModuleDataAttributeDuration workRemaining = workItem.getWorkRemaining();
            workRemaining.setUnit(workUnit);
            return workRemaining.getDisplayRepresentationWithUnit();
        }
        if (columnID.equals("ressources")) {
            Collection stakeHolders = modelController.getLinkableObjects((IModuleData)workItem, "WorkItemStakeholder");
            String stakeholderName = null;
            if (!stakeHolders.isEmpty()) {
                String displayString = "";
                for (IStakeholder stakeholder : stakeHolders) {
                    displayString = String.valueOf(displayString) + stakeholder.getStakeholderName() + ", ";
                }
                if (displayString.length() > 0) {
                    displayString = displayString.substring(0, displayString.length() - 2);
                }
                stakeholderName = displayString;
            }
            String resourceName = null;
            if (workItem.getResources().getValue() != null && workItem.getResources().getValue().length() > 0) {
                resourceName = workItem.getResources().getDisplayStringRepresentation();
            }
            if (stakeholderName != null && resourceName != null) {
                return String.valueOf(stakeholderName) + " / " + resourceName;
            }
            if (stakeholderName != null) {
                return stakeholderName;
            }
            if (resourceName != null) {
                return resourceName;
            }
            return "-";
        }
        if (columnID.equals("start")) {
            return "";
        }
        if (columnID.equals("wi_category")) {
            Collection wiCategoryCollection = CollectionUtils.getTypedCollection((Collection)modelController.getLinkableObjects((IModuleData)workItem, "WorkItemCategory"), WorkItemCategory.class);
            if (!wiCategoryCollection.isEmpty()) {
                WorkItemCategory category = (WorkItemCategory)((Object)wiCategoryCollection.iterator().next());
                return category.getCategory().getDisplayStringRepresentation();
            }
            return "";
        }
        return "";
    }
}

