/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.core.project;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholder;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDuration;
import com.arcway.cockpit.projectplanningmodule2.client.Messages;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.DataMgr;
import com.arcway.cockpit.projectplanningmodule2.client.messages.ProjectPlan;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItem;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class RessourceWorkCumulator {
    private final Map<String, RessourceWork> ressourceWorks = new HashMap<String, RessourceWork>();

    public RessourceWorkCumulator(DataMgr dataManager, ProjectPlan projectPlan) {
        assert (dataManager != null) : "dataManager is missing";
        assert (projectPlan != null) : "projectPlan is missing";
        for (Task task : dataManager.getChildren((IModuleData)projectPlan, "ppm2.task")) {
            this.loadWorkOfTask(dataManager, task);
        }
    }

    public RessourceWorkCumulator(DataMgr dataManager, Task task) {
        this.loadWorkOfTask(dataManager, task);
    }

    private void loadWorkOfTask(DataMgr dataManager, Task task) {
        assert (dataManager != null) : "dataManager is missing";
        assert (task != null) : "task is missing";
        Collection workItems = dataManager.getWorkItemChildren(task);
        if (workItems.size() > 0) {
            this.analyzeWorkItems(dataManager, task, workItems);
        } else {
            String ressourceNames;
            Collection subtasks = dataManager.getTaskChildren(task);
            if (subtasks.size() > 0) {
                for (Task subtask : subtasks) {
                    this.loadWorkOfTask(dataManager, subtask);
                }
            } else if (task.hasExternalRepresentation() && (ressourceNames = task.getResourceNames().getDisplayStringRepresentation()) != null && ressourceNames.length() > 0) {
                ModuleDataAttributeDuration work = task.getOriginalWork();
                ModuleDataAttributeDuration workDone = new ModuleDataAttributeDuration(work.getValue() * (long)task.getOriginalPercentWorkComplete().getValue() / 100L);
                this.addResourceWork(ressourceNames, work, workDone);
            }
        }
    }

    private void analyzeWorkItems(DataMgr dataManager, Task task, Collection workItems) {
        for (WorkItem workItem : workItems) {
            String resourceName;
            Collection resources = dataManager.getLinkableObjects((IModuleData)workItem, "WorkItemStakeholder");
            String stakeholderName = null;
            if (resources.size() > 0) {
                IStakeholder stakeholder = (IStakeholder)resources.iterator().next();
                stakeholderName = stakeholder.getStakeholderName();
            }
            if ((resourceName = workItem.getResources().getValue()) != null && resourceName.length() > 0) {
                if (stakeholderName != null && stakeholderName.length() > 0) {
                    stakeholderName = String.valueOf(stakeholderName) + " / ";
                    stakeholderName = String.valueOf(stakeholderName) + resourceName;
                } else {
                    stakeholderName = resourceName;
                }
            }
            if (stakeholderName != null && stakeholderName.length() > 0) {
                this.addResourceWork(stakeholderName, workItem.calculateForecast(), workItem.getWorkDone());
                continue;
            }
            Locale locale = dataManager.getProjectLanguage();
            resourceName = Messages.getString("RessourceWorkCumulator.0", locale);
            this.addResourceWork(resourceName, workItem.calculateForecast(), workItem.getWorkDone());
        }
    }

    public Set<String> getResourceNames() {
        return this.ressourceWorks.keySet();
    }

    public boolean containsRessource(String resourceName) {
        return this.ressourceWorks.containsKey(resourceName);
    }

    public ModuleDataAttributeDuration getWorkForecast(String resourceName) {
        RessourceWork work = this.ressourceWorks.get(resourceName);
        if (work != null) {
            return work.workForecast;
        }
        return new ModuleDataAttributeDuration(0L);
    }

    public ModuleDataAttributeDuration getWorkDone(String resourceName) {
        RessourceWork work = this.ressourceWorks.get(resourceName);
        if (work != null) {
            return work.workDone;
        }
        return new ModuleDataAttributeDuration(0L);
    }

    private void addResourceWork(String resourceName, ModuleDataAttributeDuration work, ModuleDataAttributeDuration workDone) {
        if (this.ressourceWorks.containsKey(resourceName)) {
            RessourceWork resourceWork = this.ressourceWorks.get(resourceName);
            resourceWork.addWork(work, workDone);
        } else {
            RessourceWork resourceWork = new RessourceWork(resourceName, work, workDone);
            this.ressourceWorks.put(resourceName, resourceWork);
        }
    }

    private class RessourceWork {
        String ressourceName;
        ModuleDataAttributeDuration workForecast = new ModuleDataAttributeDuration(0L);
        ModuleDataAttributeDuration workDone = new ModuleDataAttributeDuration(0L);

        RessourceWork(String name, ModuleDataAttributeDuration aWork, ModuleDataAttributeDuration aWorkDone) {
            this.ressourceName = name;
            this.addWork(aWork, aWorkDone);
        }

        private void addWork(ModuleDataAttributeDuration aWorkForecast, ModuleDataAttributeDuration aWorkDone) {
            this.workForecast.setValue(this.workForecast.getValue() + aWorkForecast.getValue());
            this.workDone.setValue(this.workDone.getValue() + aWorkDone.getValue());
        }
    }
}

