/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.core.project;

import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.frame.client.project.modules.IUniqueElementProjectionRequest;
import com.arcway.cockpit.frame.client.project.modules.ProjectionIdentifier;
import com.arcway.cockpit.frame.client.project.modules.UniqueElementProjectionRequest;
import com.arcway.cockpit.frame.client.project.planeditors.projections.IProjectionReceiver;
import com.arcway.cockpit.modulelib2.client.core.project.IModel;
import com.arcway.cockpit.modulelib2.client.core.project.LinkMgr;
import com.arcway.cockpit.modulelib2.client.core.project.ProjectionMgr;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDuration;
import com.arcway.cockpit.projectplanningmodule2.client.ModuleIdentification;
import com.arcway.cockpit.projectplanningmodule2.client.ProjectPlanningModule2Plugin;
import com.arcway.cockpit.projectplanningmodule2.client.gui.DataView;
import com.arcway.cockpit.projectplanningmodule2.client.gui.projection.IPPMProjectionConstants;
import com.arcway.cockpit.projectplanningmodule2.client.gui.projection.WorkProgressProjectionFactory;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItem;
import com.arcway.planagent.controllinginterface.lib.projections.WarningSignProjection;
import com.arcway.planagent.controllinginterface.planviewer.IProjection;
import de.plans.lib.util.valueranges.ValueRangeHelperDuration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class ProjectionManager
extends ProjectionMgr {
    private int percentWorkComplete;
    private int work;
    private int workComplete;
    private int workEstimated;

    public void construct(IModuleProjectAgent project, IModel mdl, LinkMgr linkMgr) {
        super.construct(project, mdl, linkMgr);
        ProjectPlanningModule2Plugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected final void closeProject_() {
        ProjectPlanningModule2Plugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    protected Collection<ProjectionIdentifier> getAvailableProjections() {
        return Arrays.asList(new ProjectionIdentifier("ppm2.projections.progress"), new ProjectionIdentifier("ppm2.projections.latetasks"), new ProjectionIdentifier("ppm2.projections.criticaltasks"));
    }

    protected Collection<Class<?>> getDatatypesWhichTriggerUpdate() {
        return Arrays.asList(WorkItem.class, Task.class);
    }

    protected Collection<String> getLinktypesWhichTriggerUpdate() {
        return Arrays.asList("WorkItemUniqueElement");
    }

    protected Set<String> getPreferences() {
        return IPPMProjectionConstants.PREFERENCES;
    }

    protected ProjectionIdentifier getProjectionIdentifierForHighlighting() {
        return new ProjectionIdentifier(String.valueOf(ModuleIdentification.getModuleID()) + ".projection.highlight");
    }

    protected void doProject(ProjectionIdentifier projectionID, IProjectionReceiver projectionReceiver, IWorkbenchPage page) {
        Collection uniqueElementsOfPlan = this.projectAgent.getModuleUniqueElementManager().getUniqueElementsOfPlan(projectionReceiver.getPlanUID());
        List<IUniqueElementProjectionRequest> requests = null;
        if (projectionID.getProjectionID().equals("ppm2.projections.progress")) {
            requests = this.getRequestList_progress(uniqueElementsOfPlan);
        } else if (projectionID.getProjectionID().equals("ppm2.projections.latetasks")) {
            requests = this.getRequestList_LateTasks(uniqueElementsOfPlan, projectionReceiver.getPlanUID());
        } else if (projectionID.getProjectionID().equals("ppm2.projections.criticaltasks")) {
            requests = this.getRequestList_CriticalTasks(uniqueElementsOfPlan, projectionReceiver.getPlanUID());
        }
        if (requests != null) {
            projectionReceiver.project(Collections.EMPTY_LIST, requests);
        }
    }

    protected void doStopProjection(IProjectionReceiver projectionReceiver, IWorkbenchPage page) {
    }

    private List<IUniqueElementProjectionRequest> getRequestList_CriticalTasks(Collection<IUniqueElement> uniqueElements, String planUid) {
        ArrayList<IUniqueElementProjectionRequest> requests = new ArrayList<IUniqueElementProjectionRequest>();
        for (IUniqueElement ue : uniqueElements) {
            if (!this.hasCriticalTaskWorkItems(ue, planUid)) continue;
            WarningSignProjection factory = new WarningSignProjection();
            UniqueElementProjectionRequest request = new UniqueElementProjectionRequest(ue.getUID(), (IProjection)factory);
            requests.add((IUniqueElementProjectionRequest)request);
        }
        return requests;
    }

    private List<IUniqueElementProjectionRequest> getRequestList_LateTasks(Collection<IUniqueElement> uniqueElements, String planUid) {
        ArrayList<IUniqueElementProjectionRequest> requests = new ArrayList<IUniqueElementProjectionRequest>();
        for (IUniqueElement ue : uniqueElements) {
            if (!this.hasLateTaskWorkItems(ue, planUid)) continue;
            WarningSignProjection factory = new WarningSignProjection();
            UniqueElementProjectionRequest request = new UniqueElementProjectionRequest(ue.getUID(), (IProjection)factory);
            requests.add((IUniqueElementProjectionRequest)request);
        }
        return requests;
    }

    private List<IUniqueElementProjectionRequest> getRequestList_progress(Collection<IUniqueElement> uniqueElements) {
        ArrayList<IUniqueElementProjectionRequest> requests = new ArrayList<IUniqueElementProjectionRequest>();
        for (IUniqueElement ue : uniqueElements) {
            this.setElementWorkValues(ue);
            if (this.work <= 0 && this.workComplete <= 0 && this.workEstimated <= 0) continue;
            IProjection factory = WorkProgressProjectionFactory.createProjection(this.work, this.workComplete, this.workEstimated, this.percentWorkComplete);
            UniqueElementProjectionRequest request = new UniqueElementProjectionRequest(ue.getUID(), factory);
            requests.add((IUniqueElementProjectionRequest)request);
        }
        return requests;
    }

    private boolean hasCriticalTaskWorkItems(IUniqueElement ue, String planUid) {
        IViewPart dataView;
        Collection uniqueElementSubtree = this.projectAgent.getModuleUniqueElementManager().getContainedUniqueElements(ue.getUID());
        uniqueElementSubtree.add(ue);
        Set linkedWorkItems = new HashSet();
        for (IUniqueElement uniqueElement : uniqueElementSubtree) {
            if (uniqueElement != ue && this.projectAgent.isAssignedToElementOnPlan(uniqueElement.getUID(), planUid)) continue;
            linkedWorkItems.addAll(this.linkManager.getModuleData(uniqueElement.getUID(), "WorkItemUniqueElement"));
        }
        IPreferenceStore store = ProjectPlanningModule2Plugin.getDefault().getPreferenceStore();
        if (store.getBoolean("ppm2.projections.preference.applydataviewfilter") && (dataView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("com.arcway.cockpit.projectplanningmodule2.client.gui.dataview")) != null) {
            linkedWorkItems = ((DataView)dataView).applyFilters(linkedWorkItems);
        }
        for (WorkItem workItem : linkedWorkItems) {
            Task parentTask = (Task)this.model.getParent((IModuleData)workItem);
            if (parentTask == null || !parentTask.isCritical().getValue()) continue;
            return true;
        }
        return false;
    }

    private boolean hasLateTaskWorkItems(IUniqueElement ue, String planUid) {
        IViewPart dataView;
        Collection uniqueElementSubtree = this.projectAgent.getModuleUniqueElementManager().getContainedUniqueElements(ue.getUID());
        uniqueElementSubtree.add(ue);
        Set linkedWorkItems = new HashSet();
        for (IUniqueElement uniqueElement : uniqueElementSubtree) {
            if (uniqueElement != ue && this.projectAgent.isAssignedToElementOnPlan(uniqueElement.getUID(), planUid)) continue;
            linkedWorkItems.addAll(this.linkManager.getModuleData(uniqueElement.getUID(), "WorkItemUniqueElement"));
        }
        IPreferenceStore store = ProjectPlanningModule2Plugin.getDefault().getPreferenceStore();
        if (store.getBoolean("ppm2.projections.preference.applydataviewfilter") && (dataView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("com.arcway.cockpit.projectplanningmodule2.client.gui.dataview")) != null) {
            linkedWorkItems = ((DataView)dataView).applyFilters(linkedWorkItems);
        }
        for (WorkItem workItem : linkedWorkItems) {
            Task parentTask = (Task)this.model.getParent((IModuleData)workItem);
            if (parentTask == null || !parentTask.isLate()) continue;
            return true;
        }
        return false;
    }

    private void setElementWorkValues(IUniqueElement ue) {
        IViewPart dataView;
        Collection uniqueElementSubtree = this.projectAgent.getModuleUniqueElementManager().getContainedUniqueElements(ue.getUID());
        uniqueElementSubtree.add(ue);
        Set linkedWorkItems = new HashSet();
        for (IUniqueElement uniqueElement : uniqueElementSubtree) {
            linkedWorkItems.addAll(this.linkManager.getModuleData(uniqueElement.getUID(), "WorkItemUniqueElement"));
        }
        IPreferenceStore store = ProjectPlanningModule2Plugin.getDefault().getPreferenceStore();
        if (store.getBoolean("ppm2.projections.preference.applydataviewfilter") && (dataView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("com.arcway.cockpit.projectplanningmodule2.client.gui.dataview")) != null) {
            linkedWorkItems = ((DataView)dataView).applyFilters(linkedWorkItems);
        }
        ModuleDataAttributeDuration workEst = new ModuleDataAttributeDuration();
        workEst.setUnit(1);
        ModuleDataAttributeDuration workDone = new ModuleDataAttributeDuration();
        workDone.setUnit(1);
        ModuleDataAttributeDuration workForecast = new ModuleDataAttributeDuration();
        workForecast.setUnit(1);
        for (WorkItem workItem : linkedWorkItems) {
            workEst = workEst.addDuration(workItem.getWorkEstimated());
            workDone = workDone.addDuration(workItem.getWorkDone());
            workForecast = workForecast.addDuration(workItem.calculateForecast());
        }
        ValueRangeHelperDuration vrd = (ValueRangeHelperDuration)workEst.getValueRangeHelper();
        this.workEstimated = (int)vrd.getDurationInSpecificUnit(1);
        vrd = (ValueRangeHelperDuration)workForecast.getValueRangeHelper();
        this.work = (int)vrd.getDurationInSpecificUnit(1);
        vrd = (ValueRangeHelperDuration)workDone.getValueRangeHelper();
        this.workComplete = (int)vrd.getDurationInSpecificUnit(1);
        this.percentWorkComplete = this.work == 0 ? 0 : this.workComplete * 100 / this.work;
    }
}

