/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.core.project;

import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IParentOperandTree;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.AbstractPermissionMgr;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.projectplanningmodule2.client.core.permissions.ModulePermissionConstants;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.DataMgr;
import com.arcway.cockpit.projectplanningmodule2.client.messages.ProjectPlan;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItem;
import java.util.Collection;
import java.util.Iterator;

public class PermissionMgr
extends AbstractPermissionMgr {
    public boolean mayEditWorkItem(WorkItem workItem, IModuleData parent) {
        if (parent != null) {
            return this.mayEditWorkItemsOfTask((Task)parent);
        }
        return this.mayEditUnassignedWorkItems();
    }

    public boolean mayEditUnassignedWorkItems() {
        return this.getProjectAgent().hasPermission("ppm2.editUnassignedWorkItems", ModulePermissionConstants.UNASSIGNED_WORK_ITEMS_ROOT_NODE) || this.getProjectAgent().hasPermission("ppm2.editUnassignedWorkItems", ModulePermissionConstants.ROOT_NODE);
    }

    public boolean mayEditWorkItemsOfTask(Task parentTask) {
        return this.internal_mayEditWorkItemsOfProjectPlanOrTask((IModuleData)parentTask);
    }

    public boolean mayCreateProjectPlans() {
        return this.getProjectAgent().hasPermission("ppm2.createProjectPlan", ModulePermissionConstants.ROOT_NODE);
    }

    public boolean mayEditProjectPlan(ProjectPlan projectPlan) {
        return this.internal_mayEditProjectPlanOrTask((IModuleData)projectPlan);
    }

    public boolean mayDeleteProjectPlan(ProjectPlan projectPlan) {
        return this.internal_mayEditProjectPlanOrTask((IModuleData)projectPlan) && this.internal_isDeletionOfContainedWorkItemsPossible((IModuleData)projectPlan, true);
    }

    public boolean mayEditTask(Task task) {
        return this.internal_mayEditProjectPlanOrTask((IModuleData)task);
    }

    public boolean mayDeleteTask(Task task) {
        return this.internal_mayEditProjectPlanOrTask((IModuleData)task) && this.internal_isDeletionOfContainedWorkItemsPossible((IModuleData)task, true);
    }

    public boolean mayDeleteItem(IModuleData moduleData) {
        if (moduleData instanceof ProjectPlan) {
            return this.mayDeleteProjectPlan((ProjectPlan)moduleData);
        }
        if (moduleData instanceof Task) {
            return this.mayDeleteTask((Task)moduleData);
        }
        if (moduleData instanceof WorkItem) {
            IModuleData parent = this.getDataMgr().getParent(moduleData);
            return this.mayEditWorkItem((WorkItem)moduleData, parent);
        }
        return false;
    }

    public boolean mayDeleteItems(Collection items) {
        assert (items != null);
        for (Object item : items) {
            if (!(item instanceof IModuleData) || this.mayDeleteItem((IModuleData)item)) continue;
            return false;
        }
        return true;
    }

    public boolean mayLinkItemToPlanElement(String linkableItemTypeID, IModuleData permissionOperand) {
        return linkableItemTypeID.equals("ppm2.workitem");
    }

    private boolean internal_mayEditProjectPlanOrTask(IModuleData projectPlanOrTask) {
        if (this.getProjectAgent().hasPermission("ppm2.editProjectPlanOrTask", (IPermissionOperand)projectPlanOrTask)) {
            return true;
        }
        if (this.getProjectAgent().hasPermission("ppm2.editProjectPlanOrTask", ModulePermissionConstants.ROOT_NODE)) {
            return true;
        }
        IModuleData parent = this.getDataMgr().getParent(projectPlanOrTask);
        while (parent != null) {
            if (this.getProjectAgent().hasPermission("ppm2.editProjectPlanOrTask", (IPermissionOperand)parent)) {
                return true;
            }
            parent = this.getDataMgr().getParent(parent);
        }
        return false;
    }

    private boolean internal_mayEditWorkItemsOfProjectPlanOrTask(IModuleData projectPlanOrTask) {
        if (this.getProjectAgent().hasPermission("ppm2.editContainedWorkItems", (IPermissionOperand)projectPlanOrTask)) {
            return true;
        }
        IModuleData parent = this.getDataMgr().getParent(projectPlanOrTask);
        if (parent != null) {
            return this.internal_mayEditWorkItemsOfProjectPlanOrTask(parent);
        }
        return this.getProjectAgent().hasPermission("ppm2.editContainedWorkItems", ModulePermissionConstants.ROOT_NODE);
    }

    private boolean internal_isDeletionOfContainedWorkItemsPossible(IModuleData projectPlanOrTask, boolean firstCall) {
        if (firstCall && this.internal_mayEditWorkItemsOfProjectPlanOrTask(projectPlanOrTask) || !firstCall && this.getProjectAgent().hasPermission("ppm2.editContainedWorkItems", (IPermissionOperand)projectPlanOrTask)) {
            return true;
        }
        if (projectPlanOrTask instanceof Task && ((DataMgr)this.getDataMgr()).containsWorkItems((Task)projectPlanOrTask)) {
            return false;
        }
        Iterator childTasks = projectPlanOrTask instanceof ProjectPlan ? ((DataMgr)this.getDataMgr()).getChildren(projectPlanOrTask).iterator() : ((DataMgr)this.getDataMgr()).getTaskChildren((Task)projectPlanOrTask).iterator();
        while (childTasks.hasNext()) {
            if (this.internal_isDeletionOfContainedWorkItemsPossible((IModuleData)((Task)((Object)childTasks.next())), false)) continue;
            return false;
        }
        return true;
    }

    public boolean mayEditItemStructurally(IModuleData moduleData, IModuleData parent) {
        return moduleData instanceof ProjectPlan && this.mayEditProjectPlan((ProjectPlan)moduleData) || moduleData instanceof Task && this.mayEditTask((Task)moduleData) || moduleData instanceof WorkItem && this.mayEditWorkItem((WorkItem)moduleData, parent);
    }

    public IParentOperandTree getParentOperandTree(IModuleData moduleData, IModuleData parent) {
        if (parent == null && moduleData instanceof WorkItem) {
            return ModulePermissionConstants.UNASSIGNED_WORK_ITEMS_PARENT_TREE;
        }
        return super.getParentOperandTree(moduleData, parent);
    }

    public boolean mayCreateChildren(IModuleData parent, String childDataType) {
        if (parent == null && childDataType.equals("ppm2.projectplan")) {
            return this.mayCreateProjectPlans();
        }
        if (parent == null && childDataType.equals("ppm2.workitem")) {
            return this.mayEditUnassignedWorkItems();
        }
        if (parent instanceof ProjectPlan && childDataType.equals("ppm2.task")) {
            return this.mayEditProjectPlan((ProjectPlan)parent);
        }
        if (parent instanceof Task && childDataType.equals("ppm2.workitem")) {
            return this.mayEditWorkItemsOfTask((Task)parent);
        }
        return false;
    }
}

