/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.core.project;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholder;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.modulelib2.client.core.IClientDataFactory;
import com.arcway.cockpit.modulelib2.client.core.project.IModel;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractDataFacade;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractImExModuleData;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.projectplanningmodule2.client.core.imexportdata.ImExProjectPlan;
import com.arcway.cockpit.projectplanningmodule2.client.core.imexportdata.ImExTask;
import com.arcway.cockpit.projectplanningmodule2.client.core.imexportdata.ImExWorkItem;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.DataMgr;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.RessourceWorkCumulator;
import com.arcway.cockpit.projectplanningmodule2.client.gui.ProjectPlanningFilters;
import com.arcway.cockpit.projectplanningmodule2.client.messages.ProjectPlan;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class ModuleDataFacade
extends AbstractDataFacade {
    private ModelController concreteModelController;
    private DataMgr concreteDataManager;

    public void construct(IModel model, IModelController modelController, IClientDataFactory clientDataFactory) {
        super.construct(model, modelController, clientDataFactory);
        this.concreteModelController = (ModelController)modelController;
        this.concreteDataManager = (DataMgr)model;
    }

    public List getProjectPlans(Collection filters, Locale locale) {
        ArrayList projectPlans = new ArrayList(this.concreteModelController.getAllProjectPlans());
        this.sortByNaturalOrder(projectPlans);
        projectPlans = new ArrayList(ModuleDataFacade.filter(projectPlans, (Collection)filters));
        ArrayList<ImExProjectPlan> imEx = new ArrayList<ImExProjectPlan>();
        for (ProjectPlan plan : projectPlans) {
            imEx.add(new ImExProjectPlan(plan, this, this.concreteDataManager.getModelController(), filters, locale));
        }
        return imEx;
    }

    public ImExProjectPlan getProjectPlanForTask(Task task, Collection filters, Locale locale) {
        ProjectPlan plan = this.concreteModelController.getProjectPlanForTask(task);
        return new ImExProjectPlan(plan, this, this.concreteDataManager.getModelController(), filters, locale);
    }

    public List getRootTasksOfProjectPlan(ProjectPlan projectPlan, Collection filters, Locale locale) {
        ArrayList rootTasks = new ArrayList(this.concreteModelController.getChildren((IModuleData)projectPlan, "ppm2.task"));
        this.sortByNaturalOrder(rootTasks);
        rootTasks = new ArrayList(ModuleDataFacade.filter(rootTasks, (Collection)filters));
        ArrayList<ImExTask> tasks = new ArrayList<ImExTask>();
        for (Task task : rootTasks) {
            ImExTask rootTask = new ImExTask(task, null, this, this.concreteDataManager.getModelController(), filters, locale);
            rootTask.setChildTasks(this.getTaskChildren(task, rootTask, filters, locale));
            tasks.add(rootTask);
        }
        return tasks;
    }

    public List getWorkItemsForTask1(Task task, Collection filters, Locale locale) {
        ArrayList original = new ArrayList(ModuleDataFacade.filter(this.concreteModelController.getWorkItemChildren(task), (Collection)filters));
        this.sortByNaturalOrder(original);
        ArrayList<ImExWorkItem> workItems = new ArrayList<ImExWorkItem>();
        for (WorkItem wi : original) {
            workItems.add(new ImExWorkItem(wi, this, this.concreteDataManager.getModelController(), locale));
        }
        return workItems;
    }

    public Collection getWorkItemsForUE1(String uniqueElementUID, Collection filters, Locale locale) {
        Collection original = ModuleDataFacade.filter((Collection)this.concreteModelController.getModuleData(uniqueElementUID, "WorkItemUniqueElement"), (Collection)filters);
        ArrayList<ImExWorkItem> workItems = new ArrayList<ImExWorkItem>();
        for (WorkItem wi : original) {
            workItems.add(new ImExWorkItem(wi, this, this.concreteDataManager.getModelController(), locale));
        }
        return workItems;
    }

    public Collection getWorkItemsForStakeholder(String stakeholdername, Collection filters, Locale locale) {
        Collection original = ModuleDataFacade.filter((Collection)this.modelController.getAllItems("ppm2.workitem"), (Collection)filters);
        ArrayList<ImExWorkItem> workItems = new ArrayList<ImExWorkItem>();
        for (WorkItem wi : original) {
            if (stakeholdername != null && !stakeholdername.equals(this.getStakeholderName(wi))) continue;
            workItems.add(new ImExWorkItem(wi, this, this.concreteDataManager.getModelController(), locale));
        }
        return workItems;
    }

    public String getUniqueElementUIDLinkedWithWorkItem(WorkItem workItem) {
        Collection ues = this.concreteModelController.getLinkableObjects((IModuleData)workItem, "WorkItemUniqueElement");
        if (ues.isEmpty()) {
            return null;
        }
        IUniqueElement ue = (IUniqueElement)ues.iterator().next();
        return ue.getUID();
    }

    public List getUnassignedWorkItems1(Collection filters, Locale locale) {
        ArrayList original = new ArrayList(ModuleDataFacade.filter((Collection)this.concreteModelController.getUnassignedWorkItems(), (Collection)filters));
        this.sortByNaturalOrder(original);
        ArrayList<ImExWorkItem> workItems = new ArrayList<ImExWorkItem>();
        for (WorkItem wi : original) {
            workItems.add(new ImExWorkItem(wi, this, this.concreteDataManager.getModelController(), locale));
        }
        return workItems;
    }

    public RessourceWorkCumulator getRessourceWorkCumulatorForProjectPlan(ProjectPlan projectPlan) {
        assert (projectPlan != null) : "projectPlan must not be null";
        return this.concreteModelController.getRessourceWorkCumulator(projectPlan);
    }

    @Deprecated
    public Task getTaskForWorkItem(ImExWorkItem workItem) {
        return this.concreteModelController.getTaskForWorkItem((WorkItem)this.getModuleDataItemForImExItem(workItem));
    }

    private List getTaskChildren(Task parent, ImExTask imExParent, Collection filters, Locale locale) {
        ArrayList original = new ArrayList(this.concreteModelController.getTaskChildren(parent));
        this.sortByNaturalOrder(original);
        original = new ArrayList(ModuleDataFacade.filter(original, (Collection)filters));
        ArrayList<ImExTask> children = new ArrayList<ImExTask>();
        for (Task t : original) {
            ImExTask childTask = new ImExTask(t, imExParent, this, this.concreteDataManager.getModelController(), filters, locale);
            List childChildren = this.getTaskChildren(t, childTask, filters, locale);
            childTask.setChildTasks(childChildren);
            children.add(childTask);
        }
        return children;
    }

    public ProjectPlanningFilters getFilterFactory() {
        return new ProjectPlanningFilters((IModelController)this.concreteModelController);
    }

    public String getStakeholderName(WorkItem workItem) {
        String personInCharge = "";
        Iterator iterator = this.concreteModelController.getLinkableObjects((IModuleData)workItem, "WorkItemStakeholder").iterator();
        if (iterator.hasNext()) {
            personInCharge = ((IStakeholder)iterator.next()).getStakeholderName();
        }
        return personInCharge;
    }

    public AbstractImExModuleData getExportableItem(IModuleData item, Locale locale, Collection filters) {
        if (item instanceof ProjectPlan) {
            return new ImExProjectPlan((ProjectPlan)item, this, this.concreteDataManager.getModelController(), filters, locale);
        }
        if (item instanceof Task) {
            return this.retrieveExportableTask((Task)item, filters, locale);
        }
        if (item instanceof WorkItem) {
            return new ImExWorkItem((WorkItem)item, this, this.concreteDataManager.getModelController(), locale);
        }
        return null;
    }

    private ImExTask retrieveExportableTask(Task task, Collection filters, Locale locale) {
        IModuleData parentItem = this.concreteModelController.getParent((IModuleData)task);
        if (parentItem instanceof Task) {
            ImExTask exportableParentTask = this.retrieveExportableTask((Task)parentItem, filters, locale);
            if (exportableParentTask == null) {
                return null;
            }
            for (ImExTask exportableTask : exportableParentTask.getFilteredChildTasks()) {
                if (!exportableTask.getUID().equals(task.getUID())) continue;
                return exportableTask;
            }
            return null;
        }
        List exportableRootTasks = this.getRootTasksOfProjectPlan((ProjectPlan)parentItem, filters, locale);
        for (ImExTask exportableTask : exportableRootTasks) {
            if (!exportableTask.getUID().equals(task.getUID())) continue;
            return exportableTask;
        }
        return null;
    }

    public IModelController getModelController() {
        return this.concreteModelController;
    }

    public String getProjectUID() {
        return this.concreteModelController.getProjectUID();
    }

    public boolean isLinkedWithUniqueElement(ImExWorkItem workItem) {
        Collection ues = this.concreteDataManager.getLinkableObjects(this.getModuleDataItemForImExItem(workItem), "WorkItemUniqueElement");
        return ues.size() > 0;
    }

    public IUniqueElement getLinkedUniqueElement(ImExWorkItem workItem) {
        Collection ues = this.concreteDataManager.getLinkableObjects(this.getModuleDataItemForImExItem(workItem), "WorkItemUniqueElement");
        if (ues.size() > 0) {
            IUniqueElement ue = (IUniqueElement)ues.iterator().next();
            return ue;
        }
        return null;
    }
}

