/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.core.project;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholder;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.projectplanningmodule2.client.ModuleIdentification;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.DataMgr;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.RessourceWorkCumulator;
import com.arcway.cockpit.projectplanningmodule2.client.messages.ProjectPlan;
import com.arcway.cockpit.projectplanningmodule2.client.messages.SourceFile;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItem;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItemCategory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class ModelController
extends com.arcway.cockpit.modulelib2.client.core.project.ModelController {
    public String getModuleID() {
        return ModuleIdentification.getModuleID();
    }

    public int getNewTaskID(ProjectPlan parentPlan) {
        return ((DataMgr)this.getModel()).getNewTaskID(parentPlan);
    }

    public Collection<WorkItem> getWorkItemChildren(Task parent) {
        assert (parent != null);
        return ((DataMgr)this.getModel()).getWorkItemChildren(parent);
    }

    public boolean containsWorkItems(Task parent) {
        return ((DataMgr)this.getModel()).containsWorkItems(parent);
    }

    public Collection getTaskChildren(Task parent) {
        return ((DataMgr)this.getModel()).getTaskChildren(parent);
    }

    public Collection getAllTasksOfProject(ProjectPlan projectPlan) {
        return ((DataMgr)this.getModel()).getAllTasksOfProject(projectPlan);
    }

    public Collection getAllProjectPlans() {
        return ((DataMgr)this.getModel()).getAllProjectPlans();
    }

    public ProjectPlan getProjectPlanForTask(Task task) {
        return ((DataMgr)this.getModel()).getProjectPlanForTask(task);
    }

    public Task getTaskForWorkItem(WorkItem workItem) {
        return ((DataMgr)this.getModel()).getTaskForWorkItem(workItem);
    }

    public boolean containsSubTasks(Task parent) {
        return ((DataMgr)this.getModel()).containsSubTasks(parent);
    }

    public Collection getUnassignedWorkItems() {
        return ((DataMgr)this.getModel()).getUnassignedWorkItems();
    }

    public RessourceWorkCumulator getRessourceWorkCumulator(Task task) {
        return new RessourceWorkCumulator((DataMgr)this.getModel(), task);
    }

    public RessourceWorkCumulator getRessourceWorkCumulator(ProjectPlan projectPlan) {
        return new RessourceWorkCumulator((DataMgr)this.getModel(), projectPlan);
    }

    public boolean isSynchronized(Task task) {
        return ((DataMgr)this.getModel()).isSynchronized(task);
    }

    public boolean isSynchronized(ProjectPlan projectPlan) {
        return ((DataMgr)this.getModel()).isSynchronized(projectPlan);
    }

    public Task getTask(String taskUID) {
        return ((DataMgr)this.getModel()).getTask(taskUID);
    }

    public SourceFile getSourceFile(ProjectPlan projectPlan) {
        Iterator i = this.getLinkableObjects((IModuleData)projectPlan, "ProjectSourceFile").iterator();
        if (i.hasNext()) {
            return (SourceFile)((Object)i.next());
        }
        return null;
    }

    public WorkItemCategory getCategory(WorkItem workItem) {
        assert (workItem != null) : "workitem must not be null";
        Collection categories = this.getLinkableObjects((IModuleData)workItem, "WorkItemCategory");
        WorkItemCategory category = null;
        if (!categories.isEmpty()) {
            category = (WorkItemCategory)((Object)categories.iterator().next());
        }
        return category;
    }

    public IStakeholder getStakeholderForWorkItem(WorkItem workItem) {
        return ((DataMgr)this.getModel()).getStakeholderForWorkItem(workItem);
    }

    public String getStakeholdersAndResourcesAsString(Task task) {
        HashSet<String> names = new HashSet<String>();
        for (WorkItem workItem : this.getWorkItemChildren(task)) {
            String resources;
            IStakeholder stakeholder = this.getStakeholderForWorkItem(workItem);
            if (stakeholder != null) {
                names.add(stakeholder.getStakeholderName());
            }
            if ((resources = workItem.getResources().getValue()) == null || resources.length() <= 0) continue;
            names.add(resources);
        }
        Iterator nameIterator = names.iterator();
        String result = null;
        while (nameIterator.hasNext()) {
            String name = (String)nameIterator.next();
            result = result == null ? name : String.valueOf(result) + ", " + name;
        }
        if (result != null) {
            return result;
        }
        return "";
    }

    public void storeNewWorkItemCreation(WorkItem newWorkItem, WorkItemCategory newCategory, IStakeholder newStakeholder, Task task, IUniqueElement linkedUniqueElement) {
        this.addItem((IModuleData)newWorkItem);
        if (newCategory != null) {
            this.createLink(newCategory.getUID(), (IModuleData)newWorkItem, "WorkItemCategory");
        }
        if (newStakeholder != null) {
            this.createLink(newStakeholder.getUID(), (IModuleData)newWorkItem, "WorkItemStakeholder");
        }
        if (task != null) {
            this.createLink(task.getUID(), (IModuleData)newWorkItem, "WorkItemTask");
            this.propagateAttributes_workItem(task);
        }
        if (linkedUniqueElement != null) {
            this.createLink(linkedUniqueElement.getUID(), (IModuleData)newWorkItem, "WorkItemUniqueElement");
        }
    }

    public void propagateAttributes_completely(int unitOfBottomUpWork, int unitOfTopDownWork) {
        ((DataMgr)this.getModel()).propagateAttributes_completely(unitOfBottomUpWork, unitOfTopDownWork);
    }

    public void propagateAttributes_completely(ProjectPlan projectPlan, int unitOfBottomUpWork, int unitOfTopDownWork) {
        ((DataMgr)this.getModel()).propagateAttributes_completely(projectPlan, unitOfBottomUpWork, unitOfTopDownWork);
    }

    public void propagateAttributes_unitOfWork(int unitOfBottomUpWork, int unitOfTopDownWork) {
        ((DataMgr)this.getModel()).propagateAttributes_unitOfWork(unitOfBottomUpWork, unitOfTopDownWork);
    }

    public void propagateAttributes_projectPlan(ProjectPlan projectPlan) {
        ((DataMgr)this.getModel()).propagateAttributes_projectPlan(projectPlan);
    }

    public void propagateAttributes_task(IModuleData parentTaskOrProject) {
        ((DataMgr)this.getModel()).propagateAttributes_task(parentTaskOrProject);
    }

    public void propagateAttributes_workItem(Task parentTask) {
        ((DataMgr)this.getModel()).propagateAttributes_workItem(parentTask);
    }

    public void disconnectProjectPlan(ProjectPlan plan) {
        ((DataMgr)this.getModel()).disconnectProjectPlan(plan);
    }

    public void movedItems(Map<IModuleData, IModuleData> movedItemsWithOldParents, IModuleData newParent) {
        if (newParent != null) {
            if (newParent instanceof Task) {
                this.propagateAttributes_workItem((Task)newParent);
            }
            this.propagateAttributes_task(newParent);
        }
        for (IModuleData oldParent : new HashSet<IModuleData>(movedItemsWithOldParents.values())) {
            if (oldParent == null) continue;
            if (oldParent instanceof Task) {
                this.propagateAttributes_workItem((Task)oldParent);
            }
            this.propagateAttributes_task(oldParent);
        }
    }
}

