/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.core.project;

import com.arcway.cockpit.client.base.datamanager.PropertyChangesManager;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDataLabelProvider2;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholder;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.modulelib2.client.core.IClientDataFactory;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractDataMgr;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LinkMgr;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleFacade;
import com.arcway.cockpit.modulelib2.client.core.project.ProjectionMgr;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.AbstractPermissionMgr;
import com.arcway.cockpit.modulelib2.client.messages.IDataTypesHelper;
import com.arcway.cockpit.modulelib2.client.messages.ILinkTypeHelper;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDuration;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeString;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeTimestamp;
import com.arcway.cockpit.projectplanningmodule2.client.ProjectPlanningModule2Plugin;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.DatalabelProvider;
import com.arcway.cockpit.projectplanningmodule2.client.gui.preferences.PreferenceManager;
import com.arcway.cockpit.projectplanningmodule2.client.messages.IWorkItem;
import com.arcway.cockpit.projectplanningmodule2.client.messages.PPMDataTypesHelper;
import com.arcway.cockpit.projectplanningmodule2.client.messages.PPMLinkTypeHelper;
import com.arcway.cockpit.projectplanningmodule2.client.messages.ProjectPlan;
import com.arcway.cockpit.projectplanningmodule2.client.messages.SourceFile;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItem;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.AbstractEncodableObjectFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;

public class DataMgr
extends AbstractDataMgr
implements IPropertyChangeListener {
    private static final ILogger logger = Logger.getLogger(AbstractDataMgr.class);
    private IDataLabelProvider2<String> dataLabelProvider;

    public void construct(String projectUid, IFrameProjectAgent project, IModelController modelControllerP, AbstractPermissionMgr permissionMgrP, AbstractLockManager lockMgrP, ProjectionMgr projectionMgrP, LinkMgr linkMgrP, PropertyChangesManager propertyChangesManager, ModuleFacade moduleFacade, IClientDataFactory clientDataFactory, AbstractEncodableObjectFactory p_eoFactory) {
        super.construct(projectUid, project, modelControllerP, permissionMgrP, lockMgrP, projectionMgrP, linkMgrP, propertyChangesManager, moduleFacade, clientDataFactory, p_eoFactory);
        ProjectPlanningModule2Plugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public Collection getChildren(IModuleData item) {
        if (item == null) {
            return super.getChildren(null);
        }
        ArrayList children = new ArrayList();
        if (item instanceof ProjectPlan) {
            children.addAll(this.getLinkMgr().getModuleData(item, "TaskProjectPlan"));
            children.addAll(this.getLinkMgr().getLinkableObjects(item, "ProjectSourceFile"));
        } else if (item instanceof Task) {
            children.addAll(this.getLinkMgr().getModuleData(item, "TaskTask"));
            children.addAll(this.getLinkMgr().getModuleData(item, "WorkItemTask"));
        }
        return children;
    }

    public IModuleData getParent(IModuleData item) {
        assert (item != null);
        if (item instanceof Task) {
            Iterator i = this.getLinkMgr().getLinkableObjects(item, "TaskTask").iterator();
            if (i.hasNext()) {
                return (Task)((Object)i.next());
            }
            Iterator j = this.getLinkMgr().getLinkableObjects(item, "TaskProjectPlan").iterator();
            if (j.hasNext()) {
                return (ProjectPlan)((Object)j.next());
            }
            return null;
        }
        if (item instanceof WorkItem) {
            Iterator i = this.getLinkMgr().getLinkableObjects(item, "WorkItemTask").iterator();
            if (i.hasNext()) {
                return (Task)((Object)i.next());
            }
            return null;
        }
        if (item instanceof SourceFile) {
            Iterator i = this.getLinkMgr().getModuleData(item, "ProjectSourceFile").iterator();
            return (ProjectPlan)((Object)i.next());
        }
        return null;
    }

    public Collection getWorkItemChildren(Task parent) {
        Collection children = this.getLinkMgr().getModuleData(parent.getUID(), "WorkItemTask");
        return children;
    }

    public Collection getTaskChildren(Task parent) {
        Collection children = this.getLinkMgr().getModuleData(parent.getUID(), "TaskTask");
        return children;
    }

    public Collection getAllTasksOfProject(ProjectPlan plan) {
        Collection children = this.getLinkMgr().getModuleData((IModuleData)plan, "TaskProjectPlan");
        HashSet indirectChildren = new HashSet();
        for (Task subTask : children) {
            indirectChildren.addAll(this.getAllSubTasks(subTask));
        }
        children.addAll(indirectChildren);
        return children;
    }

    private Collection getAllSubTasks(Task task) {
        Collection children = this.getLinkMgr().getModuleData((IModuleData)task, "TaskTask");
        HashSet indirectChildren = new HashSet();
        for (Task subTask : children) {
            indirectChildren.addAll(this.getAllSubTasks(subTask));
        }
        children.addAll(indirectChildren);
        return children;
    }

    public ProjectPlan getProjectPlanForTask(Task task) {
        IModuleData parent = this.getParent((IModuleData)task);
        while (!(parent instanceof ProjectPlan)) {
            parent = this.getParent(parent);
        }
        return (ProjectPlan)parent;
    }

    public Task getTaskForWorkItem(WorkItem workItem) {
        IModuleData parent = this.getParent((IModuleData)workItem);
        return (Task)parent;
    }

    public boolean containsWorkItems(Task parent) {
        return !this.getWorkItemChildren(parent).isEmpty();
    }

    public boolean containsSubTasks(Task parent) {
        return !this.getTaskChildren(parent).isEmpty();
    }

    public Collection getUnassignedWorkItems() {
        return this.getRootItems("ppm2.workitem");
    }

    public ProjectPlan getProjectPlan(String projectPlanUID) {
        return (ProjectPlan)((Object)this.getItem("ppm2.projectplan", projectPlanUID));
    }

    public Collection getAllProjectPlans() {
        return this.getAllItems("ppm2.projectplan");
    }

    public Task getTask(String taskUID) {
        return (Task)((Object)this.getItem("ppm2.task", taskUID));
    }

    public WorkItem getWorkItem(String workItemUID) {
        return (WorkItem)this.getItem("ppm2.workitem", workItemUID);
    }

    private void calculateState(Task task) {
        assert (task != null) : "task must not be null";
        Collection taskChildren = this.getTaskChildren(task);
        Collection workItemChildren = this.getWorkItemChildren(task);
        int value = 4;
        ModuleDataAttributeTimestamp start = task.getStart();
        ModuleDataAttributeTimestamp end = task.getFinish();
        Date startDate = start != null && start.getValue() != null ? new Date(start.getValue()) : null;
        Date endDate = end != null && end.getValue() != null ? new Date(end.getValue()) : null;
        Date now = new Date(System.currentTimeMillis());
        if (startDate != null && now.before(startDate)) {
            value = 3;
        }
        if (endDate != null && now.after(endDate)) {
            value = 2;
        }
        if (startDate != null && endDate != null && startDate.before(now) && now.before(endDate)) {
            value = 1;
        }
        boolean isComplete = true;
        if (taskChildren.size() > 0) {
            for (Task childTask : taskChildren) {
                if (childTask.isComplete()) continue;
                isComplete = false;
                break;
            }
        } else if (workItemChildren.size() > 0) {
            for (WorkItem childWorkitem : workItemChildren) {
                if (childWorkitem.isComplete()) continue;
                isComplete = false;
                break;
            }
        } else {
            boolean bl = isComplete = task.getOriginalPercentWorkComplete().getValue() == 100;
        }
        if (isComplete) {
            value = 0;
        }
        task.getState().setValue(value);
    }

    private void updateBottomUpWork(IModuleData taskOrProjectPlan) {
        assert (taskOrProjectPlan != null) : "item must not be null";
        assert (taskOrProjectPlan instanceof Task || taskOrProjectPlan instanceof ProjectPlan) : "item must be a task or a project plan";
        ModuleDataAttributeDuration workEstimated = new ModuleDataAttributeDuration(0L);
        ModuleDataAttributeDuration workDone = new ModuleDataAttributeDuration(0L);
        ModuleDataAttributeDuration workRemaining = new ModuleDataAttributeDuration(0L);
        for (IModuleData child : this.getChildren(taskOrProjectPlan)) {
            if (child instanceof WorkItem) {
                WorkItem workItem = (WorkItem)child;
                workEstimated = workEstimated.addDuration(workItem.getWorkEstimated());
                workDone = workDone.addDuration(workItem.getWorkDone());
                workRemaining = workRemaining.addDuration(workItem.getWorkRemaining());
                continue;
            }
            if (!(child instanceof Task)) continue;
            Task taskChild = (Task)child;
            workEstimated = workEstimated.addDuration(taskChild.getWorkEstimated());
            workDone = workDone.addDuration(taskChild.getWorkDone());
            workRemaining = workRemaining.addDuration(taskChild.getWorkRemaining());
        }
        if (taskOrProjectPlan instanceof Task) {
            ((Task)taskOrProjectPlan).getWorkEstimated().setValue(workEstimated.getValue());
            ((Task)taskOrProjectPlan).getWorkDone().setValue(workDone.getValue());
            ((Task)taskOrProjectPlan).getWorkRemaining().setValue(workRemaining.getValue());
        } else if (taskOrProjectPlan instanceof ProjectPlan) {
            ((ProjectPlan)taskOrProjectPlan).getWorkEstimated().setValue(workEstimated.getValue());
            ((ProjectPlan)taskOrProjectPlan).getWorkDone().setValue(workDone.getValue());
            ((ProjectPlan)taskOrProjectPlan).getWorkRemaining().setValue(workRemaining.getValue());
        }
    }

    private void updateRessources(Task task) {
        assert (task != null) : "task must not be null";
        HashSet<String> nameSet = new HashSet<String>();
        Collection childs = this.getChildren((IModuleData)task);
        for (IModuleData child : childs) {
            String[] names;
            Task taskChild;
            String resoureNames;
            if (child instanceof WorkItem) {
                String ressourceName;
                WorkItem wi = (WorkItem)child;
                IStakeholder stakeholder = this.getStakeholderForWorkItem(wi);
                if (stakeholder != null && !nameSet.contains(stakeholder.getStakeholderName())) {
                    nameSet.add(stakeholder.getStakeholderName());
                }
                if ((ressourceName = wi.getResources().getValue()) == null || ressourceName.length() <= 0 || nameSet.contains(ressourceName)) continue;
                nameSet.add(ressourceName);
                continue;
            }
            if (!(child instanceof Task) || (resoureNames = (taskChild = (Task)child).getBottomUpResourceNames().getValue()) == null) continue;
            String[] stringArray = names = resoureNames.split(",");
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name2 = stringArray[n2];
                String name = name2.trim();
                if (!nameSet.contains(name)) {
                    nameSet.add(name);
                }
                ++n2;
            }
        }
        String resourceString = "";
        Object[] names = nameSet.toArray();
        int j = 0;
        while (j < names.length) {
            if (j > 0) {
                resourceString = String.valueOf(resourceString) + ", ";
            }
            resourceString = String.valueOf(resourceString) + (String)names[j];
            ++j;
        }
        task.getBottomUpResourceNames().setValue(resourceString);
    }

    public IStakeholder getStakeholderForWorkItem(WorkItem workItem) {
        assert (workItem != null) : "workitem must not be null";
        Collection stakeholders = this.getLinkableObjects((IModuleData)workItem, "WorkItemStakeholder");
        IStakeholder stakeholder = null;
        if (!stakeholders.isEmpty()) {
            stakeholder = (IStakeholder)stakeholders.iterator().next();
        }
        return stakeholder;
    }

    private void updateTopDownWorkCompletely() {
        for (ProjectPlan p : this.getAllProjectPlans()) {
            this.updateTopDownWork((IModuleData)p);
        }
    }

    private void updateTopDownWork(IModuleData taskOrProjectPlan) {
        assert (taskOrProjectPlan != null) : "item must not be null";
        assert (taskOrProjectPlan instanceof Task || taskOrProjectPlan instanceof ProjectPlan) : "item must be a task or a project plan";
        ModuleDataAttributeDuration workTopDown = new ModuleDataAttributeDuration(0L);
        Long start = null;
        Long finish = null;
        boolean hasTaskChildren = false;
        for (IModuleData child : this.getChildren(taskOrProjectPlan)) {
            if (!(child instanceof Task)) continue;
            hasTaskChildren = true;
            Task task = (Task)child;
            workTopDown = workTopDown.addDuration(task.getOriginalWork());
            if (task.getStart().getValue() != null) {
                Long l = start = start == null ? task.getStart().getValue() : new Long(Math.min(start, task.getStart().getValue()));
            }
            if (task.getFinish().getValue() == null) continue;
            Long l = finish = finish == null ? task.getFinish().getValue() : new Long(Math.max(finish, task.getFinish().getValue()));
        }
        if (hasTaskChildren) {
            if (taskOrProjectPlan instanceof Task) {
                ((Task)taskOrProjectPlan).getOriginalWork().setValue(workTopDown.getValue());
                ((Task)taskOrProjectPlan).getStart().setValue(start);
                ((Task)taskOrProjectPlan).getFinish().setValue(finish);
            } else if (taskOrProjectPlan instanceof ProjectPlan) {
                ((ProjectPlan)taskOrProjectPlan).getOriginalWork().setValue(workTopDown.getValue());
                ((ProjectPlan)taskOrProjectPlan).getStart().setValue(start);
                ((ProjectPlan)taskOrProjectPlan).getFinish().setValue(finish);
            }
        }
    }

    private void propagateAttributes_projectPlan(IModuleData taskOrWorkItem, int hoursPerDay) {
        assert (taskOrWorkItem != null) : "item must not be null";
        assert (taskOrWorkItem instanceof Task || taskOrWorkItem instanceof WorkItem) : "item must be a task or a work item";
        this.updateHoursPerDayConversion(taskOrWorkItem, hoursPerDay);
        Iterator children = this.getChildren(taskOrWorkItem).iterator();
        while (children.hasNext()) {
            this.propagateAttributes_projectPlan((IModuleData)children.next(), hoursPerDay);
        }
    }

    private void updateHoursPerDayConversion(ProjectPlan projectPlan) {
        int hoursPerDay = projectPlan.getHoursPerDay().getValue();
        projectPlan.getWorkEstimated().setHoursPerDay(hoursPerDay);
        projectPlan.getWorkDone().setHoursPerDay(hoursPerDay);
        projectPlan.getWorkRemaining().setHoursPerDay(hoursPerDay);
        projectPlan.getOriginalWork().setHoursPerDay(hoursPerDay);
    }

    private void updateHoursPerDayConversion(IModuleData taskOrWorkItem, int hoursPerDay) {
        assert (taskOrWorkItem != null) : "item must not be null";
        assert (taskOrWorkItem instanceof Task || taskOrWorkItem instanceof WorkItem) : "item must be a task or a work item";
        if (taskOrWorkItem instanceof Task) {
            ((Task)taskOrWorkItem).getWorkEstimated().setHoursPerDay(hoursPerDay);
            ((Task)taskOrWorkItem).getWorkDone().setHoursPerDay(hoursPerDay);
            ((Task)taskOrWorkItem).getWorkRemaining().setHoursPerDay(hoursPerDay);
            ((Task)taskOrWorkItem).getOriginalWork().setHoursPerDay(hoursPerDay);
        } else if (taskOrWorkItem instanceof WorkItem) {
            ((WorkItem)taskOrWorkItem).getWorkEstimated().setHoursPerDay(hoursPerDay);
            ((WorkItem)taskOrWorkItem).getWorkDone().setHoursPerDay(hoursPerDay);
            ((WorkItem)taskOrWorkItem).getWorkRemaining().setHoursPerDay(hoursPerDay);
        }
    }

    private void propagateAttributes_unitOfWork(IModuleData item, int unitOfBottomUpWork, int unitOfTopDownWork) {
        assert (item != null) : "item must not be null";
        assert (item instanceof Task || item instanceof WorkItem || item instanceof ProjectPlan) : "item must be a task or a work item";
        this.updateUnitOfWork(item, unitOfBottomUpWork, unitOfTopDownWork);
        Iterator children = this.getChildren(item).iterator();
        while (children.hasNext()) {
            this.propagateAttributes_unitOfWork((IModuleData)children.next(), unitOfBottomUpWork, unitOfTopDownWork);
        }
    }

    private void updateUnitOfWork(IModuleData item, int unitOfBottomUpWork, int unitOfTopDownWork) {
        assert (item != null) : "item must not be null";
        assert (item instanceof Task || item instanceof WorkItem || item instanceof ProjectPlan) : "item must be a task or a work item";
        if (item instanceof ProjectPlan) {
            ((ProjectPlan)item).getWorkEstimated().setUnit(unitOfBottomUpWork);
            ((ProjectPlan)item).getWorkDone().setUnit(unitOfBottomUpWork);
            ((ProjectPlan)item).getWorkRemaining().setUnit(unitOfBottomUpWork);
            ((ProjectPlan)item).getOriginalWork().setUnit(unitOfTopDownWork);
        } else if (item instanceof Task) {
            ((Task)item).getWorkEstimated().setUnit(unitOfBottomUpWork);
            ((Task)item).getWorkDone().setUnit(unitOfBottomUpWork);
            ((Task)item).getWorkRemaining().setUnit(unitOfBottomUpWork);
            ((Task)item).getOriginalWork().setUnit(unitOfTopDownWork);
        } else if (item instanceof WorkItem) {
            ((WorkItem)item).getWorkEstimated().setUnit(unitOfBottomUpWork);
            ((WorkItem)item).getWorkDone().setUnit(unitOfBottomUpWork);
            ((WorkItem)item).getWorkRemaining().setUnit(unitOfBottomUpWork);
        }
    }

    private void propagateAttributes_completely(IModuleData workItemOrTask, int unitOfBottomUpWork, int unitOfTopDownWork, int hoursPerDay) {
        assert (workItemOrTask != null) : "item must not be null";
        assert (workItemOrTask instanceof Task || workItemOrTask instanceof WorkItem) : "item must be a task or a work item";
        Iterator children = this.getChildren(workItemOrTask).iterator();
        while (children.hasNext()) {
            this.propagateAttributes_completely((IModuleData)children.next(), unitOfBottomUpWork, unitOfTopDownWork, hoursPerDay);
        }
        if (workItemOrTask instanceof Task) {
            this.updateCompletely((Task)workItemOrTask, unitOfBottomUpWork, unitOfTopDownWork, hoursPerDay);
            this.calculateState((Task)workItemOrTask);
        } else if (workItemOrTask instanceof WorkItem) {
            this.updateCompletely((WorkItem)workItemOrTask, unitOfBottomUpWork, unitOfTopDownWork, hoursPerDay);
        }
    }

    private void updateCompletely(ProjectPlan projectPlan, int unitOfBottomUpWork, int unitOfTopDownWork) {
        this.updateBottomUpWork((IModuleData)projectPlan);
        this.updateTopDownWork((IModuleData)projectPlan);
        this.updateHoursPerDayConversion(projectPlan);
        this.updateUnitOfWork((IModuleData)projectPlan, unitOfBottomUpWork, unitOfTopDownWork);
    }

    private void updateCompletely(Task task, int unitOfBottomUpWork, int unitOfTopDownWork, int hoursPerDay) {
        assert (task != null) : "item must not be null";
        this.updateBottomUpWork((IModuleData)task);
        this.updateTopDownWork((IModuleData)task);
        this.updateHoursPerDayConversion((IModuleData)task, hoursPerDay);
        this.updateUnitOfWork((IModuleData)task, unitOfBottomUpWork, unitOfTopDownWork);
        this.updateRessources(task);
    }

    private void updateCompletely(WorkItem workItem, int unitOfBottomUpWork, int unitOfTopDownWork, int hoursPerDay) {
        assert (workItem != null) : "item must not be null";
        this.updateHoursPerDayConversion((IModuleData)workItem, hoursPerDay);
        this.updateUnitOfWork((IModuleData)workItem, unitOfBottomUpWork, unitOfTopDownWork);
    }

    public void propagateAttributes_completely(int unitOfBottomUpWork, int unitOfTopDownWork) {
        Iterator allProjects = this.getAllItems("ppm2.projectplan").iterator();
        while (allProjects.hasNext()) {
            this.propagateAttributes_completely((ProjectPlan)((Object)allProjects.next()), unitOfBottomUpWork, unitOfTopDownWork);
        }
        Iterator allUnassignedWorkItems = this.getUnassignedWorkItems().iterator();
        while (allUnassignedWorkItems.hasNext()) {
            this.propagateAttributes_completely((IModuleData)((WorkItem)allUnassignedWorkItems.next()), unitOfBottomUpWork, unitOfTopDownWork, 8);
        }
    }

    public void propagateAttributes_completely(ProjectPlan projectPlan, int unitOfBottomUpWork, int unitOfTopDownWork) {
        Iterator children = this.getChildren((IModuleData)projectPlan, "ppm2.task").iterator();
        while (children.hasNext()) {
            this.propagateAttributes_completely((IModuleData)children.next(), unitOfBottomUpWork, unitOfTopDownWork, projectPlan.getHoursPerDay().getValue());
        }
        this.updateCompletely(projectPlan, unitOfBottomUpWork, unitOfTopDownWork);
    }

    public void propagateAttributes_unitOfWork(int unitOfBottomUpWork, int unitOfTopDownWork) {
        Iterator allProjects = this.getAllItems("ppm2.projectplan").iterator();
        while (allProjects.hasNext()) {
            this.propagateAttributes_unitOfWork((IModuleData)allProjects.next(), unitOfBottomUpWork, unitOfTopDownWork);
        }
    }

    public void propagateAttributes_projectPlan(ProjectPlan projectPlan) {
        this.updateHoursPerDayConversion(projectPlan);
        Iterator children = this.getChildren((IModuleData)projectPlan).iterator();
        while (children.hasNext()) {
            this.propagateAttributes_projectPlan((IModuleData)children.next(), projectPlan.getHoursPerDay().getValue());
        }
    }

    public void propagateAttributes_task(Task task) {
        assert (task != null) : "task must not be null";
        this.updateBottomUpWork((IModuleData)task);
        this.calculateState(task);
        this.propagateAttributes_task(this.getParent((IModuleData)task));
    }

    public void propagateAttributes_task(IModuleData parentTaskOrProject) {
        assert (parentTaskOrProject != null) : "item must not be null";
        assert (parentTaskOrProject instanceof Task || parentTaskOrProject instanceof ProjectPlan) : "item must be a task or a project plan";
        if (parentTaskOrProject instanceof Task) {
            this.updateTopDownWork(parentTaskOrProject);
            this.calculateState((Task)parentTaskOrProject);
        } else if (parentTaskOrProject instanceof ProjectPlan) {
            this.updateTopDownWork(parentTaskOrProject);
        }
        IModuleData parent = this.getParent(parentTaskOrProject);
        if (parent != null) {
            this.propagateAttributes_task(parent);
        }
    }

    public void propagateAttributes_workItem(Task parentTask) {
        this.updateBottomUpWork((IModuleData)parentTask);
        this.updateRessources(parentTask);
        this.calculateState(parentTask);
        IModuleData parent = this.getParent((IModuleData)parentTask);
        if (parent instanceof Task) {
            this.propagateAttributes_workItem((Task)parent);
        } else if (parent instanceof ProjectPlan) {
            this.updateBottomUpWork(parent);
        }
    }

    public Collection getAllRootItems() {
        Collection rootItems = this.getRootItems("ppm2.projectplan");
        rootItems.addAll(this.getRootItems("ppm2.workitem"));
        return rootItems;
    }

    public Collection getRootItems(String cockpitTypeID) {
        if (cockpitTypeID.equals("ppm2.projectplan")) {
            return this.getAllItems("ppm2.projectplan");
        }
        if (cockpitTypeID.equals("ppm2.workitem")) {
            LinkedList<WorkItem> rootWorkItems = new LinkedList<WorkItem>();
            for (WorkItem currentWorkItem : this.getAllItems("ppm2.workitem")) {
                Set parentTask = this.getLinkMgr().getLinksForModuleDataItem((IModuleData)currentWorkItem, "WorkItemTask");
                if (!parentTask.isEmpty()) continue;
                rootWorkItems.add(currentWorkItem);
            }
            return rootWorkItems;
        }
        return Collections.EMPTY_SET;
    }

    public List filterSelection(List selection) {
        ArrayList filteredSelection = new ArrayList();
        for (Object nextItem : selection) {
            if (nextItem instanceof ProjectPlan || nextItem instanceof Task || nextItem instanceof WorkItem) {
                filteredSelection.add(nextItem);
                continue;
            }
            if (!(nextItem instanceof IWorkItem)) continue;
            filteredSelection.add(((IWorkItem)nextItem).getWorkItem());
        }
        return filteredSelection;
    }

    public void callbackAsynchronousUpdateStarted() {
        super.callbackAsynchronousUpdateStarted();
        this.rememberLinksOfType(Arrays.asList("WorkItemCategory"));
    }

    public void asynchronousUpdateHook_post_addedItems(String dataTypeId, Collection<IModuleData> addedItems) {
        if (dataTypeId.equals("ppm2.workitemcategory")) {
            this.mergeAttributeItemsOnAsynchronousUpdate(addedItems, "ppm2.workitemcategory", Arrays.asList("WorkItemCategory"));
        }
    }

    public void asynchronousUpdateHook_post_modifiedItems(String dataTypeId, Collection<IModuleData> modifiedItems) {
    }

    public void asynchronousUpdateHook_pre_removedItems(String dataTypeId, Collection<IModuleData> removedItems) {
        assert (dataTypeId != null) : "dataTypeId must not be null";
        if (dataTypeId.equals("ppm2.workitemcategory")) {
            this.restoreAttributeItemsOnAsynchronousUpdate(removedItems, Arrays.asList("WorkItemCategory"));
        }
    }

    public void callbackAsynchronousUpdateCompleted() {
        this.propagateAttributes_completely(PreferenceManager.getBottomUpWorkUnit(), PreferenceManager.getTopDownWorkUnit());
        super.callbackAsynchronousUpdateCompleted();
    }

    public void callbackCommitCompleted() {
        this.propagateAttributes_completely(PreferenceManager.getBottomUpWorkUnit(), PreferenceManager.getTopDownWorkUnit());
        super.callbackCommitCompleted();
    }

    public int getNewTaskID(ProjectPlan parentPlan) {
        return this.getNewTaskID(parentPlan, -1);
    }

    public int getNewTaskID(ProjectPlan parentPlan, int proposal) {
        int max = 0;
        boolean proposalOk = proposal > 0;
        for (Object element : this.getAllDescendants((IModuleData)parentPlan)) {
            if (!(element instanceof Task)) continue;
            int id = ((Task)((Object)element)).getID().getValue();
            if (id > max) {
                max = id;
            }
            if (id != proposal) continue;
            proposalOk = false;
        }
        if (proposalOk) {
            return proposal;
        }
        return max + 1;
    }

    public boolean isSynchronized(ProjectPlan projectPlan) {
        return !this.getLinkMgr().getLinksForModuleDataItem((IModuleData)projectPlan, "ProjectSourceFile").isEmpty();
    }

    public boolean isSynchronized(Task task) {
        return task.getExternalUID().getValue() != null;
    }

    public void newProjectCreated() {
    }

    public void projectInitialized_callbackForSubClasses() {
        this.propagateAttributes_completely(PreferenceManager.getBottomUpWorkUnit(), PreferenceManager.getTopDownWorkUnit());
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("ppm.prefs.PrefBottomUpWorkUnit") || event.getProperty().equals("ppm.prefs.PrefTopDownWorkUnit")) {
            this.propagateAttributes_unitOfWork(PreferenceManager.getBottomUpWorkUnit(), PreferenceManager.getTopDownWorkUnit());
        }
        this.getPropertyChangesManager().signalPropertyChanges(null, (Object)this, null, DataMgr.class);
    }

    public void projectClosed() {
        super.projectClosed();
        ProjectPlanningModule2Plugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void disconnectProjectPlan(ProjectPlan plan) {
        Iterator sourceFiles = this.getLinkableObjects((IModuleData)plan, "ProjectSourceFile").iterator();
        assert (sourceFiles.hasNext());
        if (sourceFiles.hasNext()) {
            this.getLinkMgr().deleteLink(((SourceFile)((Object)sourceFiles.next())).getUID(), plan.getUID(), "ProjectSourceFile");
        } else {
            logger.warn("Disconnect: No source file found");
        }
        HashSet<Task> changedTasks = new HashSet<Task>();
        for (Task task : this.getModuleData((IModuleData)plan, "TaskProjectPlan")) {
            ModuleDataAttributeString externalUID = task.getExternalUID();
            if (externalUID.getValue() == null) continue;
            externalUID.setNull();
            changedTasks.add(task);
        }
        this.getPropertyChangesManager().signalPropertyChanges(null, Collections.singleton(plan), null, ProjectPlan.class);
        this.getPropertyChangesManager().signalPropertyChanges(null, changedTasks, null, Task.class);
    }

    public IDataLabelProvider2<String> getDataLabelProvider2() {
        if (this.dataLabelProvider == null) {
            this.dataLabelProvider = new DatalabelProvider(this);
        }
        return this.dataLabelProvider;
    }

    public Image getImageForData() {
        return this.getDataLabelProvider2().getImageForType((Object)"ppm2.projectplan");
    }

    public String getDisplayNameForData() {
        return this.getDataLabelProvider2().getDisplayNameForType((Object)"ppm2.projectplan");
    }

    public IDataTypesHelper getDataTypesHelper() {
        return PPMDataTypesHelper.getDefault();
    }

    protected ILinkTypeHelper getLinkTypesHelper() {
        return PPMLinkTypeHelper.getDefault();
    }

    protected boolean isDataTypeWithID(String dataTypeID) {
        return false;
    }
}

