/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.core.permissions;

import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.permissions.AllAttributeModificationPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.permissions.AttributeModificationPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.permissions.CockpitPermissionTemplate;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.frame.client.project.modules.permissionproviders.IPermissionOperandTreeContentProvider;
import com.arcway.cockpit.frame.client.project.modules.permissionproviders.IPermissionTemplateCategory;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.AbstractPermissionTemplateProvider;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.ModulePermissionTemplate;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.description.ModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.projectplanningmodule2.client.Messages;
import com.arcway.cockpit.projectplanningmodule2.client.ModuleIdentification;
import com.arcway.cockpit.projectplanningmodule2.client.ProjectPlanningModule2Plugin;
import com.arcway.cockpit.projectplanningmodule2.client.core.permissions.ModulePermissionConstants;
import com.arcway.cockpit.projectplanningmodule2.client.core.permissions.PPMPermissionRootNode;
import com.arcway.cockpit.projectplanningmodule2.client.core.permissions.PPMPermissionUnassignedWorkItemsNode;
import com.arcway.cockpit.projectplanningmodule2.client.messages.PPMDataTypesHelper;
import com.arcway.cockpit.projectplanningmodule2.client.messages.ProjectPlan;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItem;
import com.arcway.cockpit.projectplanningmodule2.client.messages.description.ProjectPlanDescription;
import com.arcway.cockpit.projectplanningmodule2.client.messages.description.TaskDescription;
import com.arcway.cockpit.projectplanningmodule2.client.messages.description.WorkItemDescription;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;

public class PPMPermissionTemplateProvider
extends AbstractPermissionTemplateProvider {
    private static final ILogger logger = Logger.getLogger(PPMPermissionTemplateProvider.class);
    private static final String PERMISSION_DIALOG_TAB_NAME = Messages.getString("Permissions.TabName");
    private static final String PERMISSION_DIALOG_TAB_DESCRIPTION = Messages.getString("Permissions.TabDescription");
    private static final HashMap categoryMap = new HashMap();
    private static final String PROJECT_PLAN_KEY = "ProjectPlan";
    private static final String TASK_KEY = "Task";
    private static final String WORK_ITEM_KEY = "WorkItem";

    public PPMPermissionTemplateProvider() {
        super(PPMDataTypesHelper.getDefault());
    }

    public String getName() {
        return PERMISSION_DIALOG_TAB_NAME;
    }

    public String getDescription() {
        return PERMISSION_DIALOG_TAB_DESCRIPTION;
    }

    public Collection getTemplates(IFrameProjectAgent projectAgent) {
        ArrayList operationTemplates = new ArrayList(ModulePermissionConstants.getTemplates());
        operationTemplates.addAll(PPMPermissionTemplateProvider.getAttributeModificationTemplates((IModuleProjectAgent)projectAgent, (ModuleDataTypeDescriptionForFrame)ProjectPlanDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, (String)"ppm2.prmOperand.projectPlan"));
        operationTemplates.addAll(PPMPermissionTemplateProvider.getAttributeModificationTemplates((IModuleProjectAgent)projectAgent, (ModuleDataTypeDescriptionForFrame)ProjectPlanDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, (String)"ppm2.prmOperand.root"));
        operationTemplates.addAll(PPMPermissionTemplateProvider.getAttributeModificationTemplates((IModuleProjectAgent)projectAgent, (ModuleDataTypeDescriptionForFrame)TaskDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, (String)"ppm2.prmOperand.projectPlan"));
        operationTemplates.addAll(PPMPermissionTemplateProvider.getAttributeModificationTemplates((IModuleProjectAgent)projectAgent, (ModuleDataTypeDescriptionForFrame)TaskDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, (String)"ppm2.prmOperand.task"));
        operationTemplates.addAll(PPMPermissionTemplateProvider.getAttributeModificationTemplates((IModuleProjectAgent)projectAgent, (ModuleDataTypeDescriptionForFrame)TaskDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, (String)"ppm2.prmOperand.root"));
        operationTemplates.addAll(PPMPermissionTemplateProvider.getAttributeModificationTemplates((IModuleProjectAgent)projectAgent, (ModuleDataTypeDescriptionForFrame)WorkItemDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, (String)"ppm2.prmOperand.projectPlan"));
        operationTemplates.addAll(PPMPermissionTemplateProvider.getAttributeModificationTemplates((IModuleProjectAgent)projectAgent, (ModuleDataTypeDescriptionForFrame)WorkItemDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, (String)"ppm2.prmOperand.task"));
        operationTemplates.addAll(PPMPermissionTemplateProvider.getAttributeModificationTemplates((IModuleProjectAgent)projectAgent, (ModuleDataTypeDescriptionForFrame)WorkItemDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, (String)"ppm2.prmOp.unassignedWIs"));
        operationTemplates.addAll(PPMPermissionTemplateProvider.getAttributeModificationTemplates((IModuleProjectAgent)projectAgent, (ModuleDataTypeDescriptionForFrame)WorkItemDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, (String)"ppm2.prmOperand.root"));
        return operationTemplates;
    }

    public ILabelProvider getTemplatesLabelProvider(IFrameProjectAgent projectAgent) {
        return new TemplateLabelProvider(projectAgent);
    }

    public Object getTreeViewerInput(IModuleProjectAgent projectAgent) {
        return new Object();
    }

    public IPermissionOperandTreeContentProvider getTreeContentProvider(IModuleProjectAgent projectAgent) {
        return new TreeContentProvider(projectAgent);
    }

    public ILabelProvider getTreeLabelProvider(IModuleProjectAgent projectAgent) {
        return new TreeLabelProvider();
    }

    public ViewerSorter getTreeSorter() {
        return null;
    }

    public IPermissionTemplateCategory getCategory(IFrameProjectAgent projectAgent, CockpitPermissionTemplate template) {
        AllAttributeModificationPermissionTemplate attrTemplate;
        if (template.getOperation().equals("ppm2.editProjectPlanOrTask")) {
            return this.getCategoryForTask();
        }
        if (template.getOperation().equals("ppm2.editContainedWorkItems") || template.getOperation().equals("ppm2.editUnassignedWorkItems")) {
            return this.getCategoryForWorkItem();
        }
        if (template.getOperation().equals("ppm2.createProjectPlan")) {
            return null;
        }
        if (template instanceof AllAttributeModificationPermissionTemplate) {
            attrTemplate = (AllAttributeModificationPermissionTemplate)template;
            if (attrTemplate.getCockpitDataTypeID().equals(ProjectPlanDescription.MODULEDATATYPEDESCRIPTION_FORFRAME.getCockpitDataTypeID())) {
                return this.getCategoryForProjectPlan();
            }
            if (attrTemplate.getCockpitDataTypeID().equals(TaskDescription.MODULEDATATYPEDESCRIPTION_FORFRAME.getCockpitDataTypeID())) {
                return this.getCategoryForTask();
            }
            if (attrTemplate.getCockpitDataTypeID().equals(WorkItemDescription.MODULEDATATYPEDESCRIPTION_FORFRAME.getCockpitDataTypeID())) {
                return this.getCategoryForWorkItem();
            }
        }
        if (template instanceof AttributeModificationPermissionTemplate) {
            attrTemplate = (AttributeModificationPermissionTemplate)template;
            if (attrTemplate.getCockpitDataTypeID().equals(ProjectPlanDescription.MODULEDATATYPEDESCRIPTION_FORFRAME.getCockpitDataTypeID())) {
                return this.getCategoryForProjectPlan();
            }
            if (attrTemplate.getCockpitDataTypeID().equals(TaskDescription.MODULEDATATYPEDESCRIPTION_FORFRAME.getCockpitDataTypeID())) {
                return this.getCategoryForTask();
            }
            if (attrTemplate.getCockpitDataTypeID().equals(WorkItemDescription.MODULEDATATYPEDESCRIPTION_FORFRAME.getCockpitDataTypeID())) {
                return this.getCategoryForWorkItem();
            }
        }
        return super.getCategory(projectAgent, template);
    }

    private IPermissionTemplateCategory getCategoryForProjectPlan() {
        if (!categoryMap.containsKey(PROJECT_PLAN_KEY)) {
            categoryMap.put(PROJECT_PLAN_KEY, new IPermissionTemplateCategory(){

                public String getID() {
                    return PPMPermissionTemplateProvider.PROJECT_PLAN_KEY;
                }

                public String getDisplayName() {
                    return Messages.getString("PPMPermissionTemplateProvider.ProjectPlanPermissions");
                }
            });
        }
        return (IPermissionTemplateCategory)categoryMap.get(PROJECT_PLAN_KEY);
    }

    private IPermissionTemplateCategory getCategoryForTask() {
        if (!categoryMap.containsKey(TASK_KEY)) {
            categoryMap.put(TASK_KEY, new IPermissionTemplateCategory(){

                public String getID() {
                    return PPMPermissionTemplateProvider.TASK_KEY;
                }

                public String getDisplayName() {
                    return Messages.getString("PPMPermissionTemplateProvider.TaskPermissions");
                }
            });
        }
        return (IPermissionTemplateCategory)categoryMap.get(TASK_KEY);
    }

    private IPermissionTemplateCategory getCategoryForWorkItem() {
        if (!categoryMap.containsKey(WORK_ITEM_KEY)) {
            categoryMap.put(WORK_ITEM_KEY, new IPermissionTemplateCategory(){

                public String getID() {
                    return PPMPermissionTemplateProvider.WORK_ITEM_KEY;
                }

                public String getDisplayName() {
                    return Messages.getString("PPMPermissionTemplateProvider.WorkItemPermissions");
                }
            });
        }
        return (IPermissionTemplateCategory)categoryMap.get(WORK_ITEM_KEY);
    }

    private static class TemplateLabelProvider
    extends AbstractPermissionTemplateProvider.AbstractTemplateLabelProvider {
        public TemplateLabelProvider(IFrameProjectAgent projectAgent) {
            super(projectAgent, PPMDataTypesHelper.getDefault());
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (!(element instanceof ModulePermissionTemplate)) {
                return null;
            }
            ModulePermissionTemplate template = (ModulePermissionTemplate)element;
            if (template.getBaseTemplate() instanceof AllAttributeModificationPermissionTemplate) {
                return ((AllAttributeModificationPermissionTemplate)template.getBaseTemplate()).getPermissionName();
            }
            if (template.getBaseTemplate() instanceof AttributeModificationPermissionTemplate) {
                AttributeModificationPermissionTemplate attrTemplate = (AttributeModificationPermissionTemplate)template.getBaseTemplate();
                String label = this.getAttributePermissionTemplateLabel(attrTemplate);
                if (label != null) {
                    return label;
                }
                if (attrTemplate.getCockpitDataTypeID().equals(ProjectPlanDescription.MODULEDATATYPEDESCRIPTION_FORFRAME.getCockpitDataTypeID())) {
                    String attributeName = ProjectPlan.getAttributeDisplayName(attrTemplate.getAttributeTypeUID());
                    return "\"" + attributeName + "\"" + Messages.getString("PPMPermissionTemplateProvider.ofProjectPlan");
                }
                if (attrTemplate.getCockpitDataTypeID().equals(TaskDescription.MODULEDATATYPEDESCRIPTION_FORFRAME.getCockpitDataTypeID())) {
                    String attributeName = Task.getAttributeDisplayName(attrTemplate.getAttributeTypeUID());
                    return "\"" + attributeName + "\"" + Messages.getString("PPMPermissionTemplateProvider.ofTask");
                }
                if (attrTemplate.getCockpitDataTypeID().equals(WorkItemDescription.MODULEDATATYPEDESCRIPTION_FORFRAME.getCockpitDataTypeID())) {
                    String attributeName = WorkItem.getAttributeDisplayName(attrTemplate.getAttributeTypeUID());
                    return "\"" + attributeName + "\"" + Messages.getString("PPMPermissionTemplateProvider.ofWorkItem");
                }
                return "TODO!!!!";
            }
            return ModulePermissionConstants.getName((CockpitPermissionTemplate)template);
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private static class TreeContentProvider
    extends AbstractPermissionTemplateProvider.AbstractTreeContentProvider {
        public TreeContentProvider(IModuleProjectAgent projectAgent) {
            super(projectAgent, ModuleIdentification.getModuleID());
        }

        public IPermissionOperand[] getElements(Object element) {
            return new IPermissionOperand[]{ModulePermissionConstants.ROOT_NODE};
        }

        public boolean hasChildren(IPermissionOperand element) {
            boolean hasChildren = false;
            if (element instanceof PPMPermissionRootNode) {
                hasChildren = true;
            } else if (element instanceof PPMPermissionUnassignedWorkItemsNode) {
                hasChildren = false;
            } else if (element instanceof ProjectPlan) {
                hasChildren = !this.getModelController().getLinksForLinkableObject((IModuleData)((ProjectPlan)element), "TaskProjectPlan").isEmpty();
            } else if (element instanceof Task) {
                hasChildren = !this.getModelController().getLinksForLinkableObject((IModuleData)((Task)element), "TaskTask").isEmpty();
            }
            return hasChildren;
        }

        public IPermissionOperand getParent(IPermissionOperand element) {
            IPermissionOperand parent = null;
            if (element instanceof PPMPermissionUnassignedWorkItemsNode) {
                parent = ModulePermissionConstants.ROOT_NODE;
            } else if (element instanceof ProjectPlan) {
                parent = ModulePermissionConstants.ROOT_NODE;
            } else if (element instanceof Task) {
                Collection parentTask = this.getModelController().getLinkableObjects((IModuleData)((Task)element), "TaskTask");
                if (parentTask.size() == 1) {
                    parent = (IPermissionOperand)parentTask.iterator().next();
                } else {
                    Collection parentProjectPlan = this.getModelController().getLinkableObjects((IModuleData)((Task)element), "TaskProjectPlan");
                    if (parentProjectPlan.size() == 1) {
                        parent = (IPermissionOperand)parentProjectPlan.iterator().next();
                    } else {
                        logger.warn("task has no parent (in permission template provider)");
                    }
                }
            } else if (element instanceof WorkItem && (parent = (IPermissionOperand)this.getModelController().getParent((IModuleData)((WorkItem)element))) == null) {
                parent = ModulePermissionConstants.UNASSIGNED_WORK_ITEMS_ROOT_NODE;
            }
            return parent;
        }

        public IPermissionOperand[] getChildren(IPermissionOperand parentElement) {
            IPermissionOperand[] childrenArray = null;
            if (parentElement instanceof PPMPermissionRootNode) {
                Object[] projectPlans = this.getModelController().getAllItems("ppm2.projectplan").toArray();
                childrenArray = new IPermissionOperand[projectPlans.length + 1];
                childrenArray[0] = ModulePermissionConstants.UNASSIGNED_WORK_ITEMS_ROOT_NODE;
                if (projectPlans.length > 0) {
                    System.arraycopy(projectPlans, 0, childrenArray, 1, projectPlans.length);
                }
            } else if (parentElement instanceof ProjectPlan) {
                Collection children = this.getModelController().getModuleData((IModuleData)((ProjectPlan)parentElement), "TaskProjectPlan");
                childrenArray = new IPermissionOperand[children.size()];
                children.toArray(childrenArray);
            } else if (parentElement instanceof Task) {
                Collection children = this.getModelController().getModuleData((IModuleData)((Task)parentElement), "TaskTask");
                childrenArray = new IPermissionOperand[children.size()];
                children.toArray(childrenArray);
            }
            return childrenArray;
        }

        public IPermissionOperand getTreeRootNode() {
            return ModulePermissionConstants.ROOT_NODE;
        }
    }

    private static class TreeLabelProvider
    implements ILabelProvider {
        private TreeLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof PPMPermissionRootNode) {
                ImageDescriptor desc = ProjectPlanningModule2Plugin.getImageDescriptor("Project.gif");
                return ProjectPlanningModule2Plugin.getDefault().getImageDescriptorRegistry().get(desc);
            }
            if (element instanceof PPMPermissionUnassignedWorkItemsNode) {
                ImageDescriptor desc = ProjectPlanningModule2Plugin.getImageDescriptor("WorkItem.gif");
                return ProjectPlanningModule2Plugin.getDefault().getImageDescriptorRegistry().get(desc);
            }
            if (element instanceof ProjectPlan) {
                ImageDescriptor desc = ProjectPlanningModule2Plugin.getImageDescriptor("Project.gif");
                return ProjectPlanningModule2Plugin.getDefault().getImageDescriptorRegistry().get(desc);
            }
            if (element instanceof Task) {
                ImageDescriptor desc = ProjectPlanningModule2Plugin.getImageDescriptor("Task.gif");
                return ProjectPlanningModule2Plugin.getDefault().getImageDescriptorRegistry().get(desc);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof PPMPermissionRootNode) {
                return PPMPermissionRootNode.ROOT_LABEL;
            }
            if (element instanceof PPMPermissionUnassignedWorkItemsNode) {
                return PPMPermissionUnassignedWorkItemsNode.LABEL;
            }
            if (element instanceof ProjectPlan) {
                return ((ProjectPlan)((Object)element)).getDisplayRepresentation();
            }
            if (element instanceof Task) {
                return ((Task)((Object)element)).getDisplayRepresentation();
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

