/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.core.permissions;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.frame.client.project.core.permissions.AllAttributeModificationPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.permissions.CockpitPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IParentOperandTree;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.ModulePermissionTemplate;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.PermissionOperationDescription;
import com.arcway.cockpit.projectplanningmodule2.client.Messages;
import com.arcway.cockpit.projectplanningmodule2.client.core.permissions.PPMPermissionRootNode;
import com.arcway.cockpit.projectplanningmodule2.client.core.permissions.PPMPermissionUnassignedWorkItemsNode;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItem;
import com.arcway.cockpit.projectplanningmodule2.client.messages.description.ProjectPlanDescription;
import com.arcway.cockpit.projectplanningmodule2.client.messages.description.TaskDescription;
import com.arcway.cockpit.projectplanningmodule2.client.messages.description.WorkItemDescription;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ModulePermissionConstants {
    public static final String OPERAND_TYPE_PROJECT_PLAN = "ppm2.prmOperand.projectPlan";
    public static final String OPERAND_TYPE_TASK = "ppm2.prmOperand.task";
    public static final String OPERAND_TYPE_PERMISSION_ROOT = "ppm2.prmOperand.root";
    public static final String OPERAND_TYPE_UNASSIGNED_WORK_ITEMS = "ppm2.prmOp.unassignedWIs";
    public static final String OPERATION_CREATE_PROJECT_PLAN = "ppm2.createProjectPlan";
    public static final String OPERATION_MODIFY_PROJECTPLAN_OR_TASK = "ppm2.editProjectPlanOrTask";
    public static final String OPERATION_MODIFY_CONTAINED_WORKITEMS = "ppm2.editContainedWorkItems";
    public static final String OPERATION_MODIFY_UNASSIGNED_WORKITEMS = "ppm2.editUnassignedWorkItems";
    public static final IPermissionOperand ROOT_NODE = new PPMPermissionRootNode();
    public static final IPermissionOperand UNASSIGNED_WORK_ITEMS_ROOT_NODE = new PPMPermissionUnassignedWorkItemsNode();
    public static final IParentOperandTree UNASSIGNED_WORK_ITEMS_PARENT_TREE = new IParentOperandTree(){

        public IPermissionOperand getBaseOperand() {
            return UNASSIGNED_WORK_ITEMS_ROOT_NODE;
        }

        public IPermissionOperand getParent(IPermissionOperand childOperand) {
            if (childOperand instanceof WorkItem) {
                return UNASSIGNED_WORK_ITEMS_ROOT_NODE;
            }
            if (childOperand instanceof PPMPermissionUnassignedWorkItemsNode) {
                return ROOT_NODE;
            }
            return null;
        }
    };
    public static final CockpitPermissionTemplate CREATE_PROJECTPLAN = new ModulePermissionTemplate("ppm2.createProjectPlan", Arrays.asList(new PermissionOperationDescription("Create", "ppm2.projectplan")), "ppm2.prmOperand.root", ROOT_NODE);
    public static final CockpitPermissionTemplate EDIT_UNASSIGNED_WORKITEMS = new ModulePermissionTemplate("ppm2.editUnassignedWorkItems", Arrays.asList(new PermissionOperationDescription("Create", "ppm2.workitem"), new PermissionOperationDescription("Modify", "ppm2.workitem"), new PermissionOperationDescription("Delete", "ppm2.workitem")), "ppm2.prmOp.unassignedWIs", UNASSIGNED_WORK_ITEMS_ROOT_NODE);
    public static final CockpitPermissionTemplate EDIT_ALL_PROJECTPLANS = new ModulePermissionTemplate("ppm2.editProjectPlanOrTask", Arrays.asList(new PermissionOperationDescription("Create", "ppm2.projectplan"), new PermissionOperationDescription("Create", "ppm2.task"), new PermissionOperationDescription("Modify", "ppm2.projectplan"), new PermissionOperationDescription("Modify", "ppm2.task"), new PermissionOperationDescription("Delete", "ppm2.projectplan"), new PermissionOperationDescription("Delete", "ppm2.task")), "ppm2.prmOperand.root", ROOT_NODE);
    public static final CockpitPermissionTemplate EDIT_PROJECTPLAN = new ModulePermissionTemplate("ppm2.editProjectPlanOrTask", Arrays.asList(new PermissionOperationDescription("Create", "ppm2.projectplan"), new PermissionOperationDescription("Create", "ppm2.task"), new PermissionOperationDescription("Modify", "ppm2.projectplan"), new PermissionOperationDescription("Modify", "ppm2.task"), new PermissionOperationDescription("Delete", "ppm2.projectplan"), new PermissionOperationDescription("Delete", "ppm2.task")), "ppm2.prmOperand.projectPlan");
    public static final CockpitPermissionTemplate EDIT_TASK = new ModulePermissionTemplate("ppm2.editProjectPlanOrTask", Arrays.asList(new PermissionOperationDescription("Create", "ppm2.task"), new PermissionOperationDescription("Modify", "ppm2.task"), new PermissionOperationDescription("Delete", "ppm2.task")), "ppm2.prmOperand.task");
    public static final CockpitPermissionTemplate EDIT_ASSIGNED_WORKITEMS_IN_PROJECT_PLAN = new ModulePermissionTemplate("ppm2.editContainedWorkItems", Arrays.asList(new PermissionOperationDescription("Create", "ppm2.workitem"), new PermissionOperationDescription("Modify", "ppm2.workitem"), new PermissionOperationDescription("Delete", "ppm2.workitem")), "ppm2.prmOperand.projectPlan");
    public static final CockpitPermissionTemplate EDIT_ALL_WORKITEMS_IN_PROJECTS = new ModulePermissionTemplate("ppm2.editContainedWorkItems", Arrays.asList(new PermissionOperationDescription("Create", "ppm2.workitem"), new PermissionOperationDescription("Modify", "ppm2.workitem"), new PermissionOperationDescription("Delete", "ppm2.workitem")), "ppm2.prmOperand.root", ROOT_NODE);
    public static final CockpitPermissionTemplate EDIT_ASSIGNED_WORKITEMS_OF_TASK = new ModulePermissionTemplate("ppm2.editContainedWorkItems", Arrays.asList(new PermissionOperationDescription("Create", "ppm2.workitem"), new PermissionOperationDescription("Modify", "ppm2.workitem"), new PermissionOperationDescription("Delete", "ppm2.workitem")), "ppm2.prmOperand.task");
    public static final CockpitPermissionTemplate EDIT_ALL_ATTR_OF_ASSIGNED_WORKITEMS_OF_TASK = new ModulePermissionTemplate((CockpitPermissionTemplate)AllAttributeModificationPermissionTemplate.getAllAttrTemplate((ICockpitDataType)WorkItemDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, (String)"ppm2.prmOperand.task"), Arrays.asList(new PermissionOperationDescription("ModifyAllAttributes", "ppm2.workitem")));
    public static final CockpitPermissionTemplate EDIT_ALL_ATTR_OF_ASSIGNED_WORKITEMS_OF_PROJECTPLAN = new ModulePermissionTemplate((CockpitPermissionTemplate)AllAttributeModificationPermissionTemplate.getAllAttrTemplate((ICockpitDataType)WorkItemDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, (String)"ppm2.prmOperand.projectPlan"), Arrays.asList(new PermissionOperationDescription("ModifyAllAttributes", "ppm2.workitem")));
    public static final CockpitPermissionTemplate EDIT_ALL_ATTR_OF_UNASSIGNED_WORKITEMS = new ModulePermissionTemplate((CockpitPermissionTemplate)AllAttributeModificationPermissionTemplate.getAllAttrTemplate((ICockpitDataType)WorkItemDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, (String)"ppm2.prmOp.unassignedWIs", (boolean)true, (IPermissionOperand)UNASSIGNED_WORK_ITEMS_ROOT_NODE), Arrays.asList(new PermissionOperationDescription("ModifyAllAttributes", "ppm2.workitem")));
    public static final CockpitPermissionTemplate EDIT_ALL_ATTR_OF_ALL_WORKITEMS = new ModulePermissionTemplate((CockpitPermissionTemplate)AllAttributeModificationPermissionTemplate.getAllAttrTemplate((ICockpitDataType)WorkItemDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, (String)"ppm2.prmOperand.root", (boolean)true, (IPermissionOperand)ROOT_NODE), Arrays.asList(new PermissionOperationDescription("ModifyAllAttributes", "ppm2.workitem")));
    public static final CockpitPermissionTemplate EDIT_ALL_ATTR_OF_TASKS_IN_PROJECTS = new ModulePermissionTemplate((CockpitPermissionTemplate)AllAttributeModificationPermissionTemplate.getAllAttrTemplate((ICockpitDataType)TaskDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, (String)"ppm2.prmOperand.projectPlan"), Arrays.asList(new PermissionOperationDescription("ModifyAllAttributes", "ppm2.task")));
    public static final CockpitPermissionTemplate EDIT_ALL_ATTR_OF_TASKS = new ModulePermissionTemplate((CockpitPermissionTemplate)AllAttributeModificationPermissionTemplate.getAllAttrTemplate((ICockpitDataType)TaskDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, (String)"ppm2.prmOperand.task"), Arrays.asList(new PermissionOperationDescription("ModifyAllAttributes", "ppm2.task")));
    public static final CockpitPermissionTemplate EDIT_ALL_ATTR_OF_ALL_TASKS = new ModulePermissionTemplate((CockpitPermissionTemplate)AllAttributeModificationPermissionTemplate.getAllAttrTemplate((ICockpitDataType)TaskDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, (String)"ppm2.prmOperand.root", (boolean)true, (IPermissionOperand)ROOT_NODE), Arrays.asList(new PermissionOperationDescription("ModifyAllAttributes", "ppm2.task")));
    public static final CockpitPermissionTemplate EDIT_ALL_ATTR_OF_PROJECT_PLANS = new ModulePermissionTemplate((CockpitPermissionTemplate)AllAttributeModificationPermissionTemplate.getAllAttrTemplate((ICockpitDataType)ProjectPlanDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, (String)"ppm2.prmOperand.projectPlan"), Arrays.asList(new PermissionOperationDescription("ModifyAllAttributes", "ppm2.projectplan")));
    public static final CockpitPermissionTemplate EDIT_ALL_ATTR_OF_ALL_PROJECT_PLANS = new ModulePermissionTemplate((CockpitPermissionTemplate)AllAttributeModificationPermissionTemplate.getAllAttrTemplate((ICockpitDataType)ProjectPlanDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, (String)"ppm2.prmOperand.root", (boolean)true, (IPermissionOperand)ROOT_NODE), Arrays.asList(new PermissionOperationDescription("ModifyAllAttributes", "ppm2.projectplan")));
    private static List allTemplates = null;

    public static List getTemplates() {
        if (allTemplates == null) {
            allTemplates = new ArrayList();
            allTemplates.add(CREATE_PROJECTPLAN);
            allTemplates.add(EDIT_ALL_PROJECTPLANS);
            allTemplates.add(EDIT_PROJECTPLAN);
            allTemplates.add(EDIT_TASK);
            allTemplates.add(EDIT_ALL_WORKITEMS_IN_PROJECTS);
            allTemplates.add(EDIT_ASSIGNED_WORKITEMS_IN_PROJECT_PLAN);
            allTemplates.add(EDIT_ASSIGNED_WORKITEMS_OF_TASK);
            allTemplates.add(EDIT_UNASSIGNED_WORKITEMS);
            allTemplates.add(EDIT_ALL_ATTR_OF_PROJECT_PLANS);
            allTemplates.add(EDIT_ALL_ATTR_OF_ALL_PROJECT_PLANS);
            allTemplates.add(EDIT_ALL_ATTR_OF_TASKS_IN_PROJECTS);
            allTemplates.add(EDIT_ALL_ATTR_OF_ALL_TASKS);
            allTemplates.add(EDIT_ALL_ATTR_OF_TASKS);
            allTemplates.add(EDIT_ALL_ATTR_OF_ASSIGNED_WORKITEMS_OF_TASK);
            allTemplates.add(EDIT_ALL_ATTR_OF_ASSIGNED_WORKITEMS_OF_PROJECTPLAN);
            allTemplates.add(EDIT_ALL_ATTR_OF_UNASSIGNED_WORKITEMS);
            allTemplates.add(EDIT_ALL_ATTR_OF_ALL_WORKITEMS);
        }
        return allTemplates;
    }

    public static List getTemplates(String operandType) {
        assert (operandType != null);
        ArrayList<CockpitPermissionTemplate> result = new ArrayList<CockpitPermissionTemplate>();
        for (CockpitPermissionTemplate permission : ModulePermissionConstants.getTemplates()) {
            if (!permission.getOperandType().equals(operandType)) continue;
            result.add(permission);
        }
        return result;
    }

    public static String getName(CockpitPermissionTemplate template) {
        assert (template != null);
        if (template.getOperation().equals(OPERATION_CREATE_PROJECT_PLAN)) {
            return Messages.getString("Permissions.CreateProjectPlan");
        }
        if (template.getOperation().equals(OPERATION_MODIFY_UNASSIGNED_WORKITEMS)) {
            return Messages.getString("Permissions.ModifyUnassignedWorkItems");
        }
        if (template.getOperation().equals(OPERATION_MODIFY_CONTAINED_WORKITEMS)) {
            return Messages.getString("Permissions.ModifyContainedWorkItems");
        }
        if (template.getOperation().equals(OPERATION_MODIFY_PROJECTPLAN_OR_TASK)) {
            return Messages.getString("Permissions.ModifyProjectPlanOrTask");
        }
        return null;
    }
}

