/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.core.imexportdata;

import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractImExModuleData;
import com.arcway.cockpit.modulelib2.client.messages.AbstractModuleData;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModuleDataFacade;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItem;
import com.arcway.cockpit.projectplanningmodule2.client.messages.WorkItemCategory;
import java.util.Collection;
import java.util.Locale;

public class ImExWorkItem
extends AbstractImExModuleData {
    private final String stakeholderName;
    private final String resources;
    private final String name;
    private final String description;
    private final String workEstimated;
    private final String workDone;
    private final String workRemaining;
    private final String forecast;
    private final String percentWorkComplete;
    private final String category;
    private boolean isComplete = false;
    private boolean isInProgress = false;
    private boolean isNotStarted = false;

    public ImExWorkItem(WorkItem workItem, ModuleDataFacade dataFacade, IModelController modelController, Locale locale) {
        super((AbstractModuleData)workItem, modelController, locale);
        this.stakeholderName = dataFacade.getStakeholderName(workItem);
        this.resources = workItem.getResources().getDisplayStringRepresentation();
        this.name = workItem.getName().getDisplayStringRepresentation();
        this.description = workItem.getDescription().getValue();
        this.workEstimated = workItem.getWorkEstimated().getDisplayRepresentationWithUnit();
        this.workDone = workItem.getWorkDone().getDisplayRepresentationWithUnit();
        this.workRemaining = workItem.getWorkRemaining().getDisplayRepresentationWithUnit();
        this.forecast = workItem.calculateForecast().getDisplayRepresentationWithUnit();
        this.percentWorkComplete = workItem.calculatePercentWorkComplete().getDisplayStringRepresentation();
        Collection categoryCollection = modelController.getLinkableObjects((IModuleData)workItem, "WorkItemCategory");
        if (!categoryCollection.isEmpty()) {
            WorkItemCategory category_ = (WorkItemCategory)((Object)categoryCollection.iterator().next());
            this.category = category_.getDisplayRepresentation(locale);
        } else {
            this.category = "";
        }
        long workRemaining_ = workItem.getWorkRemaining().getValue();
        long workDone_ = workItem.getWorkDone().getValue();
        this.isComplete = workRemaining_ == 0L && workDone_ > 0L;
        this.isInProgress = workRemaining_ > 0L && workDone_ > 0L;
        this.isNotStarted = workDone_ == 0L;
    }

    public String getStakeholderName() {
        return this.stakeholderName;
    }

    public String getResources() {
        return this.resources;
    }

    public String getName() {
        return this.name;
    }

    public String getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public String getWorkEstimated() {
        return this.workEstimated;
    }

    public String getWorkDone() {
        return this.workDone;
    }

    public String getWorkRemaining() {
        return this.workRemaining;
    }

    public String getForecast() {
        return this.forecast;
    }

    public String getPercentWorkComplete() {
        return this.percentWorkComplete;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public boolean isInProgress() {
        return this.isInProgress;
    }

    public boolean isNotStarted() {
        return this.isNotStarted;
    }
}

