/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.core.imexportdata;

import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractImExModuleData;
import com.arcway.cockpit.modulelib2.client.messages.AbstractModuleData;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModuleDataFacade;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import de.plans.lib.util.valueranges.ILong;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class ImExTask
extends AbstractImExModuleData {
    private final String name;
    private List workitems = new ArrayList();
    private Collection childTasks = Collections.EMPTY_LIST;
    private final ImExTask parentTask;
    private final String workDone;
    private final String workEstimated;
    private final String workRemaining;
    private final String workForecast;
    private final int percentWorkComplete;
    private final String start;
    private final String finish;
    private final String duration;
    private final String state;

    public ImExTask(Task task, ImExTask parentTask, ModuleDataFacade dataFacade, IModelController modelController, Collection filters, Locale locale) {
        super((AbstractModuleData)task, modelController, locale);
        this.name = task.getName().getDisplayStringRepresentation();
        this.workitems = dataFacade.getWorkItemsForTask1(task, filters, locale);
        this.parentTask = parentTask;
        this.workDone = task.getWorkDone().getDisplayRepresentationWithUnit();
        this.workEstimated = task.getWorkEstimated().getDisplayRepresentationWithUnit();
        this.workRemaining = task.getWorkRemaining().getDisplayRepresentationWithUnit();
        this.workForecast = task.calculateWorkForecast().getDisplayRepresentationWithUnit();
        this.percentWorkComplete = task.calculatePercentWorkComplete();
        this.start = task.getStart().getDisplayStringRepresentation();
        this.finish = task.getFinish().getDisplayStringRepresentation();
        this.duration = task.calculateDuration().getDisplayRepresentationWithUnit();
        this.state = task.getState().getDisplayStringRepresentation(locale);
    }

    public void setChildTasks(Collection childTasks) {
        this.childTasks = childTasks;
    }

    public String getName() {
        return this.name;
    }

    public List getFilteredWorkItems() {
        return this.workitems;
    }

    public Collection getFilteredChildTasks() {
        return this.childTasks;
    }

    public ImExTask getParentTask() {
        return this.parentTask;
    }

    public String getWorkDone() {
        return this.workDone;
    }

    public String getWorkEstimated() {
        return this.workEstimated;
    }

    public String getWorkRemaining() {
        return this.workRemaining;
    }

    public String getWorkForecast() {
        return this.workForecast;
    }

    public int getPercentWorkComplete() {
        return this.percentWorkComplete;
    }

    public String getStart() {
        return this.start;
    }

    public String getFinish() {
        return this.finish;
    }

    public String getDuration() {
        return this.duration;
    }

    public String getState() {
        return this.state;
    }

    public ILong getStartDateComparisonValue() {
        return ((Task)this.getModuleData()).getStart();
    }

    public ILong getEndDateComparisonValue() {
        return ((Task)this.getModuleData()).getFinish();
    }
}

