/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.core.imexportdata;

import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractImExModuleData;
import com.arcway.cockpit.modulelib2.client.messages.AbstractModuleData;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModuleDataFacade;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.RessourceWorkCumulator;
import com.arcway.cockpit.projectplanningmodule2.client.messages.ProjectPlan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public class ImExProjectPlan
extends AbstractImExModuleData {
    private final RessourceWorkCumulator ressourceWorkCumulator;
    private final String uID;
    private final String description;
    private final String name;
    private List rootTasks = new ArrayList();
    private final String workEstimated;

    public ImExProjectPlan(ProjectPlan projectPlan, ModuleDataFacade dataFacade, IModelController modelController, Collection filters, Locale locale) {
        super((AbstractModuleData)projectPlan, modelController, locale);
        this.ressourceWorkCumulator = dataFacade.getRessourceWorkCumulatorForProjectPlan(projectPlan);
        this.uID = projectPlan.getUID();
        this.description = projectPlan.getDescription().getDisplayStringRepresentation();
        this.name = projectPlan.getName().getDisplayStringRepresentation();
        this.rootTasks = dataFacade.getRootTasksOfProjectPlan(projectPlan, filters, locale);
        this.workEstimated = projectPlan.getWorkEstimated().getDisplayRepresentationWithUnit();
    }

    public RessourceWorkCumulator getRessourceWorkCumluator() {
        return this.ressourceWorkCumulator;
    }

    public String getUID() {
        return this.uID;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getWorkEstimated() {
        return this.workEstimated;
    }

    public List getFilteredRootTasks() {
        return this.rootTasks;
    }
}

