/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui;

import com.arcway.cockpit.projectplanningmodule2.client.Messages;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui.DataExchangeTaskTreeContentProvider;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui.ExportSelectTasksPage;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui.IProgressListener;
import com.arcway.cockpit.projectplanningmodule2.client.adapterlib.gui.ProgressListener;
import com.arcway.cockpit.projectplanningmodule2.client.core.project.ModelController;
import com.arcway.cockpit.projectplanningmodule2.client.messages.ProjectPlan;
import com.arcway.cockpit.projectplanningmodule2.client.messages.Task;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class SynchronizeSelectTasksPage
extends ExportSelectTasksPage {
    private Button btnExportActualWork;
    private Button btnExportWorkForecast;

    public SynchronizeSelectTasksPage(String pageName, ModelController modelController) {
        super(pageName, modelController);
        this.setDescription(Messages.getString("SynchronizeSelectTasksPage.5"));
    }

    @Override
    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        Group exportTypeGroup = new Group(composite, 0);
        exportTypeGroup.setText(Messages.getString("SynchronizeSelectTasksPage.0"));
        exportTypeGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        exportTypeGroup.setLayoutData((Object)gridData);
        this.btnExportActualWork = new Button((Composite)exportTypeGroup, 32);
        this.btnExportActualWork.setText(Messages.getString("SynchronizeSelectTasksPage.1"));
        this.btnExportActualWork.setSelection(true);
        this.btnExportWorkForecast = new Button((Composite)exportTypeGroup, 32);
        this.btnExportWorkForecast.setText(Messages.getString("SynchronizeSelectTasksPage.2"));
        this.btnExportWorkForecast.setSelection(false);
        this.btnExportWorkForecast.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SynchronizeSelectTasksPage.this.checkExportTypeButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SynchronizeSelectTasksPage.this.checkExportTypeButtons();
            }
        });
        this.createTaskTree(composite);
        this.createProgressBar(composite);
        this.checkState();
        this.setControl((Control)composite);
    }

    @Override
    public void checkState() {
        this.setMessage(null, 3);
        this.setPageComplete(true);
    }

    private void checkExportTypeButtons() {
        if (!this.btnExportActualWork.getSelection() && !this.btnExportWorkForecast.getSelection()) {
            this.setMessage(Messages.getString("SynchronizeSelectTasksPage.3"), 3);
            this.setPageComplete(false);
        } else if (this.btnExportWorkForecast.getSelection()) {
            this.setMessage(Messages.getString("SynchronizeSelectTasksPage.4"), 2);
            this.setPageComplete(true);
        } else {
            this.setMessage(null, 3);
            this.setMessage(null, 2);
            this.setPageComplete(true);
        }
    }

    @Override
    public void setInput(ProjectPlan projectPlan) {
        assert (projectPlan != null) : "projectPlan list is null";
        if (this.treeViewer != null) {
            this.treeViewer.setInput((Object)projectPlan);
            this.treeViewer.expandAll();
            this.treeViewer.setSubtreeChecked((Object)projectPlan, true);
        }
        this.checkState();
    }

    @Override
    public List getSelectedTasks() {
        ArrayList<Object> selectedTasks = new ArrayList<Object>();
        if (this.treeViewer != null) {
            Object[] checkedElements;
            Object[] objectArray = checkedElements = this.treeViewer.getCheckedElements();
            int n = checkedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Task task;
                Object checkedElement = objectArray[n2];
                if (!(!(checkedElement instanceof Task) || (task = (Task)((Object)checkedElement)).hasExternalRepresentation() && this.modelController.getWorkItemChildren(task).isEmpty())) {
                    selectedTasks.add(checkedElement);
                }
                ++n2;
            }
        }
        return selectedTasks;
    }

    @Override
    public void setContentProvider() {
        this.treeViewer.setContentProvider((IContentProvider)new DataExchangeTaskTreeContentProvider(false));
    }

    @Override
    public IProgressListener getProgressListener() {
        return new ProgressListener(this.progressBar);
    }

    public boolean getExportWork() {
        return this.btnExportWorkForecast.getSelection();
    }

    public boolean getExportActualWork() {
        return this.btnExportActualWork.getSelection();
    }
}

